/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.sleigh.symbol;

import ghidra.app.plugin.processors.sleigh.Constructor;
import ghidra.app.plugin.processors.sleigh.ParserWalker;
import ghidra.app.plugin.processors.sleigh.SleighDebugLogger;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.plugin.processors.sleigh.expression.PatternExpression;
import ghidra.app.plugin.processors.sleigh.expression.PatternValue;
import ghidra.app.plugin.processors.sleigh.symbol.ValueSymbol;
import ghidra.program.model.lang.UnknownInstructionException;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class NameSymbol
extends ValueSymbol {
    private String[] nametable;
    private boolean tableisfilled;

    public List<String> getNameTable() {
        return Collections.unmodifiableList(Arrays.asList(this.nametable));
    }

    private void checkTableFill() {
        long min = this.getPatternValue().minValue();
        long max = this.getPatternValue().maxValue();
        this.tableisfilled = min >= 0L && max < (long)this.nametable.length;
        for (int i = 0; i < this.nametable.length; ++i) {
            if (null != this.nametable[i]) continue;
            this.tableisfilled = false;
        }
    }

    @Override
    public Constructor resolve(ParserWalker walker, SleighDebugLogger debug) throws MemoryAccessException, UnknownInstructionException {
        long ind;
        if (!(this.tableisfilled || (ind = this.getPatternValue().getValue(walker)) < (long)this.nametable.length && ind >= 0L && this.nametable[(int)ind] != null)) {
            String errmsg = "No corresponding entry in nametable <" + this.getName() + ">, index=" + ind;
            if (debug != null) {
                debug.append(errmsg + "\n");
            }
            throw new UnknownInstructionException(errmsg);
        }
        return null;
    }

    @Override
    public String print(ParserWalker walker) throws MemoryAccessException {
        int ind = (int)this.getPatternValue().getValue(walker);
        return this.nametable[ind];
    }

    @Override
    public void printList(ParserWalker walker, ArrayList<Object> list) throws MemoryAccessException {
        int ind = (int)this.getPatternValue().getValue(walker);
        String token = this.nametable[ind];
        for (int i = 0; i < token.length(); ++i) {
            list.add(Character.valueOf(token.charAt(i)));
        }
    }

    @Override
    public void restoreXml(XmlPullParser parser, SleighLanguage sleigh) {
        XmlElement nametab;
        XmlElement el = parser.start(new String[]{"name_sym"});
        this.patval = (PatternValue)PatternExpression.restoreExpression(parser, sleigh);
        ArrayList<String> names = new ArrayList<String>();
        while ((nametab = parser.softStart(new String[]{"nametab"})) != null) {
            names.add(nametab.getAttribute("name"));
            parser.end(nametab);
        }
        this.nametable = new String[names.size()];
        for (int i = 0; i < this.nametable.length; ++i) {
            this.nametable[i] = (String)names.get(i);
        }
        this.checkTableFill();
        parser.end(el);
    }
}

