/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.expr;

import ghidra.app.plugin.assembler.sleigh.expr.AbstractExpressionSolver;
import ghidra.app.plugin.assembler.sleigh.expr.MaskedLong;
import ghidra.app.plugin.assembler.sleigh.expr.SolverHint;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyPatternBlock;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolution;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedPatterns;
import ghidra.app.plugin.processors.sleigh.expression.ContextField;
import java.util.Map;
import java.util.Set;

public class ContextFieldSolver
extends AbstractExpressionSolver<ContextField> {
    public ContextFieldSolver() {
        super(ContextField.class);
    }

    @Override
    public AssemblyResolution solve(ContextField cf, MaskedLong goal, Map<String, Long> vals, AssemblyResolvedPatterns cur, Set<SolverHint> hints, String description) {
        assert (cf.minValue() == 0L);
        if (!goal.isInRange(cf.maxValue(), cf.hasSignbit())) {
            return AssemblyResolution.error("Value " + goal + " is not valid for " + cf, description);
        }
        AssemblyPatternBlock block = AssemblyPatternBlock.fromContextField(cf, goal);
        return AssemblyResolution.contextOnly(block, description);
    }

    @Override
    public MaskedLong getValue(ContextField cf, Map<String, Long> vals, AssemblyResolvedPatterns cur) {
        if (cur == null) {
            return null;
        }
        return this.valueForResolution(cf, vals, cur);
    }

    @Override
    public int getInstructionLength(ContextField cf) {
        return 0;
    }

    @Override
    public MaskedLong valueForResolution(ContextField cf, Map<String, Long> vals, AssemblyResolvedPatterns rc) {
        int size = cf.getByteEnd() - cf.getByteStart() + 1;
        MaskedLong res = rc.readContext(cf.getByteStart(), size);
        res = res.shiftRight(cf.getShift());
        res = cf.hasSignbit() ? res.signExtend(cf.getEndBit() - cf.getStartBit() + 1) : res.zeroExtend(cf.getEndBit() - cf.getStartBit() + 1);
        return res;
    }
}

