/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table;

import docking.DockingWindowManager;
import docking.menu.ActionState;
import docking.menu.MultiStateDockingAction;
import docking.menu.NonToolbarMultiStateAction;
import docking.widgets.EmptyBorderButton;
import docking.widgets.EventTrigger;
import docking.widgets.filter.FilterListener;
import docking.widgets.filter.FilterOptions;
import docking.widgets.filter.FilterOptionsEditorDialog;
import docking.widgets.filter.FilterTextField;
import docking.widgets.label.GDLabel;
import docking.widgets.table.AbstractSortedTableModel;
import docking.widgets.table.CombinedTableFilter;
import docking.widgets.table.DefaultRowFilterTransformer;
import docking.widgets.table.DefaultTableTextFilterFactory;
import docking.widgets.table.GDynamicColumnTableModel;
import docking.widgets.table.GTable;
import docking.widgets.table.RowFilterTransformer;
import docking.widgets.table.RowObjectFilterModel;
import docking.widgets.table.RowObjectTableModel;
import docking.widgets.table.SortListener;
import docking.widgets.table.SortedTableModel;
import docking.widgets.table.TableFilter;
import docking.widgets.table.TableModelWrapper;
import docking.widgets.table.TableSortState;
import docking.widgets.table.TableTextFilterFactory;
import docking.widgets.table.columnfilter.ColumnBasedTableFilter;
import docking.widgets.table.columnfilter.ColumnFilterSaveManager;
import docking.widgets.table.constraint.dialog.ColumnFilterDialog;
import generic.theme.GIcon;
import ghidra.framework.options.PreferenceState;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.datastruct.WeakDataStructureFactory;
import ghidra.util.datastruct.WeakSet;
import ghidra.util.exception.AssertException;
import ghidra.util.task.SwingUpdateManager;
import help.HelpService;
import java.awt.Component;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.apache.commons.collections4.CollectionUtils;
import org.jdom.Element;
import resources.Icons;
import utilities.util.reflection.ReflectionUtilities;
import utility.function.Callback;

public class GTableFilterPanel<ROW_OBJECT>
extends JPanel {
    public static final String FILTER_TEXTFIELD_NAME = "filter.panel.textfield";
    private static final String FILTER_STATE = "FILTER_STATE";
    private static final String FILTER_EXTENSION = ".FilterExtension";
    private static final Icon FILTER_ON_ICON = new GIcon("icon.widget.filterpanel.filter.on");
    private static final Icon FILTER_OFF_ICON = new GIcon("icon.widget.filterpanel.filter.off");
    private static final Icon APPLY_FILTER_ICON = Icons.OPEN_FOLDER_ICON;
    private static final Icon CLEAR_FILTER_ICON = Icons.DELETE_ICON;
    private JTable table;
    private RowObjectFilterModel<ROW_OBJECT> textFilterModel;
    private JLabel searchLabel;
    private FilterTextField filterField;
    private FilterListener filterListener = new GTableFilterListener();
    private WeakSet<Callback> listeners = WeakDataStructureFactory.createSingleThreadAccessWeakSet();
    private FilterOptions filterOptions = new FilterOptions();
    private TableTextFilterFactory<ROW_OBJECT> filterFactory = new DefaultTableTextFilterFactory(this.filterOptions);
    private RowFilterTransformer<ROW_OBJECT> transformer;
    private TableFilter<ROW_OBJECT> secondaryTableFilter;
    private ColumnBasedTableFilter<ROW_OBJECT> columnTableFilter;
    private List<ColumnBasedTableFilter<ROW_OBJECT>> savedFilters = new ArrayList<ColumnBasedTableFilter<ROW_OBJECT>>();
    private EmptyBorderButton filterStateButton;
    private String uniquePreferenceKey;
    private MultiStateDockingAction<ColumnBasedTableFilter<ROW_OBJECT>> columnFilterAction;
    private ColumnFilterDialog<ROW_OBJECT> columnFilterDialog;
    private ColumnBasedTableFilter<ROW_OBJECT> lastUsedColumnFilter;
    private SwingUpdateManager updateManager = new SwingUpdateManager(250, 1000, () -> {
        String text = this.filterField.getText();
        TableFilter<ROW_OBJECT> tableFilter = this.filterFactory.getTableFilter(text, this.transformer);
        this.textFilterModel.setTableFilter(this.getCombinedTableFilter(this.secondaryTableFilter, tableFilter, this.columnTableFilter));
    });
    private TableColumnModelListener columnModelListener = new TableColumnModelListener(){

        @Override
        public void columnSelectionChanged(ListSelectionEvent e) {
        }

        @Override
        public void columnMarginChanged(ChangeEvent e) {
        }

        @Override
        public void columnMoved(TableColumnModelEvent e) {
        }

        @Override
        public void columnRemoved(TableColumnModelEvent e) {
            GTableFilterPanel.this.updateTableContents();
        }

        @Override
        public void columnAdded(TableColumnModelEvent e) {
            GTableFilterPanel.this.updateTableContents();
        }
    };
    private PropertyChangeListener badProgrammingPropertyChangeListener = evt -> {
        if (evt.getPropertyName().equals("model")) {
            throw new AssertException("HEY!  You can't change the model once you've made the commitment to use a filter panel!...duh!");
        }
    };

    public GTableFilterPanel(JTable table, RowObjectTableModel<ROW_OBJECT> tableModel) {
        this(table, tableModel, " Filter: ");
    }

    public GTableFilterPanel(JTable table, RowObjectTableModel<ROW_OBJECT> tableModel, String filterLabel) {
        this.table = table;
        this.buildPanel(filterLabel);
        this.uniquePreferenceKey = this.createUniqueFilterPreferenceKey(table);
        this.transformer = new DefaultRowFilterTransformer<ROW_OBJECT>(tableModel, table.getColumnModel());
        this.textFilterModel = this.installTableModel(tableModel);
        TableColumnModel columnModel = table.getColumnModel();
        columnModel.addColumnModelListener(this.columnModelListener);
        table.addPropertyChangeListener(this.badProgrammingPropertyChangeListener);
        DockingWindowManager.registerComponentLoadedListener(this, (windowManager, provider) -> this.initialize(windowManager));
    }

    private void initialize(DockingWindowManager windowManager) {
        this.loadFilterPreference(windowManager);
        this.initializeSavedFilters();
    }

    private void loadFilterPreference(DockingWindowManager dockingWindowManager) {
        PreferenceState preferenceState;
        if (dockingWindowManager != null && (preferenceState = dockingWindowManager.getPreferenceState(this.uniquePreferenceKey)) != null) {
            Element xmlElement = preferenceState.getXmlElement(FILTER_STATE);
            this.restoreFromXML(xmlElement);
        }
    }

    private void doSaveState() {
        PreferenceState preferenceState = new PreferenceState();
        preferenceState.putXmlElement(FILTER_STATE, this.saveToXML());
        DockingWindowManager dockingWindowManager = DockingWindowManager.getInstance(this.table);
        if (dockingWindowManager != null) {
            dockingWindowManager.putPreferenceState(this.uniquePreferenceKey, preferenceState);
        }
    }

    private Element saveToXML() {
        return this.filterOptions.toXML();
    }

    private void restoreFromXML(Element xmlElement) {
        if (xmlElement != null) {
            this.filterOptions = FilterOptions.restoreFromXML(xmlElement);
            this.updateFilterFactory();
            this.updateTableContents();
        }
    }

    protected TableFilter<ROW_OBJECT> getCombinedTableFilter(TableFilter<ROW_OBJECT> filter1, TableFilter<ROW_OBJECT> filter2, TableFilter<ROW_OBJECT> filter3) {
        return new CombinedTableFilter<ROW_OBJECT>(filter1, filter2, filter3);
    }

    public void addFilterChagnedListener(FilterListener l) {
        this.filterField.addFilterListener(l);
    }

    public void addEnterListener(Callback callback) {
        this.filterField.addEnterListener(callback);
    }

    public void setColumnTableFilter(ColumnBasedTableFilter<ROW_OBJECT> newFilter) {
        if (Objects.equals(newFilter, this.columnTableFilter)) {
            return;
        }
        if (this.columnTableFilter != null && !this.columnTableFilter.isSaved()) {
            this.lastUsedColumnFilter = this.columnTableFilter;
        }
        this.columnTableFilter = newFilter;
        this.updateTableContents();
        this.updateColumnFilterButton();
        if (this.columnFilterDialog != null) {
            this.columnFilterDialog.filterChanged(newFilter);
        }
    }

    public void setFilterRowTransformer(RowFilterTransformer<ROW_OBJECT> transformer) {
        this.transformer = transformer;
        this.updateTableContents();
    }

    public void setSecondaryFilter(TableFilter<ROW_OBJECT> tableFilter) {
        this.secondaryTableFilter = tableFilter;
        this.updateTableContents();
    }

    public void setFilterOptions(FilterOptions filterOptions) {
        this.filterOptions = filterOptions;
        this.updateFilterFactory();
        this.updateTableContents();
        this.doSaveState();
    }

    private void buildPanel(String filterLabel) {
        this.setLayout(new BoxLayout(this, 0));
        this.setBorder(BorderFactory.createBevelBorder(1));
        this.searchLabel = new GDLabel(filterLabel);
        this.searchLabel.setToolTipText("Include only table elements that match the given search text");
        this.filterField = new FilterTextField(this.table);
        this.filterField.setName(FILTER_TEXTFIELD_NAME);
        this.filterField.addFilterListener(this.filterListener);
        this.add(this.searchLabel);
        this.add(Box.createHorizontalStrut(5));
        this.add(this.filterField);
        this.add(this.buildFilterStateButton());
        if (this.isTableColumnFilterableModel()) {
            this.add(Box.createHorizontalStrut(5));
            this.add(this.buildColumnFilterStateButton());
        }
        HelpService helpService = DockingWindowManager.getHelpService();
        HelpLocation helpLocation = new HelpLocation("Trees", "Filters");
        helpService.registerHelp((Object)this.filterStateButton, helpLocation);
        helpService.registerHelp((Object)this.searchLabel, helpLocation);
        helpService.registerHelp((Object)this.filterField, helpLocation);
    }

    private JComponent buildFilterStateButton() {
        this.filterStateButton = new EmptyBorderButton(this.filterOptions.getFilterStateIcon());
        this.filterStateButton.addActionListener(e -> {
            FilterOptionsEditorDialog dialog = new FilterOptionsEditorDialog(this.filterOptions);
            DockingWindowManager.showDialog(this, dialog);
            FilterOptions resultFilterOptions = dialog.getResultFilterOptions();
            if (resultFilterOptions != null) {
                this.setFilterOptions(resultFilterOptions);
            }
        });
        this.filterStateButton.setToolTipText("Filter Options");
        this.updateFilterFactory();
        return this.filterStateButton;
    }

    private boolean isTableColumnFilterableModel() {
        return this.table.getModel() instanceof RowObjectFilterModel;
    }

    private JComponent buildColumnFilterStateButton() {
        final RowObjectFilterModel tableModel = (RowObjectFilterModel)this.table.getModel();
        this.columnFilterAction = new NonToolbarMultiStateAction<ColumnBasedTableFilter<ROW_OBJECT>>("Column Filter", "GTableFilterPanel"){

            @Override
            public void actionStateChanged(ActionState<ColumnBasedTableFilter<ROW_OBJECT>> newActionState, EventTrigger trigger) {
                if (trigger != EventTrigger.GUI_ACTION) {
                    return;
                }
                ColumnFilterActionState state = (ColumnFilterActionState)newActionState;
                state.performAction();
            }

            @Override
            protected void actionPerformed() {
                GTableFilterPanel.this.showFilterDialog(tableModel);
            }
        };
        HelpLocation helpLocation = new HelpLocation("Trees", "Column_Filters");
        this.columnFilterAction.setHelpLocation(helpLocation);
        this.updateFilterFactory();
        this.updateColumnFilterButton();
        JButton button = this.columnFilterAction.createButton();
        DockingWindowManager.getHelpService().registerHelp((Object)button, helpLocation);
        return button;
    }

    private void initializeSavedFilters() {
        TableModel model = this.table.getModel();
        if (!(model instanceof GDynamicColumnTableModel)) {
            return;
        }
        GDynamicColumnTableModel dynamicModel = (GDynamicColumnTableModel)model;
        ColumnFilterSaveManager saveManager = new ColumnFilterSaveManager(this, this.table, dynamicModel, dynamicModel.getDataSource());
        this.savedFilters = saveManager.getSavedFilters();
        Collections.reverse(this.savedFilters);
        this.updateColumnFilterButton();
    }

    private void updateColumnFilterButton() {
        List list = this.getActionStates();
        this.columnFilterAction.setActionStates(list);
    }

    private List<ActionState<ColumnBasedTableFilter<ROW_OBJECT>>> getActionStates() {
        ArrayList<ActionState<ColumnBasedTableFilter<ROW_OBJECT>>> list = new ArrayList<ActionState<ColumnBasedTableFilter<ROW_OBJECT>>>();
        if (this.columnTableFilter == null) {
            list.add(new CreateFilterActionState());
        } else {
            list.add(new EditFilterActionState(this.columnTableFilter));
            list.add(new ClearFilterActionState());
        }
        if (this.lastUsedColumnFilter != null) {
            list.add(new ApplyLastUsedActionState(this.lastUsedColumnFilter));
        }
        for (ColumnBasedTableFilter<ROW_OBJECT> filter : this.savedFilters) {
            list.add(new ApplyFilterActionState(filter));
        }
        return list;
    }

    private void showFilterDialog(RowObjectFilterModel<ROW_OBJECT> tableModel) {
        if (this.columnFilterDialog == null) {
            if (ColumnFilterDialog.hasFilterableColumns(this.table, tableModel)) {
                DockingWindowManager dockingWindowManager = DockingWindowManager.getInstance(this.table);
                this.loadFilterPreference(dockingWindowManager);
                this.columnFilterDialog = new ColumnFilterDialog<ROW_OBJECT>(this, this.table, tableModel);
            } else {
                Msg.showError((Object)this, (Component)this, (String)"Column Filter Error", (Object)"This table contains no filterable columns!");
                return;
            }
        }
        this.columnFilterDialog.setCloseCallback(() -> {
            this.doSaveState();
            this.updateFilterFactory();
            this.columnFilterDialog = null;
        });
        DockingWindowManager.showDialog(this, this.columnFilterDialog);
    }

    private void updateFilterFactory() {
        this.filterStateButton.setIcon(this.filterOptions.getFilterStateIcon());
        this.filterStateButton.setToolTipText(this.filterOptions.getFilterDescription());
        this.filterFactory = new DefaultTableTextFilterFactory(this.filterOptions);
    }

    protected RowObjectFilterModel<ROW_OBJECT> installTableModel(RowObjectTableModel<ROW_OBJECT> currentModel) {
        ListSelectionModel selectionModel = this.table.getSelectionModel();
        int selectionMode = selectionModel.getSelectionMode();
        RowObjectFilterModel<ROW_OBJECT> newModel = this.createTextFilterModel(currentModel);
        if (newModel instanceof TableModelWrapper) {
            this.table.setModel(newModel);
            TableModelWrapper wrapper = (TableModelWrapper)newModel;
            currentModel.addTableModelListener(new TranslatingTableModelListener(wrapper));
        }
        currentModel.addTableModelListener(new UpdateTableModelListener());
        this.table.setSelectionMode(selectionMode);
        return newModel;
    }

    protected RowObjectFilterModel<ROW_OBJECT> createTextFilterModel(RowObjectTableModel<ROW_OBJECT> model) {
        SortedTableModelWrapper newModel = null;
        if (model instanceof RowObjectFilterModel) {
            newModel = (SortedTableModelWrapper)model;
        } else if (model instanceof SortedTableModel) {
            if (model instanceof AbstractSortedTableModel) {
                AbstractSortedTableModel abstractSortedTableModel = (AbstractSortedTableModel)model;
                newModel = new SortedTableModelWrapper(this.table, abstractSortedTableModel);
            } else {
                Msg.debug((Object)this, (Object)("You will not get sorting capability while using a " + this.getClass().getSimpleName() + ".  Your table model should be changed to extend " + AbstractSortedTableModel.class.getSimpleName()));
            }
        } else {
            newModel = new TableModelWrapper(model);
        }
        return newModel;
    }

    protected JTable getTable() {
        return this.table;
    }

    public RowObjectFilterModel<ROW_OBJECT> getTableFilterModel() {
        return this.textFilterModel;
    }

    private void updateTableContents() {
        this.updateManager.updateLater();
        this.notifyFilterChanged();
    }

    private void notifyFilterChanged() {
        this.listeners.forEach(callback -> callback.call());
    }

    public void dispose() {
        TableColumnModel columnModel = this.table.getColumnModel();
        columnModel.removeColumnModelListener(this.columnModelListener);
        this.columnModelListener = null;
        if (this.columnFilterDialog != null) {
            this.columnFilterDialog.dispose();
        }
        this.table.removePropertyChangeListener(this.badProgrammingPropertyChangeListener);
        this.updateManager.dispose();
        if (this.table instanceof GTable) {
            ((GTable)this.table).dispose();
        }
    }

    public void setFocusComponent(Component component) {
        this.filterField.setFocusComponent(component);
    }

    @Override
    public void requestFocus() {
        this.filterField.requestFocus();
    }

    @Override
    public void setToolTipText(String text) {
        this.searchLabel.setToolTipText(text);
    }

    public void setFilterText(String text) {
        this.filterField.setText(text);
    }

    public String getFilterText() {
        return this.filterField.getText();
    }

    public int getModelRow(int viewRow) {
        if (viewRow < 0) {
            return viewRow;
        }
        return this.textFilterModel.getModelRow(viewRow);
    }

    public int getViewRow(int modelRow) {
        return this.textFilterModel.getViewRow(modelRow);
    }

    public ROW_OBJECT getRowObject(int viewRow) {
        Object rowObject = this.textFilterModel.getRowObject(viewRow);
        return (ROW_OBJECT)rowObject;
    }

    public void setSelectedItem(ROW_OBJECT t) {
        if (t == null) {
            this.table.clearSelection();
            return;
        }
        int viewRow = this.textFilterModel.getViewIndex(t);
        if (viewRow >= 0) {
            this.table.setRowSelectionInterval(viewRow, viewRow);
            this.scrollToSelectedRow();
        }
    }

    public void setSelectedItems(List<ROW_OBJECT> items) {
        if (CollectionUtils.isEmpty(items)) {
            this.table.clearSelection();
            return;
        }
        ListSelectionModel selectionModel = this.table.getSelectionModel();
        int mode = selectionModel.getSelectionMode();
        if (mode == 0) {
            ROW_OBJECT item = items.get(items.size() - 1);
            int viewRow = this.textFilterModel.getViewIndex(item);
            this.table.setRowSelectionInterval(viewRow, viewRow);
            return;
        }
        ArrayList<Integer> rows = new ArrayList<Integer>();
        for (ROW_OBJECT item : items) {
            int viewRow = this.textFilterModel.getViewIndex(item);
            if (viewRow < 0) continue;
            rows.add(viewRow);
        }
        if (rows.isEmpty()) {
            return;
        }
        selectionModel.setValueIsAdjusting(true);
        selectionModel.clearSelection();
        Iterator<Object> iterator = rows.iterator();
        while (iterator.hasNext()) {
            int row = (Integer)iterator.next();
            selectionModel.addSelectionInterval(row, row);
        }
        selectionModel.setValueIsAdjusting(false);
    }

    public void scrollToSelectedRow() {
        int[] selectedRows = this.table.getSelectedRows();
        if (selectedRows == null || selectedRows.length == 0) {
            return;
        }
        int row = selectedRows[0];
        Rectangle visibleRect = this.getVisibleRect();
        Rectangle cellRect = this.table.getCellRect(row, 0, true);
        cellRect.x = visibleRect.x;
        cellRect.width = visibleRect.width;
        this.table.scrollRectToVisible(cellRect);
    }

    public ROW_OBJECT getSelectedItem() {
        int row = this.table.getSelectedRow();
        if (row < 0) {
            return null;
        }
        return (ROW_OBJECT)this.textFilterModel.getRowObject(row);
    }

    public List<ROW_OBJECT> getSelectedItems() {
        int[] rows = this.table.getSelectedRows();
        if (rows.length == 0) {
            return Collections.emptyList();
        }
        ArrayList list = new ArrayList(rows.length);
        for (int row : rows) {
            list.add(this.textFilterModel.getRowObject(row));
        }
        return list;
    }

    public boolean isInView(ROW_OBJECT o) {
        int rowIndex = this.textFilterModel.getRowIndex(o);
        return rowIndex >= 0;
    }

    public boolean isFiltered() {
        return this.getRowCount() != this.getUnfilteredRowCount();
    }

    public int getRowCount() {
        return this.textFilterModel.getRowCount();
    }

    public int getUnfilteredRowCount() {
        return this.textFilterModel.getUnfilteredRowCount();
    }

    public String createUniqueFilterPreferenceKey(JTable jTable) {
        return GTableFilterPanel.generateFilterPreferenceKey(jTable, FILTER_EXTENSION);
    }

    public ColumnBasedTableFilter<ROW_OBJECT> getColumnTableFilter() {
        return this.columnTableFilter;
    }

    public String getPreferenceKey() {
        return this.uniquePreferenceKey;
    }

    public void updateSavedFilters(ColumnBasedTableFilter<ROW_OBJECT> filter, boolean add) {
        if (add) {
            ArrayList<ColumnBasedTableFilter<ROW_OBJECT>> list = new ArrayList<ColumnBasedTableFilter<ROW_OBJECT>>();
            list.add(filter);
            list.addAll(this.savedFilters);
            this.savedFilters = list;
            if (filter.isEquivalent(this.columnTableFilter)) {
                this.setColumnTableFilter(filter);
            }
        } else {
            this.savedFilters.remove(filter);
        }
        this.updateColumnFilterButton();
    }

    private static String generateFilterPreferenceKey(JTable jTable, String extension) {
        GTable gTable;
        String preferenceKey;
        if (jTable instanceof GTable && (preferenceKey = (gTable = (GTable)jTable).getPreferenceKey()) != null) {
            return preferenceKey + extension;
        }
        return GTableFilterPanel.getInceptionInformationFromTheFirstClassThatIsNotUs();
    }

    private static String getInceptionInformationFromTheFirstClassThatIsNotUs() {
        Throwable throwable = new Throwable();
        StackTraceElement[] stackTrace = throwable.getStackTrace();
        String filterName = "Filter";
        StackTraceElement[] filteredTrace = ReflectionUtilities.filterStackTrace((StackTraceElement[])stackTrace, (String[])new String[]{filterName});
        String clientName = filteredTrace[0].getClassName();
        return clientName;
    }

    String getFilterName(ColumnBasedTableFilter<ROW_OBJECT> filter) {
        String filterName = filter.getName();
        return filterName == null ? "Unsaved" : filterName;
    }

    private class GTableFilterListener
    implements FilterListener {
        private GTableFilterListener() {
        }

        @Override
        public void filterChanged(String text) {
            GTableFilterPanel.this.updateTableContents();
        }
    }

    private class CreateFilterActionState
    extends ColumnFilterActionState {
        public CreateFilterActionState() {
            super("Create Column Filter", FILTER_OFF_ICON, null);
        }

        @Override
        void performAction() {
            GTableFilterPanel.this.showFilterDialog(GTableFilterPanel.this.textFilterModel);
        }
    }

    private class EditFilterActionState
    extends ColumnFilterActionState {
        public EditFilterActionState(ColumnBasedTableFilter<ROW_OBJECT> filter) {
            super("Edit: " + GTableFilterPanel.this.getFilterName(filter), FILTER_ON_ICON, filter);
        }

        @Override
        void performAction() {
            GTableFilterPanel.this.showFilterDialog(GTableFilterPanel.this.textFilterModel);
        }
    }

    private class ClearFilterActionState
    extends ColumnFilterActionState {
        public ClearFilterActionState() {
            super("Clear Filter", CLEAR_FILTER_ICON, null);
        }

        @Override
        void performAction() {
            GTableFilterPanel.this.setColumnTableFilter(null);
        }
    }

    private class ApplyLastUsedActionState
    extends ColumnFilterActionState {
        public ApplyLastUsedActionState(ColumnBasedTableFilter<ROW_OBJECT> filter) {
            super("Apply Last Unsaved", FILTER_ON_ICON, filter);
        }

        @Override
        void performAction() {
            GTableFilterPanel.this.setColumnTableFilter((ColumnBasedTableFilter)this.getUserData());
        }
    }

    private class ApplyFilterActionState
    extends ColumnFilterActionState {
        public ApplyFilterActionState(ColumnBasedTableFilter<ROW_OBJECT> filter) {
            super("Apply: " + GTableFilterPanel.this.getFilterName(filter), APPLY_FILTER_ICON, filter);
        }

        @Override
        void performAction() {
            GTableFilterPanel.this.setColumnTableFilter((ColumnBasedTableFilter)this.getUserData());
        }
    }

    private class TranslatingTableModelListener
    implements TableModelListener {
        private TableModelWrapper<ROW_OBJECT> tableModelWrapper;

        TranslatingTableModelListener(TableModelWrapper<ROW_OBJECT> tableModelWrapper) {
            this.tableModelWrapper = tableModelWrapper;
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            this.tableModelWrapper.fireTableDataChanged(this.translateEventForFilter(e));
        }

        private TableModelEvent translateEventForFilter(TableModelEvent event) {
            int rowCount = GTableFilterPanel.this.textFilterModel.getUnfilteredRowCount();
            if (rowCount == 0) {
                return event;
            }
            int firstRow = event.getFirstRow();
            int lastRow = event.getLastRow();
            if (firstRow == 0 && lastRow == Integer.MAX_VALUE) {
                return event;
            }
            if (firstRow == 0 && lastRow == rowCount - 1) {
                firstRow = 0;
                lastRow = Math.max(0, GTableFilterPanel.this.textFilterModel.getRowCount() - 1);
            } else {
                firstRow = GTableFilterPanel.this.getViewRow(firstRow);
                lastRow = GTableFilterPanel.this.getViewRow(lastRow);
            }
            return new TableModelEvent(GTableFilterPanel.this.textFilterModel, firstRow, lastRow, event.getColumn(), event.getType());
        }
    }

    private class UpdateTableModelListener
    implements TableModelListener {
        private boolean isUpdatingModel;

        private UpdateTableModelListener() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (this.isUpdatingModel) {
                return;
            }
            this.isUpdatingModel = true;
            if (GTableFilterPanel.this.textFilterModel instanceof TableModelWrapper) {
                TableModelWrapper tableModelWrapper = (TableModelWrapper)GTableFilterPanel.this.textFilterModel;
                tableModelWrapper.wrappedModelChangedFromTableChangedEvent();
            }
            GTableFilterPanel.this.filterField.alert();
            this.isUpdatingModel = false;
        }
    }

    private class SortedTableModelWrapper
    extends TableModelWrapper<ROW_OBJECT>
    implements SortedTableModel {
        private AbstractSortedTableModel<ROW_OBJECT> sortedModel;

        private SortedTableModelWrapper(JTable table, AbstractSortedTableModel<ROW_OBJECT> sortedModel) {
            super(sortedModel);
            this.sortedModel = sortedModel;
        }

        @Override
        public int getPrimarySortColumnIndex() {
            return this.sortedModel.getPrimarySortColumnIndex();
        }

        @Override
        public boolean isSortable(int columnIndex) {
            return this.sortedModel.isSortable(columnIndex);
        }

        @Override
        public TableSortState getTableSortState() {
            return this.sortedModel.getTableSortState();
        }

        @Override
        public void setTableSortState(TableSortState tableSortState) {
            this.sortedModel.setTableSortState(tableSortState);
        }

        @Override
        public void addSortListener(SortListener l) {
            this.sortedModel.addSortListener(l);
        }
    }

    private abstract class ColumnFilterActionState
    extends ActionState<ColumnBasedTableFilter<ROW_OBJECT>> {
        ColumnFilterActionState(String name, Icon icon, ColumnBasedTableFilter<ROW_OBJECT> filter) {
            super(name, icon, filter);
        }

        abstract void performAction();
    }
}

