/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.list;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionListener;

public class ListPanel<T>
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_WARNING = "You must first select an item from the list.";
    private ListSelectionListener listSelectionListener;
    private ActionListener doubleClickActionListener;
    private MouseListener mouseListener;
    private JScrollPane scrollpane;
    private JList<T> list;

    public ListPanel() {
        this.setLayout(new BorderLayout());
        this.list = new JList<T>(){

            @Override
            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                d.width = Math.max(d.width, 200);
                return d;
            }
        };
        this.scrollpane = new JScrollPane(this.list);
        this.add((Component)this.scrollpane, "Center");
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int index;
                if (ListPanel.this.doubleClickActionListener != null && e.getClickCount() == 2 && (index = ListPanel.this.list.locationToIndex(e.getPoint())) >= 0) {
                    Object o = ListPanel.this.list.getModel().getElementAt(index);
                    ActionEvent ev = new ActionEvent(this, e.getID(), o.toString());
                    ListPanel.this.doubleClickActionListener.actionPerformed(ev);
                    ListPanel.this.list.repaint();
                }
            }
        });
    }

    public void setSelectionMode(int selectionMode) {
        this.list.setSelectionMode(selectionMode);
    }

    public void setListTitle(String listTitle) {
        if (listTitle == null) {
            Border border = BorderFactory.createEmptyBorder(5, 5, 5, 5);
            this.setBorder(border);
        } else {
            TitledBorder tBorder = new TitledBorder(listTitle);
            Border emptyBorder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
            this.setBorder(new CompoundBorder(tBorder, emptyBorder));
        }
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.list.addListSelectionListener(listener);
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        this.list.removeListSelectionListener(listener);
    }

    public boolean isSelectionEmpty() {
        return this.list.isSelectionEmpty();
    }

    public T getSelectedValue() {
        return this.list.getSelectedValue();
    }

    public int getSelectedIndex() {
        return this.list.getSelectedIndex();
    }

    public void setSelectedIndex(int i) {
        this.list.setSelectedIndex(i);
    }

    public void setSelectedValue(T item) {
        this.list.setSelectedValue(item, true);
    }

    public List<T> getSelectedValues() {
        return this.list.getSelectedValuesList();
    }

    public void refreshList(T[] dataList) {
        this.list.setListData(dataList);
        this.list.clearSelection();
    }

    public void setListData(T[] data) {
        this.list.setListData(data);
    }

    public void setListModel(ListModel<T> listModel) {
        this.list.setModel(listModel);
        this.list.clearSelection();
    }

    public ListModel<T> getListModel() {
        return this.list.getModel();
    }

    public JList<T> getList() {
        return this.list;
    }

    public void setCellRenderer(ListCellRenderer<T> r) {
        this.list.setCellRenderer(r);
    }

    public void setListSelectionListener(ListSelectionListener listener) {
        if (this.listSelectionListener != null) {
            this.list.removeListSelectionListener(this.listSelectionListener);
        }
        if (listener != null) {
            this.list.addListSelectionListener(listener);
        }
        this.listSelectionListener = listener;
    }

    public final void setDoubleClickActionListener(ActionListener listener) {
        this.doubleClickActionListener = listener;
    }

    public void setMouseListener(MouseListener l) {
        if (this.mouseListener != null) {
            this.list.removeMouseListener(this.mouseListener);
        }
        this.list.addMouseListener(l);
        this.mouseListener = l;
    }

    public void issueWarning() {
        JOptionPane.showMessageDialog(null, DEFAULT_WARNING, "Warning", 2);
    }

    public void issueWarning(String msg, String title) {
        JOptionPane.showMessageDialog(null, msg, title, 2);
    }

    public void ensureIndexIsVisible(int index) {
        this.list.ensureIndexIsVisible(index);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exc) {
            System.out.println("Error loading L&F: " + exc);
        }
        JFrame frame = new JFrame("ListPanel");
        frame.getContentPane().setLayout(new GridLayout(1, 1));
        ListPanel lbp = new ListPanel();
        DefaultListModel<String> listModel = new DefaultListModel<String>();
        frame.getContentPane().add(lbp);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        listModel.addElement("Ellen");
        listModel.addElement("Bill");
        listModel.addElement("Mike");
        listModel.addElement("Dennis");
        lbp.setListModel(listModel);
        lbp.setListTitle("Developers");
        frame.pack();
        frame.setVisible(true);
    }
}

