/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.dbgeng;

import agent.dbgeng.dbgeng.DebugProcessId;
import agent.dbgeng.dbgeng.DebugSessionId;
import agent.dbgeng.dbgeng.DebugThreadId;
import java.util.ArrayList;
import java.util.List;

public interface DebugSystemObjects {
    public DebugThreadId getEventThread();

    public DebugProcessId getEventProcess();

    public DebugSessionId getEventSystem();

    public DebugThreadId getCurrentThreadId();

    public void setCurrentThreadId(DebugThreadId var1);

    public DebugProcessId getCurrentProcessId();

    public void setCurrentProcessId(DebugProcessId var1);

    public DebugSessionId getCurrentSystemId();

    public void setCurrentSystemId(DebugSessionId var1);

    public int getNumberThreads();

    public int getTotalNumberThreads();

    public List<DebugThreadId> getThreads(int var1, int var2);

    default public List<DebugThreadId> getThreads() {
        return this.getThreads(0, this.getNumberThreads());
    }

    public DebugThreadId getThreadIdByHandle(long var1);

    public DebugProcessId getProcessIdByHandle(long var1);

    public int getNumberSystems();

    public List<DebugSessionId> getSystems(int var1, int var2);

    default public List<DebugSessionId> getSessions() {
        int numberSystems = this.getNumberSystems();
        if (numberSystems < 0) {
            return new ArrayList<DebugSessionId>();
        }
        return this.getSystems(0, numberSystems);
    }

    public int getNumberProcesses();

    public List<DebugProcessId> getProcesses(int var1, int var2);

    default public List<DebugProcessId> getProcesses() {
        int numberProcesses = this.getNumberProcesses();
        if (numberProcesses < 0) {
            return new ArrayList<DebugProcessId>();
        }
        return this.getProcesses(0, numberProcesses);
    }

    public int getCurrentThreadSystemId();

    public int getCurrentProcessSystemId();

    public DebugThreadId getThreadIdBySystemId(int var1);

    public DebugProcessId getProcessIdBySystemId(int var1);

    public long getCurrentThreadDataOffset();

    public long getCurrentProcessDataOffset();

    public long getImplicitThreadDataOffset();

    public long getImplicitProcessDataOffset();

    public void setImplicitThreadDataOffset(long var1);

    public void setImplicitProcessDataOffset(long var1);
}

