/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.dbgeng;

import ghidra.comm.util.BitmaskUniverse;

public interface DebugRunningProcess {
    public int getSystemId();

    public Description getFullDescription(Description.ProcessDescriptionFlags ... var1);

    public String getExecutableName(Description.ProcessDescriptionFlags ... var1);

    public String getDescription(Description.ProcessDescriptionFlags ... var1);

    public static class Description {
        private final int systemId;
        private final String exeName;
        private final String description;

        public Description(int systemId, String exeName, String description) {
            this.systemId = systemId;
            this.exeName = exeName;
            this.description = description;
        }

        public int getSystemId() {
            return this.systemId;
        }

        public String getExecutableName() {
            return this.exeName;
        }

        public String getDescription() {
            return this.description;
        }

        public String toString() {
            return String.format("PID:%d, EXE:%s, Description:%s", this.systemId, this.exeName, this.description);
        }

        public static enum ProcessDescriptionFlags implements BitmaskUniverse
        {
            NO_PATHS(1),
            NO_SERVICES(2),
            NO_MTS_PACKAGES(4),
            NO_COMMAND_LINE(8),
            NO_SESSION_ID(16),
            NO_USER_NAME(32);

            private final int mask;

            private ProcessDescriptionFlags(int mask) {
                this.mask = mask;
            }

            public long getMask() {
                return this.mask;
            }
        }
    }
}

