/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ios.img4;

import ghidra.app.util.bin.ByteArrayProvider;
import ghidra.app.util.bin.ByteProvider;
import ghidra.file.crypto.CryptoKey;
import ghidra.file.crypto.CryptoKeyFactory;
import ghidra.file.formats.ios.generic.iOS_AesCrypto;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileImpl;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.GFileSystemBase;
import ghidra.formats.gfilesystem.annotations.FileSystemInfo;
import ghidra.formats.gfilesystem.factory.GFileSystemBaseFactory;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.Icon;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;

@FileSystemInfo(type="img4", description="iOS Img4", factory=GFileSystemBaseFactory.class)
public class Img4FileSystem
extends GFileSystemBase {
    private List<GFile> dataFileList = new ArrayList<GFile>();
    private byte[] decryptedBytes = new byte[0];

    public Img4FileSystem(String fileSystemName, ByteProvider provider) {
        super(fileSystemName, provider);
    }

    public boolean isValid(TaskMonitor monitor) throws IOException {
        try {
            byte[] magicBytes = this.provider.readBytes(0L, 32L);
            String magicString = new String(magicBytes);
            return magicString.indexOf("IM4P") != -1;
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(TaskMonitor monitor) throws IOException {
        block11: {
            monitor.setMessage("Opening IMG4...");
            try (ASN1InputStream asn1InputStream = new ASN1InputStream(this.provider.getInputStream(0L));){
                ASN1Primitive asn1Primitive = asn1InputStream.readObject();
                if (!(asn1Primitive instanceof ASN1Sequence)) break block11;
                ASN1Sequence asn1Sequence = (ASN1Sequence)asn1Primitive;
                Enumeration enumeration = asn1Sequence.getObjects();
                while (enumeration.hasMoreElements()) {
                    if (monitor.isCancelled()) {
                        break;
                    }
                    Object nextElement = enumeration.nextElement();
                    if (!(nextElement instanceof DEROctetString)) continue;
                    DEROctetString octet = (DEROctetString)nextElement;
                    byte[] encryptedBytes = octet.getOctets();
                    FSRLRoot fsFSRL = this.getFSRL();
                    CryptoKey cryptoKey = CryptoKey.NOT_ENCRYPTED_KEY;
                    try {
                        cryptoKey = CryptoKeyFactory.getCryptoKey(fsFSRL.getName(2), this.fileSystemName);
                    }
                    catch (IOException e) {
                        monitor.setMessage("WARNING: Crypto Key file not found! Trying unencrypted");
                    }
                    if (cryptoKey == CryptoKey.NOT_ENCRYPTED_KEY) {
                        this.decryptedBytes = encryptedBytes;
                    } else {
                        iOS_AesCrypto aes = new iOS_AesCrypto(cryptoKey.key, cryptoKey.iv);
                        this.decryptedBytes = aes.decrypt(encryptedBytes);
                    }
                    String filename = "im4p_data";
                    GFileImpl dataFile = GFileImpl.fromPathString((GFileSystem)this, (GFile)this.root, (String)filename, null, (boolean)false, (long)this.decryptedBytes.length);
                    this.dataFileList.add((GFile)dataFile);
                    break;
                }
            }
            catch (Exception e) {
                throw new IOException("Error opening IMG4 file: ", e);
            }
        }
    }

    public void close() throws IOException {
        super.close();
    }

    public ByteProvider getByteProvider(GFile file, TaskMonitor monitor) throws IOException, CancelledException {
        if (this.dataFileList.contains(file)) {
            return new ByteArrayProvider(this.decryptedBytes, file.getFSRL());
        }
        throw new IOException("Unable to get DATA for " + file.getPath());
    }

    public Icon getIcon() {
        return null;
    }

    public List<GFile> getListing(GFile directory) {
        if (directory == null || directory.equals(this.root)) {
            return this.dataFileList;
        }
        return new ArrayList<GFile>();
    }

    public boolean isDirectory(GFileImpl directory) {
        return directory.equals((Object)this.root);
    }

    public boolean isFile(GFileImpl file) {
        return !file.equals((Object)this.root);
    }
}

