/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.wizard;

import docking.widgets.label.GDHtmlLabel;
import docking.wizard.AbstractMageJPanel;
import docking.wizard.WizardPanelDisplayability;
import docking.wizard.WizardState;
import ghidra.feature.vt.api.main.VTProgramCorrelatorFactory;
import ghidra.feature.vt.gui.wizard.ChooseAddressSetEditorPanel;
import ghidra.feature.vt.gui.wizard.VTWizardStateKey;
import ghidra.framework.model.DomainFile;
import ghidra.util.HTMLUtilities;
import ghidra.util.HelpLocation;
import ghidra.util.layout.PairLayout;
import java.awt.BorderLayout;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import util.CollectionUtils;

public class SummaryPanel
extends AbstractMageJPanel<VTWizardStateKey> {
    private JLabel labelLabel;
    private JLabel summaryLabel;
    private static String NEW_SUMMARY_PANEL = "New_Session_Summary_Panel";
    private static String ADD_SUMMARY_PANEL = "Add_To_Session_Summary_Panel";
    private String helpName = ADD_SUMMARY_PANEL;

    SummaryPanel() {
        this.labelLabel = new GDHtmlLabel();
        this.summaryLabel = new GDHtmlLabel();
        JPanel mainPanel = new JPanel((LayoutManager)new PairLayout(5, 10));
        mainPanel.add(this.labelLabel);
        mainPanel.add(this.summaryLabel);
        this.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        this.setLayout(new BorderLayout());
        this.add(mainPanel, "Center");
    }

    public void dispose() {
    }

    public HelpLocation getHelpLocation() {
        return new HelpLocation("VersionTrackingPlugin", this.helpName);
    }

    public void enterPanel(WizardState<VTWizardStateKey> state) {
        Boolean showAddressSetPanels;
        Boolean excludeAcceptedMatches;
        StringBuilder label = new StringBuilder();
        StringBuilder summary = new StringBuilder();
        label.append("<html>");
        summary.append("<html>");
        label.append("Operation:");
        String opDescription = (String)state.get((Object)VTWizardStateKey.WIZARD_OP_DESCRIPTION);
        this.helpName = opDescription != null && opDescription.startsWith("New") ? NEW_SUMMARY_PANEL : ADD_SUMMARY_PANEL;
        summary.append(opDescription);
        label.append("<br>");
        summary.append("<br>");
        String sessionName = (String)state.get((Object)VTWizardStateKey.SESSION_NAME);
        label.append("Session Name:");
        summary.append(sessionName);
        label.append("<br>");
        summary.append("<br>");
        String sourceProgramName = null;
        String destinationProgramName = null;
        DomainFile sourceProgram = (DomainFile)state.get((Object)VTWizardStateKey.SOURCE_PROGRAM_FILE);
        sourceProgramName = sourceProgram.getName();
        DomainFile destinationProgram = (DomainFile)state.get((Object)VTWizardStateKey.DESTINATION_PROGRAM_FILE);
        destinationProgramName = destinationProgram.getName();
        label.append("Source Program:");
        summary.append(sourceProgramName == null ? "(null)" : HTMLUtilities.escapeHTML((String)sourceProgramName));
        label.append("<br>");
        summary.append("<br>");
        label.append("Destination Program:");
        summary.append(destinationProgramName == null ? "(null)" : HTMLUtilities.escapeHTML((String)destinationProgramName));
        label.append("<br>");
        summary.append("<br>");
        String correlatorLabel = "";
        String correlatorName = null;
        List<VTProgramCorrelatorFactory> correlators = this.getCorrelators(state);
        if (correlators != null) {
            for (VTProgramCorrelatorFactory correlatorFactory : correlators) {
                correlatorName = correlatorFactory.getName();
                label.append(correlatorLabel + "Program Correlator:");
                summary.append(correlatorName == null ? "(null)" : correlatorName);
                label.append("<br>");
                summary.append("<br>");
            }
        }
        if ((excludeAcceptedMatches = (Boolean)state.get((Object)VTWizardStateKey.EXCLUDE_ACCEPTED_MATCHES)) != null) {
            label.append("Exclude Accepted Matches:");
            summary.append(excludeAcceptedMatches != false ? "Yes" : "No");
            label.append("<br>");
            summary.append("<br>");
        }
        if ((showAddressSetPanels = (Boolean)state.get((Object)VTWizardStateKey.SHOW_ADDRESS_SET_PANELS)) != null) {
            String sourceAddressesInfo;
            boolean manuallySpecifiedAddresses = showAddressSetPanels;
            ChooseAddressSetEditorPanel.AddressSetChoice sourceAddressSetChoice = (ChooseAddressSetEditorPanel.AddressSetChoice)((Object)state.get((Object)VTWizardStateKey.SOURCE_ADDRESS_SET_CHOICE));
            ChooseAddressSetEditorPanel.AddressSetChoice destinationAddressSetChoice = (ChooseAddressSetEditorPanel.AddressSetChoice)((Object)state.get((Object)VTWizardStateKey.DESTINATION_ADDRESS_SET_CHOICE));
            String string = sourceAddressSetChoice == ChooseAddressSetEditorPanel.AddressSetChoice.MANUALLY_DEFINED ? "Manually Defined" : (sourceAddressesInfo = sourceAddressSetChoice == ChooseAddressSetEditorPanel.AddressSetChoice.SELECTION ? "Source Tool Selection" : "Entire Source Program");
            String destinationAddressesInfo = destinationAddressSetChoice == ChooseAddressSetEditorPanel.AddressSetChoice.MANUALLY_DEFINED ? "Manually Defined" : (destinationAddressSetChoice == ChooseAddressSetEditorPanel.AddressSetChoice.SELECTION ? "Destination Tool Selection" : "Entire Destination Program");
            label.append("Source Address Set:");
            summary.append(sourceAddressesInfo);
            label.append("<br>");
            summary.append("<br>");
            label.append("Destination Address Set:");
            summary.append(destinationAddressesInfo);
            label.append("<br>");
            summary.append("<br>");
        }
        label.append("</html>");
        summary.append("</html>");
        this.labelLabel.setText(label.toString());
        this.summaryLabel.setText(summary.toString());
    }

    private List<VTProgramCorrelatorFactory> getCorrelators(WizardState<VTWizardStateKey> state) {
        List list = (List)state.get((Object)VTWizardStateKey.PROGRAM_CORRELATOR_FACTORY_LIST);
        if (list == null) {
            return null;
        }
        return CollectionUtils.asList((List)list, VTProgramCorrelatorFactory.class);
    }

    public WizardPanelDisplayability getPanelDisplayabilityAndUpdateState(WizardState<VTWizardStateKey> state) {
        return WizardPanelDisplayability.CAN_BE_DISPLAYED;
    }

    public void leavePanel(WizardState<VTWizardStateKey> state) {
        this.updateStateObjectWithPanelInfo(state);
    }

    public void updateStateObjectWithPanelInfo(WizardState<VTWizardStateKey> state) {
    }

    public String getTitle() {
        return "Summary";
    }

    public void initialize() {
    }

    public boolean isValidInformation() {
        return true;
    }

    public void addDependencies(WizardState<VTWizardStateKey> state) {
    }
}

