/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.target;

import db.DBRecord;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMapTree;
import ghidra.trace.database.target.DBTraceObject;
import ghidra.trace.database.target.DBTraceObjectManager;
import ghidra.trace.database.target.DBTraceObjectValue;
import ghidra.trace.database.target.InternalTraceObjectValue;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.target.TraceObjectKeyPath;
import ghidra.trace.model.target.TraceObjectValue;
import ghidra.trace.util.TraceAddressSpace;
import ghidra.util.LockHold;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBObjectColumn;
import ghidra.util.database.annot.DBAnnotatedColumn;
import ghidra.util.database.annot.DBAnnotatedField;
import ghidra.util.database.annot.DBAnnotatedObjectInfo;
import java.util.concurrent.locks.Lock;

@DBAnnotatedObjectInfo(version=0)
public class DBTraceObjectAddressRangeValue
extends DBTraceAddressSnapRangePropertyMapTree.AbstractDBTraceAddressSnapRangePropertyMapData<DBTraceObjectAddressRangeValue>
implements InternalTraceObjectValue {
    public static final String TABLE_NAME = "ObjectRangeValue";
    static final String PARENT_COLUMN_NAME = "ValueParent";
    static final String KEY_COLUMN_NAME = "ValueKey";
    static final String TYPE_COLUMN_NAME = "IsAddress";
    @DBAnnotatedColumn(value="ValueParent")
    static DBObjectColumn PARENT_COLUMN;
    @DBAnnotatedColumn(value="ValueKey")
    static DBObjectColumn KEY_COLUMN;
    @DBAnnotatedColumn(value="IsAddress")
    static DBObjectColumn TYPE_COLUMN;
    @DBAnnotatedField(column="ValueParent", indexed=true, codec=DBTraceObjectValue.DBTraceObjectDBFieldCodec.class)
    private DBTraceObject parent;
    @DBAnnotatedField(column="ValueKey")
    private String entryKey;
    @DBAnnotatedField(column="IsAddress")
    private boolean isAddress;
    protected final DBTraceObjectManager manager;

    public DBTraceObjectAddressRangeValue(DBTraceObjectManager manager, DBTraceAddressSnapRangePropertyMapTree<DBTraceObjectAddressRangeValue, ?> tree, DBCachedObjectStore<?> store, DBRecord record) {
        super(tree, store, record);
        this.manager = manager;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": parent=" + this.parent + ", key=" + this.entryKey + ", lifespan=" + this.getLifespan() + ", value=" + this.getValue();
    }

    protected void setRecordValue(DBTraceObjectAddressRangeValue value) {
        assert (value == null);
    }

    public TraceAddressSpace getTraceAddressSpace() {
        return this.tree.getMapSpace();
    }

    protected DBTraceObjectAddressRangeValue getRecordValue() {
        return this;
    }

    void set(DBTraceObject parent, String key, boolean isAddress) {
        this.parent = parent;
        this.entryKey = key;
        this.isAddress = isAddress;
        this.update(PARENT_COLUMN, KEY_COLUMN, TYPE_COLUMN);
    }

    @Override
    public Trace getTrace() {
        return this.manager.trace;
    }

    @Override
    public DBTraceObjectManager getManager() {
        return this.manager;
    }

    @Override
    public DBTraceObject getParent() {
        return this.parent;
    }

    @Override
    public String getEntryKey() {
        return this.entryKey;
    }

    @Override
    public Object getValue() {
        if (this.isAddress) {
            return this.getRange().getMinAddress();
        }
        return this.getRange();
    }

    @Override
    public DBTraceObject getChild() {
        throw new ClassCastException();
    }

    @Override
    public boolean isObject() {
        return false;
    }

    @Override
    public DBTraceObject getChildOrNull() {
        return null;
    }

    @Override
    public TraceObjectKeyPath getCanonicalPath() {
        try (LockHold hold = this.manager.trace.lockRead();){
            TraceObjectKeyPath traceObjectKeyPath = this.parent.getCanonicalPath().extend(this.entryKey);
            return traceObjectKeyPath;
        }
    }

    @Override
    public boolean isCanonical() {
        return false;
    }

    @Override
    public void doSetLifespan(Lifespan lifespan) {
        super.doSetLifespan(lifespan);
    }

    @Override
    public void setMinSnap(long minSnap) {
        try (LockHold hold = this.manager.trace.lockWrite();){
            this.setLifespan(Lifespan.span(minSnap, this.getY2()));
        }
    }

    @Override
    public long getMinSnap() {
        try (LockHold hold = this.manager.trace.lockRead();){
            long l = this.getY1();
            return l;
        }
    }

    @Override
    public void setMaxSnap(long maxSnap) {
        try (LockHold hold = this.manager.trace.lockWrite();){
            this.setLifespan(Lifespan.span(this.getY1(), maxSnap));
        }
    }

    @Override
    public long getMaxSnap() {
        try (LockHold hold = this.manager.trace.lockRead();){
            long l = this.getY2();
            return l;
        }
    }

    @Override
    public void doDelete() {
        this.manager.rangeValueMap.deleteData(this);
    }

    @Override
    public void delete() {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            this.doDeleteAndEmit();
        }
    }

    @Override
    public TraceObjectValue truncateOrDelete(Lifespan span) {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            InternalTraceObjectValue internalTraceObjectValue = this.doTruncateOrDeleteAndEmitLifeChange(span);
            return internalTraceObjectValue;
        }
    }
}

