/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.property;

import ghidra.trace.database.property.DBTraceAddressPropertyManager;
import ghidra.trace.model.property.TraceAddressPropertyManager;
import ghidra.trace.model.property.TracePropertyMap;
import ghidra.util.exception.DuplicateNameException;
import java.util.Map;
import java.util.stream.Collectors;

class DBTraceAddressPropertyManagerApiView
implements TraceAddressPropertyManager {
    protected static final String API_PREFIX = "_API_";
    protected final DBTraceAddressPropertyManager internalView;

    public DBTraceAddressPropertyManagerApiView(DBTraceAddressPropertyManager internalView) {
        this.internalView = internalView;
    }

    @Override
    public <T> TracePropertyMap<T> createPropertyMap(String name, Class<T> valueClass) throws DuplicateNameException {
        return this.internalView.createPropertyMap(API_PREFIX + name, (Class)valueClass);
    }

    @Override
    public <T> TracePropertyMap<T> getPropertyMap(String name, Class<T> valueClass) {
        return this.internalView.getPropertyMap(API_PREFIX + name, (Class)valueClass);
    }

    @Override
    public <T> TracePropertyMap<? extends T> getPropertyMapExtends(String name, Class<T> valueClass) {
        return this.internalView.getPropertyMapExtends(API_PREFIX + name, valueClass);
    }

    @Override
    public <T> TracePropertyMap<T> getOrCreatePropertyMap(String name, Class<T> valueClass) {
        return this.internalView.getOrCreatePropertyMap(API_PREFIX + name, (Class)valueClass);
    }

    @Override
    public <T> TracePropertyMap<? super T> getOrCreatePropertyMapSuper(String name, Class<T> valueClass) {
        return this.internalView.getOrCreatePropertyMapSuper(API_PREFIX + name, valueClass);
    }

    @Override
    public TracePropertyMap<?> getPropertyMap(String name) {
        return this.internalView.getPropertyMap(API_PREFIX + name);
    }

    @Override
    public Map<String, TracePropertyMap<?>> getAllProperties() {
        return this.internalView.getAllProperties().entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(API_PREFIX)).collect(Collectors.toMap(e -> ((String)e.getKey()).substring(API_PREFIX.length()), Map.Entry::getValue));
    }
}

