/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.program;

import ghidra.framework.store.LockException;
import ghidra.program.database.mem.ByteMappingScheme;
import ghidra.program.database.mem.FileBytes;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.mem.MemoryBlockSourceInfo;
import ghidra.program.model.mem.MemoryBlockType;
import ghidra.trace.database.memory.DBTraceMemorySpace;
import ghidra.trace.database.program.DBTraceProgramView;
import ghidra.trace.model.memory.TraceMemorySpaceInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.help.UnsupportedOperationException;

public class DBTraceProgramViewRegisterMemoryBlock
implements MemoryBlock {
    public static final String REGS_BLOCK_NAME = "regs";
    private final DBTraceProgramView program;
    private final DBTraceMemorySpace space;
    private final AddressRange range;
    private final List<MemoryBlockSourceInfo> info = Collections.singletonList(new DBTraceProgramViewRegisterMemoryBlockSourceInfo());

    public DBTraceProgramViewRegisterMemoryBlock(DBTraceProgramView program, DBTraceMemorySpace space) {
        this.program = program;
        this.space = space;
        this.range = new AddressRangeImpl(space.getAddressSpace().getMinAddress(), space.getAddressSpace().getMaxAddress());
    }

    public int compareTo(MemoryBlock that) {
        return this.getStart().compareTo((Object)that.getStart());
    }

    public int getPermissions() {
        return 6;
    }

    public InputStream getData() {
        return new TraceMemorySpaceInputStream(this.program, this.space, this.range);
    }

    public boolean contains(Address addr) {
        return this.range.contains(addr);
    }

    public Address getStart() {
        return this.range.getMinAddress();
    }

    public Address getEnd() {
        return this.range.getMaxAddress();
    }

    public long getSize() {
        return this.range.getLength();
    }

    public BigInteger getSizeAsBigInteger() {
        return this.range.getBigLength();
    }

    public String getName() {
        return REGS_BLOCK_NAME;
    }

    public void setName(String name) throws IllegalArgumentException, LockException {
        throw new UnsupportedOperationException();
    }

    public String getComment() {
        return null;
    }

    public void setComment(String comment) {
        throw new UnsupportedOperationException();
    }

    public boolean isRead() {
        return true;
    }

    public void setRead(boolean r) {
        throw new UnsupportedOperationException();
    }

    public boolean isWrite() {
        return true;
    }

    public void setWrite(boolean w) {
        throw new UnsupportedOperationException();
    }

    public boolean isExecute() {
        return false;
    }

    public void setExecute(boolean e) {
        throw new UnsupportedOperationException();
    }

    public void setPermissions(boolean read, boolean write, boolean execute) {
        throw new UnsupportedOperationException();
    }

    public boolean isVolatile() {
        return false;
    }

    public void setVolatile(boolean v) {
        throw new UnsupportedOperationException();
    }

    public String getSourceName() {
        return "Trace";
    }

    public void setSourceName(String sourceName) {
        throw new UnsupportedOperationException();
    }

    public byte getByte(Address addr) throws MemoryAccessException {
        if (!this.range.contains(addr)) {
            throw new MemoryAccessException();
        }
        ByteBuffer buf = ByteBuffer.allocate(1);
        if (this.space.getViewBytes(this.program.snap, addr, buf) != 1) {
            throw new MemoryAccessException();
        }
        return buf.get(0);
    }

    public int getBytes(Address addr, byte[] b) throws MemoryAccessException {
        return this.getBytes(addr, b, 0, b.length);
    }

    public int getBytes(Address addr, byte[] b, int off, int len) throws MemoryAccessException {
        if (!this.range.contains(addr)) {
            throw new MemoryAccessException();
        }
        len = (int)Math.min((long)len, this.range.getMaxAddress().subtract(addr) + 1L);
        return this.space.getViewBytes(this.program.snap, addr, ByteBuffer.wrap(b, off, len));
    }

    public void putByte(Address addr, byte b) throws MemoryAccessException {
        if (this.putBytes(addr, new byte[]{b}) != 1) {
            throw new MemoryAccessException();
        }
    }

    public int putBytes(Address addr, byte[] b) throws MemoryAccessException {
        return this.putBytes(addr, b, 0, b.length);
    }

    public int putBytes(Address addr, byte[] b, int off, int len) throws MemoryAccessException {
        if (!this.range.contains(addr)) {
            throw new MemoryAccessException();
        }
        len = (int)Math.min((long)len, this.range.getMaxAddress().subtract(addr) + 1L);
        return this.space.putBytes(this.program.snap, addr, ByteBuffer.wrap(b, off, len));
    }

    public MemoryBlockType getType() {
        return MemoryBlockType.DEFAULT;
    }

    public boolean isInitialized() {
        return true;
    }

    public boolean isMapped() {
        return false;
    }

    public boolean isOverlay() {
        return false;
    }

    public boolean isLoaded() {
        return true;
    }

    public List<MemoryBlockSourceInfo> getSourceInfos() {
        return this.info;
    }

    private class DBTraceProgramViewRegisterMemoryBlockSourceInfo
    implements MemoryBlockSourceInfo {
        private DBTraceProgramViewRegisterMemoryBlockSourceInfo() {
        }

        public long getLength() {
            return DBTraceProgramViewRegisterMemoryBlock.this.range.getLength();
        }

        public Address getMinAddress() {
            return DBTraceProgramViewRegisterMemoryBlock.this.range.getMinAddress();
        }

        public Address getMaxAddress() {
            return DBTraceProgramViewRegisterMemoryBlock.this.range.getMaxAddress();
        }

        public String getDescription() {
            return "Trace registers: " + DBTraceProgramViewRegisterMemoryBlock.this.space.getThread().getName();
        }

        public Optional<FileBytes> getFileBytes() {
            return Optional.empty();
        }

        public long getFileBytesOffset() {
            return -1L;
        }

        public long getFileBytesOffset(Address address) {
            return -1L;
        }

        public Optional<AddressRange> getMappedRange() {
            return Optional.empty();
        }

        public Optional<ByteMappingScheme> getByteMappingScheme() {
            return Optional.empty();
        }

        public MemoryBlock getMemoryBlock() {
            return DBTraceProgramViewRegisterMemoryBlock.this;
        }

        public boolean contains(Address address) {
            return DBTraceProgramViewRegisterMemoryBlock.this.range.contains(address);
        }

        public String toString() {
            return this.getDescription();
        }
    }
}

