/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.guest;

import ghidra.framework.store.LockException;
import ghidra.lifecycle.Unfinished;
import ghidra.program.database.mem.AddressSourceInfo;
import ghidra.program.database.mem.ByteMappingScheme;
import ghidra.program.database.mem.FileBytes;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.LiveMemoryHandler;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.mem.MemoryBlockException;
import ghidra.program.model.mem.MemoryConflictException;
import ghidra.trace.database.guest.DBTraceGuestPlatform;
import ghidra.trace.database.guest.DBTraceGuestPlatformMappedRange;
import ghidra.trace.database.memory.DBTraceMemoryManager;
import ghidra.trace.database.memory.DBTraceMemorySpace;
import ghidra.util.MathUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.NotFoundException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DBTraceGuestPlatformMappedMemory
implements Memory {
    protected final DBTraceMemoryManager manager;
    protected final DBTraceGuestPlatform guest;
    protected final long snap;

    public DBTraceGuestPlatformMappedMemory(DBTraceMemoryManager manager, DBTraceGuestPlatform guest, long snap) {
        this.manager = manager;
        this.guest = guest;
        this.snap = snap;
    }

    public boolean contains(Address addr) {
        return (Boolean)Unfinished.TODO();
    }

    public boolean contains(Address start, Address end) {
        return (Boolean)Unfinished.TODO();
    }

    public boolean contains(AddressSetView rangeSet) {
        return (Boolean)Unfinished.TODO();
    }

    public boolean isEmpty() {
        return (Boolean)Unfinished.TODO();
    }

    public Address getMinAddress() {
        return (Address)Unfinished.TODO();
    }

    public Address getMaxAddress() {
        return (Address)Unfinished.TODO();
    }

    public int getNumAddressRanges() {
        return (Integer)Unfinished.TODO();
    }

    public AddressRangeIterator getAddressRanges() {
        return (AddressRangeIterator)Unfinished.TODO();
    }

    public AddressRangeIterator getAddressRanges(boolean forward) {
        return (AddressRangeIterator)Unfinished.TODO();
    }

    public AddressRangeIterator getAddressRanges(Address start, boolean forward) {
        return (AddressRangeIterator)Unfinished.TODO();
    }

    public Iterator<AddressRange> iterator() {
        return (Iterator)Unfinished.TODO();
    }

    public Iterator<AddressRange> iterator(boolean forward) {
        return (Iterator)Unfinished.TODO();
    }

    public Iterator<AddressRange> iterator(Address start, boolean forward) {
        return (Iterator)Unfinished.TODO();
    }

    public long getNumAddresses() {
        return (Long)Unfinished.TODO();
    }

    public AddressIterator getAddresses(boolean forward) {
        return (AddressIterator)Unfinished.TODO();
    }

    public AddressIterator getAddresses(Address start, boolean forward) {
        return (AddressIterator)Unfinished.TODO();
    }

    public boolean intersects(AddressSetView addrSet) {
        return (Boolean)Unfinished.TODO();
    }

    public boolean intersects(Address start, Address end) {
        return (Boolean)Unfinished.TODO();
    }

    public AddressSet intersect(AddressSetView view) {
        return (AddressSet)Unfinished.TODO();
    }

    public AddressSet intersectRange(Address start, Address end) {
        return (AddressSet)Unfinished.TODO();
    }

    public AddressSet union(AddressSetView addrSet) {
        return (AddressSet)Unfinished.TODO();
    }

    public AddressSet subtract(AddressSetView addrSet) {
        return (AddressSet)Unfinished.TODO();
    }

    public AddressSet xor(AddressSetView addrSet) {
        return (AddressSet)Unfinished.TODO();
    }

    public boolean hasSameAddresses(AddressSetView view) {
        return (Boolean)Unfinished.TODO();
    }

    public AddressRange getFirstRange() {
        return (AddressRange)Unfinished.TODO();
    }

    public AddressRange getLastRange() {
        return (AddressRange)Unfinished.TODO();
    }

    public AddressRange getRangeContaining(Address address) {
        return (AddressRange)Unfinished.TODO();
    }

    public Address findFirstAddressInCommon(AddressSetView set) {
        return (Address)Unfinished.TODO();
    }

    public Program getProgram() {
        return null;
    }

    public AddressSetView getLoadedAndInitializedAddressSet() {
        return (AddressSetView)Unfinished.TODO();
    }

    public AddressSetView getAllInitializedAddressSet() {
        return (AddressSetView)Unfinished.TODO();
    }

    public AddressSetView getInitializedAddressSet() {
        return (AddressSetView)Unfinished.TODO();
    }

    public AddressSetView getExecuteSet() {
        return (AddressSetView)Unfinished.TODO();
    }

    public boolean isBigEndian() {
        return this.guest.getLanguage().isBigEndian();
    }

    public void setLiveMemoryHandler(LiveMemoryHandler handler) {
        throw new UnsupportedOperationException();
    }

    public LiveMemoryHandler getLiveMemoryHandler() {
        return null;
    }

    public MemoryBlock createInitializedBlock(String name, Address start, InputStream is, long length, TaskMonitor monitor, boolean overlay) throws LockException, MemoryConflictException, AddressOverflowException, CancelledException, IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public MemoryBlock createInitializedBlock(String name, Address start, long size, byte initialValue, TaskMonitor monitor, boolean overlay) throws LockException, IllegalArgumentException, MemoryConflictException, AddressOverflowException, CancelledException {
        throw new UnsupportedOperationException();
    }

    public MemoryBlock createInitializedBlock(String name, Address start, FileBytes fileBytes, long offset, long size, boolean overlay) throws LockException, IllegalArgumentException, MemoryConflictException, AddressOverflowException {
        throw new UnsupportedOperationException();
    }

    public MemoryBlock createUninitializedBlock(String name, Address start, long size, boolean overlay) throws LockException, IllegalArgumentException, MemoryConflictException, AddressOverflowException {
        throw new UnsupportedOperationException();
    }

    public MemoryBlock createBitMappedBlock(String name, Address start, Address mappedAddress, long length, boolean overlay) throws LockException, MemoryConflictException, AddressOverflowException, IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public MemoryBlock createByteMappedBlock(String name, Address start, Address mappedAddress, long length, ByteMappingScheme byteMappingScheme, boolean overlay) throws LockException, MemoryConflictException, AddressOverflowException, IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public MemoryBlock createBlock(MemoryBlock block, String name, Address start, long length) throws LockException, IllegalArgumentException, MemoryConflictException, AddressOverflowException {
        throw new UnsupportedOperationException();
    }

    public void removeBlock(MemoryBlock block, TaskMonitor monitor) throws LockException {
        throw new UnsupportedOperationException();
    }

    public long getSize() {
        return (Long)Unfinished.TODO();
    }

    public MemoryBlock getBlock(Address addr) {
        return (MemoryBlock)Unfinished.TODO();
    }

    public MemoryBlock getBlock(String blockName) {
        return (MemoryBlock)Unfinished.TODO();
    }

    public MemoryBlock[] getBlocks() {
        return (MemoryBlock[])Unfinished.TODO();
    }

    public void moveBlock(MemoryBlock block, Address newStartAddr, TaskMonitor monitor) throws LockException, MemoryBlockException, MemoryConflictException, AddressOverflowException, NotFoundException {
        throw new UnsupportedOperationException();
    }

    public void split(MemoryBlock block, Address addr) throws MemoryBlockException, LockException, NotFoundException {
        throw new UnsupportedOperationException();
    }

    public MemoryBlock join(MemoryBlock blockOne, MemoryBlock blockTwo) throws LockException, MemoryBlockException, NotFoundException {
        throw new UnsupportedOperationException();
    }

    public MemoryBlock convertToInitialized(MemoryBlock uninitializedBlock, byte initialValue) throws LockException, MemoryBlockException, NotFoundException {
        throw new UnsupportedOperationException();
    }

    public MemoryBlock convertToUninitialized(MemoryBlock itializedBlock) throws MemoryBlockException, NotFoundException, LockException {
        throw new UnsupportedOperationException();
    }

    public Address findBytes(Address addr, byte[] bytes, byte[] masks, boolean forward, TaskMonitor monitor) {
        return (Address)Unfinished.TODO();
    }

    public Address findBytes(Address startAddr, Address endAddr, byte[] bytes, byte[] masks, boolean forward, TaskMonitor monitor) {
        return (Address)Unfinished.TODO();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getBytes(ByteBuffer buffer, Address guestStart) {
        int startPos = buffer.position();
        while (buffer.hasRemaining()) {
            int offset = buffer.position() - startPos;
            Address guestCur = guestStart.add((long)offset);
            Map.Entry<Address, DBTraceGuestPlatformMappedRange> floorEntry = this.guest.rangesByGuestAddress.floorEntry(guestCur);
            if (floorEntry == null) {
                return offset;
            }
            DBTraceGuestPlatformMappedRange range = floorEntry.getValue();
            Address hostCur = range.mapGuestToHost(guestCur);
            if (hostCur == null) {
                return offset;
            }
            int lenToRead = MathUtilities.unsignedMin((int)buffer.remaining(), (long)(range.getGuestRange().getMaxAddress().subtract(guestStart) + 1L));
            DBTraceMemorySpace hostSpace = this.manager.getMemorySpace(hostCur.getAddressSpace(), false);
            if (hostSpace == null) {
                buffer.position(buffer.position() + lenToRead);
                continue;
            }
            int savedLimit = buffer.limit();
            try {
                buffer.limit(buffer.position() + lenToRead);
                hostSpace.getViewBytes(this.snap, hostCur, buffer);
            }
            finally {
                buffer.limit(savedLimit);
            }
        }
        return buffer.position() - startPos;
    }

    protected ByteBuffer getBytesInFull(Address address, int len) throws MemoryAccessException {
        ByteBuffer buf = ByteBuffer.allocate(len);
        if (this.getBytes(buf, address) != len) {
            throw new MemoryAccessException("Could not read enough bytes");
        }
        if (!this.isBigEndian()) {
            buf.order(ByteOrder.LITTLE_ENDIAN);
        }
        return buf;
    }

    public byte getByte(Address addr) throws MemoryAccessException {
        byte[] val = new byte[1];
        if (this.getBytes(addr, val) < 1) {
            throw new MemoryAccessException("Guest address " + addr.toString() + " is not mapped, or the mapped address does not exist in host memory");
        }
        return val[0];
    }

    public int getBytes(Address addr, byte[] dest) throws MemoryAccessException {
        return this.getBytes(addr, dest, 0, dest.length);
    }

    public int getBytes(Address addr, byte[] dest, int destIndex, int size) throws MemoryAccessException {
        return this.getBytes(ByteBuffer.wrap(dest, destIndex, size), addr);
    }

    public short getShort(Address addr) throws MemoryAccessException {
        return this.getBytesInFull(addr, 2).getShort(0);
    }

    public short getShort(Address addr, boolean bigEndian) throws MemoryAccessException {
        return this.getBytesInFull(addr, 2).order(bigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN).getShort(0);
    }

    public int getShorts(Address addr, short[] dest) throws MemoryAccessException {
        return this.getShorts(addr, dest, 0, dest.length);
    }

    public int getShorts(Address addr, short[] dest, int dIndex, int nElem) throws MemoryAccessException {
        ByteBuffer buf = ByteBuffer.allocate(nElem * 2);
        int countBytes = this.getBytes(buf, addr);
        buf.flip();
        buf.asShortBuffer().get(dest, dIndex, countBytes / 2);
        return countBytes / 2;
    }

    public int getShorts(Address addr, short[] dest, int dIndex, int nElem, boolean isBigEndian) throws MemoryAccessException {
        ByteBuffer buf = ByteBuffer.allocate(nElem * 2);
        int countBytes = this.getBytes(buf, addr);
        buf.flip();
        buf.order(isBigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
        buf.asShortBuffer().get(dest, dIndex, countBytes / 2);
        return countBytes / 2;
    }

    public int getInt(Address addr) throws MemoryAccessException {
        return (Integer)Unfinished.TODO();
    }

    public int getInt(Address addr, boolean bigEndian) throws MemoryAccessException {
        return (Integer)Unfinished.TODO();
    }

    public int getInts(Address addr, int[] dest) throws MemoryAccessException {
        return (Integer)Unfinished.TODO();
    }

    public int getInts(Address addr, int[] dest, int dIndex, int nElem) throws MemoryAccessException {
        return (Integer)Unfinished.TODO();
    }

    public int getInts(Address addr, int[] dest, int dIndex, int nElem, boolean isBigEndian) throws MemoryAccessException {
        return (Integer)Unfinished.TODO();
    }

    public long getLong(Address addr) throws MemoryAccessException {
        return (Long)Unfinished.TODO();
    }

    public long getLong(Address addr, boolean bigEndian) throws MemoryAccessException {
        return (Long)Unfinished.TODO();
    }

    public int getLongs(Address addr, long[] dest) throws MemoryAccessException {
        return (Integer)Unfinished.TODO();
    }

    public int getLongs(Address addr, long[] dest, int dIndex, int nElem) throws MemoryAccessException {
        return (Integer)Unfinished.TODO();
    }

    public int getLongs(Address addr, long[] dest, int dIndex, int nElem, boolean isBigEndian) throws MemoryAccessException {
        return (Integer)Unfinished.TODO();
    }

    public void setByte(Address addr, byte value) throws MemoryAccessException {
        Unfinished.TODO();
    }

    public void setBytes(Address addr, byte[] source) throws MemoryAccessException {
        Unfinished.TODO();
    }

    public void setBytes(Address addr, byte[] source, int sIndex, int size) throws MemoryAccessException {
        Unfinished.TODO();
    }

    public void setShort(Address addr, short value) throws MemoryAccessException {
        Unfinished.TODO();
    }

    public void setShort(Address addr, short value, boolean bigEndian) throws MemoryAccessException {
        Unfinished.TODO();
    }

    public void setInt(Address addr, int value) throws MemoryAccessException {
        Unfinished.TODO();
    }

    public void setInt(Address addr, int value, boolean bigEndian) throws MemoryAccessException {
        Unfinished.TODO();
    }

    public void setLong(Address addr, long value) throws MemoryAccessException {
        Unfinished.TODO();
    }

    public void setLong(Address addr, long value, boolean bigEndian) throws MemoryAccessException {
        Unfinished.TODO();
    }

    public FileBytes createFileBytes(String filename, long offset, long size, InputStream is, TaskMonitor monitor) throws IOException, CancelledException {
        throw new UnsupportedOperationException();
    }

    public List<FileBytes> getAllFileBytes() {
        return List.of();
    }

    public boolean deleteFileBytes(FileBytes fileBytes) throws IOException {
        return false;
    }

    public AddressSourceInfo getAddressSourceInfo(Address address) {
        return (AddressSourceInfo)Unfinished.TODO();
    }
}

