/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.jdi.model;

import com.sun.jdi.ObjectReference;
import ghidra.async.AsyncFence;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.jdi.model.JdiModelTargetObjectImpl;
import ghidra.dbg.jdi.model.JdiModelTargetObjectReference;
import ghidra.dbg.jdi.model.iface2.JdiModelTargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@TargetObjectSchemaInfo(name="TargetObjectReferenceContainer", elements={@TargetElementType(type=JdiModelTargetObjectReference.class)}, elementResync=TargetObjectSchema.ResyncMode.ONCE, attributes={@TargetAttributeType(type=Void.class)}, canonicalContainer=true)
public class JdiModelTargetObjectReferenceContainer
extends JdiModelTargetObjectImpl {
    protected final List<ObjectReference> refs;
    protected final Map<String, JdiModelTargetObjectReference> objectsByName = new HashMap<String, JdiModelTargetObjectReference>();

    public JdiModelTargetObjectReferenceContainer(JdiModelTargetObject parent, String name, List<ObjectReference> refs) {
        super(parent, name);
        this.refs = refs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompletableFuture<Void> updateUsingReferences(Map<String, ObjectReference> byName) {
        Map<String, JdiModelTargetObjectReference> objects;
        JdiModelTargetObjectReferenceContainer jdiModelTargetObjectReferenceContainer = this;
        synchronized (jdiModelTargetObjectReferenceContainer) {
            objects = byName.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> this.getTargetObject((ObjectReference)e.getValue())));
        }
        AsyncFence fence = new AsyncFence();
        for (JdiModelTargetObjectReference m : objects.values()) {
            fence.include(m.init());
        }
        return fence.ready().thenAccept(__ -> this.changeElements(List.of(), List.of(), objects, "Refreshed"));
    }

    public CompletableFuture<Void> requestElements(DebuggerObjectModel.RefreshBehavior refresh) {
        HashMap<String, ObjectReference> map = new HashMap<String, ObjectReference>();
        for (ObjectReference ref : this.refs) {
            map.put(ref.toString(), ref);
        }
        this.objectsByName.keySet().retainAll(map.keySet());
        return this.updateUsingReferences(map);
    }

    protected synchronized JdiModelTargetObjectReference getTargetObject(ObjectReference ref) {
        return this.objectsByName.computeIfAbsent(ref.toString(), n -> (JdiModelTargetObjectReference)this.getInstance(ref));
    }

    public synchronized JdiModelTargetObjectReference getTargetObjectIfPresent(String name) {
        return this.objectsByName.get(name);
    }
}

