/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.stack;

import ghidra.app.plugin.core.debug.DebuggerCoordinates;
import ghidra.app.plugin.core.debug.stack.DynamicMappingException;
import ghidra.app.plugin.core.debug.stack.SavedRegisterMap;
import ghidra.app.plugin.core.debug.stack.UnwoundFrame;
import ghidra.app.services.DebuggerControlService;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.async.AsyncFence;
import ghidra.framework.plugintool.PluginTool;
import ghidra.pcode.eval.AbstractVarnodeEvaluator;
import ghidra.pcode.eval.ArithmeticVarnodeEvaluator;
import ghidra.pcode.exec.BytesPcodeArithmetic;
import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.pcode.exec.PcodeExecutorState;
import ghidra.pcode.exec.PcodeExecutorStatePiece;
import ghidra.pcode.opbehavior.BinaryOpBehavior;
import ghidra.pcode.opbehavior.UnaryOpBehavior;
import ghidra.pcode.utils.Utils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.util.ProgramLocation;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceLocation;
import ghidra.trace.model.guest.TracePlatform;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.ArrayUtils;

public abstract class AbstractUnwoundFrame<T>
implements UnwoundFrame<T> {
    protected final DebuggerCoordinates coordinates;
    protected final Trace trace;
    protected final TracePlatform platform;
    protected final long snap;
    protected final long viewSnap;
    protected final Language language;
    protected final AddressSpace codeSpace;
    protected final Register pc;
    protected final PcodeExecutorState<T> state;
    protected final DebuggerStaticMappingService mappingService;

    public AbstractUnwoundFrame(PluginTool tool, DebuggerCoordinates coordinates, PcodeExecutorState<T> state) {
        this.coordinates = coordinates;
        this.trace = coordinates.getTrace();
        this.platform = coordinates.getPlatform();
        this.snap = coordinates.getSnap();
        this.viewSnap = coordinates.getViewSnap();
        this.language = this.platform.getLanguage();
        this.codeSpace = this.language.getDefaultSpace();
        this.pc = this.language.getProgramCounter();
        this.state = state;
        this.mappingService = (DebuggerStaticMappingService)tool.getService(DebuggerStaticMappingService.class);
    }

    protected abstract SavedRegisterMap computeRegisterMap();

    protected abstract Address computeAddressOfReturnAddress();

    protected abstract Address applyBase(long var1);

    @Override
    public T getValue(Program program, VariableStorage storage) {
        final SavedRegisterMap registerMap = this.computeRegisterMap();
        return (T)new FrameVarnodeValueGetter<T>(this.state.getArithmetic()){

            protected T evaluateMemory(Address address, int size) {
                return registerMap.getVar(AbstractUnwoundFrame.this.state, address, size, PcodeExecutorStatePiece.Reason.INSPECT);
            }
        }.evaluateStorage(program, storage);
    }

    @Override
    public T getValue(Register register) {
        SavedRegisterMap registerMap = this.computeRegisterMap();
        return registerMap.getVar(this.state, register.getAddress(), register.getNumBytes(), PcodeExecutorStatePiece.Reason.INSPECT);
    }

    @Override
    public T evaluate(Program program, VariableStorage storage, AddressSetView symbolStorage) {
        final SavedRegisterMap registerMap = this.computeRegisterMap();
        return (T)new FrameVarnodeEvaluator<T>(this.state.getArithmetic(), symbolStorage){

            protected T evaluateMemory(Address address, int size) {
                return registerMap.getVar(AbstractUnwoundFrame.this.state, address, size, PcodeExecutorStatePiece.Reason.INSPECT);
            }
        }.evaluateStorage(program, storage);
    }

    @Override
    public T evaluate(Program program, PcodeOp op, AddressSetView symbolStorage) {
        final SavedRegisterMap registerMap = this.computeRegisterMap();
        return (T)new FrameVarnodeEvaluator<T>(this.state.getArithmetic(), symbolStorage){

            protected T evaluateMemory(Address address, int size) {
                return registerMap.getVar(AbstractUnwoundFrame.this.state, address, size, PcodeExecutorStatePiece.Reason.INSPECT);
            }
        }.evaluateOp(program, op);
    }

    @Override
    public CompletableFuture<Void> setValue(final DebuggerControlService.StateEditor editor, Program program, VariableStorage storage, BigInteger value) {
        final SavedRegisterMap registerMap = this.computeRegisterMap();
        final ByteBuffer buf = ByteBuffer.wrap(Utils.bigIntegerToBytes((BigInteger)value, (int)storage.size(), (boolean)true));
        final AsyncFence fence = new AsyncFence();
        new FrameVarnodeValueSetter<ByteBuffer>(){

            protected ByteBuffer evaluateMemory(Address address, int size) {
                byte[] bytes = new byte[size];
                buf.get(bytes);
                if (!AbstractUnwoundFrame.this.language.isBigEndian()) {
                    ArrayUtils.reverse((byte[])bytes);
                }
                fence.include(registerMap.setVar(editor, address, bytes));
                return buf;
            }

            protected ByteBuffer catenate(int total, ByteBuffer value, ByteBuffer piece, int size) {
                return value;
            }

            public ByteBuffer evaluateStorage(Program program, VariableStorage storage) {
                return (ByteBuffer)this.evaluateStorage(program, storage, buf);
            }
        }.evaluateStorage(program, storage);
        return fence.ready();
    }

    @Override
    public CompletableFuture<Void> setReturnAddress(DebuggerControlService.StateEditor editor, Address addr) {
        if (addr.getAddressSpace() != this.codeSpace) {
            throw new IllegalArgumentException("Return address must be in " + this.codeSpace);
        }
        BytesPcodeArithmetic bytesArithmetic = BytesPcodeArithmetic.forLanguage((Language)this.language);
        byte[] bytes = (byte[])bytesArithmetic.fromConst(addr.getOffset(), this.pc.getNumBytes());
        return editor.setVariable(this.computeAddressOfReturnAddress(), bytes);
    }

    @Override
    public T zext(T value, int length) {
        PcodeArithmetic arithmetic = this.state.getArithmetic();
        return (T)arithmetic.unaryOp(17, length, (int)arithmetic.sizeOf(value), value);
    }

    protected abstract class FrameVarnodeValueSetter<U>
    extends AbstractFrameVarnodeEvaluator<U> {
        protected FrameVarnodeValueSetter() {
        }

        protected boolean isLeaf(Varnode vn) {
            return true;
        }

        protected U evaluateUnaryOp(Program program, PcodeOp op, UnaryOpBehavior unOp, Map<Varnode, U> already) {
            throw new UnsupportedOperationException();
        }

        protected U evaluateBinaryOp(Program program, PcodeOp op, BinaryOpBehavior binOp, Map<Varnode, U> already) {
            throw new UnsupportedOperationException();
        }

        protected U evaluateAbstract(Program program, AddressSpace space, U offset, int size, Map<Varnode, U> already) {
            throw new UnsupportedOperationException();
        }

        protected U evaluateConstant(long value, int size) {
            throw new UnsupportedOperationException();
        }

        protected U evaluateLoad(Program program, PcodeOp op, Map<Varnode, U> already) {
            throw new UnsupportedOperationException();
        }

        protected U evaluatePtrAdd(Program program, PcodeOp op, Map<Varnode, U> already) {
            throw new UnsupportedOperationException();
        }

        protected U evaluatePtrSub(Program program, PcodeOp op, Map<Varnode, U> already) {
            throw new UnsupportedOperationException();
        }
    }

    protected abstract class FrameVarnodeValueGetter<U>
    extends ArithmeticFrameVarnodeEvaluator<U> {
        public FrameVarnodeValueGetter(PcodeArithmetic<U> arithmetic) {
            super(arithmetic);
        }

        protected boolean isLeaf(Varnode vn) {
            return true;
        }
    }

    protected abstract class FrameVarnodeEvaluator<U>
    extends ArithmeticFrameVarnodeEvaluator<U> {
        private final AddressSetView symbolStorage;

        public FrameVarnodeEvaluator(PcodeArithmetic<U> arithmetic, AddressSetView symbolStorage) {
            super(arithmetic);
            this.symbolStorage = symbolStorage;
        }

        protected boolean isLeaf(Varnode vn) {
            if (vn.getDef() == null && (vn.isRegister() || vn.isAddress())) {
                return true;
            }
            return vn.isConstant() || this.symbolStorage.contains(vn.getAddress(), vn.getAddress().add((long)(vn.getSize() - 1)));
        }
    }

    protected abstract class AbstractFrameVarnodeEvaluator<U>
    extends AbstractVarnodeEvaluator<U> {
        protected AbstractFrameVarnodeEvaluator() {
        }

        protected Address applyBase(long offset) {
            return AbstractUnwoundFrame.this.applyBase(offset);
        }

        protected Address translateMemory(Program program, Address address) {
            TraceLocation location = AbstractUnwoundFrame.this.mappingService.getOpenMappedLocation(AbstractUnwoundFrame.this.trace, new ProgramLocation(program, address), AbstractUnwoundFrame.this.snap);
            if (location == null) {
                throw new DynamicMappingException(program, address);
            }
            return location.getAddress();
        }
    }

    protected abstract class ArithmeticFrameVarnodeEvaluator<U>
    extends ArithmeticVarnodeEvaluator<U> {
        public ArithmeticFrameVarnodeEvaluator(PcodeArithmetic<U> arithmetic) {
            super(arithmetic);
        }

        protected Address applyBase(long offset) {
            return AbstractUnwoundFrame.this.applyBase(offset);
        }

        protected Address translateMemory(Program program, Address address) {
            TraceLocation location = AbstractUnwoundFrame.this.mappingService.getOpenMappedLocation(AbstractUnwoundFrame.this.trace, new ProgramLocation(program, address), AbstractUnwoundFrame.this.snap);
            if (location == null) {
                throw new DynamicMappingException(program, address);
            }
            return location.getAddress();
        }
    }
}

