/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.breakpoint;

import docking.widgets.fieldpanel.LayoutModel;
import docking.widgets.fieldpanel.listener.IndexMapper;
import docking.widgets.fieldpanel.listener.LayoutModelListener;
import ghidra.app.decompiler.ClangLine;
import ghidra.app.decompiler.component.margin.DecompilerMarginProvider;
import ghidra.app.decompiler.component.margin.LayoutPixelIndexMap;
import ghidra.app.plugin.core.debug.gui.breakpoint.DebuggerBreakpointMarkerPlugin;
import ghidra.app.services.LogicalBreakpoint;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.trace.model.breakpoint.TraceBreakpointKind;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigInteger;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.swing.JPanel;

public class BreakpointsDecompilerMarginProvider
extends JPanel
implements DecompilerMarginProvider,
LayoutModelListener {
    private Program program;
    private LayoutModel model;
    private LayoutPixelIndexMap pixmap;
    private final DebuggerBreakpointMarkerPlugin plugin;

    public BreakpointsDecompilerMarginProvider(DebuggerBreakpointMarkerPlugin plugin) {
        this.plugin = plugin;
        this.setPreferredSize(new Dimension(16, 0));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                BreakpointsDecompilerMarginProvider.this.doToggleBreakpoint(e);
            }
        });
    }

    public void setProgram(Program program, LayoutModel model, LayoutPixelIndexMap pixmap) {
        this.program = program;
        this.setLayoutManager(model);
        this.pixmap = pixmap;
        this.repaint();
    }

    private void setLayoutManager(LayoutModel model) {
        if (this.model == model) {
            return;
        }
        if (this.model != null) {
            this.model.removeLayoutModelListener((LayoutModelListener)this);
        }
        this.model = model;
        if (this.model != null) {
            this.model.addLayoutModelListener((LayoutModelListener)this);
        }
    }

    public Component getComponent() {
        return this;
    }

    public void modelSizeChanged(IndexMapper indexMapper) {
        this.repaint();
    }

    public void dataChanged(BigInteger start, BigInteger end) {
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.plugin.breakpointService == null) {
            return;
        }
        Rectangle visible = this.getVisibleRect();
        BigInteger startIdx = this.pixmap.getIndex(visible.y);
        BigInteger endIdx = this.pixmap.getIndex(visible.y + visible.height);
        List lines = this.plugin.decompilerMarginService.getDecompilerPanel().getLines();
        BigInteger index = startIdx;
        while (index.compareTo(endIdx) <= 0) {
            int i = index.intValue();
            if (i < lines.size()) {
                ClangLine line = (ClangLine)lines.get(i);
                List<ProgramLocation> locs = DebuggerBreakpointMarkerPlugin.getLocationsFromLine(this.program, line);
                LogicalBreakpoint.State state = this.plugin.computeState(locs);
                if (state.icon != null) {
                    state.icon.paintIcon(this, g, 0, this.pixmap.getPixel(index));
                }
            }
            index = index.add(BigInteger.ONE);
        }
    }

    private void doToggleBreakpoint(MouseEvent e) {
        if (e.getClickCount() == 2 && e.getButton() == 1) {
            List lines;
            int i = this.pixmap.getIndex(e.getY()).intValue();
            List<ProgramLocation> locs = DebuggerBreakpointMarkerPlugin.nearestLocationsToLine(this.program, i, lines = this.plugin.decompilerMarginService.getDecompilerPanel().getLines());
            if (locs == null || locs.isEmpty()) {
                return;
            }
            Set<LogicalBreakpoint> col = this.plugin.collectBreakpoints(locs);
            this.plugin.breakpointService.toggleBreakpointsAt(col, locs.get(0), () -> {
                this.plugin.placeBreakpointDialog.prompt(this.plugin.getTool(), this.plugin.breakpointService, "Set breakpoint", (ProgramLocation)locs.get(0), 1L, Set.of(TraceBreakpointKind.SW_EXECUTE), "");
                return CompletableFuture.completedFuture(Set.of());
            });
        }
    }
}

