/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.action;

import db.Transaction;
import ghidra.app.plugin.core.debug.DebuggerCoordinates;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.action.AutoReadMemorySpec;
import ghidra.app.plugin.core.debug.service.emulation.ProgramEmulationUtils;
import ghidra.app.plugin.core.debug.service.model.record.RecorderUtils;
import ghidra.app.plugin.core.debug.utils.AbstractMappedMemoryBytesVisitor;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.async.AsyncUtils;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.memory.TraceMemoryManager;
import ghidra.trace.model.memory.TraceMemoryState;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import javax.swing.Icon;

public class LoadEmulatorAutoReadMemorySpec
implements AutoReadMemorySpec {
    public static final String CONFIG_NAME = "LOAD_EMULATOR";

    @Override
    public String getConfigName() {
        return CONFIG_NAME;
    }

    @Override
    public String getMenuName() {
        return "Load Emulator from Programs";
    }

    @Override
    public Icon getMenuIcon() {
        return DebuggerResources.AutoReadMemoryAction.ICON_LOAD_EMU;
    }

    @Override
    public CompletableFuture<?> readMemory(PluginTool tool, DebuggerCoordinates coordinates, AddressSetView visible) {
        CompletableFuture completableFuture;
        block12: {
            DebuggerStaticMappingService mappingService = (DebuggerStaticMappingService)tool.getService(DebuggerStaticMappingService.class);
            if (mappingService == null) {
                return AsyncUtils.NIL;
            }
            Trace trace = coordinates.getTrace();
            if (trace == null || coordinates.isAlive() || !ProgramEmulationUtils.isEmulatedProgram(trace)) {
                return AsyncUtils.NIL;
            }
            final TraceMemoryManager mm = trace.getMemoryManager();
            AddressSet toRead = new AddressSet(RecorderUtils.INSTANCE.quantize(12, visible));
            for (Lifespan span : coordinates.getView().getViewport().getOrderedSpans()) {
                AddressSetView alreadyKnown = mm.getAddressesWithState(span.lmin(), visible, s -> s == TraceMemoryState.KNOWN);
                toRead.delete(alreadyKnown);
                if (span.lmax() == span.lmin() && !toRead.isEmpty()) continue;
                break;
            }
            if (toRead.isEmpty()) {
                return AsyncUtils.NIL;
            }
            final long snap = coordinates.getSnap();
            final ByteBuffer buf = ByteBuffer.allocate(4096);
            Transaction tx = trace.openTransaction("Load Visible");
            try {
                new AbstractMappedMemoryBytesVisitor(mappingService, buf.array()){

                    @Override
                    protected void visitData(Address hostAddr, byte[] data, int size) {
                        buf.position(0);
                        buf.limit(size);
                        mm.putBytes(snap, hostAddr, buf);
                    }
                }.visit(trace, snap, (AddressSetView)toRead);
                completableFuture = AsyncUtils.NIL;
                if (tx == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (tx != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (MemoryAccessException e) {
                    throw new AssertionError((Object)e);
                }
            }
            tx.close();
        }
        return completableFuture;
    }
}

