/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.algo;

import ghidra.graph.GDirectedGraph;
import ghidra.graph.GEdge;
import ghidra.graph.algo.FindPathsAlgorithm;
import ghidra.graph.algo.GraphAlgorithmStatusListener;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.collections4.map.LazyMap;
import org.apache.commons.collections4.set.ListOrderedSet;

public class IterativeFindPathsAlgorithm<V, E extends GEdge<V>>
implements FindPathsAlgorithm<V, E> {
    private GDirectedGraph<V, E> g;
    private V start;
    private V end;
    private Set<V> blockedSet = new HashSet<V>();
    private Map<V, Set<V>> blockedBackEdgesMap = LazyMap.lazyMap(new HashMap(), k -> new HashSet());
    private GraphAlgorithmStatusListener<V> listener = new GraphAlgorithmStatusListener();
    private TaskMonitor monitor;
    private Accumulator<List<V>> accumulator;

    @Override
    public void setStatusListener(GraphAlgorithmStatusListener<V> listener) {
        this.listener = listener;
    }

    @Override
    public void findPaths(GDirectedGraph<V, E> g, V start, V end, Accumulator<List<V>> accumulator, TaskMonitor monitor) throws CancelledException {
        this.g = g;
        this.start = start;
        this.end = end;
        this.accumulator = accumulator;
        this.monitor = monitor;
        if (start.equals(end)) {
            throw new IllegalArgumentException("Start and end vertex cannot be the same: " + start);
        }
        if (!g.containsVertex(start)) {
            throw new IllegalArgumentException("Start vertex is not in the graph: " + start);
        }
        if (!g.containsVertex(end)) {
            throw new IllegalArgumentException("End vertex is not in the graph: " + end);
        }
        this.find();
        this.listener.finished();
    }

    private void find() throws CancelledException {
        Stack<Node> path = new Stack<Node>();
        path.push(new Node(null, this.start));
        this.monitor.initialize((long)this.g.getEdgeCount());
        while (!path.isEmpty()) {
            this.monitor.checkCancelled();
            this.monitor.incrementProgress(1L);
            Node node = (Node)path.peek();
            this.setStatus(node.v, GraphAlgorithmStatusListener.STATUS.EXPLORING);
            if (node.v.equals(this.end)) {
                this.outputCircuit(path);
                node.setParentFound();
                path.pop();
                continue;
            }
            if (node.isExplored()) {
                node.setDone();
                path.pop();
                continue;
            }
            node = node.getNext();
            path.push(node);
        }
    }

    private void unblock(V v) {
        ListOrderedSet toProcess = new ListOrderedSet();
        toProcess.add(v);
        while (!toProcess.isEmpty()) {
            Object next = toProcess.remove(0);
            Set<Object> childBlocked = this.doUnblock(next);
            if (childBlocked == null || childBlocked.isEmpty()) continue;
            toProcess.addAll(childBlocked);
            childBlocked.clear();
        }
    }

    private Set<V> doUnblock(V v) {
        this.blockedSet.remove(v);
        this.setStatus(v, GraphAlgorithmStatusListener.STATUS.WAITING);
        Set<V> set = this.blockedBackEdgesMap.get(v);
        return set;
    }

    private void blockBackEdge(V u, V v) {
        Set<V> set = this.blockedBackEdgesMap.get(u);
        set.add(v);
    }

    private void outputCircuit(Stack<Node> stack) throws CancelledException {
        ArrayList path = new ArrayList();
        for (Node vv : stack) {
            path.add(vv.v);
        }
        this.setStatus((V)path, GraphAlgorithmStatusListener.STATUS.IN_PATH);
        this.accumulator.add(path);
        this.monitor.checkCancelled();
    }

    private void setStatus(List<V> path, GraphAlgorithmStatusListener.STATUS s) {
        for (V v : path) {
            this.listener.statusChanged(v, s);
        }
    }

    private void setStatus(V v, GraphAlgorithmStatusListener.STATUS s) {
        if (this.blockedSet.contains(v) && s == GraphAlgorithmStatusListener.STATUS.WAITING) {
            this.listener.statusChanged(v, GraphAlgorithmStatusListener.STATUS.BLOCKED);
        } else {
            this.listener.statusChanged(v, s);
        }
    }

    private Collection<E> getOutEdges(V v) {
        Collection<E> outEdges = this.g.getOutEdges(v);
        if (outEdges == null) {
            return Collections.emptyList();
        }
        return outEdges;
    }

    private class Node {
        private Node parent;
        private V v;
        private Deque<V> unexplored;
        private boolean found;

        Node(Node parent, V v) {
            this.parent = parent;
            this.v = v;
            IterativeFindPathsAlgorithm.this.blockedSet.add(v);
            IterativeFindPathsAlgorithm.this.setStatus(v, GraphAlgorithmStatusListener.STATUS.SCHEDULED);
            Collection outEdges = IterativeFindPathsAlgorithm.this.getOutEdges(v);
            this.unexplored = new ArrayDeque(outEdges.size());
            for (GEdge e : IterativeFindPathsAlgorithm.this.getOutEdges(v)) {
                Object u = e.getEnd();
                if (IterativeFindPathsAlgorithm.this.blockedSet.contains(u)) continue;
                this.unexplored.add(u);
            }
        }

        void setDone() {
            if (this.found) {
                this.setParentFound();
            } else {
                for (GEdge e : IterativeFindPathsAlgorithm.this.getOutEdges(this.v)) {
                    Object u = e.getEnd();
                    IterativeFindPathsAlgorithm.this.blockBackEdge(u, this.v);
                }
                IterativeFindPathsAlgorithm.this.setStatus(this.v, GraphAlgorithmStatusListener.STATUS.BLOCKED);
            }
        }

        void setParentFound() {
            if (this.parent != null) {
                this.parent.found = true;
            }
            IterativeFindPathsAlgorithm.this.unblock(this.v);
        }

        boolean isExplored() {
            return this.unexplored.isEmpty();
        }

        Node getNext() {
            if (this.isExplored()) {
                return null;
            }
            Node node = new Node(this, this.unexplored.pop());
            return node;
        }

        public String toString() {
            return this.v.toString();
        }
    }
}

