/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgmodel.model.impl;

import agent.dbgeng.dbgeng.DebugModuleInfo;
import agent.dbgeng.dbgeng.DebugProcessId;
import agent.dbgeng.dbgeng.DebugSessionId;
import agent.dbgeng.dbgeng.DebugSystemObjects;
import agent.dbgeng.dbgeng.DebugThreadId;
import agent.dbgeng.manager.DbgCause;
import agent.dbgeng.manager.DbgEventsListener;
import agent.dbgeng.manager.DbgProcess;
import agent.dbgeng.manager.DbgReason;
import agent.dbgeng.manager.DbgSession;
import agent.dbgeng.manager.DbgStackFrame;
import agent.dbgeng.manager.DbgState;
import agent.dbgeng.manager.DbgThread;
import agent.dbgeng.manager.breakpoint.DbgBreakpointInfo;
import agent.dbgeng.manager.reason.DbgEndSteppingRangeReason;
import agent.dbgeng.manager.reason.DbgExitNormallyReason;
import agent.dbgeng.manager.reason.DbgExitedReason;
import agent.dbgeng.manager.reason.DbgSignalReceivedReason;
import agent.dbgeng.model.iface1.DbgModelSelectableObject;
import agent.dbgeng.model.iface1.DbgModelTargetExecutionStateful;
import agent.dbgeng.model.iface2.DbgModelTargetBreakpointSpec;
import agent.dbgeng.model.iface2.DbgModelTargetConnector;
import agent.dbgeng.model.iface2.DbgModelTargetModule;
import agent.dbgeng.model.iface2.DbgModelTargetObject;
import agent.dbgeng.model.iface2.DbgModelTargetProcess;
import agent.dbgeng.model.iface2.DbgModelTargetProcessContainer;
import agent.dbgeng.model.iface2.DbgModelTargetRoot;
import agent.dbgeng.model.iface2.DbgModelTargetThread;
import agent.dbgeng.model.iface2.DbgModelTargetThreadContainer;
import agent.dbgeng.model.impl.DbgModelTargetConnectorContainerImpl;
import agent.dbgmodel.dbgmodel.main.ModelObject;
import agent.dbgmodel.manager.DbgManager2Impl;
import agent.dbgmodel.model.impl.DbgModel2DefaultTargetModelRoot;
import agent.dbgmodel.model.impl.DbgModel2Impl;
import agent.dbgmodel.model.impl.DbgModel2TargetAvailableContainerImpl;
import agent.dbgmodel.model.impl.DbgModel2TargetObjectImpl;
import agent.dbgmodel.model.impl.DbgModel2TargetProxy;
import agent.dbgmodel.model.impl.DbgModel2TargetSystemMarkerImpl;
import agent.dbgmodel.model.impl.DelegateDbgModel2TargetObject;
import ghidra.async.AsyncUtils;
import ghidra.async.TypeSpec;
import ghidra.async.seq.AsyncSequenceHandlerForProducer;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.target.TargetBreakpointLocation;
import ghidra.dbg.target.TargetBreakpointSpec;
import ghidra.dbg.target.TargetEventScope;
import ghidra.dbg.target.TargetExecutionStateful;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetThread;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.util.PathUtils;
import ghidra.util.Msg;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class DbgModel2TargetRootImpl
extends DbgModel2DefaultTargetModelRoot
implements DbgModelTargetRoot {
    protected final DbgModel2Impl impl;
    protected final DbgModel2TargetAvailableContainerImpl available;
    protected final DbgModelTargetConnectorContainerImpl connectors;
    protected final DbgModel2TargetSystemMarkerImpl systemMarker;

    public DbgModel2TargetRootImpl(DbgModel2Impl impl) {
        super(impl, "Debugger");
        this.impl = impl;
        this.available = new DbgModel2TargetAvailableContainerImpl(this);
        this.connectors = new DbgModelTargetConnectorContainerImpl((DbgModelTargetRoot)this);
        this.systemMarker = new DbgModel2TargetSystemMarkerImpl(this);
        DbgModelTargetConnector defaultConnector = this.connectors.getDefaultConnector();
        this.changeAttributes(List.of(), List.of(this.available, this.connectors, this.systemMarker), Map.of("_accessible", true, "_display", "Debugger", "_focus", this, "_parameters", defaultConnector.getParameters()), "Initialized");
        impl.getManager().addEventsListener((DbgEventsListener)this);
    }

    public DbgModel2TargetRootImpl(DbgModel2Impl impl, TargetObjectSchema schema) {
        super(impl, "Debugger", schema);
        this.impl = impl;
        this.available = new DbgModel2TargetAvailableContainerImpl(this);
        this.connectors = new DbgModelTargetConnectorContainerImpl((DbgModelTargetRoot)this);
        this.systemMarker = new DbgModel2TargetSystemMarkerImpl(this);
        DbgModelTargetConnector defaultConnector = this.connectors.getDefaultConnector();
        this.changeAttributes(List.of(), List.of(this.available, this.connectors, this.systemMarker), Map.of("_accessible", true, "_display", "Debugger", "_focus", this, "_parameters", defaultConnector.getParameters()), "Initialized");
        impl.getManager().addEventsListener((DbgEventsListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setFocus(DbgModelSelectableObject sel) {
        boolean doFire;
        DbgModel2TargetRootImpl dbgModel2TargetRootImpl = this;
        synchronized (dbgModel2TargetRootImpl) {
            boolean bl = doFire = !Objects.equals(this.focus, sel);
            if (doFire && this.focus != null) {
                List focusPath = this.focus.getPath();
                List selPath = sel.getPath();
                doFire = !PathUtils.isAncestor((List)selPath, (List)focusPath);
            }
        }
        if (doFire) {
            this.focus = sel;
            this.changeAttributes(List.of(), List.of(), Map.of("_focus", this.focus), "Focus changed");
            this.intrinsics.put("_focus", this.focus);
        }
        return doFire;
    }

    public void setDefaultConnector(DbgModelTargetConnector defaultConnector) {
        this.changeAttributes(List.of(), List.of(), Map.of("_parameters", defaultConnector.getParameters()), "Default connector changed");
    }

    public void sessionSelected(DbgSession session, DbgCause cause) {
        this.objectSelected(session);
    }

    public void processSelected(DbgProcess process, DbgCause cause) {
        if (process != null) {
            this.objectSelected(process);
        }
    }

    public void threadSelected(DbgThread thread, DbgStackFrame frame, DbgCause cause) {
        if (thread != null) {
            this.objectSelected(thread);
            if (frame != null) {
                this.objectSelected(frame);
            }
        }
    }

    public void objectSelected(Object object) {
        List<String> objPath = this.findObject(object);
        this.model.fetchModelObject(objPath, DebuggerObjectModel.RefreshBehavior.REFRESH_WHEN_ABSENT).thenAccept(obj -> this.update((TargetObject)obj));
    }

    public void sessionAdded(DbgSession session, DbgCause cause) {
        this.changeAttributes(List.of(), List.of(new DbgModel2TargetSystemMarkerImpl(this)), Map.of(), "System");
        this.getObject(session);
    }

    public void processAdded(DbgProcess proc, DbgCause cause) {
        this.getObject(proc).thenAccept(obj -> {
            DbgModelTargetProcess targetProcess = (DbgModelTargetProcess)obj;
            if (targetProcess == null) {
                return;
            }
            DbgModelTargetProcessContainer container = (DbgModelTargetProcessContainer)targetProcess.getParent();
            DelegateDbgModel2TargetObject delegate = (DelegateDbgModel2TargetObject)container.getDelegate();
            delegate.init();
            this.broadcast().event((TargetObject)this.getProxy(), null, TargetEventScope.TargetEventType.PROCESS_CREATED, "Process " + proc.getId() + " started  pid=" + proc.getPid(), List.of(targetProcess));
        });
    }

    public void threadCreated(DbgThread thread, DbgCause cause) {
        this.getObject(thread).thenAccept(obj -> {
            DbgModelTargetThread targetThread = (DbgModelTargetThread)obj;
            if (targetThread == null) {
                return;
            }
            DbgModelTargetThreadContainer container = (DbgModelTargetThreadContainer)targetThread.getParent();
            DelegateDbgModel2TargetObject cdelegate = (DelegateDbgModel2TargetObject)container.getDelegate();
            cdelegate.init();
            this.broadcast().event((TargetObject)this.getProxy(), (TargetThread)targetThread, TargetEventScope.TargetEventType.THREAD_CREATED, "Thread " + thread.getId() + " started", List.of(targetThread));
            DelegateDbgModel2TargetObject delegate = (DelegateDbgModel2TargetObject)targetThread.getDelegate();
            delegate.threadStateChangedSpecific(DbgState.STARTING, (DbgReason)DbgReason.Reasons.UNKNOWN);
        });
    }

    public void moduleLoaded(DbgProcess proc, DebugModuleInfo info, DbgCause cause) {
        this.getObjectRevisited(proc, List.of("Modules"), info).thenAccept(obj -> {
            DbgModelTargetModule mod = (DbgModelTargetModule)obj;
            if (mod == null) {
                return;
            }
            this.getObject(this.getManager().getEventProcess()).thenAccept(p -> {
                DbgModelTargetProcess eventProcess = (DbgModelTargetProcess)p;
                DbgModel2TargetObjectImpl memory = (DbgModel2TargetObjectImpl)((Object)((Object)((Object)eventProcess.getCachedAttribute("Memory"))));
                memory.requestElements(DebuggerObjectModel.RefreshBehavior.REFRESH_NEVER);
            });
        });
    }

    public void moduleUnloaded(DbgProcess proc, DebugModuleInfo info, DbgCause cause) {
        this.getObjectRevisited(proc, List.of("Modules"), info).thenAccept(obj -> {
            DbgModelTargetModule mod = (DbgModelTargetModule)obj;
            if (mod == null) {
                return;
            }
            this.getObject(this.getManager().getEventProcess()).thenAccept(p -> {
                DbgModelTargetProcess eventProcess = (DbgModelTargetProcess)p;
                DbgModel2TargetObjectImpl memory = (DbgModel2TargetObjectImpl)((Object)((Object)((Object)eventProcess.getCachedAttribute("Memory"))));
                memory.requestElements(DebuggerObjectModel.RefreshBehavior.REFRESH_NEVER);
            });
        });
    }

    private CompletableFuture<DbgModelTargetObject> getObject(Object object) {
        DbgModelTargetObject modelObject = (DbgModelTargetObject)this.getModel().getModelObject(object);
        if (modelObject != null) {
            return CompletableFuture.completedFuture(modelObject);
        }
        List<String> objPath = this.findObject(object);
        if (objPath == null) {
            return CompletableFuture.completedFuture(null);
        }
        return AsyncUtils.sequence((TypeSpec)TypeSpec.cls(DbgModelTargetObject.class)).then(seq -> this.getModel().fetchModelObject(objPath).handle((arg_0, arg_1) -> ((AsyncSequenceHandlerForProducer)seq).next(arg_0, arg_1)), TypeSpec.cls(TargetObject.class)).then((pobj, seq) -> {
            DbgModelTargetObject pimpl = (DbgModelTargetObject)pobj;
            seq.exit((Object)pimpl);
        }).finish();
    }

    private CompletableFuture<DbgModelTargetObject> getObjectRevisited(Object object, List<String> ext, Object info) {
        List<String> objPath = this.findObject(object);
        if (objPath == null) {
            return CompletableFuture.completedFuture(null);
        }
        ArrayList<String> xpath = new ArrayList<String>();
        xpath.addAll(objPath);
        xpath.addAll(ext);
        return AsyncUtils.sequence((TypeSpec)TypeSpec.cls(DbgModelTargetObject.class)).then(seq -> this.getModel().fetchModelObject(xpath, DebuggerObjectModel.RefreshBehavior.REFRESH_NEVER).handle((arg_0, arg_1) -> ((AsyncSequenceHandlerForProducer)seq).next(arg_0, arg_1)), TypeSpec.cls(TargetObject.class)).then((pobj, seq) -> {
            if (pobj == null) {
                seq.exit();
                return;
            }
            DbgModel2TargetProxy proxy = (DbgModel2TargetProxy)pobj;
            DelegateDbgModel2TargetObject delegate = proxy.getDelegate();
            Map existingElements = delegate.getCachedElements();
            xpath.add(0, "Debugger");
            DbgManager2Impl manager = (DbgManager2Impl)this.getManager();
            List<ModelObject> list = manager.getAccess().getElements(xpath);
            for (ModelObject obj : list) {
                DbgModel2TargetProxy proxyElement;
                String searchKey = obj.getSearchKey();
                if (!searchKey.equals(info.toString())) continue;
                String elKey = PathUtils.makeKey((String)searchKey);
                if (existingElements.containsKey(searchKey)) {
                    proxyElement = (DbgModel2TargetProxy)existingElements.get(searchKey);
                    DelegateDbgModel2TargetObject elementDelegate = proxyElement.getDelegate();
                    elementDelegate.setModelObject(obj);
                } else {
                    proxyElement = (DbgModel2TargetProxy)DelegateDbgModel2TargetObject.makeProxy((DbgModel2Impl)proxy.getModel(), proxy, elKey, obj);
                }
                delegate.changeElements(List.of(), List.of(proxyElement), "Created");
                seq.exit((Object)proxyElement);
            }
        }).finish();
    }

    private CompletableFuture<Void> getObjectAndRemove(Object object, List<String> ext, Object info) {
        List<String> objPath = this.findObject(object);
        if (objPath == null) {
            return CompletableFuture.completedFuture(null);
        }
        ArrayList<String> xpath = new ArrayList<String>();
        xpath.addAll(objPath);
        xpath.addAll(ext);
        return AsyncUtils.sequence((TypeSpec)TypeSpec.cls(Void.class)).then(seq -> this.getModel().fetchModelObject(xpath).handle((arg_0, arg_1) -> ((AsyncSequenceHandlerForProducer)seq).next(arg_0, arg_1)), TypeSpec.cls(TargetObject.class)).then((pobj, seq) -> {
            if (pobj == null) {
                return;
            }
            DbgModel2TargetProxy proxy = (DbgModel2TargetProxy)pobj;
            DelegateDbgModel2TargetObject delegate = proxy.getDelegate();
            delegate.changeElements(List.of(info.toString()), List.of(), "Deleted");
        }).finish();
    }

    public void sessionRemoved(DebugSessionId sessionId, DbgCause cause) {
        this.getObject(sessionId);
    }

    public void processRemoved(DebugProcessId processId, DbgCause cause) {
        this.getObject(processId).thenAccept(object -> {
            if (object == null) {
                return;
            }
            DbgModelTargetProcess process = (DbgModelTargetProcess)object.getProxy();
            if (!process.getExecutionState().equals((Object)TargetExecutionStateful.TargetExecutionState.TERMINATED)) {
                process.setExecutionState(TargetExecutionStateful.TargetExecutionState.INACTIVE, "Detached");
            }
            DbgModelTargetObject container = (DbgModelTargetObject)process.getParent();
            DelegateDbgModel2TargetObject delegate = (DelegateDbgModel2TargetObject)container.getDelegate();
            delegate.changeElements(List.of(process.getIndex()), List.of(), Map.of(), "Removed");
            process.getParent().resync();
        });
    }

    public void processExited(DbgProcess proc, DbgCause cause) {
        DbgModelTargetProcess targetProcess = (DbgModelTargetProcess)this.getModel().getModelObject(proc);
        if (targetProcess != null) {
            if (targetProcess.isValid()) {
                targetProcess.changeAttributes(List.of(), Map.of("_state", TargetExecutionStateful.TargetExecutionState.TERMINATED, "_exit_code", proc.getExitCode()), "Exited");
            }
            this.broadcast().event(targetProcess.getProxy(), null, TargetEventScope.TargetEventType.PROCESS_EXITED, "Process " + proc.getId() + " exited code=" + proc.getExitCode(), List.of(this.getProxy()));
        }
    }

    public void threadExited(DebugThreadId threadId, DbgProcess process, DbgCause cause) {
        this.getObject(threadId).thenAccept(thread -> {
            if (thread == null) {
                return;
            }
            DbgModelTargetThread targetThread = (DbgModelTargetThread)thread.getProxy();
            this.broadcast().event((TargetObject)this.getProxy(), (TargetThread)targetThread, TargetEventScope.TargetEventType.THREAD_EXITED, "Thread " + threadId + " exited", List.of(targetThread));
        });
    }

    public void threadStateChanged(DbgThread thread, DbgState state, DbgCause cause, DbgReason reason) {
        this.stateChanged(thread, state, reason.desc()).thenAccept(obj -> {
            DbgModelTargetThread targetThread = (DbgModelTargetThread)obj;
            if (targetThread == null) {
                return;
            }
            this.changeAttributes(List.of(), List.of(), Map.of("_event_thread", targetThread), reason.desc());
            this.intrinsics.put("_event_thread", targetThread);
            TargetEventScope.TargetEventType eventType = this.getEventType(state, cause, reason);
            this.broadcast().event((TargetObject)this.getProxy(), (TargetThread)targetThread, eventType, "Thread " + thread.getId() + " state changed", List.of(targetThread));
            DelegateDbgModel2TargetObject delegate = (DelegateDbgModel2TargetObject)targetThread.getDelegate();
            delegate.threadStateChangedSpecific(state, reason);
        });
    }

    private CompletableFuture<DbgModelTargetObject> stateChanged(Object object, DbgState state, String reason) {
        List<String> objPath = this.findObject(object);
        DbgModelTargetObject obj = (DbgModelTargetObject)this.getModel().getModelObject(objPath);
        if (obj instanceof DbgModelTargetExecutionStateful) {
            DbgModelTargetExecutionStateful stateful = (DbgModelTargetExecutionStateful)obj;
            TargetExecutionStateful.TargetExecutionState execState = stateful.convertState(state);
            stateful.setExecutionState(execState, reason);
        }
        return CompletableFuture.completedFuture(obj);
    }

    public void breakpointCreated(DbgBreakpointInfo info, DbgCause cause) {
        int id = info.getId();
        bptInfoMap.put(id, info);
        this.getObjectRevisited(info.getProc(), List.of("Debug", "Breakpoints"), info);
    }

    public void breakpointModified(DbgBreakpointInfo newInfo, DbgBreakpointInfo oldInfo, DbgCause cause) {
        int id = newInfo.getId();
        bptInfoMap.put(id, newInfo);
        this.getObjectRevisited(newInfo.getProc(), List.of("Debug", "Breakpoints"), newInfo);
    }

    public void breakpointDeleted(DbgBreakpointInfo info, DbgCause cause) {
        bptInfoMap.remove((int)info.getNumber());
        this.getObjectAndRemove(info.getProc(), List.of("Debug", "Breakpoints"), info);
    }

    public void breakpointHit(DbgBreakpointInfo info, DbgCause cause) {
        this.getObjectRevisited(info.getProc(), List.of("Debug", "Breakpoints"), info).thenAccept(obj -> {
            DbgModelTargetBreakpointSpec bpt = (DbgModelTargetBreakpointSpec)obj;
            if (bpt == null) {
                Msg.error((Object)((Object)this), (Object)("Stopped for breakpoint unknown to the agent: " + info.getNumber() + " (pc=" + info.getExpression() + ")"));
                return;
            }
            DbgThread thread = info.getEventThread();
            TargetObject targetThread = this.getModel().getModelObject(thread);
            this.broadcast().breakpointHit(bpt.getParent(), targetThread, null, (TargetBreakpointSpec)bpt, (TargetBreakpointLocation)bpt);
            bpt.breakpointHit();
        });
    }

    private List<String> findObject(Object obj) {
        String skey;
        DebugSystemObjects so = this.getManager().getSystemObjects();
        List<Object> objpath = new ArrayList();
        DebugSessionId sid = so.getCurrentSystemId();
        String string = skey = sid.value() < 0L ? PathUtils.makeKey((String)"0x0") : PathUtils.makeKey((String)("0x" + sid.id()));
        if (obj instanceof DbgSession) {
            DbgSession session = (DbgSession)obj;
            skey = PathUtils.makeKey((String)("0x" + session.getId().id()));
        }
        if (obj instanceof DbgSession || obj instanceof String) {
            objpath = List.of("Sessions", skey);
            return objpath;
        }
        int pid = so.getCurrentProcessSystemId();
        String pkey = PathUtils.makeKey((String)("0x" + Integer.toHexString(pid)));
        if (obj instanceof DbgProcess) {
            DbgProcess process = (DbgProcess)obj;
            pkey = PathUtils.makeKey((String)("0x" + Long.toHexString(process.getPid())));
        }
        if (obj instanceof DbgProcess || obj instanceof DebugProcessId) {
            objpath = List.of("Sessions", skey, "Processes", pkey);
            return objpath;
        }
        int tid = so.getCurrentThreadSystemId();
        String tkey = PathUtils.makeKey((String)("0x" + Integer.toHexString(tid)));
        if (obj instanceof DbgThread) {
            DbgThread thread = (DbgThread)obj;
            DbgProcess process = thread.getProcess();
            tkey = PathUtils.makeKey((String)("0x" + Long.toHexString(thread.getTid())));
            pkey = PathUtils.makeKey((String)("0x" + Long.toHexString(process.getPid())));
            if (this.getManager().isKernelMode() && tkey.equals("[0x0]")) {
                pkey = "[0x0]";
            }
        }
        if (obj instanceof DbgStackFrame) {
            DbgStackFrame frame = (DbgStackFrame)obj;
            DbgThread thread = frame.getThread();
            DbgProcess process = thread.getProcess();
            int level = frame.getLevel();
            String fkey = "[0x" + Integer.toHexString(level) + "]";
            tkey = PathUtils.makeKey((String)("0x" + Long.toHexString(thread.getTid())));
            pkey = PathUtils.makeKey((String)("0x" + Long.toHexString(process.getPid())));
            objpath = List.of("Sessions", skey, "Processes", pkey, "Threads", tkey, "Stack", "Frames", fkey);
        }
        if (obj instanceof DbgThread || obj instanceof DebugThreadId) {
            objpath = List.of("Sessions", skey, "Processes", pkey, "Threads", tkey);
        }
        return objpath;
    }

    private void update(TargetObject obj) {
        if (obj instanceof DbgModelSelectableObject) {
            this.setFocus((DbgModelSelectableObject)obj);
        }
        if (obj instanceof DbgModelTargetExecutionStateful) {
            this.activate((DbgModelTargetExecutionStateful)obj);
            DbgModelTargetProcess parentProcess = ((DbgModelTargetObject)obj).getParentProcess();
            if (obj instanceof DbgModelTargetExecutionStateful) {
                this.activate((DbgModelTargetExecutionStateful)parentProcess);
            }
        }
    }

    private void activate(DbgModelTargetExecutionStateful stateful) {
        TargetExecutionStateful.TargetExecutionState state = stateful.getExecutionState();
        if (state.equals((Object)TargetExecutionStateful.TargetExecutionState.INACTIVE)) {
            stateful.changeAttributes(List.of(), Map.of("_state", TargetExecutionStateful.TargetExecutionState.ALIVE), "Selected");
            stateful.fetchAttributes(DebuggerObjectModel.RefreshBehavior.REFRESH_ALWAYS);
        }
    }

    private TargetEventScope.TargetEventType getEventType(DbgState state, DbgCause cause, DbgReason reason) {
        switch (state) {
            case RUNNING: {
                return TargetEventScope.TargetEventType.RUNNING;
            }
            case STOPPED: 
            case EXIT: {
                if (reason instanceof DbgEndSteppingRangeReason) {
                    return TargetEventScope.TargetEventType.STEP_COMPLETED;
                }
                if (reason instanceof DbgSignalReceivedReason) {
                    return TargetEventScope.TargetEventType.SIGNAL;
                }
                if (reason instanceof DbgExitedReason) {
                    return TargetEventScope.TargetEventType.EXCEPTION;
                }
                if (reason instanceof DbgExitNormallyReason) {
                    return TargetEventScope.TargetEventType.THREAD_EXITED;
                }
                return TargetEventScope.TargetEventType.STOPPED;
            }
            case SESSION_EXIT: {
                return TargetEventScope.TargetEventType.PROCESS_EXITED;
            }
        }
        return null;
    }

    @Override
    public CompletableFuture<Void> requestAttributes(DebuggerObjectModel.RefreshBehavior refresh) {
        DbgManager2Impl manager2 = (DbgManager2Impl)this.getManager();
        List pathX = PathUtils.extend(List.of("Debugger"), (List)this.path);
        this.intrinsics.put(this.available.getName(), this.available);
        this.intrinsics.put(this.connectors.getName(), this.connectors);
        this.intrinsics.put(this.systemMarker.getName(), this.systemMarker);
        return manager2.listAttributes(pathX, this).thenAccept(map -> {
            if (map == null) {
                return;
            }
            this.changeAttributes(List.of(), (Map)map, "Refreshed");
        });
    }

    public boolean isAccessible() {
        return this.accessible;
    }

    public void setAccessible(boolean accessible) {
        this.accessible = accessible;
    }
}

