/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgmodel.jna.cmd;

import agent.dbgeng.manager.cmd.AbstractDbgCommand;
import agent.dbgeng.manager.cmd.DbgPendingCommand;
import agent.dbgeng.manager.impl.DbgManagerImpl;
import agent.dbgeng.model.iface2.DbgModelTargetObject;
import agent.dbgmodel.dbgmodel.main.ModelObject;
import agent.dbgmodel.gadp.impl.WrappedDbgModel;
import agent.dbgmodel.manager.DbgManager2Impl;
import agent.dbgmodel.model.impl.DbgModel2TargetObjectImpl;
import agent.dbgmodel.model.impl.DbgModel2TargetProxy;
import agent.dbgmodel.model.impl.DelegateDbgModel2TargetObject;
import ghidra.dbg.util.PathUtils;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class DbgListAttributesCommand
extends AbstractDbgCommand<Map<String, ?>> {
    private Map<String, Object> updatedAttributes;
    private WrappedDbgModel access;
    private List<String> path;
    private DbgModel2TargetObjectImpl targetObject;

    public DbgListAttributesCommand(DbgManager2Impl manager, List<String> path, DbgModel2TargetObjectImpl targetObject) {
        super((DbgManagerImpl)manager);
        this.access = manager.getAccess();
        this.path = path;
        this.targetObject = targetObject;
    }

    public Map<String, ?> complete(DbgPendingCommand<?> pending) {
        return this.updatedAttributes;
    }

    public void invoke() {
        try {
            this.updatedAttributes = new TreeMap<String, Object>((Comparator<String>)PathUtils.TargetObjectKeyComparator.ATTRIBUTE);
            Map<String, ModelObject> map = this.access.getAttributes(this.path);
            Map existingAttributes = this.targetObject.getCachedAttributes();
            for (String key : map.keySet()) {
                DbgModel2TargetProxy proxyAttribute;
                ModelObject obj = map.get(key);
                String atKey = obj.getSearchKey();
                Object object = existingAttributes.get(atKey);
                if (object != null && object instanceof DbgModelTargetObject) {
                    proxyAttribute = (DbgModel2TargetProxy)object;
                    DelegateDbgModel2TargetObject delegate = proxyAttribute.getDelegate();
                    delegate.setModelObject(obj);
                    this.updatedAttributes.put(key, proxyAttribute);
                    continue;
                }
                proxyAttribute = (DbgModel2TargetProxy)DelegateDbgModel2TargetObject.makeProxy(this.targetObject.getModel(), this.targetObject, atKey, obj);
                this.updatedAttributes.put(key, proxyAttribute);
            }
            this.updatedAttributes.putAll(this.targetObject.getIntrinsics());
        }
        catch (Exception e) {
            System.err.println("Failure in ListAttributes " + this.targetObject);
            e.printStackTrace();
        }
    }
}

