/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgmodel.impl.dbgmodel.bridge;

import agent.dbgeng.dbgeng.DebugClient;
import agent.dbgeng.impl.dbgeng.client.DebugClientImpl1;
import agent.dbgmodel.dbgmodel.DbgModel;
import agent.dbgmodel.dbgmodel.datamodel.DataModelManager1;
import agent.dbgmodel.dbgmodel.debughost.DebugHost;
import agent.dbgmodel.impl.dbgmodel.bridge.HostDataModelAccessInternal;
import agent.dbgmodel.impl.dbgmodel.datamodel.DataModelManagerInternal;
import agent.dbgmodel.impl.dbgmodel.debughost.DebugHostInternal;
import agent.dbgmodel.jna.dbgmodel.bridge.IHostDataModelAccess;
import agent.dbgmodel.jna.dbgmodel.datamodel.WrapIDataModelManager1;
import agent.dbgmodel.jna.dbgmodel.debughost.WrapIDebugHost;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.PointerByReference;

public class HostDataModelAccessImpl
implements HostDataModelAccessInternal {
    private final DbgModel.OpaqueCleanable cleanable;
    private final IHostDataModelAccess jnaData;
    private DataModelManager1 manager;
    private DebugHost host;
    private DebugClient debugClient;

    public HostDataModelAccessImpl(IHostDataModelAccess jnaData) {
        this.cleanable = DbgModel.releaseWhenPhantom((Object)this, jnaData);
        this.jnaData = jnaData;
    }

    public HostDataModelAccessImpl(DebugClient debugClient) {
        DebugClientImpl1 impl = (DebugClientImpl1)debugClient;
        this.jnaData = (IHostDataModelAccess)impl.getJNAClient();
        this.cleanable = DbgModel.releaseWhenPhantom((Object)this, this.jnaData);
    }

    @Override
    public Pointer getPointer() {
        return this.jnaData.getPointer();
    }

    public IHostDataModelAccess getJNAData() {
        return this.jnaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getDataModel() {
        PointerByReference ppManager = new PointerByReference();
        PointerByReference ppHost = new PointerByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.GetDataModel(ppManager, ppHost));
        WrapIDataModelManager1 wrap0 = new WrapIDataModelManager1(ppManager.getValue());
        try {
            this.manager = DataModelManagerInternal.tryPreferredInterfaces(wrap0::QueryInterface);
        }
        finally {
            wrap0.Release();
        }
        WrapIDebugHost wrap1 = new WrapIDebugHost(ppHost.getValue());
        try {
            this.host = DebugHostInternal.tryPreferredInterfaces(wrap1::QueryInterface);
        }
        finally {
            wrap1.Release();
        }
    }

    @Override
    public DataModelManager1 getManager() {
        return this.manager;
    }

    @Override
    public DebugHost getHost() {
        return this.host;
    }

    @Override
    public DebugClient getClient() {
        return this.debugClient;
    }

    @Override
    public void setClient(DebugClient debugClient) {
        this.debugClient = debugClient;
    }
}

