/*
 * Decompiled with CFR 0.152.
 */
package generic.theme;

import generic.theme.GThemeValueMap;
import generic.theme.ThemeManager;
import ghidra.util.Msg;
import java.util.HashSet;
import java.util.Objects;

public abstract class ThemeValue<T>
implements Comparable<ThemeValue<T>> {
    protected final String id;
    protected final T value;
    protected final String referenceId;

    protected ThemeValue(String id, String referenceId, T value) {
        if (id.equals(referenceId)) {
            throw new IllegalArgumentException("Can't create a themeValue that referencs itself");
        }
        this.id = id;
        this.referenceId = referenceId;
        this.value = value;
    }

    public abstract boolean isExternal();

    public String getId() {
        return this.id;
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public T getRawValue() {
        return this.value;
    }

    public T get(GThemeValueMap values) {
        if (this.value != null) {
            return this.value;
        }
        HashSet<String> visitedKeys = new HashSet<String>();
        visitedKeys.add(this.id);
        ThemeValue<T> referred = this.getReferredValue(values, this.referenceId);
        while (referred != null) {
            if (referred.value != null) {
                return referred.get(values);
            }
            visitedKeys.add(referred.id);
            if (visitedKeys.contains(referred.referenceId)) {
                Msg.warn((Object)this, (Object)("Theme value reference loop detected for key: " + this.id));
                return this.getUnresolvedReferenceValue(this.id, referred.referenceId);
            }
            referred = this.getReferredValue(values, referred.referenceId);
        }
        return this.getUnresolvedReferenceValue(this.id, this.referenceId);
    }

    public boolean hasResolvableValue(GThemeValueMap values) {
        if (this.value != null) {
            return true;
        }
        HashSet<String> visitedKeys = new HashSet<String>();
        visitedKeys.add(this.id);
        ThemeValue<T> referred = this.getReferredValue(values, this.referenceId);
        while (referred != null) {
            if (referred.value != null) {
                return true;
            }
            visitedKeys.add(referred.id);
            if (visitedKeys.contains(referred.referenceId)) {
                Msg.warn((Object)this, (Object)("Theme value reference loop detected for key: " + this.id));
                return false;
            }
            referred = this.getReferredValue(values, referred.referenceId);
        }
        return false;
    }

    public boolean inheritsFrom(String ancestorId, GThemeValueMap values) {
        if (this.referenceId == null) {
            return false;
        }
        if (this.referenceId.equals(ancestorId)) {
            return true;
        }
        HashSet<String> visitedKeys = new HashSet<String>();
        visitedKeys.add(this.id);
        ThemeValue<T> parent = this.getReferredValue(values, this.referenceId);
        while (parent != null) {
            if (parent.referenceId == null) {
                return false;
            }
            if (parent.referenceId.equals(ancestorId)) {
                return true;
            }
            visitedKeys.add(parent.id);
            if (visitedKeys.contains(parent.referenceId)) {
                return false;
            }
            parent = this.getReferredValue(values, parent.referenceId);
        }
        return false;
    }

    public boolean isIndirect() {
        return this.referenceId != null;
    }

    public abstract String getSerializationString();

    protected abstract T getUnresolvedReferenceValue(String var1, String var2);

    protected abstract ThemeValue<T> getReferredValue(GThemeValueMap var1, String var2);

    @Override
    public int compareTo(ThemeValue<T> o) {
        return this.id.compareTo(o.id);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.referenceId, this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ThemeValue other = (ThemeValue)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.referenceId, other.referenceId) && Objects.equals(this.value, other.value);
    }

    public String toString() {
        String name = this.getClass().getSimpleName();
        if (this.referenceId == null) {
            return name + " (" + this.id + ", " + this.value + ")";
        }
        return name + " (" + this.id + ", " + this.referenceId + ")";
    }

    public abstract void installValue(ThemeManager var1);
}

