/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.BTreeNode;
import db.ChainedBuffer;
import db.DBFieldIterator;
import db.DBHandle;
import db.DBLongIterator;
import db.DBRecord;
import db.Field;
import db.FieldKeyNode;
import db.FieldKeyRecordNode;
import db.FixedField;
import db.FixedKeyRecordNode;
import db.IndexTable;
import db.InteriorNode;
import db.KeyToRecordIterator;
import db.LongField;
import db.LongKeyNode;
import db.LongKeyRecordNode;
import db.NodeMgr;
import db.RecordIterator;
import db.Schema;
import db.TableRecord;
import db.TableStatistics;
import db.VarKeyRecordNode;
import ghidra.util.Msg;
import ghidra.util.datastruct.IntObjectHashtable;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.NoSuchElementException;

public class Table {
    private DBHandle db;
    private TableRecord tableRecord;
    private Schema schema;
    private NodeMgr nodeMgr;
    private int rootBufferId = -1;
    private int recordCount;
    private long maximumKey;
    private IntObjectHashtable<IndexTable> secondaryIndexes = new IntObjectHashtable();
    private int[] indexedColumns = new int[0];
    private boolean isIndexed = false;
    int modCount = 0;

    Table(DBHandle db, TableRecord tableRecord) throws Field.UnsupportedFieldException {
        this.db = db;
        this.tableRecord = tableRecord;
        this.schema = tableRecord.getSchema();
        tableRecord.setTable(this);
        this.rootBufferId = tableRecord.getRootBufferId();
        this.recordCount = tableRecord.getRecordCount();
        this.maximumKey = tableRecord.getMaxKey();
        this.nodeMgr = new NodeMgr(this, db.getBufferMgr());
    }

    DBHandle getDBHandle() {
        return this.db;
    }

    public boolean useLongKeys() {
        return this.schema.useLongKeyNodes();
    }

    public boolean useFixedKeys() {
        return this.schema.useFixedKeyNodes();
    }

    void tableRecordChanged() {
        this.rootBufferId = this.tableRecord.getRootBufferId();
        this.recordCount = this.tableRecord.getRecordCount();
        this.maximumKey = this.tableRecord.getMaxKey();
        ++this.modCount;
    }

    void invalidate() {
        this.tableRecord = null;
        this.rootBufferId = -1;
        this.nodeMgr = null;
        ++this.modCount;
    }

    long getTableNum() {
        return this.tableRecord.getTableNum();
    }

    public TableStatistics[] getAllStatistics() throws IOException {
        TableStatistics[] statList = new TableStatistics[this.indexedColumns.length + 1];
        statList[0] = this.getStatistics();
        for (int i = 0; i < this.indexedColumns.length; ++i) {
            IndexTable indexTable = (IndexTable)this.secondaryIndexes.get(this.indexedColumns[i]);
            statList[i + 1] = indexTable.getStatistics();
        }
        return statList;
    }

    private BTreeNode getBTreeNode(int bufferId) throws IOException {
        if (this.schema.useLongKeyNodes()) {
            return this.nodeMgr.getLongKeyNode(bufferId);
        }
        if (this.schema.useFixedKeyNodes()) {
            return this.nodeMgr.getFixedKeyNode(bufferId);
        }
        return this.nodeMgr.getVarKeyNode(bufferId);
    }

    private FieldKeyNode getFieldKeyNode(int bufferId) throws IOException {
        if (this.schema.useFixedKeyNodes()) {
            return this.nodeMgr.getFixedKeyNode(bufferId);
        }
        return this.nodeMgr.getVarKeyNode(bufferId);
    }

    private void accumulateNodeStatistics(TableStatistics stats, int bufferId) throws IOException {
        if (bufferId < 0) {
            return;
        }
        BTreeNode node = this.getBTreeNode(bufferId);
        ++stats.bufferCount;
        int[] ids = node.getBufferReferences();
        if (node instanceof InteriorNode) {
            ++stats.interiorNodeCnt;
            for (int id : ids) {
                this.accumulateNodeStatistics(stats, id);
            }
        } else {
            ++stats.recordNodeCnt;
            for (int id : ids) {
                ChainedBuffer dbBuf = new ChainedBuffer(this.nodeMgr.getBufferMgr(), id);
                int cnt = dbBuf.getBufferCount();
                stats.chainedBufferCnt += cnt;
                stats.bufferCount += cnt;
            }
        }
        this.nodeMgr.releaseNodes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableStatistics getStatistics() throws IOException {
        DBHandle dBHandle = this.db;
        synchronized (dBHandle) {
            TableStatistics stats = new TableStatistics();
            stats.name = this.getName();
            try {
                this.accumulateNodeStatistics(stats, this.rootBufferId);
                stats.size = stats.bufferCount * this.nodeMgr.getBufferMgr().getBufferSize();
            }
            finally {
                this.nodeMgr.releaseNodes();
            }
            return stats;
        }
    }

    void addIndex(IndexTable indexTable) {
        this.secondaryIndexes.put(indexTable.getColumnIndex(), (Object)indexTable);
        this.indexedColumns = this.secondaryIndexes.getKeys();
        this.isIndexed = true;
    }

    void insertedRecord(DBRecord record) throws IOException {
        for (int indexedColumn : this.indexedColumns) {
            IndexTable indexTable = (IndexTable)this.secondaryIndexes.get(indexedColumn);
            indexTable.addEntry(record);
        }
    }

    void updatedRecord(DBRecord oldRecord, DBRecord newRecord) throws IOException {
        for (int colIx : this.indexedColumns) {
            Field newField;
            Field oldField = oldRecord.getField(colIx);
            if (oldField.equals(newField = newRecord.getField(colIx))) continue;
            IndexTable indexTable = (IndexTable)this.secondaryIndexes.get(colIx);
            indexTable.deleteEntry(oldRecord);
            indexTable.addEntry(newRecord);
        }
    }

    void deletedRecord(DBRecord oldRecord) throws IOException {
        for (int indexedColumn : this.indexedColumns) {
            IndexTable indexTable = (IndexTable)this.secondaryIndexes.get(indexedColumn);
            indexTable.deleteEntry(oldRecord);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuild(TaskMonitor monitor) throws IOException, CancelledException {
        DBHandle dBHandle = this.db;
        synchronized (dBHandle) {
            this.db.checkTransaction();
            if (this.rootBufferId < 0) {
                return;
            }
            try {
                BTreeNode rootNode = this.getBTreeNode(this.rootBufferId);
                if (!rootNode.isConsistent(this.getName(), monitor)) {
                    throw new IOException("Low level tree consistency error (" + this.getName() + "): Unable to rebuild database");
                }
            }
            catch (IOException t) {
                throw new IOException("Low level tree consistency error (" + this.getName() + "): failed to fetch root buffer: " + t.getMessage());
            }
            finally {
                this.nodeMgr.releaseNodes();
            }
            try {
                for (int indexedColumn : this.indexedColumns) {
                    IndexTable indexTable = (IndexTable)this.secondaryIndexes.get(indexedColumn);
                    monitor.setMessage("Clear Index Table " + this.getName() + "." + this.schema.getFieldNames()[indexTable.getColumnIndex()]);
                    indexTable.indexTable.deleteAll();
                }
            }
            finally {
                this.nodeMgr.releaseNodes();
            }
            monitor.setMessage("Rebuild Table " + this.getName());
            int actualCount = 0;
            LongField maxKey = null;
            try {
                RecordIterator recIter = this.iterator();
                while (recIter.hasNext()) {
                    DBRecord rec = recIter.next();
                    ++actualCount;
                    Field keyField = rec.getKeyField();
                    if (keyField instanceof LongField && (maxKey == null || maxKey.compareTo(rec.getKeyField()) > 0)) {
                        maxKey = (LongField)keyField;
                    }
                    this.insertedRecord(rec);
                }
            }
            finally {
                this.nodeMgr.releaseNodes();
            }
            if (maxKey != null && maxKey.getLongValue() > this.tableRecord.getMaxKey()) {
                this.tableRecord.setMaxKey(maxKey.getLongValue());
            }
            this.tableRecord.setRecordCount(actualCount);
            if (!this.isConsistent(monitor)) {
                throw new IOException("Consistency check failed after rebuilding table " + this.getName());
            }
        }
    }

    public boolean isConsistent(TaskMonitor monitor) throws IOException, CancelledException {
        return this.isConsistent(null, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean isConsistent(String indexName, TaskMonitor monitor) throws IOException, CancelledException {
        DBHandle dBHandle = this.db;
        synchronized (dBHandle) {
            int n;
            int n2;
            Object object;
            Object indexTable;
            boolean consistent;
            if (this.rootBufferId < 0) {
                return true;
            }
            monitor.setMessage("Check Table " + this.getName());
            try {
                BTreeNode rootNode = this.getBTreeNode(this.rootBufferId);
                consistent = rootNode.isConsistent(this.getName(), monitor);
            }
            catch (IOException t) {
                Msg.debug((Object)this, (Object)("Consistency Error (" + this.getName() + "): failed to fetch root buffer: " + t.getMessage()));
                boolean bl = false;
                return bl;
            }
            finally {
                this.nodeMgr.releaseNodes();
            }
            int[] t = this.indexedColumns;
            int n3 = t.length;
            for (int i = 0; i < n3; consistent &= ((IndexTable)indexTable).isConsistent(monitor), ++i) {
                int indexedColumn = t[i];
                indexTable = (IndexTable)this.secondaryIndexes.get(indexedColumn);
                monitor.setMessage("Check Table " + this.getName() + "." + this.schema.getFieldNames()[((IndexTable)indexTable).getColumnIndex()]);
            }
            HashMap<Integer, Integer> missingIndexRecMap = new HashMap<Integer, Integer>();
            int actualCount = 0;
            RecordIterator recIter = this.iterator();
            block8: while (true) {
                DBRecord rec;
                if (recIter.hasNext()) {
                    rec = recIter.next();
                    ++actualCount;
                } else {
                    if (actualCount != this.getRecordCount()) {
                        consistent = false;
                        this.logIndexConsistencyError(indexName, "Table record count inconsistent: iterator-count=" + actualCount + " stored-count=" + this.getRecordCount());
                    }
                    object = missingIndexRecMap.keySet().iterator();
                    while (object.hasNext()) {
                        int indexCol = (Integer)object.next();
                        int missing = (Integer)missingIndexRecMap.get(indexCol);
                        this.logIndexConsistencyError(this.schema.getFieldNames()[indexCol], "Index is missing " + missing + " record references");
                    }
                    object = this.indexedColumns;
                    n2 = ((Object)object).length;
                    n = 0;
                    break;
                }
                indexTable = this.indexedColumns;
                n = ((Object)indexTable).length;
                int n4 = 0;
                while (true) {
                    if (n4 >= n) continue block8;
                    Object indexedColumn = indexTable[n4];
                    IndexTable indexTable2 = (IndexTable)this.secondaryIndexes.get((int)indexedColumn);
                    Field f = rec.getField((int)indexedColumn);
                    if (!indexTable2.isSparseIndex || !f.isNull()) {
                        Field[] keys;
                        boolean found = false;
                        for (Field key : keys = indexTable2.findPrimaryKeys(f)) {
                            if (!key.equals(rec.getKeyField())) continue;
                            found = true;
                            break;
                        }
                        if (!found) {
                            consistent = false;
                            Integer missing = (Integer)missingIndexRecMap.get(indexTable2.getColumnIndex());
                            if (missing == null) {
                                missingIndexRecMap.put(indexTable2.getColumnIndex(), 1);
                            } else {
                                missingIndexRecMap.put(indexTable2.getColumnIndex(), missing + 1);
                            }
                            this.logIndexConsistencyError(this.schema.getFieldNames()[indexTable2.getColumnIndex()], "Index table does not reference record key: " + rec.getKeyField().getValueAsString());
                        }
                    }
                    ++n4;
                }
                break;
            }
            while (n < n2) {
                Object indexedColumn = object[n];
                IndexTable indexTable3 = (IndexTable)this.secondaryIndexes.get((int)indexedColumn);
                monitor.setMessage("Check Index " + this.getName() + "." + this.schema.getFieldNames()[indexTable3.getColumnIndex()]);
                HashSet<Field> keySet = new HashSet<Field>();
                int extra = 0;
                DBFieldIterator keyIterator = indexTable3.keyIterator();
                while (keyIterator.hasNext()) {
                    Field key = keyIterator.next();
                    if (this.getRecord(key) == null) {
                        ++extra;
                    }
                    if (keySet.add(key)) continue;
                    this.logIndexConsistencyError(this.schema.getFieldNames()[indexTable3.getColumnIndex()], "Index table references duplicate key: " + key.getValueAsString());
                }
                if (extra != 0) {
                    consistent = false;
                    this.logIndexConsistencyError(this.schema.getFieldNames()[indexTable3.getColumnIndex()], "Index table references " + extra + " nonexistent record keys");
                }
                ++n;
            }
            return consistent;
        }
    }

    void logIndexConsistencyError(String indexName, String msg) {
        Msg.debug((Object)this, (Object)("Index Consistency Error (" + this.getName() + (String)(indexName != null ? "." + indexName : "") + "): " + msg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAll() throws IOException {
        DBHandle dBHandle = this.db;
        synchronized (dBHandle) {
            this.db.checkTransaction();
            if (this.rootBufferId < 0) {
                return;
            }
            try {
                BTreeNode rootNode = this.getBTreeNode(this.rootBufferId);
                try {
                    rootNode.delete();
                    for (int indexedColumn : this.indexedColumns) {
                        IndexTable indexTable = (IndexTable)this.secondaryIndexes.get(indexedColumn);
                        indexTable.deleteAll();
                    }
                }
                finally {
                    this.rootBufferId = -1;
                    this.tableRecord.setRootBufferId(-1);
                    this.recordCount = 0;
                    this.tableRecord.setRecordCount(0);
                    this.maximumKey = Long.MIN_VALUE;
                    this.tableRecord.setMaxKey(Long.MIN_VALUE);
                }
            }
            finally {
                this.nodeMgr.releaseNodes();
            }
        }
    }

    public int[] getIndexedColumns() {
        return this.indexedColumns;
    }

    void removeIndex(int columnIndex) throws IOException {
        IndexTable indexTable = (IndexTable)this.secondaryIndexes.get(columnIndex);
        if (indexTable != null) {
            indexTable.deleteAll();
            this.db.getMasterTable().deleteTableRecord(indexTable.getTableNum());
            this.secondaryIndexes.remove(columnIndex);
            this.indexedColumns = this.secondaryIndexes.getKeys();
        }
    }

    public Schema getSchema() {
        return this.schema;
    }

    public String getName() {
        return this.tableRecord.getName();
    }

    public boolean setName(String name) throws DuplicateNameException {
        return this.db.setTableName(this.getName(), name);
    }

    public int getRecordCount() {
        return this.tableRecord.getRecordCount();
    }

    public long getMaxKey() {
        return this.tableRecord.getMaxKey();
    }

    public long getKey() {
        long key = this.getMaxKey();
        if (key == Long.MIN_VALUE) {
            return 0L;
        }
        return key + 1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasRecord(long key) throws IOException {
        DBHandle dBHandle = this.db;
        synchronized (dBHandle) {
            if (this.rootBufferId < 0) {
                return false;
            }
            boolean result = false;
            try {
                LongKeyRecordNode leaf = this.nodeMgr.getLongKeyNode(this.rootBufferId).getLeafNode(key);
                result = leaf.getKeyIndex(key) >= 0;
            }
            finally {
                this.nodeMgr.releaseNodes();
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasRecord(Field key) throws IOException {
        DBHandle dBHandle = this.db;
        synchronized (dBHandle) {
            if (this.schema.useLongKeyNodes()) {
                return this.hasRecord(key.getLongValue());
            }
            if (this.rootBufferId < 0) {
                return false;
            }
            boolean result = false;
            try {
                FieldKeyRecordNode leaf = this.getFieldKeyNode(this.rootBufferId).getLeafNode(key);
                result = leaf.getKeyIndex(key) >= 0;
            }
            finally {
                this.nodeMgr.releaseNodes();
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBRecord getRecord(long key) throws IOException {
        DBHandle dBHandle = this.db;
        synchronized (dBHandle) {
            DBRecord dBRecord;
            if (this.rootBufferId < 0) {
                return null;
            }
            try {
                LongKeyRecordNode leaf = this.nodeMgr.getLongKeyNode(this.rootBufferId).getLeafNode(key);
                dBRecord = leaf.getRecord(key, this.schema);
            }
            catch (Throwable throwable) {
                this.nodeMgr.releaseNodes();
                throw throwable;
            }
            this.nodeMgr.releaseNodes();
            return dBRecord;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DBRecord getRecord(Field key) throws IOException {
        DBHandle dBHandle = this.db;
        synchronized (dBHandle) {
            if (this.rootBufferId < 0) {
                return null;
            }
            if (key instanceof LongField) {
                return this.getRecord(key.getLongValue());
            }
            try {
                if (key instanceof FixedField) {
                    FieldKeyRecordNode leaf = this.nodeMgr.getFixedKeyNode(this.rootBufferId).getLeafNode(key);
                    DBRecord dBRecord = leaf.getRecord(key, this.schema);
                    return dBRecord;
                }
                FieldKeyRecordNode leaf = this.getFieldKeyNode(this.rootBufferId).getLeafNode(key);
                DBRecord dBRecord = leaf.getRecord(key, this.schema);
                return dBRecord;
            }
            finally {
                this.nodeMgr.releaseNodes();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBRecord getRecordBefore(long key) throws IOException {
        DBHandle dBHandle = this.db;
        synchronized (dBHandle) {
            DBRecord dBRecord;
            if (this.rootBufferId < 0) {
                return null;
            }
            try {
                LongKeyRecordNode leaf = this.nodeMgr.getLongKeyNode(this.rootBufferId).getLeafNode(key);
                dBRecord = leaf.getRecordBefore(key, this.schema);
            }
            catch (Throwable throwable) {
                this.nodeMgr.releaseNodes();
                throw throwable;
            }
            this.nodeMgr.releaseNodes();
            return dBRecord;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBRecord getRecordBefore(Field key) throws IOException {
        DBHandle dBHandle = this.db;
        synchronized (dBHandle) {
            DBRecord dBRecord;
            if (this.rootBufferId < 0) {
                return null;
            }
            if (key instanceof LongField) {
                return this.getRecordBefore(key.getLongValue());
            }
            try {
                FieldKeyRecordNode leaf = this.getFieldKeyNode(this.rootBufferId).getLeafNode(key);
                dBRecord = leaf.getRecordBefore(key, this.schema);
            }
            catch (Throwable throwable) {
                this.nodeMgr.releaseNodes();
                throw throwable;
            }
            this.nodeMgr.releaseNodes();
            return dBRecord;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBRecord getRecordAfter(long key) throws IOException {
        DBHandle dBHandle = this.db;
        synchronized (dBHandle) {
            DBRecord dBRecord;
            if (this.rootBufferId < 0) {
                return null;
            }
            try {
                LongKeyRecordNode leaf = this.nodeMgr.getLongKeyNode(this.rootBufferId).getLeafNode(key);
                dBRecord = leaf.getRecordAfter(key, this.schema);
            }
            catch (Throwable throwable) {
                this.nodeMgr.releaseNodes();
                throw throwable;
            }
            this.nodeMgr.releaseNodes();
            return dBRecord;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBRecord getRecordAfter(Field key) throws IOException {
        DBHandle dBHandle = this.db;
        synchronized (dBHandle) {
            DBRecord dBRecord;
            if (this.rootBufferId < 0) {
                return null;
            }
            if (key instanceof LongField) {
                return this.getRecordAfter(key.getLongValue());
            }
            try {
                FieldKeyRecordNode leaf = this.getFieldKeyNode(this.rootBufferId).getLeafNode(key);
                dBRecord = leaf.getRecordAfter(key, this.schema);
            }
            catch (Throwable throwable) {
                this.nodeMgr.releaseNodes();
                throw throwable;
            }
            this.nodeMgr.releaseNodes();
            return dBRecord;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBRecord getRecordAtOrBefore(long key) throws IOException {
        DBHandle dBHandle = this.db;
        synchronized (dBHandle) {
            DBRecord dBRecord;
            if (this.rootBufferId < 0) {
                return null;
            }
            try {
                LongKeyRecordNode leaf = this.nodeMgr.getLongKeyNode(this.rootBufferId).getLeafNode(key);
                dBRecord = leaf.getRecordAtOrBefore(key, this.schema);
            }
            catch (Throwable throwable) {
                this.nodeMgr.releaseNodes();
                throw throwable;
            }
            this.nodeMgr.releaseNodes();
            return dBRecord;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBRecord getRecordAtOrBefore(Field key) throws IOException {
        DBHandle dBHandle = this.db;
        synchronized (dBHandle) {
            DBRecord dBRecord;
            if (this.rootBufferId < 0) {
                return null;
            }
            if (key instanceof LongField) {
                return this.getRecordAtOrBefore(key.getLongValue());
            }
            try {
                FieldKeyRecordNode leaf = this.getFieldKeyNode(this.rootBufferId).getLeafNode(key);
                dBRecord = leaf.getRecordAtOrBefore(key, this.schema);
            }
            catch (Throwable throwable) {
                this.nodeMgr.releaseNodes();
                throw throwable;
            }
            this.nodeMgr.releaseNodes();
            return dBRecord;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBRecord getRecordAtOrAfter(long key) throws IOException {
        DBHandle dBHandle = this.db;
        synchronized (dBHandle) {
            DBRecord dBRecord;
            if (this.rootBufferId < 0) {
                return null;
            }
            try {
                LongKeyRecordNode leaf = this.nodeMgr.getLongKeyNode(this.rootBufferId).getLeafNode(key);
                dBRecord = leaf.getRecordAtOrAfter(key, this.schema);
            }
            catch (Throwable throwable) {
                this.nodeMgr.releaseNodes();
                throw throwable;
            }
            this.nodeMgr.releaseNodes();
            return dBRecord;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBRecord getRecordAtOrAfter(Field key) throws IOException {
        DBHandle dBHandle = this.db;
        synchronized (dBHandle) {
            DBRecord dBRecord;
            if (this.rootBufferId < 0) {
                return null;
            }
            if (key instanceof LongField) {
                return this.getRecordAtOrAfter(key.getLongValue());
            }
            try {
                FieldKeyRecordNode leaf = this.getFieldKeyNode(this.rootBufferId).getLeafNode(key);
                dBRecord = leaf.getRecordAtOrAfter(key, this.schema);
            }
            catch (Throwable throwable) {
                this.nodeMgr.releaseNodes();
                throw throwable;
            }
            this.nodeMgr.releaseNodes();
            return dBRecord;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putRecord(DBRecord record) throws IOException {
        DBHandle dBHandle = this.db;
        synchronized (dBHandle) {
            this.db.checkTransaction();
            if (this.schema.useLongKeyNodes()) {
                this.putLongKeyRecord(record);
            } else {
                this.putFieldKeyRecord(record);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putLongKeyRecord(DBRecord record) throws IOException {
        try {
            ++this.modCount;
            LongKeyNode rootNode = null;
            rootNode = this.rootBufferId < 0 ? LongKeyRecordNode.createRecordNode(this.nodeMgr, this.schema) : this.nodeMgr.getLongKeyNode(this.rootBufferId);
            long recKey = record.getKey();
            LongKeyRecordNode leaf = rootNode.getLeafNode(recKey);
            rootNode = leaf.putRecord(record, this.isIndexed ? this : null);
            int id = rootNode.getBufferId();
            if (this.rootBufferId != id) {
                this.rootBufferId = id;
                this.tableRecord.setRootBufferId(this.rootBufferId);
            }
            if (this.maximumKey < recKey) {
                this.maximumKey = recKey;
                this.tableRecord.setMaxKey(this.maximumKey);
            }
        }
        finally {
            int delta = this.nodeMgr.releaseNodes();
            if (delta != 0) {
                this.recordCount += delta;
                this.tableRecord.setRecordCount(this.recordCount);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putFieldKeyRecord(DBRecord record) throws IOException {
        try {
            ++this.modCount;
            FieldKeyNode rootNode = null;
            rootNode = this.rootBufferId < 0 ? (this.schema.useFixedKeyNodes() ? FixedKeyRecordNode.createRecordNode(this.nodeMgr) : new VarKeyRecordNode(this.nodeMgr, this.schema.getKeyFieldType())) : this.getFieldKeyNode(this.rootBufferId);
            Field recKey = record.getKeyField();
            FieldKeyRecordNode leaf = rootNode.getLeafNode(recKey);
            rootNode = leaf.putRecord(record, this.isIndexed ? this : null);
            int id = rootNode.getBufferId();
            if (this.rootBufferId != id) {
                this.rootBufferId = id;
                this.tableRecord.setRootBufferId(this.rootBufferId);
            }
        }
        finally {
            int delta = this.nodeMgr.releaseNodes();
            if (delta != 0) {
                this.recordCount += delta;
                this.tableRecord.setRecordCount(this.recordCount);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteRecord(long key) throws IOException {
        DBHandle dBHandle = this.db;
        synchronized (dBHandle) {
            this.db.checkTransaction();
            boolean result = false;
            if (this.rootBufferId < 0) {
                return false;
            }
            if (!this.schema.useLongKeyNodes()) {
                throw new IllegalArgumentException("Field key required");
            }
            try {
                ++this.modCount;
                LongKeyNode rootNode = this.nodeMgr.getLongKeyNode(this.rootBufferId);
                LongKeyRecordNode leaf = rootNode.getLeafNode(key);
                rootNode = leaf.deleteRecord(key, this.isIndexed ? this : null);
                if (rootNode != null) {
                    int id = rootNode.getBufferId();
                    if (this.rootBufferId != id) {
                        this.rootBufferId = id;
                        this.tableRecord.setRootBufferId(this.rootBufferId);
                    }
                } else {
                    this.rootBufferId = -1;
                    this.tableRecord.setRootBufferId(this.rootBufferId);
                }
            }
            finally {
                int delta = this.nodeMgr.releaseNodes();
                if (delta != 0) {
                    result = true;
                    this.recordCount += delta;
                    this.tableRecord.setRecordCount(this.recordCount);
                }
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteRecord(Field key) throws IOException {
        DBHandle dBHandle = this.db;
        synchronized (dBHandle) {
            this.db.checkTransaction();
            boolean result = false;
            if (this.rootBufferId < 0) {
                return false;
            }
            if (key instanceof LongField) {
                return this.deleteRecord(key.getLongValue());
            }
            try {
                ++this.modCount;
                FieldKeyNode rootNode = this.getFieldKeyNode(this.rootBufferId);
                FieldKeyRecordNode leaf = rootNode.getLeafNode(key);
                rootNode = leaf.deleteRecord(key, this.isIndexed ? this : null);
                if (rootNode != null) {
                    int id = rootNode.getBufferId();
                    if (this.rootBufferId != id) {
                        this.rootBufferId = id;
                        this.tableRecord.setRootBufferId(this.rootBufferId);
                    }
                } else {
                    this.rootBufferId = -1;
                    this.tableRecord.setRootBufferId(this.rootBufferId);
                }
            }
            finally {
                int delta = this.nodeMgr.releaseNodes();
                if (delta != 0) {
                    result = true;
                    this.recordCount += delta;
                    this.tableRecord.setRecordCount(this.recordCount);
                }
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean deleteRecords(long startKey, long endKey) throws IOException {
        DBHandle dBHandle = this.db;
        synchronized (dBHandle) {
            this.db.checkTransaction();
            if (startKey > endKey) {
                throw new IllegalArgumentException();
            }
            if (!this.schema.useLongKeyNodes()) {
                throw new IllegalArgumentException("Long key required");
            }
            boolean result = false;
            if (this.rootBufferId < 0) {
                return result;
            }
            try {
                ++this.modCount;
                LongKeyNode rootNode = this.nodeMgr.getLongKeyNode(this.rootBufferId);
                LongKeyRecordNode leaf = rootNode.getLeafNode(startKey);
                try {
                    int index = leaf.getKeyIndex(startKey);
                    long lastKey = 0L;
                    if (index < 0) {
                        index = -index - 1;
                    }
                    if (index > 0) {
                        int lastIndex = leaf.getKeyIndex(endKey);
                        if (lastIndex < 0) {
                            lastIndex = -lastIndex - 2;
                        }
                        while (index <= lastIndex--) {
                            if (this.isIndexed) {
                                this.deletedRecord(leaf.getRecord(this.schema, index));
                            }
                            leaf.remove(index);
                        }
                        result = true;
                        if (index < leaf.keyCount) {
                            boolean bl = result;
                            return bl;
                        }
                        LongKeyRecordNode nextLeaf2 = leaf.getNextLeaf();
                        if (nextLeaf2 == null) {
                            boolean delta = result;
                            return delta;
                        }
                        lastKey = nextLeaf2.getKey(nextLeaf2.keyCount - 1);
                        leaf = rootNode.getLeafNode(lastKey);
                        index = 0;
                    } else {
                        lastKey = leaf.getKey(leaf.keyCount - 1);
                    }
                    while (lastKey <= endKey) {
                        if (this.isIndexed) {
                            for (int n = 0; n < leaf.keyCount; ++n) {
                                this.deletedRecord(leaf.getRecord(this.schema, n));
                            }
                        }
                        LongKeyRecordNode nextLeaf = leaf.getNextLeaf();
                        rootNode = leaf.removeLeaf();
                        result = true;
                        if (nextLeaf == null) {
                            boolean nextLeaf2 = result;
                            return nextLeaf2;
                        }
                        lastKey = nextLeaf.getKey(nextLeaf.keyCount - 1);
                        leaf = rootNode.getLeafNode(lastKey);
                    }
                    int lastIndex = leaf.getKeyIndex(endKey);
                    if (lastIndex < 0) {
                        lastIndex = -lastIndex - 2;
                    }
                    long key = leaf.getKey(0);
                    while (index <= lastIndex--) {
                        if (this.isIndexed) {
                            this.deletedRecord(leaf.getRecord(this.schema, index));
                        }
                        leaf.remove(index);
                        result = true;
                    }
                    if (index == 0 && leaf.parent != null) {
                        leaf.parent.keyChanged(key, leaf.getKey(0));
                    }
                }
                finally {
                    if (rootNode != null) {
                        int id = rootNode.getBufferId();
                        if (this.rootBufferId != id) {
                            this.rootBufferId = id;
                            this.tableRecord.setRootBufferId(this.rootBufferId);
                        }
                    } else {
                        this.rootBufferId = -1;
                        this.tableRecord.setRootBufferId(this.rootBufferId);
                    }
                }
            }
            finally {
                int delta = this.nodeMgr.releaseNodes();
                if (delta != 0) {
                    result = true;
                    this.recordCount += delta;
                    this.tableRecord.setRecordCount(this.recordCount);
                }
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean deleteRecords(Field startKey, Field endKey) throws IOException {
        DBHandle dBHandle = this.db;
        synchronized (dBHandle) {
            this.db.checkTransaction();
            if (startKey.compareTo(endKey) > 0) {
                throw new IllegalArgumentException();
            }
            if (this.schema.useLongKeyNodes()) {
                throw new IllegalArgumentException("Field key required");
            }
            boolean result = false;
            if (this.rootBufferId < 0) {
                return result;
            }
            try {
                ++this.modCount;
                FieldKeyNode rootNode = this.getFieldKeyNode(this.rootBufferId);
                FieldKeyRecordNode leaf = rootNode.getLeafNode(startKey);
                try {
                    int index = leaf.getKeyIndex(startKey);
                    Field lastKey = null;
                    if (index < 0) {
                        index = -index - 1;
                    }
                    if (index > 0) {
                        int lastIndex = leaf.getKeyIndex(endKey);
                        if (lastIndex < 0) {
                            lastIndex = -lastIndex - 2;
                        }
                        while (index <= lastIndex--) {
                            if (this.isIndexed) {
                                this.deletedRecord(leaf.getRecord(this.schema, index));
                            }
                            leaf.remove(index);
                        }
                        result = true;
                        if (index < leaf.getKeyCount()) {
                            boolean bl = result;
                            return bl;
                        }
                        FieldKeyRecordNode nextLeaf = leaf.getNextLeaf();
                        if (nextLeaf == null) {
                            boolean delta = result;
                            return delta;
                        }
                        lastKey = nextLeaf.getKeyField(nextLeaf.getKeyCount() - 1);
                        leaf = rootNode.getLeafNode(lastKey);
                        index = 0;
                    } else {
                        lastKey = leaf.getKeyField(leaf.getKeyCount() - 1);
                    }
                    while (lastKey.compareTo(endKey) <= 0) {
                        if (this.isIndexed) {
                            int count = leaf.getKeyCount();
                            for (int n = 0; n < count; ++n) {
                                this.deletedRecord(leaf.getRecord(this.schema, n));
                            }
                        }
                        FieldKeyRecordNode nextLeaf = leaf.getNextLeaf();
                        rootNode = leaf.removeLeaf();
                        result = true;
                        if (nextLeaf == null) {
                            boolean n = result;
                            return n;
                        }
                        lastKey = nextLeaf.getKeyField(nextLeaf.getKeyCount() - 1);
                        leaf = rootNode.getLeafNode(lastKey);
                    }
                    int lastIndex = leaf.getKeyIndex(endKey);
                    if (lastIndex < 0) {
                        lastIndex = -lastIndex - 2;
                    }
                    Field key = leaf.getKeyField(0);
                    while (index <= lastIndex--) {
                        if (this.isIndexed) {
                            this.deletedRecord(leaf.getRecord(this.schema, index));
                        }
                        leaf.remove(index);
                        result = true;
                    }
                    if (index == 0 && leaf.getParent() != null) {
                        leaf.getParent().keyChanged(key, leaf.getKeyField(0), leaf);
                    }
                }
                finally {
                    if (rootNode != null) {
                        int id = rootNode.getBufferId();
                        if (this.rootBufferId != id) {
                            this.rootBufferId = id;
                            this.tableRecord.setRootBufferId(this.rootBufferId);
                        }
                    } else {
                        this.rootBufferId = -1;
                        this.tableRecord.setRootBufferId(this.rootBufferId);
                    }
                }
            }
            finally {
                int delta = this.nodeMgr.releaseNodes();
                if (delta != 0) {
                    result = true;
                    this.recordCount += delta;
                    this.tableRecord.setRecordCount(this.recordCount);
                }
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Field[] findRecords(Field field, int columnIndex) throws IOException {
        DBHandle dBHandle = this.db;
        synchronized (dBHandle) {
            IndexTable indexTable = (IndexTable)this.secondaryIndexes.get(columnIndex);
            if (indexTable == null) {
                throw new IOException("Index required (" + this.getName() + "," + columnIndex + ")");
            }
            return indexTable.findPrimaryKeys(field);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMatchingRecordCount(Field field, int columnIndex) throws IOException {
        DBHandle dBHandle = this.db;
        synchronized (dBHandle) {
            IndexTable indexTable = (IndexTable)this.secondaryIndexes.get(columnIndex);
            if (indexTable == null) {
                throw new IOException("Index required (" + this.getName() + "," + columnIndex + ")");
            }
            return indexTable.getKeyCount(field);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasRecord(Field field, int columnIndex) throws IOException {
        DBHandle dBHandle = this.db;
        synchronized (dBHandle) {
            IndexTable indexTable = (IndexTable)this.secondaryIndexes.get(columnIndex);
            if (indexTable == null) {
                throw new IOException("Index required (" + this.getName() + "," + columnIndex + ")");
            }
            return indexTable.hasRecord(field);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBFieldIterator indexFieldIterator(int columnIndex) throws IOException {
        DBHandle dBHandle = this.db;
        synchronized (dBHandle) {
            IndexTable indexTable = (IndexTable)this.secondaryIndexes.get(columnIndex);
            if (indexTable == null) {
                throw new IOException("Index required (" + this.getName() + "," + columnIndex + ")");
            }
            return indexTable.indexIterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBFieldIterator indexFieldIterator(Field minField, Field maxField, boolean before, int columnIndex) throws IOException {
        DBHandle dBHandle = this.db;
        synchronized (dBHandle) {
            IndexTable indexTable = (IndexTable)this.secondaryIndexes.get(columnIndex);
            if (indexTable == null) {
                throw new IOException("Index required (" + this.getName() + "," + columnIndex + ")");
            }
            return indexTable.indexIterator(minField, maxField, before);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBFieldIterator indexFieldIterator(Field minField, Field maxField, Field startField, boolean before, int columnIndex) throws IOException {
        DBHandle dBHandle = this.db;
        synchronized (dBHandle) {
            IndexTable indexTable = (IndexTable)this.secondaryIndexes.get(columnIndex);
            if (indexTable == null) {
                throw new IOException("Index required (" + this.getName() + "," + columnIndex + ")");
            }
            return indexTable.indexIterator(minField, maxField, startField, before);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordIterator indexIterator(int columnIndex) throws IOException {
        DBHandle dBHandle = this.db;
        synchronized (dBHandle) {
            IndexTable indexTable = (IndexTable)this.secondaryIndexes.get(columnIndex);
            if (indexTable == null) {
                throw new IOException("Index required (" + this.getName() + "," + columnIndex + ")");
            }
            return new KeyToRecordIterator(this, indexTable.keyIterator());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordIterator indexIterator(int columnIndex, Field startValue, Field endValue, boolean atStart) throws IOException {
        DBHandle dBHandle = this.db;
        synchronized (dBHandle) {
            IndexTable indexTable = (IndexTable)this.secondaryIndexes.get(columnIndex);
            if (indexTable == null) {
                throw new IOException("Index required (" + this.getName() + "," + columnIndex + ")");
            }
            return new KeyToRecordIterator(this, indexTable.keyIterator(startValue, endValue, atStart));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordIterator indexIteratorAfter(int columnIndex, Field startValue) throws IOException {
        DBHandle dBHandle = this.db;
        synchronized (dBHandle) {
            IndexTable indexTable = (IndexTable)this.secondaryIndexes.get(columnIndex);
            if (indexTable == null) {
                throw new IOException("Index required (" + this.getName() + "," + columnIndex + ")");
            }
            return new KeyToRecordIterator(this, indexTable.keyIteratorAfter(startValue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordIterator indexIteratorBefore(int columnIndex, Field startValue) throws IOException {
        DBHandle dBHandle = this.db;
        synchronized (dBHandle) {
            IndexTable indexTable = (IndexTable)this.secondaryIndexes.get(columnIndex);
            if (indexTable == null) {
                throw new IOException("Index required (" + this.getName() + "," + columnIndex + ")");
            }
            return new KeyToRecordIterator(this, indexTable.keyIteratorBefore(startValue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordIterator indexIteratorAfter(int columnIndex, Field startValue, Field primaryKey) throws IOException {
        DBHandle dBHandle = this.db;
        synchronized (dBHandle) {
            IndexTable indexTable = (IndexTable)this.secondaryIndexes.get(columnIndex);
            if (indexTable == null) {
                throw new IOException("Index required (" + this.getName() + "," + columnIndex + ")");
            }
            return new KeyToRecordIterator(this, indexTable.keyIteratorAfter(startValue, primaryKey));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordIterator indexIteratorBefore(int columnIndex, Field startValue, Field primaryKey) throws IOException {
        DBHandle dBHandle = this.db;
        synchronized (dBHandle) {
            IndexTable indexTable = (IndexTable)this.secondaryIndexes.get(columnIndex);
            if (indexTable == null) {
                throw new IOException("Index required (" + this.getName() + "," + columnIndex + ")");
            }
            return new KeyToRecordIterator(this, indexTable.keyIteratorBefore(startValue, primaryKey));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBFieldIterator indexKeyIterator(int columnIndex) throws IOException {
        DBHandle dBHandle = this.db;
        synchronized (dBHandle) {
            IndexTable indexTable = (IndexTable)this.secondaryIndexes.get(columnIndex);
            if (indexTable == null) {
                throw new IOException("Index required (" + this.getName() + "," + columnIndex + ")");
            }
            return indexTable.keyIterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBFieldIterator indexKeyIteratorBefore(int columnIndex, Field startField) throws IOException {
        DBHandle dBHandle = this.db;
        synchronized (dBHandle) {
            IndexTable indexTable = (IndexTable)this.secondaryIndexes.get(columnIndex);
            if (indexTable == null) {
                throw new IOException("Index required (" + this.getName() + "," + columnIndex + ")");
            }
            return indexTable.keyIteratorBefore(startField);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBFieldIterator indexKeyIteratorAfter(int columnIndex, Field startField) throws IOException {
        DBHandle dBHandle = this.db;
        synchronized (dBHandle) {
            IndexTable indexTable = (IndexTable)this.secondaryIndexes.get(columnIndex);
            if (indexTable == null) {
                throw new IOException("Index required (" + this.getName() + "," + columnIndex + ")");
            }
            return indexTable.keyIteratorAfter(startField);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBFieldIterator indexKeyIteratorBefore(int columnIndex, Field startField, Field primaryKey) throws IOException {
        DBHandle dBHandle = this.db;
        synchronized (dBHandle) {
            IndexTable indexTable = (IndexTable)this.secondaryIndexes.get(columnIndex);
            if (indexTable == null) {
                throw new IOException("Index required (" + this.getName() + "," + columnIndex + ")");
            }
            return indexTable.keyIteratorBefore(startField, primaryKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBFieldIterator indexKeyIteratorAfter(int columnIndex, Field startField, Field primaryKey) throws IOException {
        DBHandle dBHandle = this.db;
        synchronized (dBHandle) {
            IndexTable indexTable = (IndexTable)this.secondaryIndexes.get(columnIndex);
            if (indexTable == null) {
                throw new IOException("Index required (" + this.getName() + "," + columnIndex + ")");
            }
            return indexTable.keyIteratorAfter(startField, primaryKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBFieldIterator indexKeyIterator(int columnIndex, Field minField, Field maxField, boolean atMin) throws IOException {
        DBHandle dBHandle = this.db;
        synchronized (dBHandle) {
            IndexTable indexTable = (IndexTable)this.secondaryIndexes.get(columnIndex);
            if (indexTable == null) {
                throw new IOException("Index required (" + this.getName() + "," + columnIndex + ")");
            }
            return indexTable.keyIterator(minField, maxField, atMin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBFieldIterator indexKeyIterator(int columnIndex, Field minField, Field maxField, Field startField, boolean before) throws IOException {
        DBHandle dBHandle = this.db;
        synchronized (dBHandle) {
            IndexTable indexTable = (IndexTable)this.secondaryIndexes.get(columnIndex);
            if (indexTable == null) {
                throw new IOException("Index required (" + this.getName() + "," + columnIndex + ")");
            }
            return indexTable.keyIterator(minField, maxField, startField, before);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordIterator iterator() throws IOException {
        DBHandle dBHandle = this.db;
        synchronized (dBHandle) {
            if (this.schema.useLongKeyNodes()) {
                return new LongKeyRecordIterator();
            }
            return new FieldKeyRecordIterator(null, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordIterator iterator(long startKey) throws IOException {
        DBHandle dBHandle = this.db;
        synchronized (dBHandle) {
            if (!this.schema.useLongKeyNodes()) {
                throw new IllegalArgumentException("Field key required");
            }
            return new LongKeyRecordIterator(Long.MIN_VALUE, Long.MAX_VALUE, startKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordIterator iterator(long minKey, long maxKey, long startKey) throws IOException {
        DBHandle dBHandle = this.db;
        synchronized (dBHandle) {
            if (!this.schema.useLongKeyNodes()) {
                throw new IllegalArgumentException("Field key required");
            }
            return new LongKeyRecordIterator(minKey, maxKey, startKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordIterator iterator(Field startKey) throws IOException {
        DBHandle dBHandle = this.db;
        synchronized (dBHandle) {
            if (this.schema.useLongKeyNodes()) {
                return new LongKeyRecordIterator(Long.MIN_VALUE, Long.MAX_VALUE, startKey.getLongValue());
            }
            return new FieldKeyRecordIterator(null, null, startKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordIterator iterator(Field minKey, Field maxKey, Field startKey) throws IOException {
        DBHandle dBHandle = this.db;
        synchronized (dBHandle) {
            if (this.schema.useLongKeyNodes()) {
                long min = minKey != null ? minKey.getLongValue() : Long.MIN_VALUE;
                long max = maxKey != null ? maxKey.getLongValue() : Long.MAX_VALUE;
                long start = startKey != null ? startKey.getLongValue() : min;
                return new LongKeyRecordIterator(min, max, start);
            }
            return new FieldKeyRecordIterator(minKey, maxKey, startKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBLongIterator longKeyIterator() throws IOException {
        DBHandle dBHandle = this.db;
        synchronized (dBHandle) {
            if (!this.schema.useLongKeyNodes()) {
                throw new AssertException();
            }
            return new LongKeyIterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBLongIterator longKeyIterator(long startKey) throws IOException {
        DBHandle dBHandle = this.db;
        synchronized (dBHandle) {
            if (!this.schema.useLongKeyNodes()) {
                throw new AssertException();
            }
            return new LongKeyIterator(Long.MIN_VALUE, Long.MAX_VALUE, startKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBLongIterator longKeyIterator(long minKey, long maxKey, long startKey) throws IOException {
        DBHandle dBHandle = this.db;
        synchronized (dBHandle) {
            if (!this.schema.useLongKeyNodes()) {
                throw new AssertException();
            }
            return new LongKeyIterator(minKey, maxKey, startKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBFieldIterator fieldKeyIterator() throws IOException {
        DBHandle dBHandle = this.db;
        synchronized (dBHandle) {
            if (this.schema.useLongKeyNodes()) {
                throw new AssertException();
            }
            return new FieldKeyIterator(null, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBFieldIterator fieldKeyIterator(Field startKey) throws IOException {
        DBHandle dBHandle = this.db;
        synchronized (dBHandle) {
            if (this.schema.useLongKeyNodes()) {
                throw new AssertException();
            }
            return new FieldKeyIterator(null, null, startKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBFieldIterator fieldKeyIterator(Field minKey, Field maxKey, Field startKey) throws IOException {
        DBHandle dBHandle = this.db;
        synchronized (dBHandle) {
            if (this.schema.useLongKeyNodes()) {
                throw new AssertException();
            }
            return new FieldKeyIterator(minKey, maxKey, startKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBFieldIterator fieldKeyIterator(Field minKey, Field maxKey, boolean before) throws IOException {
        DBHandle dBHandle = this.db;
        synchronized (dBHandle) {
            if (this.schema.useLongKeyNodes()) {
                throw new AssertException();
            }
            return new FieldKeyIterator(minKey, maxKey, before);
        }
    }

    public boolean isInvalid() {
        return this.nodeMgr == null;
    }

    public String toString() {
        return this.getName() + "(" + this.getRecordCount() + ")";
    }

    private class LongKeyRecordIterator
    implements RecordIterator {
        private int bufferId = -1;
        private int recordIndex;
        private boolean isNext;
        private boolean isPrev;
        private DBRecord record;
        private long curKey;
        private DBRecord lastRecord;
        private boolean hasPrev;
        private boolean hasNext;
        private long minKey;
        private long maxKey;
        private int expectedModCount;

        private LongKeyRecordIterator() throws IOException {
            this(Long.MIN_VALUE, Long.MAX_VALUE, Long.MIN_VALUE);
            this.hasPrev = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LongKeyRecordIterator(long minKey, long maxKey, long startKey) throws IOException {
            this.expectedModCount = Table.this.modCount;
            this.minKey = minKey;
            this.maxKey = maxKey;
            if (Table.this.rootBufferId < 0) {
                return;
            }
            if (minKey > maxKey) {
                return;
            }
            try {
                LongKeyNode rootNode = Table.this.nodeMgr.getLongKeyNode(Table.this.rootBufferId);
                LongKeyRecordNode leaf = rootNode.getLeafNode(startKey);
                this.recordIndex = leaf.getKeyIndex(startKey);
                if (this.recordIndex >= 0) {
                    this.hasPrev = true;
                    this.hasNext = true;
                } else {
                    this.recordIndex = -(this.recordIndex + 1);
                    if (this.recordIndex == leaf.keyCount) {
                        --this.recordIndex;
                        boolean bl = this.hasPrev = leaf.getKey(this.recordIndex) >= minKey;
                        if (!this.hasPrev) {
                            if ((leaf = leaf.getNextLeaf()) == null) {
                                return;
                            }
                            this.recordIndex = 0;
                            this.hasNext = leaf.getKey(this.recordIndex) <= maxKey;
                        }
                    } else {
                        boolean bl = this.hasNext = leaf.getKey(this.recordIndex) <= maxKey;
                        if (!this.hasNext) {
                            if (this.recordIndex == 0) {
                                if ((leaf = leaf.getPreviousLeaf()) == null) {
                                    return;
                                }
                                this.recordIndex = leaf.keyCount - 1;
                            } else {
                                --this.recordIndex;
                            }
                            boolean bl2 = this.hasPrev = leaf.getKey(this.recordIndex) >= minKey;
                        }
                    }
                }
                if (this.hasPrev || this.hasNext) {
                    this.bufferId = leaf.getBufferId();
                    this.record = leaf.getRecord(Table.this.schema, this.recordIndex);
                    this.curKey = this.record.getKey();
                }
            }
            finally {
                Table.this.nodeMgr.releaseNodes();
            }
        }

        private LongKeyRecordNode getRecordLeaf(boolean recoverPrev) throws IOException {
            if (Table.this.rootBufferId < 0 || this.record == null) {
                return null;
            }
            LongKeyRecordNode leaf = null;
            this.isNext = false;
            this.isPrev = false;
            if (this.expectedModCount == Table.this.modCount) {
                leaf = (LongKeyRecordNode)Table.this.nodeMgr.getLongKeyNode(this.bufferId);
                if (this.recordIndex >= leaf.keyCount || leaf.getKey(this.recordIndex) != this.curKey) {
                    leaf = null;
                }
            }
            if (leaf == null) {
                LongKeyNode rootNode = Table.this.nodeMgr.getLongKeyNode(Table.this.rootBufferId);
                leaf = rootNode.getLeafNode(this.curKey);
                int index = leaf.getKeyIndex(this.curKey);
                if (index < 0) {
                    index = -index - 1;
                    if (recoverPrev) {
                        if (--index < 0) {
                            index = (leaf = leaf.getPreviousLeaf()) != null ? leaf.keyCount - 1 : 0;
                        }
                        this.isPrev = true;
                    } else {
                        if (index == leaf.keyCount) {
                            leaf = leaf.getNextLeaf();
                            index = 0;
                        }
                        this.isNext = true;
                    }
                }
                if (leaf != null) {
                    this.bufferId = leaf.getBufferId();
                    this.recordIndex = index;
                }
                this.expectedModCount = Table.this.modCount;
            }
            return leaf;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean hasNext() throws IOException {
            DBHandle dBHandle = Table.this.db;
            synchronized (dBHandle) {
                if (!this.hasNext && Table.this.nodeMgr != null) {
                    try {
                        DBRecord nextRecord;
                        LongKeyRecordNode leaf = this.getRecordLeaf(false);
                        if (leaf == null) {
                            boolean bl = false;
                            return bl;
                        }
                        int nextIndex = this.recordIndex;
                        if (!this.isNext) {
                            ++nextIndex;
                        }
                        int nextBufferId = this.bufferId;
                        if (nextIndex == leaf.keyCount) {
                            if ((leaf = leaf.getNextLeaf()) == null) {
                                boolean bl = false;
                                return bl;
                            }
                            nextBufferId = leaf.getBufferId();
                            nextIndex = 0;
                        }
                        boolean bl = this.hasNext = (nextRecord = leaf.getRecord(Table.this.schema, nextIndex)).getKey() <= this.maxKey;
                        if (this.hasNext) {
                            this.bufferId = nextBufferId;
                            this.recordIndex = nextIndex;
                            this.record = nextRecord;
                            this.curKey = this.record.getKey();
                            this.hasPrev = false;
                        }
                    }
                    finally {
                        Table.this.nodeMgr.releaseNodes();
                    }
                }
                return this.hasNext;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean hasPrevious() throws IOException {
            DBHandle dBHandle = Table.this.db;
            synchronized (dBHandle) {
                if (!this.hasPrev && Table.this.nodeMgr != null) {
                    try {
                        DBRecord prevRecord;
                        LongKeyRecordNode leaf = this.getRecordLeaf(true);
                        if (leaf == null) {
                            boolean bl = false;
                            return bl;
                        }
                        int prevIndex = this.recordIndex;
                        if (!this.isPrev) {
                            --prevIndex;
                        }
                        int prevBufferId = this.bufferId;
                        if (prevIndex < 0) {
                            if ((leaf = leaf.getPreviousLeaf()) == null) {
                                boolean bl = false;
                                return bl;
                            }
                            prevBufferId = leaf.getBufferId();
                            prevIndex = leaf.keyCount - 1;
                        }
                        boolean bl = this.hasPrev = (prevRecord = leaf.getRecord(Table.this.schema, prevIndex)).getKey() >= this.minKey;
                        if (this.hasPrev) {
                            this.bufferId = prevBufferId;
                            this.recordIndex = prevIndex;
                            this.record = prevRecord;
                            this.curKey = this.record.getKey();
                            this.hasNext = false;
                        }
                    }
                    finally {
                        Table.this.nodeMgr.releaseNodes();
                    }
                }
                return this.hasPrev;
            }
        }

        @Override
        public DBRecord next() throws IOException {
            if (this.hasNext || this.hasNext()) {
                this.hasNext = false;
                this.hasPrev = true;
                this.lastRecord = this.record;
                return this.record;
            }
            return null;
        }

        @Override
        public DBRecord previous() throws IOException {
            if (this.hasPrev || this.hasPrevious()) {
                this.hasNext = true;
                this.hasPrev = false;
                this.lastRecord = this.record;
                return this.record;
            }
            return null;
        }

        @Override
        public boolean delete() throws IOException {
            if (this.lastRecord == null) {
                return false;
            }
            Table.this.deleteRecord(this.lastRecord.getKey());
            this.lastRecord = null;
            return true;
        }
    }

    private class FieldKeyRecordIterator
    implements RecordIterator {
        private int bufferId = -1;
        private int recordIndex;
        private boolean isNext;
        private boolean isPrev;
        private DBRecord record;
        private DBRecord lastRecord;
        private boolean hasPrev;
        private boolean hasNext;
        private Field minKey;
        private Field maxKey;
        private int expectedModCount;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        FieldKeyRecordIterator(Field minKey, Field maxKey, Field startKey) throws IOException {
            this.expectedModCount = Table.this.modCount;
            this.minKey = minKey;
            this.maxKey = maxKey;
            if (Table.this.rootBufferId < 0) {
                return;
            }
            if (minKey != null && maxKey != null && minKey.compareTo(maxKey) > 0) {
                return;
            }
            if (startKey == null) {
                startKey = minKey;
            }
            try {
                FieldKeyNode rootNode = Table.this.getFieldKeyNode(Table.this.rootBufferId);
                if (startKey == null) {
                    FieldKeyRecordNode leaf = rootNode.getLeftmostLeafNode();
                    this.bufferId = leaf.getBufferId();
                    this.recordIndex = 0;
                    this.record = leaf.getRecord(Table.this.schema, 0);
                    this.hasNext = true;
                } else {
                    FieldKeyRecordNode leaf = rootNode.getLeafNode(startKey);
                    this.recordIndex = leaf.getKeyIndex(startKey);
                    if (this.recordIndex >= 0) {
                        this.hasPrev = true;
                        this.hasNext = true;
                    } else {
                        this.recordIndex = -(this.recordIndex + 1);
                        if (this.recordIndex == leaf.getKeyCount()) {
                            --this.recordIndex;
                            boolean bl = minKey == null ? true : (this.hasPrev = leaf.getKeyField(this.recordIndex).compareTo(minKey) >= 0);
                            if (!this.hasPrev) {
                                if ((leaf = leaf.getNextLeaf()) == null) {
                                    return;
                                }
                                this.recordIndex = 0;
                                this.hasNext = maxKey == null ? true : leaf.getKeyField(this.recordIndex).compareTo(maxKey) <= 0;
                            }
                        } else {
                            boolean bl = maxKey == null ? true : (this.hasNext = leaf.getKeyField(this.recordIndex).compareTo(maxKey) <= 0);
                            if (!this.hasNext) {
                                if (this.recordIndex == 0) {
                                    if ((leaf = leaf.getPreviousLeaf()) == null) {
                                        return;
                                    }
                                    this.recordIndex = leaf.getKeyCount() - 1;
                                } else {
                                    --this.recordIndex;
                                }
                                boolean bl2 = minKey == null ? true : (this.hasPrev = leaf.getKeyField(this.recordIndex).compareTo(minKey) >= 0);
                            }
                        }
                    }
                    if (this.hasPrev || this.hasNext) {
                        this.bufferId = leaf.getBufferId();
                        this.record = leaf.getRecord(Table.this.schema, this.recordIndex);
                    }
                }
            }
            finally {
                Table.this.nodeMgr.releaseNodes();
            }
        }

        private FieldKeyRecordNode getRecordLeaf(boolean recoverPrev) throws IOException {
            if (Table.this.rootBufferId < 0 || this.record == null) {
                return null;
            }
            Field key = this.record.getKeyField();
            FieldKeyRecordNode leaf = null;
            this.isNext = false;
            this.isPrev = false;
            if (!(this.expectedModCount != Table.this.modCount || this.recordIndex < (leaf = (FieldKeyRecordNode)Table.this.getFieldKeyNode(this.bufferId)).getKeyCount() && leaf.getKeyField(this.recordIndex).equals(key))) {
                leaf = null;
            }
            if (leaf == null) {
                FieldKeyNode rootNode = Table.this.getFieldKeyNode(Table.this.rootBufferId);
                leaf = rootNode.getLeafNode(key);
                int index = leaf.getKeyIndex(key);
                if (index < 0) {
                    index = -index - 1;
                    if (recoverPrev) {
                        if (--index < 0) {
                            index = (leaf = leaf.getPreviousLeaf()) != null ? leaf.getKeyCount() - 1 : 0;
                        }
                        this.isPrev = true;
                    } else {
                        if (index == leaf.getKeyCount()) {
                            leaf = leaf.getNextLeaf();
                            index = 0;
                        }
                        this.isNext = true;
                    }
                }
                if (leaf != null) {
                    this.bufferId = leaf.getBufferId();
                    this.recordIndex = index;
                }
                this.expectedModCount = Table.this.modCount;
            }
            return leaf;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean hasNext() throws IOException {
            DBHandle dBHandle = Table.this.db;
            synchronized (dBHandle) {
                if (!this.hasNext && Table.this.nodeMgr != null) {
                    try {
                        FieldKeyRecordNode leaf = this.getRecordLeaf(false);
                        if (leaf == null) {
                            boolean bl = false;
                            return bl;
                        }
                        int nextIndex = this.recordIndex;
                        if (!this.isNext) {
                            ++nextIndex;
                        }
                        int nextBufferId = this.bufferId;
                        if (nextIndex == leaf.getKeyCount()) {
                            if ((leaf = leaf.getNextLeaf()) == null) {
                                boolean bl = false;
                                return bl;
                            }
                            nextBufferId = leaf.getBufferId();
                            nextIndex = 0;
                        }
                        DBRecord nextRecord = leaf.getRecord(Table.this.schema, nextIndex);
                        boolean bl = this.maxKey == null ? true : (this.hasNext = nextRecord.getKeyField().compareTo(this.maxKey) <= 0);
                        if (this.hasNext) {
                            this.bufferId = nextBufferId;
                            this.recordIndex = nextIndex;
                            this.record = nextRecord;
                            this.hasPrev = false;
                        }
                    }
                    finally {
                        Table.this.nodeMgr.releaseNodes();
                    }
                }
                return this.hasNext;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean hasPrevious() throws IOException {
            DBHandle dBHandle = Table.this.db;
            synchronized (dBHandle) {
                if (!this.hasPrev && Table.this.nodeMgr != null) {
                    try {
                        FieldKeyRecordNode leaf = this.getRecordLeaf(true);
                        if (leaf == null) {
                            boolean bl = false;
                            return bl;
                        }
                        int prevIndex = this.recordIndex;
                        if (!this.isPrev) {
                            --prevIndex;
                        }
                        int prevBufferId = this.bufferId;
                        if (prevIndex < 0) {
                            if ((leaf = leaf.getPreviousLeaf()) == null) {
                                boolean bl = false;
                                return bl;
                            }
                            prevBufferId = leaf.getBufferId();
                            prevIndex = leaf.getKeyCount() - 1;
                        }
                        DBRecord prevRecord = leaf.getRecord(Table.this.schema, prevIndex);
                        boolean bl = this.minKey == null ? true : (this.hasPrev = prevRecord.getKeyField().compareTo(this.minKey) >= 0);
                        if (this.hasPrev) {
                            this.bufferId = prevBufferId;
                            this.recordIndex = prevIndex;
                            this.record = prevRecord;
                            this.hasNext = false;
                        }
                    }
                    finally {
                        Table.this.nodeMgr.releaseNodes();
                    }
                }
                return this.hasPrev;
            }
        }

        @Override
        public DBRecord next() throws IOException {
            if (this.hasNext || this.hasNext()) {
                this.hasNext = false;
                this.hasPrev = true;
                this.lastRecord = this.record;
                return this.record;
            }
            return null;
        }

        @Override
        public DBRecord previous() throws IOException {
            if (this.hasPrev || this.hasPrevious()) {
                this.hasNext = true;
                this.hasPrev = false;
                this.lastRecord = this.record;
                return this.record;
            }
            return null;
        }

        @Override
        public boolean delete() throws IOException {
            if (this.lastRecord == null) {
                return false;
            }
            Table.this.deleteRecord(this.lastRecord.getKeyField());
            this.lastRecord = null;
            return true;
        }
    }

    private class LongKeyIterator
    implements DBLongIterator {
        private static final int SHORT_ITER_THRESHOLD = 10;
        private DBLongIterator keyIter;
        private int iterCnt = 0;

        LongKeyIterator() throws IOException {
            this.keyIter = new LongDurationLongKeyIterator();
            this.iterCnt = Integer.MAX_VALUE;
        }

        LongKeyIterator(long minKey, long maxKey, long startKey) throws IOException {
            this.keyIter = new ShortDurationLongKeyIterator(minKey, maxKey, startKey);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() throws IOException {
            DBHandle dBHandle = Table.this.db;
            synchronized (dBHandle) {
                if (this.iterCnt <= 10 && ++this.iterCnt > 10) {
                    this.keyIter = new LongDurationLongKeyIterator((ShortDurationLongKeyIterator)this.keyIter);
                }
                return this.keyIter.hasNext();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasPrevious() throws IOException {
            DBHandle dBHandle = Table.this.db;
            synchronized (dBHandle) {
                if (this.iterCnt <= 10 && ++this.iterCnt > 10) {
                    this.keyIter = new LongDurationLongKeyIterator((ShortDurationLongKeyIterator)this.keyIter);
                }
                return this.keyIter.hasPrevious();
            }
        }

        @Override
        public long next() throws IOException {
            return this.keyIter.next();
        }

        @Override
        public long previous() throws IOException {
            return this.keyIter.previous();
        }

        @Override
        public boolean delete() throws IOException {
            return this.keyIter.delete();
        }
    }

    private class FieldKeyIterator
    implements DBFieldIterator {
        private static final int SHORT_ITER_THRESHOLD = 10;
        private DBFieldIterator keyIter;
        private int iterCnt = 0;

        FieldKeyIterator(Field minKey, Field maxKey, Field startKey) throws IOException {
            this.keyIter = new ShortDurationFieldKeyIterator(minKey, maxKey, startKey);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        FieldKeyIterator(Field minKey, Field maxKey, boolean before) throws IOException {
            Field startKey;
            Field field = startKey = before ? minKey : maxKey;
            if (startKey == null && !before && Table.this.rootBufferId != -1) {
                try {
                    FieldKeyRecordNode rightmostLeaf = Table.this.getFieldKeyNode(Table.this.rootBufferId).getRightmostLeafNode();
                    startKey = rightmostLeaf.getKeyField(rightmostLeaf.getKeyCount() - 1);
                }
                finally {
                    Table.this.nodeMgr.releaseNodes();
                }
            }
            this.keyIter = new ShortDurationFieldKeyIterator(minKey, maxKey, startKey);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() throws IOException {
            DBHandle dBHandle = Table.this.db;
            synchronized (dBHandle) {
                if (this.iterCnt <= 10 && ++this.iterCnt > 10) {
                    this.keyIter = new LongDurationFieldKeyIterator((ShortDurationFieldKeyIterator)this.keyIter);
                }
                return this.keyIter.hasNext();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasPrevious() throws IOException {
            DBHandle dBHandle = Table.this.db;
            synchronized (dBHandle) {
                if (this.iterCnt <= 10 && ++this.iterCnt > 10) {
                    this.keyIter = new LongDurationFieldKeyIterator((ShortDurationFieldKeyIterator)this.keyIter);
                }
                return this.keyIter.hasPrevious();
            }
        }

        @Override
        public Field next() throws IOException {
            return this.keyIter.next();
        }

        @Override
        public Field previous() throws IOException {
            return this.keyIter.previous();
        }

        @Override
        public boolean delete() throws IOException {
            return this.keyIter.delete();
        }
    }

    private class ShortDurationFieldKeyIterator
    implements DBFieldIterator {
        private int bufferId;
        private int keyIndex;
        private Field lastKey;
        private Field key;
        private int expectedModCount;
        private boolean hasPrev;
        private boolean hasNext;
        private Field minKey;
        private Field maxKey;

        ShortDurationFieldKeyIterator(Field minKey, Field maxKey, Field startKey) throws IOException {
            this.minKey = minKey;
            this.maxKey = maxKey;
            this.key = startKey;
            this.initialize(startKey);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initialize(Field targetKey) throws IOException {
            this.expectedModCount = Table.this.modCount;
            this.hasNext = false;
            this.hasPrev = false;
            this.bufferId = -1;
            if (Table.this.rootBufferId < 0) {
                return;
            }
            try {
                FieldKeyNode rootNode = Table.this.getFieldKeyNode(Table.this.rootBufferId);
                if (targetKey == null) {
                    targetKey = this.minKey;
                }
                if (targetKey == null) {
                    FieldKeyRecordNode leaf = rootNode.getLeftmostLeafNode();
                    this.bufferId = leaf.getBufferId();
                    this.key = leaf.getKeyField(0);
                    this.keyIndex = 0;
                    this.hasNext = true;
                    return;
                }
                FieldKeyRecordNode leaf = rootNode.getLeafNode(targetKey);
                this.bufferId = leaf.getBufferId();
                if (leaf.getKeyCount() == 0) {
                    this.keyIndex = -1;
                    return;
                }
                this.keyIndex = leaf.getKeyIndex(targetKey);
                if (this.keyIndex >= 0) {
                    this.key = leaf.getKeyField(this.keyIndex);
                    this.hasPrev = true;
                    this.hasNext = true;
                } else {
                    this.keyIndex = -(this.keyIndex + 1);
                    if (this.keyIndex == leaf.getKeyCount()) {
                        --this.keyIndex;
                        this.key = leaf.getKeyField(this.keyIndex);
                        this.hasPrev = this.minKey == null ? true : this.key.compareTo(this.minKey) >= 0;
                    } else {
                        this.key = leaf.getKeyField(this.keyIndex);
                        this.hasNext = this.maxKey == null ? true : this.key.compareTo(this.maxKey) <= 0;
                    }
                }
            }
            finally {
                Table.this.nodeMgr.releaseNodes();
            }
        }

        private void reset() throws IOException {
            boolean hadNext = this.hasNext;
            boolean hadPrev = this.hasPrev;
            this.initialize(this.key);
            if (this.hasNext && this.hasPrev) {
                this.hasNext = hadNext;
                this.hasPrev = hadPrev;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean hasNext() throws IOException {
            DBHandle dBHandle = Table.this.db;
            synchronized (dBHandle) {
                block14: {
                    if (Table.this.modCount != this.expectedModCount) {
                        this.reset();
                    }
                    if (!this.hasNext) {
                        if (this.bufferId < 0 || this.keyIndex < 0) {
                            return false;
                        }
                        int nextIndex = this.keyIndex + 1;
                        try {
                            FieldKeyRecordNode leaf = (FieldKeyRecordNode)Table.this.getFieldKeyNode(this.bufferId);
                            if (nextIndex >= leaf.getKeyCount()) {
                                if ((leaf = leaf.getNextLeaf()) == null) {
                                    boolean bl = false;
                                    return bl;
                                }
                                Field nextKey = leaf.getKeyField(0);
                                if (this.maxKey != null && nextKey.compareTo(this.maxKey) > 0) {
                                    boolean bl = false;
                                    return bl;
                                }
                                this.bufferId = leaf.getBufferId();
                                this.key = nextKey;
                                this.keyIndex = 0;
                                this.hasNext = true;
                                this.hasPrev = false;
                                break block14;
                            }
                            Field nextKey = leaf.getKeyField(nextIndex);
                            boolean bl = this.maxKey == null ? true : (this.hasNext = nextKey.compareTo(this.maxKey) <= 0);
                            if (this.hasNext) {
                                this.key = nextKey;
                                this.keyIndex = nextIndex;
                                this.hasPrev = false;
                            }
                        }
                        finally {
                            Table.this.nodeMgr.releaseNodes();
                        }
                    }
                }
                return this.hasNext;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean hasPrevious() throws IOException {
            DBHandle dBHandle = Table.this.db;
            synchronized (dBHandle) {
                block14: {
                    if (Table.this.modCount != this.expectedModCount) {
                        this.reset();
                    }
                    if (!this.hasPrev) {
                        if (this.bufferId < 0 || this.keyIndex < 0) {
                            return false;
                        }
                        int prevIndex = this.keyIndex - 1;
                        try {
                            FieldKeyRecordNode leaf = (FieldKeyRecordNode)Table.this.getFieldKeyNode(this.bufferId);
                            if (prevIndex < 0) {
                                if ((leaf = leaf.getPreviousLeaf()) == null) {
                                    boolean bl = false;
                                    return bl;
                                }
                                prevIndex = leaf.getKeyCount() - 1;
                                Field prevKey = leaf.getKeyField(prevIndex);
                                if (this.minKey != null && prevKey.compareTo(this.minKey) < 0) {
                                    boolean bl = false;
                                    return bl;
                                }
                                this.bufferId = leaf.getBufferId();
                                this.key = prevKey;
                                this.keyIndex = prevIndex;
                                this.hasNext = false;
                                this.hasPrev = true;
                                break block14;
                            }
                            Field prevKey = leaf.getKeyField(prevIndex);
                            boolean bl = this.minKey == null ? true : (this.hasPrev = prevKey.compareTo(this.minKey) >= 0);
                            if (this.hasPrev) {
                                this.key = prevKey;
                                this.keyIndex = prevIndex;
                                this.hasNext = false;
                            }
                        }
                        finally {
                            Table.this.nodeMgr.releaseNodes();
                        }
                    }
                }
                return this.hasPrev;
            }
        }

        @Override
        public Field next() throws IOException {
            if (this.hasNext || this.hasNext()) {
                this.hasNext = false;
                this.hasPrev = true;
                this.lastKey = this.key;
                return this.key;
            }
            return null;
        }

        @Override
        public Field previous() throws IOException {
            if (this.hasPrev || this.hasPrevious()) {
                this.hasNext = true;
                this.hasPrev = false;
                this.lastKey = this.key;
                return this.key;
            }
            return null;
        }

        @Override
        public boolean delete() throws IOException {
            if (this.lastKey != null) {
                Field deleteKey = this.lastKey;
                this.lastKey = null;
                return Table.this.deleteRecord(deleteKey);
            }
            return false;
        }
    }

    private class LongDurationFieldKeyIterator
    implements DBFieldIterator {
        private int bufferId;
        private int keyIndex;
        private Field[] keys;
        private Field key;
        private Field lastKey;
        private int expectedModCount;
        private boolean hasPrev;
        private boolean hasNext;
        private Field minKey;
        private Field maxKey;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        LongDurationFieldKeyIterator(ShortDurationFieldKeyIterator keyIter) throws IOException {
            this.bufferId = keyIter.bufferId;
            this.keyIndex = keyIter.keyIndex;
            this.key = keyIter.key;
            this.lastKey = keyIter.lastKey;
            this.expectedModCount = keyIter.expectedModCount;
            this.hasPrev = keyIter.hasPrev;
            this.hasNext = keyIter.hasNext;
            this.minKey = keyIter.minKey;
            this.maxKey = keyIter.maxKey;
            if (this.bufferId >= 0) {
                if (Table.this.modCount != this.expectedModCount) {
                    this.reset();
                } else {
                    try {
                        FieldKeyRecordNode leaf = (FieldKeyRecordNode)Table.this.getFieldKeyNode(this.bufferId);
                        this.getKeys(leaf);
                    }
                    finally {
                        Table.this.nodeMgr.releaseNodes();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initialize(Field targetKey) throws IOException {
            this.expectedModCount = Table.this.modCount;
            this.hasNext = false;
            this.hasPrev = false;
            if (Table.this.rootBufferId < 0) {
                this.keys = Field.EMPTY_ARRAY;
                this.bufferId = -1;
                return;
            }
            try {
                FieldKeyRecordNode leaf = null;
                if (this.keys == null || this.keys.length == 0) {
                    FieldKeyNode rootNode = Table.this.getFieldKeyNode(Table.this.rootBufferId);
                    if (targetKey == null) {
                        targetKey = this.minKey;
                    }
                    if (targetKey == null) {
                        leaf = rootNode.getLeftmostLeafNode();
                        this.getKeys(leaf);
                        this.key = this.keys[0];
                        this.keyIndex = 0;
                        this.hasNext = true;
                        return;
                    }
                    leaf = rootNode.getLeafNode(targetKey);
                    this.getKeys(leaf);
                    if (this.keys.length == 0) {
                        return;
                    }
                    this.keyIndex = leaf.getKeyIndex(targetKey);
                }
                if (this.keyIndex >= 0) {
                    this.hasPrev = true;
                    this.hasNext = true;
                } else {
                    this.keyIndex = -(this.keyIndex + 1);
                    if (this.keyIndex == this.keys.length) {
                        --this.keyIndex;
                        boolean bl = this.minKey == null ? true : (this.hasPrev = this.keys[this.keyIndex].compareTo(this.minKey) >= 0);
                        if (!this.hasPrev) {
                            if (leaf == null) {
                                this.keys = null;
                                this.initialize(targetKey);
                                return;
                            }
                            if ((leaf = leaf.getNextLeaf()) == null) {
                                this.keys = Field.EMPTY_ARRAY;
                                this.bufferId = -1;
                                return;
                            }
                            this.keyIndex = 0;
                            this.getKeys(leaf);
                            this.hasNext = this.maxKey == null ? true : this.keys[this.keyIndex].compareTo(this.maxKey) <= 0;
                        }
                    } else {
                        boolean bl = this.maxKey == null ? true : (this.hasNext = this.keys[this.keyIndex].compareTo(this.maxKey) <= 0);
                        if (!this.hasNext) {
                            if (this.keyIndex == 0) {
                                if (leaf == null) {
                                    this.keys = null;
                                    this.initialize(targetKey);
                                    return;
                                }
                                if ((leaf = leaf.getPreviousLeaf()) == null) {
                                    this.keys = Field.EMPTY_ARRAY;
                                    this.bufferId = -1;
                                    return;
                                }
                                this.keyIndex = leaf.getKeyCount() - 1;
                                this.getKeys(leaf);
                            } else {
                                --this.keyIndex;
                            }
                            boolean bl2 = this.minKey == null ? true : (this.hasPrev = this.keys[this.keyIndex].compareTo(this.minKey) >= 0);
                        }
                    }
                    if (this.hasNext || this.hasPrev) {
                        this.key = this.keys[this.keyIndex];
                    }
                }
            }
            finally {
                Table.this.nodeMgr.releaseNodes();
            }
        }

        private void reset() throws IOException {
            boolean hadNext = this.hasNext;
            boolean hadPrev = this.hasPrev;
            this.keys = null;
            this.initialize(this.key);
            if (this.hasNext && this.hasPrev) {
                this.hasNext = hadNext;
                this.hasPrev = hadPrev;
            }
        }

        private void getKeys(FieldKeyRecordNode node) throws IOException {
            this.bufferId = node.getBufferId();
            int keyCount = node.getKeyCount();
            if (this.keys == null || this.keys.length != keyCount) {
                this.keys = new Field[keyCount];
            }
            for (int i = 0; i < keyCount; ++i) {
                this.keys[i] = node.getKeyField(i);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() throws IOException {
            DBHandle dBHandle = Table.this.db;
            synchronized (dBHandle) {
                if (Table.this.modCount != this.expectedModCount) {
                    this.reset();
                }
                if (!this.hasNext) {
                    if (this.bufferId < 0) {
                        return false;
                    }
                    int nextIndex = this.keyIndex + 1;
                    if (nextIndex >= this.keys.length) {
                        try {
                            FieldKeyRecordNode leaf = ((FieldKeyRecordNode)Table.this.getFieldKeyNode(this.bufferId)).getNextLeaf();
                            if (leaf == null || this.maxKey != null && leaf.getKeyField(0).compareTo(this.maxKey) > 0) {
                                boolean bl = false;
                                return bl;
                            }
                            this.getKeys(leaf);
                            this.key = this.keys[0];
                            this.keyIndex = 0;
                            this.hasNext = true;
                            this.hasPrev = false;
                        }
                        finally {
                            Table.this.nodeMgr.releaseNodes();
                        }
                    } else {
                        boolean bl = this.hasNext = this.maxKey == null || this.keys[nextIndex].compareTo(this.maxKey) <= 0;
                        if (this.hasNext) {
                            this.key = this.keys[nextIndex];
                            this.keyIndex = nextIndex;
                            this.hasPrev = false;
                        }
                    }
                }
                return this.hasNext;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean hasPrevious() throws IOException {
            DBHandle dBHandle = Table.this.db;
            synchronized (dBHandle) {
                if (Table.this.modCount != this.expectedModCount) {
                    this.reset();
                }
                if (!this.hasPrev) {
                    if (this.bufferId < 0) {
                        return false;
                    }
                    int prevIndex = this.keyIndex - 1;
                    if (prevIndex < 0) {
                        try {
                            FieldKeyRecordNode leaf = ((FieldKeyRecordNode)Table.this.getFieldKeyNode(this.bufferId)).getPreviousLeaf();
                            if (leaf == null) {
                                boolean bl = false;
                                return bl;
                            }
                            prevIndex = leaf.getKeyCount() - 1;
                            if (this.minKey != null && leaf.getKeyField(prevIndex).compareTo(this.minKey) < 0) {
                                boolean bl = false;
                                return bl;
                            }
                            this.getKeys(leaf);
                            this.key = this.keys[prevIndex];
                            this.keyIndex = prevIndex;
                            this.hasNext = false;
                            this.hasPrev = true;
                        }
                        finally {
                            Table.this.nodeMgr.releaseNodes();
                        }
                    } else {
                        boolean bl = this.hasPrev = this.minKey == null || this.keys[prevIndex].compareTo(this.minKey) >= 0;
                        if (this.hasPrev) {
                            this.key = this.keys[prevIndex];
                            this.keyIndex = prevIndex;
                            this.hasNext = false;
                        }
                    }
                }
                return this.hasPrev;
            }
        }

        @Override
        public Field next() throws IOException {
            if (this.hasNext || this.hasNext()) {
                this.hasNext = false;
                this.hasPrev = true;
                this.lastKey = this.key;
                return this.key;
            }
            return null;
        }

        @Override
        public Field previous() throws IOException {
            if (this.hasPrev || this.hasPrevious()) {
                this.hasNext = true;
                this.hasPrev = false;
                this.lastKey = this.key;
                return this.key;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean delete() throws IOException {
            if (this.lastKey != null) {
                DBHandle dBHandle = Table.this.db;
                synchronized (dBHandle) {
                    Field deleteKey = this.lastKey;
                    this.lastKey = null;
                    boolean success = Table.this.deleteRecord(deleteKey);
                    int newLen = this.keys.length - 1;
                    if (deleteKey.equals(this.key) && this.keys.length > 1 && this.keyIndex < newLen) {
                        Field[] newKeys = new Field[newLen];
                        System.arraycopy(this.keys, 0, newKeys, 0, this.keyIndex);
                        System.arraycopy(this.keys, this.keyIndex + 1, newKeys, this.keyIndex, newLen - this.keyIndex);
                        this.keys = newKeys;
                        this.keyIndex = -(this.keyIndex + 1);
                    } else {
                        this.keys = null;
                    }
                    this.initialize(deleteKey);
                    return success;
                }
            }
            return false;
        }
    }

    private class ShortDurationLongKeyIterator
    implements DBLongIterator {
        private int bufferId;
        private int keyIndex;
        private long key;
        private long lastKey;
        private boolean hasLastKey = false;
        private int expectedModCount;
        private boolean hasPrev;
        private boolean hasNext;
        private long minKey;
        private long maxKey;

        ShortDurationLongKeyIterator(long minKey, long maxKey, long startKey) throws IOException {
            this.minKey = minKey;
            this.maxKey = maxKey;
            this.key = startKey;
            this.initialize(startKey);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initialize(long targetKey) throws IOException {
            this.expectedModCount = Table.this.modCount;
            this.hasPrev = false;
            this.hasNext = false;
            this.bufferId = -1;
            if (Table.this.rootBufferId < 0) {
                return;
            }
            try {
                LongKeyRecordNode leaf = null;
                LongKeyNode rootNode = Table.this.nodeMgr.getLongKeyNode(Table.this.rootBufferId);
                leaf = rootNode.getLeafNode(targetKey);
                this.bufferId = leaf.getBufferId();
                if (leaf.keyCount == 0) {
                    this.keyIndex = -1;
                    return;
                }
                this.keyIndex = leaf.getKeyIndex(targetKey);
                if (this.keyIndex >= 0) {
                    this.key = leaf.getKey(this.keyIndex);
                    this.hasPrev = true;
                    this.hasNext = true;
                } else {
                    this.keyIndex = -(this.keyIndex + 1);
                    if (this.keyIndex == leaf.keyCount) {
                        --this.keyIndex;
                        this.key = leaf.getKey(this.keyIndex);
                        this.hasPrev = this.key >= this.minKey;
                    } else {
                        this.key = leaf.getKey(this.keyIndex);
                        this.hasNext = this.key <= this.maxKey;
                    }
                }
            }
            finally {
                Table.this.nodeMgr.releaseNodes();
            }
        }

        private void reset() throws IOException {
            boolean hadNext = this.hasNext;
            boolean hadPrev = this.hasPrev;
            this.initialize(this.key);
            if (this.hasNext && this.hasPrev) {
                this.hasNext = hadNext;
                this.hasPrev = hadPrev;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean hasNext() throws IOException {
            DBHandle dBHandle = Table.this.db;
            synchronized (dBHandle) {
                block14: {
                    if (Table.this.modCount != this.expectedModCount) {
                        this.reset();
                    }
                    if (!this.hasNext) {
                        if (this.bufferId < 0 || this.keyIndex < 0) {
                            return false;
                        }
                        int nextIndex = this.keyIndex + 1;
                        try {
                            LongKeyRecordNode leaf = (LongKeyRecordNode)Table.this.nodeMgr.getLongKeyNode(this.bufferId);
                            if (nextIndex >= leaf.keyCount) {
                                if ((leaf = leaf.getNextLeaf()) == null) {
                                    boolean bl = false;
                                    return bl;
                                }
                                long nextKey = leaf.getKey(0);
                                if (nextKey > this.maxKey) {
                                    boolean bl = false;
                                    return bl;
                                }
                                this.bufferId = leaf.getBufferId();
                                this.key = nextKey;
                                this.keyIndex = 0;
                                this.hasNext = true;
                                this.hasPrev = false;
                                break block14;
                            }
                            long nextKey = leaf.getKey(nextIndex);
                            boolean bl = this.hasNext = nextKey <= this.maxKey;
                            if (this.hasNext) {
                                this.key = nextKey;
                                this.keyIndex = nextIndex;
                                this.hasPrev = false;
                            }
                        }
                        finally {
                            Table.this.nodeMgr.releaseNodes();
                        }
                    }
                }
                return this.hasNext;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean hasPrevious() throws IOException {
            DBHandle dBHandle = Table.this.db;
            synchronized (dBHandle) {
                block14: {
                    if (Table.this.modCount != this.expectedModCount) {
                        this.reset();
                    }
                    if (!this.hasPrev) {
                        if (this.bufferId < 0 || this.keyIndex < 0) {
                            return false;
                        }
                        int prevIndex = this.keyIndex - 1;
                        try {
                            LongKeyRecordNode leaf = (LongKeyRecordNode)Table.this.nodeMgr.getLongKeyNode(this.bufferId);
                            if (prevIndex < 0) {
                                if ((leaf = leaf.getPreviousLeaf()) == null) {
                                    boolean bl = false;
                                    return bl;
                                }
                                prevIndex = leaf.keyCount - 1;
                                long prevKey = leaf.getKey(prevIndex);
                                if (prevKey < this.minKey) {
                                    boolean bl = false;
                                    return bl;
                                }
                                this.bufferId = leaf.getBufferId();
                                this.key = prevKey;
                                this.keyIndex = prevIndex;
                                this.hasNext = false;
                                this.hasPrev = true;
                                break block14;
                            }
                            long prevKey = leaf.getKey(prevIndex);
                            boolean bl = this.hasPrev = prevKey >= this.minKey;
                            if (this.hasPrev) {
                                this.key = prevKey;
                                this.keyIndex = prevIndex;
                                this.hasNext = false;
                            }
                        }
                        finally {
                            Table.this.nodeMgr.releaseNodes();
                        }
                    }
                }
                return this.hasPrev;
            }
        }

        @Override
        public long next() throws IOException {
            if (this.hasNext || this.hasNext()) {
                this.hasNext = false;
                this.hasPrev = true;
                this.lastKey = this.key;
                this.hasLastKey = true;
                return this.key;
            }
            throw new NoSuchElementException();
        }

        @Override
        public long previous() throws IOException {
            if (this.hasPrev || this.hasPrevious()) {
                this.hasNext = true;
                this.hasPrev = false;
                this.lastKey = this.key;
                this.hasLastKey = true;
                return this.key;
            }
            throw new NoSuchElementException();
        }

        @Override
        public boolean delete() throws IOException {
            if (this.hasLastKey) {
                this.hasLastKey = false;
                return Table.this.deleteRecord(this.lastKey);
            }
            return false;
        }
    }

    private class LongDurationLongKeyIterator
    implements DBLongIterator {
        private int bufferId;
        private int keyIndex;
        private long[] keys;
        private long key;
        private long lastKey;
        private boolean hasLastKey;
        private int expectedModCount;
        private boolean hasPrev;
        private boolean hasNext;
        private long minKey;
        private long maxKey;

        LongDurationLongKeyIterator() throws IOException {
            this(Long.MIN_VALUE, Long.MAX_VALUE, Long.MIN_VALUE);
            this.hasPrev = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        LongDurationLongKeyIterator(ShortDurationLongKeyIterator keyIter) throws IOException {
            this.bufferId = keyIter.bufferId;
            this.keyIndex = keyIter.keyIndex;
            this.key = keyIter.key;
            this.lastKey = keyIter.lastKey;
            this.hasLastKey = keyIter.hasLastKey;
            this.expectedModCount = keyIter.expectedModCount;
            this.hasPrev = keyIter.hasPrev;
            this.hasNext = keyIter.hasNext;
            this.minKey = keyIter.minKey;
            this.maxKey = keyIter.maxKey;
            if (this.bufferId >= 0) {
                if (Table.this.modCount != this.expectedModCount) {
                    this.reset();
                } else {
                    try {
                        LongKeyRecordNode leaf = (LongKeyRecordNode)Table.this.nodeMgr.getLongKeyNode(this.bufferId);
                        this.getKeys(leaf);
                    }
                    finally {
                        Table.this.nodeMgr.releaseNodes();
                    }
                }
            } else {
                this.keys = new long[0];
            }
        }

        LongDurationLongKeyIterator(long minKey, long maxKey, long startKey) throws IOException {
            this.minKey = minKey;
            this.maxKey = maxKey;
            this.key = startKey;
            this.initialize(startKey);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initialize(long targetKey) throws IOException {
            this.expectedModCount = Table.this.modCount;
            this.hasPrev = false;
            this.hasNext = false;
            if (Table.this.rootBufferId < 0) {
                this.bufferId = -1;
                this.keys = new long[0];
                return;
            }
            try {
                LongKeyRecordNode leaf = null;
                if (this.keys == null || this.keys.length == 0) {
                    LongKeyNode rootNode = Table.this.nodeMgr.getLongKeyNode(Table.this.rootBufferId);
                    leaf = rootNode.getLeafNode(targetKey);
                    int leafRecCount = leaf.keyCount;
                    if (leafRecCount == 0) {
                        return;
                    }
                    this.keyIndex = leaf.getKeyIndex(targetKey);
                    this.getKeys(leaf);
                }
                if (this.keyIndex >= 0) {
                    this.key = targetKey;
                    this.hasPrev = true;
                    this.hasNext = true;
                } else {
                    this.keyIndex = -(this.keyIndex + 1);
                    if (this.keyIndex == this.keys.length) {
                        --this.keyIndex;
                        boolean bl = this.hasPrev = this.keys[this.keyIndex] >= this.minKey;
                        if (!this.hasPrev) {
                            if (leaf == null) {
                                this.keys = null;
                                this.initialize(targetKey);
                                return;
                            }
                            if ((leaf = leaf.getNextLeaf()) == null) {
                                this.keys = new long[0];
                                this.bufferId = -1;
                                return;
                            }
                            this.keyIndex = 0;
                            this.getKeys(leaf);
                            this.hasNext = this.keys[this.keyIndex] <= this.maxKey;
                        }
                    } else {
                        boolean bl = this.hasNext = this.keys[this.keyIndex] <= this.maxKey;
                        if (!this.hasNext) {
                            if (this.keyIndex == 0) {
                                if (leaf == null) {
                                    this.keys = null;
                                    this.initialize(targetKey);
                                    return;
                                }
                                if ((leaf = leaf.getPreviousLeaf()) == null) {
                                    this.keys = new long[0];
                                    this.bufferId = -1;
                                    return;
                                }
                                this.keyIndex = leaf.keyCount - 1;
                                this.getKeys(leaf);
                            } else {
                                --this.keyIndex;
                            }
                            boolean bl2 = this.hasPrev = this.keys[this.keyIndex] >= this.minKey;
                        }
                    }
                    if (this.hasNext || this.hasPrev) {
                        this.key = this.keys[this.keyIndex];
                    }
                }
            }
            finally {
                Table.this.nodeMgr.releaseNodes();
            }
        }

        private void reset() throws IOException {
            boolean hadNext = this.hasNext;
            boolean hadPrev = this.hasPrev;
            this.keys = null;
            this.initialize(this.key);
            if (this.hasNext && this.hasPrev) {
                this.hasNext = hadNext;
                this.hasPrev = hadPrev;
            }
        }

        private void getKeys(LongKeyRecordNode node) {
            this.bufferId = node.getBufferId();
            if (this.keys == null || this.keys.length != node.keyCount) {
                this.keys = new long[node.keyCount];
            }
            for (int i = 0; i < node.keyCount; ++i) {
                this.keys[i] = node.getKey(i);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean hasNext() throws IOException {
            DBHandle dBHandle = Table.this.db;
            synchronized (dBHandle) {
                if (Table.this.modCount != this.expectedModCount) {
                    this.reset();
                }
                if (!this.hasNext) {
                    int nextIndex = this.keyIndex + 1;
                    if (nextIndex >= this.keys.length) {
                        try {
                            if (this.bufferId == -1) {
                                boolean bl = false;
                                return bl;
                            }
                            LongKeyRecordNode leaf = ((LongKeyRecordNode)Table.this.nodeMgr.getLongKeyNode(this.bufferId)).getNextLeaf();
                            if (leaf == null || leaf.getKey(0) > this.maxKey) {
                                boolean bl = false;
                                return bl;
                            }
                            this.getKeys(leaf);
                            this.key = this.keys[0];
                            this.keyIndex = 0;
                            this.hasNext = true;
                            this.hasPrev = false;
                        }
                        finally {
                            Table.this.nodeMgr.releaseNodes();
                        }
                    } else {
                        boolean bl = this.hasNext = this.keys[nextIndex] <= this.maxKey;
                        if (this.hasNext) {
                            this.key = this.keys[nextIndex];
                            this.keyIndex = nextIndex;
                            this.hasPrev = false;
                        }
                    }
                }
                return this.hasNext;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean hasPrevious() throws IOException {
            DBHandle dBHandle = Table.this.db;
            synchronized (dBHandle) {
                if (Table.this.modCount != this.expectedModCount) {
                    this.reset();
                }
                if (!this.hasPrev) {
                    int prevIndex = this.keyIndex - 1;
                    if (prevIndex < 0 || this.keys.length == 0) {
                        try {
                            if (this.bufferId == -1) {
                                boolean bl = false;
                                return bl;
                            }
                            LongKeyRecordNode leaf = ((LongKeyRecordNode)Table.this.nodeMgr.getLongKeyNode(this.bufferId)).getPreviousLeaf();
                            if (leaf == null) {
                                boolean bl = false;
                                return bl;
                            }
                            prevIndex = leaf.keyCount - 1;
                            if (leaf.getKey(prevIndex) < this.minKey) {
                                boolean bl = false;
                                return bl;
                            }
                            this.getKeys(leaf);
                            this.key = this.keys[prevIndex];
                            this.keyIndex = prevIndex;
                            this.hasNext = false;
                            this.hasPrev = true;
                        }
                        finally {
                            Table.this.nodeMgr.releaseNodes();
                        }
                    } else {
                        boolean bl = this.hasPrev = this.keys[prevIndex] >= this.minKey;
                        if (this.hasPrev) {
                            this.key = this.keys[prevIndex];
                            this.keyIndex = prevIndex;
                            this.hasNext = false;
                        }
                    }
                }
                return this.hasPrev;
            }
        }

        @Override
        public long next() throws IOException {
            if (this.hasNext || this.hasNext()) {
                this.hasNext = false;
                this.hasPrev = true;
                this.lastKey = this.key;
                this.hasLastKey = true;
                return this.key;
            }
            throw new NoSuchElementException();
        }

        @Override
        public long previous() throws IOException {
            if (this.hasPrev || this.hasPrevious()) {
                this.hasNext = true;
                this.hasPrev = false;
                this.lastKey = this.key;
                this.hasLastKey = true;
                return this.key;
            }
            throw new NoSuchElementException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean delete() throws IOException {
            if (this.hasLastKey) {
                DBHandle dBHandle = Table.this.db;
                synchronized (dBHandle) {
                    long deleteKey = this.lastKey;
                    this.hasLastKey = false;
                    boolean success = Table.this.deleteRecord(deleteKey);
                    int newLen = this.keys.length - 1;
                    if (deleteKey == this.key && this.keys.length > 1) {
                        long[] newKeys = new long[newLen];
                        System.arraycopy(this.keys, 0, newKeys, 0, this.keyIndex);
                        System.arraycopy(this.keys, this.keyIndex + 1, newKeys, this.keyIndex, newLen - this.keyIndex);
                        this.keys = newKeys;
                        this.keyIndex = -(this.keyIndex + 1);
                    } else {
                        this.keys = null;
                    }
                    this.initialize(deleteKey);
                    return success;
                }
            }
            return false;
        }
    }
}

