/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.dump.mdmp;

import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.dump.DumpFileReader;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Pointer32DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class MemoryRange
implements StructConverter {
    public static final String NAME = "MINIDUMP_MEMORY_RANGE";
    private long startOfMemoryRange;
    private int dataSize;
    private int RVA;
    private DumpFileReader reader;
    private long index;

    MemoryRange(DumpFileReader reader, long index) throws IOException {
        this.reader = reader;
        this.index = index;
        this.parse();
    }

    private void parse() throws IOException {
        this.reader.setPointerIndex(this.index);
        this.setStartOfMemoryRange(this.reader.readNextLong());
        this.setDataSize(this.reader.readNextInt());
        this.setRVA(this.reader.readNextInt());
    }

    public DataType toDataType() throws DuplicateNameException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.add(QWORD, 8, "StartOfMemoryRange", null);
        struct.add(DWORD, 4, "DataSize", null);
        struct.add((DataType)Pointer32DataType.dataType, 4, "RVA", null);
        struct.setCategoryPath(new CategoryPath("/MDMP"));
        return struct;
    }

    public long getStartOfMemoryRange() {
        return this.startOfMemoryRange;
    }

    public void setStartOfMemoryRange(long startOfMemoryRange) {
        this.startOfMemoryRange = startOfMemoryRange;
    }

    public int getDataSize() {
        return this.dataSize;
    }

    public void setDataSize(int dataSize) {
        this.dataSize = dataSize;
    }

    public int getRVA() {
        return this.RVA;
    }

    public void setRVA(int rva) {
        this.RVA = rva;
    }
}

