/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.dex.analyzer;

import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.file.analyzers.FileFormatAnalyzer;
import ghidra.file.formats.android.cdex.CDexConstants;
import ghidra.file.formats.android.dex.format.DexConstants;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.AlignmentDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public class DexCondenseFillerBytesAnalyzer
extends FileFormatAnalyzer {
    @Override
    public boolean analyze(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws Exception {
        AlignmentDataType alignmentDataType = new AlignmentDataType();
        Address address = this.toAddr(program, 0x50000000L);
        MemoryBlock block = program.getMemory().getBlock(address);
        if (block == null) {
            log.appendMsg("Can't locate block with method byte code!");
            return false;
        }
        AddressSet blockSet = new AddressSet(block.getStart(), block.getEnd());
        AddressSetView undefinedSet = program.getListing().getUndefinedRanges((AddressSetView)blockSet, true, monitor);
        monitor.setMaximum((long)undefinedSet.getNumAddressRanges());
        monitor.setProgress(0L);
        monitor.setMessage("DEX: condensing filler bytes");
        AddressRangeIterator addressRanges = undefinedSet.getAddressRanges();
        while (addressRanges.hasNext()) {
            monitor.checkCanceled();
            monitor.incrementProgress(1L);
            AddressRange addressRange = (AddressRange)addressRanges.next();
            if (!this.isRangeAllSameBytes(program, addressRange, (byte)-1, monitor)) continue;
            program.getListing().createData(addressRange.getMinAddress(), (DataType)alignmentDataType, (int)addressRange.getLength());
        }
        return true;
    }

    public boolean canAnalyze(Program program) {
        MemoryByteProvider provider = MemoryByteProvider.createProgramHeaderByteProvider((Program)program, (boolean)false);
        return DexConstants.isDexFile((ByteProvider)provider) || CDexConstants.isCDEX(program);
    }

    @Override
    public AnalyzerType getAnalysisType() {
        return AnalyzerType.BYTE_ANALYZER;
    }

    public boolean getDefaultEnablement(Program program) {
        return true;
    }

    public String getDescription() {
        return "Condenses all filler bytes in a DEX/CDEX file";
    }

    public String getName() {
        return "Android DEX/CDEX Condense Filler Bytes";
    }

    @Override
    public AnalysisPriority getPriority() {
        return new AnalysisPriority(Integer.MAX_VALUE);
    }

    public boolean isPrototype() {
        return false;
    }

    private boolean isRangeAllSameBytes(Program program, AddressRange addressRange, byte value, TaskMonitor monitor) throws CancelledException {
        byte[] bytes = new byte[(int)addressRange.getLength()];
        try {
            program.getMemory().getBytes(addressRange.getMinAddress(), bytes);
        }
        catch (Exception e) {
            return false;
        }
        for (byte b : bytes) {
            monitor.checkCanceled();
            if (b == value) continue;
            return false;
        }
        return true;
    }
}

