/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table.constraint;

import docking.widgets.table.constraint.RangeColumnConstraint;
import docking.widgets.table.constraint.TableFilterContext;
import docking.widgets.table.constraint.provider.EditorProvider;
import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;

public class InDateRangeColumnConstraint
extends RangeColumnConstraint<LocalDate> {
    public InDateRangeColumnConstraint(LocalDate minValue, LocalDate maxValue, EditorProvider<LocalDate> editorProvider) {
        super("Between Dates", minValue, maxValue, editorProvider, "date");
    }

    @Override
    public boolean accepts(LocalDate value, TableFilterContext context) {
        if (value == null) {
            return false;
        }
        return value.compareTo((ChronoLocalDate)this.getMinValue()) >= 0 && value.compareTo((ChronoLocalDate)this.getMaxValue()) <= 0;
    }

    @Override
    public RangeColumnConstraint<LocalDate> copy(LocalDate min, LocalDate max) {
        return new InDateRangeColumnConstraint(min, max, this.editorProvider);
    }
}

