/*
 * Decompiled with CFR 0.152.
 */
package ghidra.server;

import generic.jar.ResourceFile;
import ghidra.GhidraApplicationLayout;
import ghidra.GhidraLaunchable;
import ghidra.framework.Application;
import ghidra.framework.ApplicationConfiguration;
import ghidra.server.CommandProcessor;
import ghidra.server.Repository;
import ghidra.server.RepositoryManager;
import ghidra.server.UserManager;
import ghidra.util.HashUtilities;
import ghidra.util.Msg;
import ghidra.util.NamingUtilities;
import java.io.Console;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import javax.security.auth.x500.X500Principal;
import utility.application.ApplicationLayout;

public class ServerAdmin
implements GhidraLaunchable {
    private static final String CONFIG_FILE_PROPERTY = "UserAdmin.config";
    private static final String SERVER_DIR_CONFIG_PROPERTY = "ghidra.repositories.dir";
    private static final String INVOCATION_NAME_PROPERTY = "UserAdmin.invocation";
    private static final String LIST_COMMAND = "-list";
    private static final String USERS_COMMAND = "-users";
    private static final String MIGRATE_COMMAND = "-migrate";
    private static final String MIGRATE_ALL_COMMAND = "-migrate-all";

    public void launch(GhidraApplicationLayout layout, String[] args) {
        if (!Application.isInitialized()) {
            ApplicationConfiguration configuration = new ApplicationConfiguration();
            configuration.setInitializeLogging(false);
            Application.initializeApplication((ApplicationLayout)layout, (ApplicationConfiguration)configuration);
        }
        this.execute(args);
    }

    public void execute(String[] args) {
        File cmdDir;
        int ix = 0;
        String configFilePath = args.length != 0 && !args[0].startsWith("-") ? args[ix++] : System.getProperty(CONFIG_FILE_PROPERTY);
        System.out.println("server.conf: " + configFilePath);
        File serverRootDir = this.getServerDirFromConfig(configFilePath);
        if (serverRootDir == null || args.length - ix == 0) {
            this.displayUsage("");
            System.exit(-1);
            return;
        }
        try {
            serverRootDir = serverRootDir.getCanonicalFile();
        }
        catch (IOException e1) {
            System.err.println("Failed to resolve server directory: " + serverRootDir);
            System.exit(-1);
        }
        System.out.println("Using server directory: " + serverRootDir);
        File userFile = new File(serverRootDir, "users");
        if (!serverRootDir.isDirectory() || !userFile.isFile()) {
            System.err.println("Invalid Ghidra server directory!");
            System.exit(-1);
        }
        if (!(cmdDir = CommandProcessor.getCommandDir(serverRootDir)).isDirectory() || !cmdDir.canWrite()) {
            System.err.println("Insufficient privilege or server not started!");
            System.exit(-1);
        }
        boolean listRepositories = false;
        boolean listAllUserPermissions = false;
        HashSet<String> listUsernameSet = new HashSet<String>();
        boolean listUsers = false;
        boolean migrationConfirmed = false;
        boolean migrationAbort = false;
        ArrayList<String> cmdList = new ArrayList<String>();
        int cmdLen = 1;
        while (ix < args.length) {
            boolean queueCmd = true;
            String pwdHash = null;
            switch (args[ix]) {
                case "-add": {
                    cmdLen = 2;
                    this.validateSID(args, ix + 1);
                    if (!this.hasOptionalArg(args, ix + 2, "--p")) break;
                    ++cmdLen;
                    pwdHash = this.promptForPasswordAndGetSaltedHash(args[ix + 1]);
                    break;
                }
                case "-remove": {
                    cmdLen = 2;
                    this.validateSID(args, ix + 1);
                    break;
                }
                case "-reset": {
                    cmdLen = 2;
                    this.validateSID(args, ix + 1);
                    if (!this.hasOptionalArg(args, ix + 2, "--p")) break;
                    ++cmdLen;
                    pwdHash = this.promptForPasswordAndGetSaltedHash(args[ix + 1]);
                    break;
                }
                case "-dn": {
                    cmdLen = 3;
                    this.validateSID(args, ix + 1);
                    this.validateDN(args, ix + 2);
                    break;
                }
                case "-grant": {
                    cmdLen = 4;
                    this.validateSID(args, ix + 1);
                    this.validatePermission(args, ix + 2);
                    this.validateRepositoryName(args, ix + 3, serverRootDir);
                    break;
                }
                case "-revoke": {
                    cmdLen = 3;
                    this.validateSID(args, ix + 1);
                    this.validateRepositoryName(args, ix + 2, serverRootDir);
                    break;
                }
                case "-list": {
                    queueCmd = false;
                    listRepositories = true;
                    boolean hasUsernames = false;
                    while (ix + 1 < args.length && !args[ix + 1].startsWith("-")) {
                        String sid = args[++ix];
                        this.validateSID(sid);
                        listUsernameSet.add(sid);
                        hasUsernames = true;
                    }
                    if (hasUsernames || ix + 1 >= args.length || !"--users".equals(args[ix + 1])) break;
                    listAllUserPermissions = true;
                    ++ix;
                    break;
                }
                case "-users": {
                    queueCmd = false;
                    listUsers = true;
                    listUsernameSet.clear();
                    break;
                }
                case "-migrate-all": {
                    queueCmd = false;
                    if (!migrationConfirmed && !ServerAdmin.confirmMigration()) {
                        migrationAbort = true;
                    }
                    migrationConfirmed = true;
                    if (migrationAbort) break;
                    RepositoryManager.markAllRepositoriesForIndexMigration(serverRootDir);
                    break;
                }
                case "-migrate": {
                    queueCmd = false;
                    if (ix == args.length - 1) {
                        System.err.println("Missing -migrate repository name argument");
                        break;
                    }
                    String repositoryName = args[ix + 1];
                    if (!migrationConfirmed && !ServerAdmin.confirmMigration()) {
                        migrationAbort = true;
                    }
                    migrationConfirmed = true;
                    if (migrationAbort) break;
                    Repository.markRepositoryForIndexMigration(serverRootDir, repositoryName, false);
                    break;
                }
                default: {
                    this.displayUsage("Invalid usage!");
                    System.exit(-1);
                }
            }
            if (queueCmd) {
                ServerAdmin.addCommand(cmdList, args, ix, cmdLen, pwdHash);
            }
            ix += cmdLen;
        }
        if (cmdList.size() != 0) {
            try {
                CommandProcessor.writeCommands(cmdList, cmdDir);
            }
            catch (IOException e) {
                System.err.println("Failed to queue commands: " + e.toString());
                System.exit(-1);
            }
            System.out.println("Command queued.");
        }
        if (listUsers) {
            UserManager.listUsers(serverRootDir);
        }
        if (listRepositories) {
            if (listUsernameSet.isEmpty()) {
                RepositoryManager.listRepositories(serverRootDir, listAllUserPermissions);
            } else {
                RepositoryManager.listRepositories(serverRootDir, listUsernameSet);
            }
        }
        System.out.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String promptForPasswordAndGetSaltedHash(String userSID) {
        String string;
        char[] pwd2;
        block9: {
            char[] pwd1 = null;
            pwd2 = null;
            try {
                while (true) {
                    System.out.println("Enter password for user '" + userSID + "'");
                    pwd1 = this.getPassword("New password: ", true);
                    pwd2 = this.getPassword("Retype new password: ", false);
                    if (Arrays.equals(pwd1, pwd2)) break;
                    System.out.println("Password entries do not match! Please try again...");
                    Arrays.fill(pwd1, '\u0000');
                    Arrays.fill(pwd2, '\u0000');
                }
                char[] saltedHash = HashUtilities.getSaltedHash((String)HashUtilities.SHA256_ALGORITHM, (char[])pwd1);
                string = new String(saltedHash);
                if (pwd1 == null) break block9;
            }
            catch (IOException e) {
                String string2;
                block10: {
                    try {
                        System.err.println("Password entry error: " + e.getMessage());
                        System.exit(-1);
                        string2 = null;
                        if (pwd1 == null) break block10;
                    }
                    catch (Throwable throwable) {
                        if (pwd1 != null) {
                            Arrays.fill(pwd1, '\u0000');
                        }
                        if (pwd2 != null) {
                            Arrays.fill(pwd2, '\u0000');
                        }
                        throw throwable;
                    }
                    Arrays.fill(pwd1, '\u0000');
                }
                if (pwd2 != null) {
                    Arrays.fill(pwd2, '\u0000');
                }
                return string2;
            }
            Arrays.fill(pwd1, '\u0000');
        }
        if (pwd2 != null) {
            Arrays.fill(pwd2, '\u0000');
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private char[] getPassword(String prompt, boolean echoWarn) throws IOException {
        char[] cArray;
        block10: {
            boolean success = false;
            char[] password = null;
            try {
                Console cons = System.console();
                if (cons != null) {
                    password = cons.readPassword(prompt, new Object[0]);
                } else {
                    int c;
                    if (echoWarn) {
                        System.out.println("*** WARNING! Password entry will NOT be masked ***");
                    }
                    System.out.print(prompt);
                    while ((c = System.in.read()) > 0 && c != 10) {
                        if (c == 13) continue;
                        if (password == null) {
                            password = new char[1];
                        } else {
                            char[] newPass = new char[password.length + 1];
                            for (int i = 0; i < password.length; ++i) {
                                newPass[i] = password[i];
                                password[i] = '\u0000';
                            }
                            password = newPass;
                        }
                        password[password.length - 1] = (char)c;
                    }
                }
                success = true;
                cArray = password;
                if (success || password == null) break block10;
            }
            catch (Throwable throwable) {
                if (!success && password != null) {
                    Arrays.fill(password, '\u0000');
                }
                throw throwable;
            }
            Arrays.fill(password, '\u0000');
        }
        return cArray;
    }

    private boolean hasOptionalArg(String[] args, int argOffset, String option) {
        return argOffset < args.length && args[argOffset].contentEquals(option);
    }

    private static void addCommand(ArrayList<String> cmdList, String[] args, int argOffset, int argCnt, String pwdHash) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < argCnt; ++i) {
            if (i > 0) {
                buf.append(' ');
            }
            buf.append(args[argOffset + i]);
        }
        if (pwdHash != null) {
            buf.append(' ');
            buf.append(pwdHash);
        }
        cmdList.add(buf.toString());
    }

    private static boolean confirmMigration() {
        System.out.print("\nWARNING!  Please confirm the requested migration of one or more\nGhidra Server repositories.  Once migrated to indexed storage,\nany attempt to use these server repositories with a Ghidra Server\nolder than version 5.5 will corrupt the data storage.\n\nWould you like to continue? [y/n]: ");
        try {
            if (121 == System.in.read()) {
                System.out.println();
                return true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("\nAll repository data migration(s) has been aborted.");
        return false;
    }

    private void validateDN(String[] args, int i) {
        if (args.length < i + 1) {
            this.displayUsage("Invalid usage!");
            System.exit(-1);
        }
        String dn = args[i];
        try {
            X500Principal x500User = new X500Principal(dn);
            args[i] = "\"" + x500User.getName() + "\"";
        }
        catch (Exception e) {
            Msg.error(CommandProcessor.class, (Object)("Invalid DN: " + dn));
            System.exit(-1);
        }
    }

    private void validateSID(String[] args, int i) {
        if (args.length < i + 1) {
            this.displayUsage("Invalid usage, expected username/sid");
            System.exit(-1);
        }
        this.validateSID(args[i]);
    }

    private void validateSID(String sid) {
        if (!UserManager.isValidUserName(sid)) {
            this.displayUsage("Invalid username/sid: " + sid);
            System.exit(-1);
        }
    }

    private void validatePermission(String[] args, int i) {
        if (args.length < i + 1 || CommandProcessor.parsePermission(args[i]) < 0) {
            this.displayUsage("Invalid usage, expected grant permission +r, +w or +a");
            System.exit(-1);
        }
    }

    private void validateRepositoryName(String[] args, int i, File rootDirFile) {
        String repName;
        File f;
        if (args.length < i + 1) {
            this.displayUsage("Invalid usage, expected repository name");
            System.exit(-1);
        }
        if (!(f = new File(rootDirFile, NamingUtilities.mangle((String)(repName = args[i])))).isDirectory()) {
            Msg.error(CommandProcessor.class, (Object)("Repository not found: " + repName));
            System.exit(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getServerDirFromConfig(String configFilePath) {
        if (configFilePath == null) {
            return null;
        }
        File configFile = new File(configFilePath);
        if (!configFile.exists()) {
            System.out.println("Config file not found: " + configFile.getAbsolutePath());
            return null;
        }
        if (configFile.isDirectory()) {
            return configFile;
        }
        System.out.println("Using config file: " + configFilePath);
        Properties config = new Properties();
        FileInputStream in = null;
        try {
            in = new FileInputStream(configFile);
            config.load(in);
        }
        catch (IOException e) {
            System.out.println("Failed to read " + configFile.getName() + ": " + e.getMessage());
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {}
            }
        }
        String p = config.getProperty(SERVER_DIR_CONFIG_PROPERTY);
        if (p == null) {
            System.out.println("Failed to find property: ghidra.repositories.dir");
            return null;
        }
        File dir = new File(p);
        if (!dir.isAbsolute()) {
            ResourceFile installRoot = Application.getInstallationDirectory();
            if (installRoot == null || installRoot.getFile(false) == null) {
                System.out.println("Failed to resolve installation root directory!");
                return null;
            }
            dir = new File(installRoot.getFile(false), p);
        }
        return dir;
    }

    private void displayUsage(String msg) {
        String invocationName;
        if (msg != null) {
            System.err.println(msg);
        }
        System.err.println("Usage: " + (String)((invocationName = System.getProperty(INVOCATION_NAME_PROPERTY)) != null ? invocationName : "java " + ServerAdmin.class.getName()) + (invocationName != null ? "" : " <configPath>") + " [<command>] [<command>] ...");
        System.err.println("\nSupported commands:");
        System.err.println("  -add <sid> [--p]");
        System.err.println("      Add a new user to the server identified by their sid identifier [optional --p prompts for password]");
        System.err.println("  -grant <sid> [+r|+w|+a] <repository-name>");
        System.err.println("      Grant access permission for a user, identified by sid, to the named repository");
        System.err.println("  -revoke <sid> <repository-name>");
        System.err.println("      Revoke access for a user, identified by sid, to a named repository");
        System.err.println("  -remove <sid>");
        System.err.println("      Remove the specified user from the server's user list and revoke all repository access");
        System.err.println("  -reset <sid> [--p]");
        System.err.println("      Reset the specified user's server login password [optional --p prompts for password]");
        System.err.println("  -dn <sid> \"<dname>\"");
        System.err.println("      When PKI authentication is used, add the specified X500 Distinguished Name for a user");
        System.err.println("  -list [--users]");
        System.err.println("      Output list of repositories to the console (user access list will be included with -users)");
        System.err.println("  -list <sid> [<sid>...]");
        System.err.println("      Output list of repository permissions for each user specified");
        System.err.println("  -users");
        System.err.println("      Output list of users to console which have server access");
        System.err.println("  -migrate \"<repository-name>\"");
        System.err.println("      Migrate the specified repository to the latest file system storage schema (see svrREADME.html)");
        System.err.println("  -migrate-all");
        System.err.println("      Migrate the all repositories to the latest file system storage schema (see svrREADME.html)");
        System.err.println();
    }
}

