/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.gadp;

import agent.gdb.gadp.impl.GdbGadpServerImpl;
import ghidra.async.AsyncUtils;
import ghidra.dbg.agent.AgentWindow;
import ghidra.util.Msg;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.exception.ExceptionUtils;

public interface GdbGadpServer
extends AutoCloseable {
    public static void main(String[] args) throws Exception {
        try {
            new Runner().run(args);
        }
        catch (Throwable t) {
            System.err.println(ExceptionUtils.getMessage((Throwable)t));
            System.exit(1);
        }
    }

    public static GdbGadpServer newInstance(SocketAddress addr) throws IOException {
        return new GdbGadpServerImpl(addr);
    }

    public CompletableFuture<Void> startGDB(String var1, String[] var2);

    public SocketAddress getLocalAddress();

    public void consoleLoop() throws IOException;

    public void terminate() throws IOException;

    @Override
    default public void close() throws IOException {
        this.terminate();
    }

    public void setExitOnClosed(boolean var1);

    public static class Runner {
        private String gdbCmd = "gdb";
        private List<String> gdbArgs = new ArrayList<String>();
        private InetSocketAddress bindTo;

        public void run(String[] args) throws IOException, InterruptedException, ExecutionException {
            this.parseArguments(args);
            try (GdbGadpServer server = GdbGadpServer.newInstance(this.bindTo);){
                server.startGDB(this.gdbCmd, this.gdbArgs.toArray(new String[0])).exceptionally(e -> {
                    e = AsyncUtils.unwrapThrowable((Throwable)e);
                    Msg.error((Object)this, (Object)("Error starting GDB/GADP: " + e));
                    System.exit(-1);
                    return null;
                });
                new AgentWindow("GDB Agent for Ghidra", server.getLocalAddress());
                server.consoleLoop();
            }
            System.exit(0);
        }

        private void parseArguments(String[] args) {
            String a;
            String iface = "localhost";
            int port = 12345;
            Iterator<String> ait = Arrays.asList(args).iterator();
            while (ait.hasNext() && !"--gadp-args".equals(a = ait.next())) {
                if ("-h".equals(a) || "--help".equals(a)) {
                    this.printUsage();
                    System.exit(0);
                    continue;
                }
                this.gdbArgs.add(a);
            }
            while (ait.hasNext()) {
                a = ait.next();
                if ("-p".equals(a) || "--port".equals(a)) {
                    if (!ait.hasNext()) {
                        System.err.println("Expected PORT");
                        this.printUsage();
                        System.exit(-1);
                    }
                    String portStr = ait.next();
                    try {
                        port = Integer.parseInt(portStr);
                    }
                    catch (NumberFormatException e) {
                        System.err.println("Integer required. Got " + portStr);
                        this.printUsage();
                        System.exit(-1);
                    }
                    continue;
                }
                if ("-H".equals(a) || "--host".equals(a)) {
                    if (!ait.hasNext()) {
                        System.err.println("Expected HOST/ADDR");
                        this.printUsage();
                        System.exit(-1);
                    }
                    iface = ait.next();
                    continue;
                }
                if ("-g".equals(a) || "--gdb-cmd".equals(a)) {
                    if (!ait.hasNext()) {
                        System.err.println("Expected CMD");
                        this.printUsage();
                        System.exit(-1);
                    }
                    this.gdbCmd = ait.next();
                    continue;
                }
                if ("-x".equals(a) || "--existing".equals(a)) {
                    this.gdbCmd = null;
                    continue;
                }
                System.err.println("Unknown option: " + a);
                this.printUsage();
                System.exit(-1);
            }
            this.bindTo = new InetSocketAddress(iface, port);
        }

        private void printUsage() {
            System.out.println("This is the GADP wrapper for GDB.  Usage:");
            System.out.println();
            System.out.println("    gadpgdb [GDB options] [--gadp-args [-H HOST/ADDR] [-p PORT] [-g CMD] [-x]]");
            System.out.println();
            System.out.println("Options:");
            System.out.println();
            System.out.println("Use gdb -h for suitable [GDB options]");
            System.out.println();
            System.out.println("  --host/-H          The address of the interface on which to listen. Default is localhost");
            System.out.println("  --port/-p          The TCP port on which to listen. Default is 12345. 0 for automatic.");
            System.out.println("  --gdb-cmd/-g       The command to launch gdb. Default is 'gdb'");
            System.out.println("  --existing/-x      Do not launch gdb. Instead just open a pty");
            System.out.println();
            System.out.println("Starts a GDB-based GADP server \"agent\". In general, it can be invoked in");
            System.out.println("the same manner as standard gdb. Arguments to control the GADP server and");
            System.out.println("GDB invocation are given after the --gadp-args flag. Once the server has");
            System.out.println("started, it will print the interface IP and port. The -g and -x flags are");
            System.out.println("mutually exclusive. The one appearing last get preference. The -x flags");
            System.out.println("causes the agent to refrain from launching its own gdb process. Instead,");
            System.out.println("it prints the file name of a private terminate (pty) where it expects a");
            System.out.println("GDB/MI v2 interpreter from an existing gdb process. Use the new-ui command");
            System.out.println("(available since GDB version 7.12) to join the agent to the existing");
            System.out.println("session:");
            System.out.println();
            System.out.println("(gdb) new-ui mi2 /dev/ptyXX");
        }
    }
}

