/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.importance;

import edu.uci.ics.jung.algorithms.importance.AbstractRanker;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class RelativeAuthorityRanker<V, E>
extends AbstractRanker<V, E> {
    private Set<V> mPriors;
    protected Map<V, Number> priorRankScoreMap = new HashMap<V, Number>();

    @Override
    protected void finalizeIterations() {
        super.finalizeIterations();
        this.priorRankScoreMap.clear();
    }

    protected double getPriorRankScore(V v) {
        return this.priorRankScoreMap.get(v).doubleValue();
    }

    public void setPriorRankScore(V v, double value) {
        this.priorRankScoreMap.put((Number)v, value);
    }

    protected Set<V> getPriors() {
        return this.mPriors;
    }

    protected void setPriors(Set<V> priors) {
        this.mPriors = priors;
    }
}

