/*
 * Decompiled with CFR 0.152.
 */
package help.screenshot;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.ToolBarData;
import docking.widgets.combobox.GComboBox;
import docking.widgets.label.GDHtmlLabel;
import docking.widgets.label.GIconLabel;
import docking.widgets.label.GLabel;
import ghidra.util.Msg;
import ghidra.util.bean.GGlassPane;
import ghidra.util.bean.GGlassPanePainter;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Ellipse2D;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import resources.ResourceManager;

public class ImageDialogProvider
extends DialogComponentProvider {
    private GGlassPane glassPane;
    private JLabel oldImageLabel;
    private JLabel newImageLabel;
    private File imageFile;
    private Image oldImage;
    private Image newImage;
    private JTextField textField;
    private ShapePainter dragShape;
    private Collection<ShapePainter> shapeList = new ArrayList<ShapePainter>();
    private JComboBox<String> shapeCombo;

    protected ImageDialogProvider(File imageFile, Image oldImage, Image newImage) {
        super("Help Snapshot");
        this.imageFile = imageFile;
        this.oldImage = oldImage;
        this.newImage = newImage;
        this.addWorkPanel(this.buildWorkPanel());
        this.addOKButton();
        this.setOkButtonText("Don't Save");
        if (imageFile != null) {
            this.addButton(this.buildSaveButton());
        }
        this.setupMouseListener();
        this.createActions();
        this.setRememberLocation(false);
        this.setRememberSize(false);
    }

    private JButton buildSaveButton() {
        JButton button = new JButton("Save");
        button.addActionListener(e -> {
            this.writeFile(this.newImage);
            this.close();
        });
        return button;
    }

    private void createActions() {
        DockingAction action = new DockingAction("Add", "Test"){

            public void actionPerformed(ActionContext context) {
                if (ImageDialogProvider.this.dragShape != null) {
                    ImageDialogProvider.this.dragShape.setColor(Color.green.brighter());
                    ImageDialogProvider.this.shapeList.add(ImageDialogProvider.this.dragShape);
                    ImageDialogProvider.this.dragShape = null;
                    ImageDialogProvider.this.glassPane.repaint();
                }
            }
        };
        action.setToolBarData(new ToolBarData((Icon)ResourceManager.loadImage((String)"images/Plus.png")));
        this.addAction((DockingActionIf)action);
        action = new DockingAction("Write", "Test"){

            public void actionPerformed(ActionContext context) {
                Msg.debug((Object)((Object)this), (Object)"Just kidding...");
            }
        };
        action.setToolBarData(new ToolBarData((Icon)ResourceManager.loadImage((String)"images/pencil16.png")));
        this.addAction((DockingActionIf)action);
    }

    private void setupMouseListener() {
        this.newImageLabel.addMouseMotionListener(new MouseMotionListener(){
            private Point startDrag;
            private Point lastDrag;

            @Override
            public void mouseMoved(MouseEvent e) {
                ImageDialogProvider.this.textField.setText("x = " + e.getX() + ", y = " + e.getY());
                if (this.startDrag != null) {
                    System.out.println("Drag ended");
                    this.startDrag = null;
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (this.startDrag == null) {
                    System.out.println("Drag started");
                    this.startDrag = e.getPoint();
                } else {
                    ImageDialogProvider.this.glassPane.removePainter((GGlassPanePainter)ImageDialogProvider.this.dragShape);
                    this.lastDrag = e.getPoint();
                    int x1 = Math.min(this.startDrag.x, this.lastDrag.x);
                    int x2 = Math.max(this.startDrag.x, this.lastDrag.x);
                    int y1 = Math.min(this.startDrag.y, this.lastDrag.y);
                    int y2 = Math.max(this.startDrag.y, this.lastDrag.y);
                    Point startPoint = new Point(x1, y1);
                    int width = x2 - x1;
                    int height = y2 - y1;
                    startPoint = SwingUtilities.convertPoint(e.getComponent(), startPoint, (Component)ImageDialogProvider.this.glassPane);
                    String selectedItem = (String)ImageDialogProvider.this.shapeCombo.getSelectedItem();
                    if ("Rectangle".equals(selectedItem)) {
                        Rectangle r = new Rectangle(startPoint, new Dimension(width, height));
                        ImageDialogProvider.this.dragShape = new ShapePainter(r, Color.RED);
                    } else if ("Oval".equals(selectedItem)) {
                        Ellipse2D.Double ellipse = new Ellipse2D.Double(startPoint.x, startPoint.y, width, height);
                        ImageDialogProvider.this.dragShape = new ShapePainter(ellipse, Color.RED);
                    } else if ("Arrow".equals(selectedItem)) {
                        // empty if block
                    }
                    ImageDialogProvider.this.glassPane.addPainter((GGlassPanePainter)ImageDialogProvider.this.dragShape);
                }
            }
        });
    }

    private JComponent buildWorkPanel() {
        this.shapeCombo = new GComboBox();
        this.shapeCombo.addItem("Rectangle");
        this.shapeCombo.addItem("Oval");
        this.shapeCombo.addItem("Arrow");
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add(this.shapeCombo, "North");
        JPanel imagePanel = new JPanel(new BorderLayout());
        this.newImageLabel = new GIconLabel((Icon)new ImageIcon(this.newImage));
        this.newImageLabel.setOpaque(true);
        this.newImageLabel.setBackground(Color.BLACK);
        JPanel newLabelPanel = new JPanel(new BorderLayout());
        if (this.oldImage != null) {
            this.oldImageLabel = new GIconLabel((Icon)new ImageIcon(this.oldImage));
            this.oldImageLabel.setOpaque(true);
            this.oldImageLabel.setBackground(Color.BLACK);
        } else {
            this.oldImageLabel = new GLabel("     Old image not found     ");
        }
        newLabelPanel.add((Component)this.createImageLabelComponent("New Image"), "North");
        newLabelPanel.setBorder(BorderFactory.createLineBorder(Color.black, 20));
        newLabelPanel.add((Component)this.newImageLabel, "Center");
        JPanel oldLabelPanel = new JPanel(new BorderLayout());
        oldLabelPanel.add((Component)this.createImageLabelComponent("Old Image"), "North");
        oldLabelPanel.setBorder(BorderFactory.createLineBorder(Color.black, 20));
        oldLabelPanel.add((Component)this.oldImageLabel, "Center");
        imagePanel.add((Component)oldLabelPanel, "West");
        imagePanel.add((Component)newLabelPanel, "East");
        jPanel.add((Component)imagePanel, "Center");
        this.textField = new JTextField();
        jPanel.add((Component)this.textField, "South");
        return jPanel;
    }

    private JComponent createImageLabelComponent(String name) {
        JPanel panel = new JPanel();
        JLabel label = this.createNameLabel(name);
        panel.add(label);
        panel.setBackground(label.getBackground());
        return panel;
    }

    private JLabel createNameLabel(String name) {
        GDHtmlLabel label = new GDHtmlLabel("<html><b><font color='yellow' size='8'>" + name);
        label.setOpaque(true);
        label.setBackground(Color.BLACK);
        label.setHorizontalTextPosition(0);
        return label;
    }

    protected void dialogShown() {
        JRootPane rootPane = SwingUtilities.getRootPane(this.getComponent());
        Component glass = rootPane.getGlassPane();
        if (glass instanceof GGlassPane) {
            this.glassPane = (GGlassPane)glass;
        }
    }

    protected void okCallback() {
        this.close();
    }

    private void writeFile(Image image) {
        try {
            ImageIO.write((RenderedImage)((Object)image), "png", this.imageFile);
            Msg.info((Object)((Object)this), (Object)("Captured tool to " + this.imageFile.getCanonicalPath()));
        }
        catch (Exception e) {
            Msg.showError((Object)((Object)this), null, (String)"Error Writing Image File", (Object)e.getMessage(), (Throwable)e);
        }
    }

    private class ShapePainter
    implements GGlassPanePainter {
        private Shape shape;
        private Color color;

        ShapePainter(Shape shape, Color color) {
            this.shape = shape;
            this.color = color;
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public void paint(GGlassPane pane, Graphics graphics) {
            graphics.setColor(this.color);
            Graphics2D g2d = (Graphics2D)graphics;
            BasicStroke stroke = new BasicStroke(5.0f);
            g2d.setStroke(stroke);
            g2d.draw(this.shape);
        }
    }
}

