/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.table.field;

import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.util.table.field.ProgramBasedDynamicTableColumnExtensionPoint;

public class ReferenceCountToAddressTableColumn
extends ProgramBasedDynamicTableColumnExtensionPoint<Address, Integer> {
    public String getColumnDisplayName(Settings settings) {
        return this.getColumnName();
    }

    public String getColumnName() {
        return "Reference Count";
    }

    public Integer getValue(Address rowObject, Settings settings, Program pgm, ServiceProvider serviceProvider) throws IllegalArgumentException {
        ReferenceManager referenceManager = pgm.getReferenceManager();
        int referenceCount = referenceManager.getReferenceCountTo(rowObject);
        if (referenceCount != 0) {
            return referenceCount;
        }
        FunctionManager functionManager = pgm.getFunctionManager();
        Function function = functionManager.getFunctionContaining(rowObject);
        if (function == null) {
            return 0;
        }
        return referenceManager.getReferenceCountTo(function.getEntryPoint());
    }
}

