/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.table.field;

import ghidra.docking.settings.EnumSettingsDefinition;
import ghidra.docking.settings.Settings;

public class ByteCountSettingsDefinition
implements EnumSettingsDefinition {
    private static final String BYTE_COUNT = "Byte count";
    public static final ByteCountSettingsDefinition DEF = new ByteCountSettingsDefinition();
    public static final int DEFAULT = 0;
    public static final int MAX_BYTE_COUNT = 8;
    private static final String[] choices = new String[]{"default", "1", "2", "3", "4", "5", "6", "7", "8"};

    private ByteCountSettingsDefinition() {
    }

    public int getChoice(Settings settings) {
        if (settings == null) {
            return 0;
        }
        Long value = settings.getLong(BYTE_COUNT);
        if (value == null || value < 0L || value >= (long)choices.length) {
            return 0;
        }
        return value.intValue();
    }

    public String getValueString(Settings settings) {
        return choices[this.getChoice(settings)];
    }

    public void setChoice(Settings settings, int value) {
        if (value < 0) {
            settings.clearSetting(BYTE_COUNT);
        } else {
            if (value > 8) {
                value = 8;
            }
            settings.setLong(BYTE_COUNT, (long)value);
        }
    }

    public String[] getDisplayChoices(Settings settings) {
        return choices;
    }

    public String getName() {
        return BYTE_COUNT;
    }

    public String getStorageKey() {
        return BYTE_COUNT;
    }

    public String getDescription() {
        return "Selects the number of bytes to display";
    }

    public String getDisplayChoice(int value, Settings s1) {
        return choices[value];
    }

    public void clear(Settings settings) {
        settings.clearSetting(BYTE_COUNT);
    }

    public void copySetting(Settings settings, Settings destSettings) {
        Long l = settings.getLong(BYTE_COUNT);
        if (l == null) {
            destSettings.clearSetting(BYTE_COUNT);
        } else {
            destSettings.setLong(BYTE_COUNT, l.longValue());
        }
    }

    public boolean hasValue(Settings setting) {
        return setting.getValue(BYTE_COUNT) != null;
    }
}

