/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.block.CodeBlock;
import ghidra.program.model.block.CodeBlockReference;
import ghidra.program.model.block.CodeBlockReferenceIterator;
import ghidra.program.model.block.IsolatedEntrySubModel;
import ghidra.program.model.block.SimpleBlockModel;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.FunctionDefinitionDataType;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.VoidDataType;
import ghidra.program.model.lang.PrototypeModel;
import ghidra.program.model.listing.CircularDependencyException;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionSignature;
import ghidra.program.model.listing.FunctionTag;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ReturnParameterImpl;
import ghidra.program.model.listing.StackFrame;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableFilter;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.FlowType;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.util.StackFrameImpl;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class UndefinedFunction
implements Function {
    private Program p;
    private AddressSetView body;
    private Address entry;
    private FunctionSignature signature;
    private StackFrame frame;

    public UndefinedFunction(Program p, Address entry) {
        if (entry != null && !entry.isMemoryAddress()) {
            throw new IllegalArgumentException("Entry point must be memory address");
        }
        this.p = p;
        this.body = new AddressSet(entry);
        this.entry = entry;
        this.signature = new FunctionDefinitionDataType((Function)this, true);
        this.frame = new StackFrameImpl(this);
    }

    public boolean isDeleted() {
        return false;
    }

    public static UndefinedFunction findFunction(Program program, Address address, TaskMonitor monitor) {
        if (program == null || address == null || monitor.isCancelled()) {
            return null;
        }
        UndefinedFunction function = UndefinedFunction.findFunctionUsingSimpleBlockModel(program, address, monitor);
        if (function != null || monitor.isCancelled()) {
            return function;
        }
        return UndefinedFunction.findFunctionUsingIsolatedBlockModel(program, address, monitor);
    }

    public int hashCode() {
        return this.entry.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UndefinedFunction)) {
            return false;
        }
        UndefinedFunction otherFunc = (UndefinedFunction)obj;
        if (!this.entry.equals((Object)otherFunc.entry)) {
            return false;
        }
        return SystemUtilities.isEqual((Object)this.getBody(), (Object)otherFunc.getBody());
    }

    public boolean isExternal() {
        return false;
    }

    public ExternalLocation getExternalLocation() {
        return null;
    }

    public static UndefinedFunction findFunctionUsingIsolatedBlockModel(Program program, Address address, TaskMonitor monitor) {
        monitor.setMessage("Find undefined entry for " + address.toString() + " (isolated entry model)");
        try {
            IsolatedEntrySubModel model = new IsolatedEntrySubModel(program);
            CodeBlock codeBlock = model.getFirstCodeBlockContaining(address, monitor);
            if (codeBlock == null) {
                return null;
            }
            Address entry = codeBlock.getFirstStartAddress();
            return new UndefinedFunction(program, entry);
        }
        catch (CancelledException e) {
            return null;
        }
    }

    public static UndefinedFunction findFunctionUsingSimpleBlockModel(Program program, Address address, TaskMonitor monitor) {
        monitor.setMessage("Find undefined entry for " + address.toString() + " (simple model)");
        if (program.getListing().getInstructionContaining(address) == null) {
            return null;
        }
        try {
            CodeBlock block = UndefinedFunction.getEntryBlock(program, address, monitor);
            if (block == null) {
                return null;
            }
            return new UndefinedFunction(program, block.getFirstStartAddress());
        }
        catch (CancelledException e) {
            return null;
        }
    }

    private static CodeBlock getEntryBlock(Program program, Address address, TaskMonitor monitor) throws CancelledException {
        SimpleBlockModel simpleModel = new SimpleBlockModel(program);
        CodeBlock block = simpleModel.getFirstCodeBlockContaining(address, monitor);
        if (block == null || block.isEmpty()) {
            return null;
        }
        AddressSet visitedAddresses = new AddressSet();
        LinkedList<CodeBlock> worklist = new LinkedList<CodeBlock>();
        Address blockStart = block.getFirstStartAddress();
        visitedAddresses.addRange(blockStart, blockStart);
        worklist.add(block);
        while (!worklist.isEmpty()) {
            CodeBlock curblock = (CodeBlock)worklist.poll();
            int count = 0;
            CodeBlockReferenceIterator iterator = curblock.getSources(monitor);
            while (iterator.hasNext() && !monitor.isCancelled()) {
                CodeBlockReference blockReference = iterator.next();
                FlowType flowType = blockReference.getFlowType();
                if (flowType.isCall() || flowType.isIndirect()) continue;
                ++count;
                Address sourceAddr = blockReference.getSourceAddress();
                if (visitedAddresses.contains(sourceAddr)) continue;
                visitedAddresses.addRange(sourceAddr, sourceAddr);
                worklist.add(blockReference.getSourceBlock());
            }
            if (count != 0) continue;
            return curblock;
        }
        return null;
    }

    public Variable addLocalVariable(Variable var, SourceType source) throws DuplicateNameException {
        throw new UnsupportedOperationException();
    }

    public Parameter addParameter(Variable var, SourceType source) throws DuplicateNameException {
        throw new UnsupportedOperationException();
    }

    public Parameter moveParameter(int fromOrdinal, int toOrdinal) {
        throw new UnsupportedOperationException();
    }

    public PrototypeModel getCallingConvention() {
        return this.p.getCompilerSpec().getDefaultCallingConvention();
    }

    public String getCallingConventionName() {
        return "unknown";
    }

    public String getComment() {
        return null;
    }

    public String[] getCommentAsArray() {
        return new String[0];
    }

    public String getDefaultCallingConventionName() {
        return this.p.getCompilerSpec().getDefaultCallingConvention().getName();
    }

    public Address getEntryPoint() {
        return this.entry;
    }

    public Variable[] getLocalVariables() {
        return new Variable[0];
    }

    public String getName() {
        return "UndefinedFunction_" + this.entry.toString(false);
    }

    public Parameter getParameter(int ordinal) {
        return null;
    }

    public int getParameterCount() {
        return 0;
    }

    public int getAutoParameterCount() {
        return 0;
    }

    public Parameter[] getParameters() {
        return new Parameter[0];
    }

    public Program getProgram() {
        return this.p;
    }

    public Parameter[] getParameters(VariableFilter filter) {
        return new Parameter[0];
    }

    public Variable[] getLocalVariables(VariableFilter filter) {
        return new Variable[0];
    }

    public Variable[] getVariables(VariableFilter filter) {
        return new Variable[0];
    }

    public boolean hasCustomVariableStorage() {
        return false;
    }

    public void setCustomVariableStorage(boolean hasCustomVariableStorage) {
    }

    public Variable[] getAllVariables() {
        return new Variable[0];
    }

    public String getRepeatableComment() {
        return null;
    }

    public String[] getRepeatableCommentAsArray() {
        return new String[0];
    }

    public DataType getReturnType() {
        return DataType.DEFAULT;
    }

    public Parameter getReturn() {
        try {
            DataType dt = this.getReturnType();
            if (dt instanceof TypeDef) {
                dt = ((TypeDef)dt).getBaseDataType();
            }
            return new ReturnParameterImpl(dt, dt instanceof VoidDataType ? VariableStorage.VOID_STORAGE : VariableStorage.UNASSIGNED_STORAGE, this.getProgram());
        }
        catch (InvalidInputException e) {
            throw new AssertException((Throwable)e);
        }
    }

    public void setReturn(DataType type, VariableStorage storage, SourceType source) throws InvalidInputException {
        throw new UnsupportedOperationException();
    }

    public FunctionSignature getSignature() {
        return this.signature;
    }

    public FunctionSignature getSignature(boolean formalSignature) {
        return this.signature;
    }

    public String getPrototypeString(boolean formalSignature, boolean includeCallingConvention) {
        return this.signature.getPrototypeString(includeCallingConvention);
    }

    public SourceType getSignatureSource() {
        return SourceType.DEFAULT;
    }

    public void setSignatureSource(SourceType signatureSource) {
        throw new UnsupportedOperationException();
    }

    public StackFrame getStackFrame() {
        return this.frame;
    }

    public int getStackPurgeSize() {
        return 0;
    }

    public boolean hasNoReturn() {
        return false;
    }

    public boolean hasVarArgs() {
        return false;
    }

    public Parameter insertParameter(int ordinal, Variable var, SourceType source) throws DuplicateNameException {
        throw new UnsupportedOperationException();
    }

    public void replaceParameters(List<? extends Variable> params, Function.FunctionUpdateType updateType, boolean force, SourceType source) throws DuplicateNameException, InvalidInputException {
        throw new UnsupportedOperationException();
    }

    public void replaceParameters(Function.FunctionUpdateType updateType, boolean force, SourceType source, Variable ... params) throws DuplicateNameException, InvalidInputException {
        throw new UnsupportedOperationException();
    }

    public void updateFunction(String callingConvention, Variable returnValue, Function.FunctionUpdateType updateType, boolean force, SourceType source, Variable ... newParams) throws DuplicateNameException, InvalidInputException {
        throw new UnsupportedOperationException();
    }

    public void updateFunction(String callingConvention, Variable returnVar, List<? extends Variable> newParams, Function.FunctionUpdateType updateType, boolean force, SourceType source) throws DuplicateNameException, InvalidInputException {
        throw new UnsupportedOperationException();
    }

    public boolean isInline() {
        return false;
    }

    public boolean isStackPurgeSizeValid() {
        return false;
    }

    public void removeParameter(int ordinal) {
        throw new UnsupportedOperationException();
    }

    public void removeVariable(Variable var) {
        throw new UnsupportedOperationException();
    }

    public void setBody(AddressSetView newBody) {
        this.body = newBody;
    }

    public void setCallingConvention(String name) throws InvalidInputException {
        throw new UnsupportedOperationException();
    }

    public void setComment(String comment) {
        throw new UnsupportedOperationException();
    }

    public void setInline(boolean isInline) {
        throw new UnsupportedOperationException();
    }

    public void setName(String name, SourceType source) throws DuplicateNameException, InvalidInputException {
        throw new UnsupportedOperationException();
    }

    public void setNoReturn(boolean hasNoReturn) {
        throw new UnsupportedOperationException();
    }

    public void setRepeatableComment(String comment) {
        throw new UnsupportedOperationException();
    }

    public void setReturnType(DataType type, SourceType source) {
        if (type == DataType.DEFAULT) {
            return;
        }
        throw new UnsupportedOperationException();
    }

    public void setStackPurgeSize(int purgeSize) {
        throw new UnsupportedOperationException();
    }

    public void setVarArgs(boolean hasVarArgs) {
        throw new UnsupportedOperationException();
    }

    public AddressSetView getBody() {
        return this.body;
    }

    public long getID() {
        return -1L;
    }

    public String getName(boolean includeNamespacePath) {
        return this.getName();
    }

    public Namespace getParentNamespace() {
        return this.p.getGlobalNamespace();
    }

    public Symbol getSymbol() {
        throw new UnsupportedOperationException();
    }

    public void setParentNamespace(Namespace parentNamespace) throws DuplicateNameException, InvalidInputException, CircularDependencyException {
        throw new UnsupportedOperationException();
    }

    public String getCallFixup() {
        return null;
    }

    public void setCallFixup(String name) {
        throw new UnsupportedOperationException();
    }

    public boolean isThunk() {
        return false;
    }

    public Function getThunkedFunction(boolean recursive) {
        return null;
    }

    public void setThunkedFunction(Function thunkedFunction) {
        throw new UnsupportedOperationException();
    }

    public Address[] getFunctionThunkAddresses(boolean recursive) {
        return null;
    }

    public Set<Function> getCallingFunctions(TaskMonitor monitor) {
        return Collections.emptySet();
    }

    public Set<Function> getCalledFunctions(TaskMonitor monitor) {
        return Collections.emptySet();
    }

    public void removeTag(String tagName) {
        throw new UnsupportedOperationException();
    }

    public Set<FunctionTag> getTags() {
        throw new UnsupportedOperationException();
    }

    public boolean addTag(String tagName) {
        throw new UnsupportedOperationException();
    }

    public void promoteLocalUserLabelsToGlobal() {
        throw new UnsupportedOperationException();
    }
}

