/*
 * Decompiled with CFR 0.152.
 */
package ghidra.test.processors.support;

import generic.jar.ResourceFile;
import generic.test.AbstractGTest;
import ghidra.GhidraTestApplicationLayout;
import ghidra.app.cmd.disassemble.DisassembleCommand;
import ghidra.app.cmd.function.ApplyFunctionDataTypesCmd;
import ghidra.app.cmd.function.CreateFunctionCmd;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.plugin.processors.sleigh.SleighDebugLogger;
import ghidra.app.util.PseudoDisassembler;
import ghidra.app.util.opinion.Loader;
import ghidra.framework.Application;
import ghidra.framework.ApplicationConfiguration;
import ghidra.framework.HeadlessGhidraApplicationConfiguration;
import ghidra.framework.model.DomainObject;
import ghidra.framework.options.Options;
import ghidra.framework.store.LockException;
import ghidra.pcode.floatformat.FloatFormat;
import ghidra.pcode.floatformat.FloatFormatFactory;
import ghidra.program.database.ProgramDB;
import ghidra.program.disassemble.DisassemblerContextImpl;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.FileDataTypeManager;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.VoidDataType;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.CompilerSpecNotFoundException;
import ghidra.program.model.lang.InstructionPrototype;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.model.lang.LanguageService;
import ghidra.program.model.lang.ParallelInstructionLanguageHelper;
import ghidra.program.model.lang.ProcessorContext;
import ghidra.program.model.lang.ProcessorContextView;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.Bookmark;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.ContextChangeException;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.ParameterImpl;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramContext;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.mem.DumbMemBufferImpl;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.program.util.DefaultLanguageService;
import ghidra.program.util.GhidraProgramUtilities;
import ghidra.test.TestEnv;
import ghidra.test.TestProgramManager;
import ghidra.test.processors.support.EmulatorTestRunner;
import ghidra.test.processors.support.ExecutionListener;
import ghidra.test.processors.support.PCodeTestAbstractControlBlock;
import ghidra.test.processors.support.PCodeTestCombinedTestResults;
import ghidra.test.processors.support.PCodeTestControlBlock;
import ghidra.test.processors.support.PCodeTestFile;
import ghidra.test.processors.support.PCodeTestGroup;
import ghidra.test.processors.support.PCodeTestResults;
import ghidra.util.BigEndianDataConverter;
import ghidra.util.InvalidNameException;
import ghidra.util.LittleEndianDataConverter;
import ghidra.util.MD5Utilities;
import ghidra.util.Msg;
import ghidra.util.NumericUtilities;
import ghidra.util.StringUtilities;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.exception.UsrException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import utilities.util.FileUtilities;
import utility.application.ApplicationLayout;

public abstract class ProcessorEmulatorTestAdapter
extends TestCase
implements ExecutionListener {
    public static final String BATCH_MODE_OUTPUT_DIR = System.getProperty("ghidra.test.property.output.dir");
    private static final String DEFAULT_PROCESSOR_TEST_MODULE = "Test/TestResources";
    private static final String TEST_INFO_STRUCT_NAME = "TestInfo";
    private static final String GROUP_INFO_STRUCT_NAME = "GroupInfo";
    private static final String PCODE_TEST_FILE_BASE_REGEX = "_PCodeTest.*";
    private static final String EMULATOR_TEST_SUFFIX = "EmulatorTest";
    private static final String EMULATOR_TRACE_LEVEL_PROPERTY = "EmuTestTraceLevel";
    private static int traceLevel = 3;
    private static Map<Class<?>, LogData> logDataMap = new HashMap();
    private static Class<?> lastTestClass;
    private static final String EMULATOR_TRACE_DISABLE_PROPERTY = "EmuTestTraceDisable";
    public static boolean traceDisabled;
    private static final int MAX_REGDUMP_WIDTH = 80;
    private static final int EXECUTION_TIMEOUT_MS = 240000;
    private static final int MAX_EXECUTION_STEPS = 2000000;
    private static final String GZF_FILE_EXT = ".gzf";
    private static final String BINARY_FILE_EXT = ".out";
    private static final String TEST_OUTPUT_PATH = "test-output";
    private static final String GZF_CACHEDIR_NAME = "cache";
    private static final String LOG_DIR_NAME = "logs";
    private static final String RESULTS_DIR_NAME = "results";
    private static final String TEST_RESOURCE_PATH = "data/pcodetests";
    private static final String FAILURE_RESULT_NAME = "failure";
    private static final String TEST_PREFIX = "test_";
    private static File outputDir;
    private static File resourcesCacheDir;
    private static File logDir;
    private static File resultsDir;
    private static PCodeTestCombinedTestResults combinedResults;
    private static Runnable resultsWriter;
    private static boolean initialized;
    protected String processorDesignator;
    private static Map<String, List<PCodeTestControlBlock>> testControlBlocksMap;
    private List<PCodeTestControlBlock> testControlBlocks;
    private HashMap<String, PCodeTestGroup> testGroupMap;
    protected Language language;
    protected CompilerSpec compilerSpec;
    protected Register[] regDumpSet;
    protected Set<Register> floatRegSet;
    protected Set<String> ignoredBlocks;
    private TestEnv env;
    private LogData logData;
    private Collection<ResourceFile> applicationRootDirectories;
    private File resourcesTestDataDir;
    private FileDataTypeManager archiveDtMgr;
    private Structure testInfoStruct;
    private Structure groupInfoStruct;
    private ParallelInstructionLanguageHelper parallelHelper;
    private static boolean deleteResultFilesOnStartup;
    private static Map<Class<?>, MyTestFailure> testFailureMap;

    private static void cleanupTempData() {
        FileUtilities.deleteDir((File)TestProgramManager.getDbTestDir());
        FileUtilities.deleteDir((File)new File(AbstractGTest.getTestDirectoryPath()));
    }

    public static void deleteResultFilesOnStartup() {
        deleteResultFilesOnStartup = true;
    }

    private static synchronized void initializeSharedResources() {
        String levelStr;
        String outputRoot;
        if (initialized) {
            return;
        }
        System.setProperty("SystemUtilities.isTesting", "true");
        try {
            GhidraTestApplicationLayout layout = new GhidraTestApplicationLayout(new File(AbstractGTest.getTestDirectoryPath()));
            HeadlessGhidraApplicationConfiguration configuration = new HeadlessGhidraApplicationConfiguration();
            Application.initializeApplication((ApplicationLayout)layout, (ApplicationConfiguration)configuration);
            initialized = true;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (BATCH_MODE_OUTPUT_DIR != null) {
            outputRoot = BATCH_MODE_OUTPUT_DIR;
        } else if (!SystemUtilities.isInDevelopmentMode()) {
            outputRoot = Application.getUserTempDirectory().getAbsolutePath();
        } else {
            try {
                outputRoot = Application.getApplicationRootDirectory().getParentFile().getParentFile().getCanonicalPath();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (!new File(outputRoot).isDirectory()) {
            throw new RuntimeException("Output directory not found: " + BATCH_MODE_OUTPUT_DIR);
        }
        outputDir = new File(outputRoot, TEST_OUTPUT_PATH);
        Msg.info(ProcessorEmulatorTestAdapter.class, (Object)("Using test output directory: " + outputDir.getAbsolutePath()));
        resourcesCacheDir = new File(outputDir, GZF_CACHEDIR_NAME);
        logDir = new File(outputDir, LOG_DIR_NAME);
        FileUtilities.mkdirs((File)logDir);
        resultsDir = new File(outputDir, RESULTS_DIR_NAME);
        if (deleteResultFilesOnStartup) {
            File xmlFile = new File(resultsDir, "pcode_test_results.xml");
            File htmlFile = new File(resultsDir, "pcode_test_results.html");
            xmlFile.delete();
            htmlFile.delete();
        }
        if ((levelStr = System.getProperty(EMULATOR_TRACE_LEVEL_PROPERTY)) != null) {
            traceLevel = Integer.parseInt(levelStr);
        }
        try {
            combinedResults = new PCodeTestCombinedTestResults(resultsDir, true);
        }
        catch (IOException e) {
            Msg.error(ProcessorEmulatorTestAdapter.class, (Object)"Error occurred reading previous XML P-Code test results, file will be re-written");
            try {
                combinedResults = new PCodeTestCombinedTestResults(resultsDir, true);
            }
            catch (IOException e1) {
                throw new AssertException();
            }
        }
        resultsWriter = () -> {
            if (combinedResults == null) {
                return;
            }
            try {
                combinedResults.saveToXml();
                combinedResults.saveToHTML();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        };
    }

    public ProcessorEmulatorTestAdapter(String name, String languageID, String compilerSpecID, String[] regDumpSetNames) throws LanguageNotFoundException, CompilerSpecNotFoundException {
        this(name, languageID, compilerSpecID, regDumpSetNames, null);
    }

    public ProcessorEmulatorTestAdapter(String name, String languageID, String compilerSpecID, String[] regDumpSetNames, String[] floatRegSetNames) throws LanguageNotFoundException, CompilerSpecNotFoundException {
        super(name);
        if (FAILURE_RESULT_NAME.equals(name)) {
            return;
        }
        ProcessorEmulatorTestAdapter.initializeSharedResources();
        try {
            this.processorDesignator = this.getProcessorDesignator();
            LanguageService languageService = DefaultLanguageService.getLanguageService();
            this.language = languageService.getLanguage(new LanguageID(languageID));
            this.compilerSpec = this.language.getCompilerSpecByID(new CompilerSpecID(compilerSpecID));
            Register pcReg = this.language.getProgramCounter();
            if (pcReg == null || pcReg.getMinimumByteSize() < this.language.getDefaultSpace().getPointerSize()) {
                throw new AssertException("Language must define properly sized program-counter register in pspec");
            }
            this.parallelHelper = this.language.getParallelInstructionHelper();
            this.regDumpSet = this.getRegisters(regDumpSetNames);
            this.floatRegSet = new HashSet<Register>(Arrays.asList(this.getRegisters(floatRegSetNames)));
        }
        catch (LanguageNotFoundException e) {
            Msg.error((Object)this, (Object)(this.getClass().getSimpleName() + " instantiation error"), (Throwable)e);
            throw e;
        }
        catch (CompilerSpecNotFoundException e) {
            Msg.error((Object)this, (Object)(this.getClass().getSimpleName() + " instantiation error"), (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            Msg.error((Object)this, (Object)(this.getClass().getSimpleName() + " instantiation error"), (Throwable)e);
            throw e;
        }
    }

    private Register[] getRegisters(String[] regNames) {
        if (regNames == null) {
            return new Register[0];
        }
        Register[] regs = new Register[regNames.length];
        for (int i = 0; i < regNames.length; ++i) {
            Register reg = this.language.getRegister(regNames[i]);
            if (reg == null) {
                throw new IllegalArgumentException("Undefined " + this.processorDesignator + " (" + this.language.getLanguageID() + ") dump register: " + regNames[i]);
            }
            regs[i] = reg;
        }
        return regs;
    }

    protected final void setIgnoredBlocks(String ... blockNames) {
        this.ignoredBlocks = new HashSet<String>();
        for (String name : blockNames) {
            this.ignoredBlocks.add(name);
        }
    }

    private AddressSetView getRestrictedSearchSet(Program program) {
        if (this.ignoredBlocks == null) {
            return program.getMemory().getLoadedAndInitializedAddressSet();
        }
        AddressSet set = new AddressSet();
        for (MemoryBlock block : program.getMemory().getBlocks()) {
            if (!block.isInitialized() || this.ignoredBlocks.contains(block.getName())) continue;
            set.add(block.getStart(), block.getEnd());
        }
        return set;
    }

    private static Throwable getCause(Throwable t) {
        if (t instanceof InvocationTargetException) {
            t = ((InvocationTargetException)t).getCause();
        }
        return t;
    }

    public static Test getTestFailure(Class<?> emulatorTestClass, String message, Throwable t) {
        if (t == null) {
            t = new AssertionFailedError(message);
        }
        MyTestFailure testFailure = new MyTestFailure(emulatorTestClass, ProcessorEmulatorTestAdapter.getCause(t));
        testFailureMap.put(emulatorTestClass, testFailure);
        return testFailure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Test buildEmulatorTestSuite(Class<?> emulatorTestClass) {
        Constructor<?> constructor;
        if (System.getProperty(EMULATOR_TRACE_DISABLE_PROPERTY) == null) {
            traceDisabled = true;
        }
        if (!emulatorTestClass.getSimpleName().endsWith(EMULATOR_TEST_SUFFIX)) {
            return ProcessorEmulatorTestAdapter.getTestFailure(emulatorTestClass, "Invalid emulator test classname, must end with 'EmulatorTest'", null);
        }
        if (!ProcessorEmulatorTestAdapter.class.isAssignableFrom(emulatorTestClass)) {
            return ProcessorEmulatorTestAdapter.getTestFailure(emulatorTestClass, "Test class does not extend " + ProcessorEmulatorTestAdapter.class.getSimpleName(), null);
        }
        try {
            constructor = emulatorTestClass.getConstructor(String.class);
        }
        catch (NoSuchMethodException e) {
            return ProcessorEmulatorTestAdapter.getTestFailure(emulatorTestClass, "Class has no public constructor TestCase(String name)", null);
        }
        ProcessorEmulatorTestAdapter instance = null;
        try {
            instance = (ProcessorEmulatorTestAdapter)constructor.newInstance(new Object[]{null});
        }
        catch (Exception e) {
            return ProcessorEmulatorTestAdapter.getTestFailure(emulatorTestClass, "Cannot instantiate test class", e);
        }
        try {
            instance.setUp();
            if (instance.testGroupMap == null || instance.testGroupMap.size() == 0) {
                Test e = ProcessorEmulatorTestAdapter.getTestFailure(emulatorTestClass, "No test binaries found", null);
                return e;
            }
            ArrayList<PCodeTestGroup> testGroups = new ArrayList<PCodeTestGroup>(instance.testGroupMap.values());
            Collections.sort(testGroups);
            EmulationTestSuite suite = new EmulationTestSuite();
            for (PCodeTestGroup testGroup : testGroups) {
                suite.addTest(TestSuite.createTest(emulatorTestClass, (String)(TEST_PREFIX + testGroup.testGroupName)));
            }
            Object object = suite;
            return object;
        }
        catch (Exception e) {
            e.printStackTrace();
            Test test = ProcessorEmulatorTestAdapter.getTestFailure(emulatorTestClass, "Exception during trial test setup", e);
            return test;
        }
        finally {
            try {
                instance.tearDown();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void log(PCodeTestGroup testGroup, String msg) {
        int index = 0;
        while (index < msg.length()) {
            Object text;
            int nextIndex = msg.indexOf(10, index);
            if (nextIndex >= 0) {
                text = msg.substring(index, nextIndex);
                index = nextIndex + 1;
            } else {
                text = msg.substring(index);
                index = msg.length();
            }
            if (testGroup != null) {
                text = testGroup.testGroupName + ": " + (String)text;
            }
            if (this.logData.traceLog != null) {
                this.logData.traceLog.println((String)text);
            }
            System.out.println((String)text);
        }
    }

    @Override
    public void log(PCodeTestGroup testGroup, String msg, Throwable t) {
        this.log(testGroup, msg);
        this.log(testGroup, ProcessorEmulatorTestAdapter.exceptionToString(t));
    }

    private Address getCallAddress(Instruction instr) {
        for (Reference ref : instr.getReferencesFrom()) {
            if (!ref.getReferenceType().isCall()) continue;
            return ref.getToAddress();
        }
        return null;
    }

    @Override
    public void logState(EmulatorTestRunner testRunner) {
        if (traceDisabled || traceLevel <= 0) {
            return;
        }
        if (traceLevel >= 1) {
            StringBuilder buf = new StringBuilder();
            Address curAddr = testRunner.getCurrentAddress();
            SymbolTable symbolTable = testRunner.getProgram().getSymbolTable();
            Symbol s = symbolTable.getPrimarySymbol(curAddr);
            if (s != null) {
                buf.append("<<");
                buf.append(s.getName());
            }
            Instruction instr = testRunner.getCurrentInstruction();
            buf.append(">> ");
            buf.append(curAddr.toString(true));
            buf.append(" ");
            if (instr != null) {
                Address callAddr;
                String prefix;
                if (this.parallelHelper != null && (prefix = this.parallelHelper.getMnemonicPrefix(instr)) != null) {
                    buf.append(prefix);
                    buf.append(' ');
                }
                buf.append(instr.toString());
                if (instr.getDelaySlotDepth() != 0) {
                    buf.append(" (delay-slots not shown)");
                }
                if (instr.getFlowType().isCall() && (callAddr = this.getCallAddress(instr)) != null && (s = symbolTable.getPrimarySymbol(callAddr)) != null) {
                    buf.append(" (call -> ");
                    buf.append(s.getName());
                    buf.append(")");
                }
            }
            this.log(testRunner.getTestGroup(), buf.toString());
        }
        if (traceLevel >= 2) {
            StringBuilder buf1 = new StringBuilder(" ");
            StringBuilder buf2 = new StringBuilder(" ");
            int width = 0;
            for (Register reg : this.regDumpSet) {
                int diff;
                int n;
                String regName = reg.getName();
                int len = Math.max(regName.length(), reg.getMinimumByteSize() * 2);
                if ((width += len) > 80) {
                    this.log(testRunner.getTestGroup(), buf1.toString());
                    this.log(testRunner.getTestGroup(), buf2.toString());
                    buf1 = new StringBuilder(" ");
                    buf2 = new StringBuilder(" ");
                    width = len;
                }
                buf1.append(regName);
                buf1.append(' ');
                buf2.append(testRunner.getRegisterValueString(reg));
                buf2.append(' ');
                for (n = diff = buf1.length() - buf2.length(); n < 0; ++n) {
                    buf1.append(' ');
                }
                for (n = diff; n > 0; --n) {
                    buf2.append(' ');
                }
            }
            if (buf1.length() > 1) {
                this.log(testRunner.getTestGroup(), buf1.toString());
                this.log(testRunner.getTestGroup(), buf2.toString());
            }
        }
    }

    @Override
    public void logState(EmulatorTestRunner emulatorTestRunner, Address dumpAddr, int dumpSize, int elementSize, EmulatorTestRunner.DumpFormat elementFormat, String comment) {
        if (dumpSize == 0) {
            return;
        }
        DumpFormatter dumpFormatter = elementFormat == EmulatorTestRunner.DumpFormat.FLOAT ? new FloatFormatter(elementSize, this.language.isBigEndian()) : (elementFormat == EmulatorTestRunner.DumpFormat.DECIMAL ? new DecimalFormatter(elementSize, this.language.isBigEndian()) : new HexFormatter(elementSize, this.language.isBigEndian()));
        int maxElementWidth = dumpFormatter.getMaxWidth();
        int elementsPerRow = (80 - dumpAddr.toString().length()) / (maxElementWidth + 1);
        if (elementsPerRow > 16) {
            elementsPerRow = 16;
        } else if (elementsPerRow > 8) {
            elementsPerRow = 8;
        } else if (elementsPerRow > 4) {
            elementsPerRow = 4;
        } else if (elementsPerRow == 0) {
            elementsPerRow = 1;
        }
        int byteCount = dumpSize * elementSize;
        byte[] bytes = emulatorTestRunner.getEmulatorHelper().readMemory(dumpAddr, byteCount);
        int index = 0;
        this.log(null, "MEMORY DUMP (" + elementFormat + "): " + comment);
        while (index < byteCount) {
            StringBuilder buf = new StringBuilder();
            buf.append("  ");
            buf.append(dumpAddr.toString(true));
            buf.append(":");
            for (int i = 0; i < elementsPerRow && index < byteCount; index += elementSize, ++i) {
                String valStr = dumpFormatter.getString(bytes, index);
                valStr = StringUtilities.pad((String)valStr, (char)' ', (int)(maxElementWidth + 1));
                buf.append(valStr);
            }
            this.log(null, buf.toString());
            if (index >= byteCount) continue;
            dumpAddr = dumpAddr.add((long)(elementsPerRow * elementSize));
        }
    }

    private void logUnimplemented(TreeSet<String> unimplementedSet) {
        if (unimplementedSet.isEmpty()) {
            return;
        }
        this.log(null, "Summary of Unimplemented Pcodeops encountered (CALLOTHER):");
        for (String name : unimplementedSet) {
            this.log(null, "   " + name);
        }
    }

    private byte[] flipBytes(byte[] bytes) {
        int index = bytes.length;
        byte[] flippedBytes = new byte[bytes.length];
        for (byte b : bytes) {
            flippedBytes[--index] = b;
        }
        return flippedBytes;
    }

    private String formatAssignmentString(Address address, int size, byte[] values) {
        Register reg;
        if (!this.language.isBigEndian()) {
            values = this.flipBytes(values);
        }
        String name = (reg = this.language.getRegister(address, size)) != null ? reg.getName() : address.toString(true) + ":" + size;
        Object floatStr = "";
        if (reg != null && this.floatRegSet.contains(reg)) {
            FloatFormat floatFormat = FloatFormatFactory.getFloatFormat((int)size);
            BigDecimal hostFloat = floatFormat.round(floatFormat.getHostFloat(new BigInteger(1, values)));
            floatStr = " (" + hostFloat.toString() + ")";
        }
        return name + "=0x" + NumericUtilities.convertBytesToString((byte[])values, (String)"") + (String)floatStr;
    }

    @Override
    public void logRead(EmulatorTestRunner testRunner, Address address, int size, byte[] values) {
        if (traceLevel < 3) {
            return;
        }
        this.log(testRunner.getTestGroup(), " Read " + this.formatAssignmentString(address, size, values));
    }

    @Override
    public void logWrite(EmulatorTestRunner testRunner, Address address, int size, byte[] values) {
        if (traceLevel < 3) {
            return;
        }
        this.log(testRunner.getTestGroup(), " Write " + this.formatAssignmentString(address, size, values));
    }

    @Override
    public void stepCompleted(EmulatorTestRunner testRunner) {
        this.logState(testRunner);
    }

    private static String exceptionToString(Throwable t) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        t.printStackTrace(writer);
        return stringWriter.toString();
    }

    private void findTestResourceDirectory(String relativeModulePath) {
        if (relativeModulePath == null) {
            return;
        }
        for (ResourceFile appRoot : this.applicationRootDirectories) {
            File moduleRoot = new File(appRoot.getAbsolutePath(), relativeModulePath);
            File dir = new File(moduleRoot, TEST_RESOURCE_PATH);
            if (!dir.isDirectory()) continue;
            this.resourcesTestDataDir = dir;
            break;
        }
    }

    protected void setUp() throws Exception {
        this.env = new TestEnv();
        this.applicationRootDirectories = Application.getApplicationRootDirectories();
        ResourceFile myModuleRootDirectory = Application.getModuleContainingClass((String)this.getClass().getName());
        if (myModuleRootDirectory != null) {
            File myModuleRoot = myModuleRootDirectory.getFile(false);
            if (myModuleRoot != null) {
                this.resourcesTestDataDir = new File(myModuleRoot, TEST_RESOURCE_PATH);
                if (!this.resourcesTestDataDir.isDirectory()) {
                    this.findTestResourceDirectory(this.getRelativeModulePath(myModuleRootDirectory));
                }
            }
        } else {
            Msg.warn((Object)this, (Object)"Unable to identify pcodetest module directory! Project must contain Module.manifest file");
        }
        if (this.resourcesTestDataDir == null || !this.resourcesTestDataDir.isDirectory()) {
            this.findTestResourceDirectory(DEFAULT_PROCESSOR_TEST_MODULE);
        }
        if (this.resourcesTestDataDir == null || !this.resourcesTestDataDir.isDirectory()) {
            throw new RuntimeException("Failed to locate pcodetest resource directory: data/pcodetests");
        }
        this.logData = ProcessorEmulatorTestAdapter.initializeLog(this.getClass());
        if (FAILURE_RESULT_NAME.equals(this.getName())) {
            this.logData.testResults.summaryHasIngestErrors = true;
            testFailureMap.get(this.getClass()).throwFailure();
        }
        ResourceFile emuTestingArchive = Application.getModuleDataFile((String)"pcodetest/EmuTesting.gdt");
        this.archiveDtMgr = FileDataTypeManager.openFileArchive((ResourceFile)emuTestingArchive, (boolean)false);
        DataType dt = this.archiveDtMgr.getDataType(CategoryPath.ROOT, TEST_INFO_STRUCT_NAME);
        if (dt == null || !(dt instanceof Structure)) {
            ProcessorEmulatorTestAdapter.fail((String)"TestInfo structure data-type not found in resource EmuTesting.gdt");
        }
        this.testInfoStruct = (Structure)dt;
        dt = this.archiveDtMgr.getDataType(CategoryPath.ROOT, GROUP_INFO_STRUCT_NAME);
        if (dt == null || !(dt instanceof Structure)) {
            ProcessorEmulatorTestAdapter.fail((String)"GroupInfo structure data-type not found in resource EmuTesting.gdt");
        }
        this.groupInfoStruct = (Structure)dt;
        this.testControlBlocks = testControlBlocksMap.get(this.processorDesignator);
        if (this.testControlBlocks == null) {
            try {
                this.ingestTestBinaries();
            }
            catch (RuntimeException e) {
                e.printStackTrace(this.logData.traceLog);
                this.logData.testResults.addSevereFailResult("", "TestFileIngest");
                throw e;
            }
            testControlBlocksMap.put(this.processorDesignator, this.testControlBlocks);
        }
        this.testGroupMap = new HashMap();
        for (PCodeTestControlBlock testControlBlock : this.testControlBlocks) {
            for (PCodeTestGroup testGroup : testControlBlock.getTestGroups()) {
                this.testGroupMap.put(testGroup.testGroupName, testGroup);
            }
        }
    }

    private String getRelativeModulePath(ResourceFile myModuleRootDirectory) {
        String absolutePath = myModuleRootDirectory.getAbsolutePath();
        for (ResourceFile appRoot : this.applicationRootDirectories) {
            String rootPath = appRoot.getAbsolutePath();
            if (!absolutePath.startsWith(rootPath)) continue;
            return absolutePath.substring(rootPath.length() + 1);
        }
        return null;
    }

    private static LogData initializeLog(Class<?> testClass) throws FileNotFoundException {
        try {
            LogData data = logDataMap.get(testClass);
            if (data == null) {
                data = new LogData();
                logDataMap.put(testClass, data);
                data.testResults = combinedResults.getTestResults(testClass.getSimpleName(), true);
                data.testResults.clear();
                data.traceFile = new File(logDir, testClass.getSimpleName() + ".log");
                if (data.traceFile.exists()) {
                    data.traceFile.delete();
                }
            } else {
                if (lastTestClass != null && !lastTestClass.equals(testClass)) {
                    resultsWriter.run();
                }
                if (data.traceLog != null) {
                    LogData logData = data;
                    return logData;
                }
            }
            data.traceLog = new PrintWriter(new BufferedWriter(new OutputStreamWriter(new FileOutputStream(data.traceFile, true))));
            data.traceLog.println(new Date().toString());
            LogData logData = data;
            return logData;
        }
        finally {
            lastTestClass = testClass;
        }
    }

    protected void tearDown() throws Exception {
        if (this.logData != null && this.logData.traceLog != null) {
            this.logUnimplemented(this.logData.unimplementedSet);
            this.logData.traceLog.flush();
            this.logData.traceLog.close();
            this.logData.traceLog = null;
        }
        if (this.archiveDtMgr != null) {
            this.archiveDtMgr.close();
        }
        if (this.env != null) {
            this.env.dispose();
        }
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void runTest() {
        String testGroupName = this.getName();
        if (testGroupName != null) {
            if (testGroupName.startsWith(TEST_PREFIX)) {
                testGroupName = testGroupName.substring(TEST_PREFIX.length());
            } else {
                ProcessorEmulatorTestAdapter.fail((String)"Expected test name to start with test_");
            }
        }
        if (testGroupName == null || testGroupName.length() == 0) {
            ProcessorEmulatorTestAdapter.fail((String)"Empty test group name");
        }
        PCodeTestGroup testGroup = this.testGroupMap.get(testGroupName);
        ProcessorEmulatorTestAdapter.assertNotNull((String)("TestGroup not found for '" + testGroupName + "'"), (Object)testGroup);
        this.log(testGroup, "Prepare for executing group test '" + testGroup.testGroupName + "' at: " + testGroup.functionEntryPtr.toString(true));
        this.log(testGroup, "Loading test binary: " + testGroup.mainTestControlBlock.testFile.fileReferencePath);
        this.log(testGroup, "Using cached program: " + testGroup.mainTestControlBlock.cachedProgramPath);
        Program program = null;
        EmulatorTestRunner testRunner = null;
        try {
            program = this.getGzfProgram(testGroup.mainTestControlBlock.cachedProgramPath);
            ProcessorEmulatorTestAdapter.assertNotNull((String)("Failed to open test program: " + testGroup.mainTestControlBlock.cachedProgramPath), (Object)program);
            if (program.isChanged()) {
                String fpath = testGroup.mainTestControlBlock.testFile.fileReferencePath;
                Msg.info(ProcessorEmulatorTestAdapter.class, (Object)("Updating cached gzf file following program upgrade: " + fpath));
                File gzfFile = new File(resourcesCacheDir, fpath + GZF_FILE_EXT);
                this.env.getGhidraProject().saveAsPackedFile(program, gzfFile, true);
                if (!gzfFile.exists()) {
                    throw new IOException("Failed to cache gzf file: " + gzfFile);
                }
            }
            ProcessorEmulatorTestAdapter.assertFalse((String)("Program contains severe disassembly/relocation errors: " + testGroup.mainTestControlBlock.cachedProgramPath), (this.logData.testResults.summaryHasRelocationErrors || this.logData.testResults.summaryHasDisassemblyErrors ? 1 : 0) != 0);
            testRunner = new EmulatorTestRunner(program, testGroup, this);
            testRunner.setRegister(this.compilerSpec.getStackPointer().getName(), 0L);
            Address address = EmulatorTestRunner.alignAddress(testGroup.functionEntryPtr, this.language.getInstructionAlignment());
            ProgramContext programContext = program.getProgramContext();
            Register contextRegister = programContext.getBaseContextRegister();
            if (contextRegister != null) {
                testRunner.setContextRegister(programContext.getRegisterValue(contextRegister, address));
            }
            this.initializeState(testRunner, program);
            this.checkStackPointerValue(testRunner);
            int totalExpectedAsserts = 0;
            int numSubTests = testGroup.controlBlock.getNumberFunctions();
            for (int i = 1; i < numSubTests; ++i) {
                PCodeTestAbstractControlBlock.FunctionInfo functionInfo = testGroup.controlBlock.getFunctionInfo(i);
                String name = functionInfo.functionName;
                this.logData.testResults.declareTest(testGroup.testGroupName, name, functionInfo.numberOfAsserts);
                totalExpectedAsserts += functionInfo.numberOfAsserts;
            }
            testGroup.mainTestControlBlock.setNumberPassed(testRunner, Integer.MIN_VALUE);
            testGroup.mainTestControlBlock.setNumberFailed(testRunner, Integer.MIN_VALUE);
            boolean done = traceDisabled ? testRunner.execute(240000, TaskMonitor.DUMMY) : testRunner.executeSingleStep(2000000);
            int pass = testGroup.mainTestControlBlock.getNumberPassed(testRunner);
            int callOtherErrors = testRunner.getCallOtherErrors();
            int fail = testGroup.mainTestControlBlock.getNumberFailed(testRunner);
            if (pass < 0 || fail < 0) {
                this.failTest(testRunner, "ERROR Invalid pass/fail counts - test may not have run properly or improper TestInfo structure updates occurred: pass " + pass + " fail " + fail);
            }
            String passFailText = "Passed: " + (pass -= callOtherErrors) + " Failed: " + fail;
            if (callOtherErrors != 0) {
                passFailText = passFailText + " Passed(w/CALLOTHER): " + callOtherErrors;
            }
            passFailText = passFailText + " Expected Assertions: " + totalExpectedAsserts;
            this.log(testGroup, passFailText);
            List<String> testFailures = testGroup.getTestFailures();
            if (!testFailures.isEmpty()) {
                this.log(testGroup, "TEST FAILURES:");
                for (String testFailure : testFailures) {
                    this.log(testGroup, " >>> " + testFailure);
                }
            }
            if (!done) {
                StringBuilder msg = new StringBuilder("ERROR Test execution failed");
                String emuError = testRunner.getEmuError();
                if (emuError != null) {
                    msg.append(" - ");
                    msg.append(emuError);
                }
                Address pcAddr = testRunner.getCurrentAddress();
                String pcStr = Long.toHexString(pcAddr.getOffset());
                if (emuError == null || emuError.indexOf(pcStr) < 0) {
                    msg.append(", pc=0x");
                    msg.append(pcStr);
                }
                this.failTest(testRunner, msg.toString());
            }
            int ranCnt = pass + fail + callOtherErrors;
            if (totalExpectedAsserts != 0 && totalExpectedAsserts != ranCnt) {
                this.failTest(testRunner, "ERROR Unexpected number of assertions ( " + passFailText + " )");
            }
            if (fail != 0 || callOtherErrors != 0 || testFailures.size() != 0) {
                this.failTest(testRunner, "ERROR One or more group tests failed ( " + passFailText + " )");
            }
        }
        catch (Exception e) {
            this.log(testGroup, "Exception occurred during test", e);
            ProcessorEmulatorTestAdapter.fail((String)("Exception occurred during test: " + e.getMessage()));
        }
        finally {
            if (testRunner != null) {
                this.logData.unimplementedSet.addAll(testRunner.getUnimplementedPcodeops());
                testRunner.dispose();
            }
            if (program != null) {
                this.env.release(program);
            }
        }
    }

    private void checkStackPointerValue(EmulatorTestRunner testRunner) {
        Program program = testRunner.getProgram();
        Register spReg = this.compilerSpec.getStackPointer();
        if (spReg != null) {
            AddressSpace stackSpace;
            RegisterValue spValue = testRunner.getRegisterValue(spReg);
            long stackOffset = spValue.getUnsignedValue().longValue();
            if (stackOffset == 0L) {
                this.initStackPointer(testRunner, spReg);
            }
            if ((stackSpace = this.compilerSpec.getStackBaseSpace()) != null) {
                Address stackPtr = stackSpace.getAddress(stackOffset);
                if (program.getMemory().getLoadedAndInitializedAddressSet().contains(stackPtr)) {
                    ProcessorEmulatorTestAdapter.fail((String)("Stack pointer defined within initialized memory region: " + stackPtr));
                }
            }
        }
    }

    private Symbol findAnyMatchingSymbol(Program program, String ... names) {
        for (String name : names) {
            Symbol s;
            if (name == null || (s = SymbolUtilities.getExpectedLabelOrFunctionSymbol((Program)program, (String)name, m -> m.toString())) == null) continue;
            return s;
        }
        return null;
    }

    private void initStackPointer(EmulatorTestRunner testRunner, Register spReg) {
        Program program = testRunner.getProgram();
        Symbol stackSymbol = this.findAnyMatchingSymbol(program, this.getPreferredStackSymbolName(), "_stack", "stack", "__STACK_START");
        if (stackSymbol != null) {
            long stackOffset = stackSymbol.getAddress().getAddressableWordOffset();
            testRunner.setRegister(spReg.getName(), stackOffset);
            this.log(null, "Stack Pointer (" + spReg.getName() + ") auto-assigned using symbol '" + stackSymbol.getName() + "' offset: 0x" + Long.toHexString(stackOffset));
        } else {
            this.log(null, "Stack Pointer (" + spReg.getName() + ") using default offset: 0");
        }
    }

    protected String getPreferredStackSymbolName() {
        return null;
    }

    private void failTest(EmulatorTestRunner testRunner, String msg) {
        this.log(testRunner.getTestGroup(), msg);
        this.checkInstructionDecodeFailure(testRunner);
        ProcessorEmulatorTestAdapter.fail((String)msg);
    }

    private void checkInstructionDecodeFailure(EmulatorTestRunner testRunner) {
        String emuError = testRunner.getEmuError();
        if (emuError == null || emuError.indexOf("Instruction decode failed") < 0 || emuError.indexOf("Uninitialized Memory") > 0) {
            return;
        }
        Address currentAddr = testRunner.getCurrentAddress();
        RegisterValue contextRegValue = testRunner.getEmulatorHelper().getEmulator().getContextRegisterValue();
        if (contextRegValue == null) {
            return;
        }
        StringBuilder buf = new StringBuilder("Context register state at: ");
        buf.append(currentAddr.toString(true));
        for (Register contextField : contextRegValue.getRegister().getChildRegisters()) {
            RegisterValue ctxValue = contextRegValue.getRegisterValue(contextField);
            String valueStr = ctxValue.getUnsignedValueIgnoreMask().toString(16);
            buf.append("\n  ");
            buf.append(contextField.getName());
            buf.append(" = 0x");
            buf.append(valueStr);
        }
        this.log(testRunner.getTestGroup(), buf.toString());
        Program program = testRunner.getProgram();
        boolean inDelaySlot = false;
        DumbMemBufferImpl memBuf = new DumbMemBufferImpl(program.getMemory(), currentAddr);
        DisassemblerContextImpl context = new DisassemblerContextImpl(program.getProgramContext());
        try {
            context.flowStart(currentAddr);
            context.setRegisterValue(contextRegValue);
            InstructionPrototype proto = this.language.parse((MemBuffer)memBuf, (ProcessorContext)context, false);
            int len = proto.getLength();
            if (proto.hasDelaySlots()) {
                len *= 3;
            }
            byte[] emuBytes = testRunner.getEmulatorHelper().readMemory(currentAddr, len);
            byte[] programBytes = new byte[emuBytes.length];
            program.getMemory().getBytes(currentAddr, programBytes);
            if (!Arrays.equals(emuBytes, programBytes)) {
                buf = new StringBuilder("Instruction bytes differ between program and emulator state at: ");
                buf.append(currentAddr.toString(true));
                if (inDelaySlot) {
                    buf.append(" (includes delay-slots)");
                }
                buf.append("\n");
                buf.append("  Program Bytes:  ");
                buf.append(NumericUtilities.convertBytesToString((byte[])programBytes, (String)" "));
                buf.append("\n");
                buf.append("  Emulator Bytes: ");
                buf.append(NumericUtilities.convertBytesToString((byte[])emuBytes, (String)" "));
                this.log(testRunner.getTestGroup(), buf.toString());
            } else {
                this.log(testRunner.getTestGroup(), "Test unable to determine cause of instruction parse failure");
            }
            return;
        }
        catch (UsrException e) {
            if (inDelaySlot) {
                this.log(testRunner.getTestGroup(), "Instruction parse error occurred in delay-slot at: " + memBuf.getAddress().toString(true));
            }
            SleighDebugLogger logger = new SleighDebugLogger((MemBuffer)memBuf, (ProcessorContextView)context, this.language, SleighDebugLogger.SleighDebugMode.VERBOSE);
            this.log(testRunner.getTestGroup(), logger.toString());
            return;
        }
    }

    protected static final Address getMaxDefinedMemoryAddress(Program program) {
        Address maxAddr = null;
        for (MemoryBlock block : program.getMemory().getBlocks()) {
            if (block.getStart().getAddressSpace().isOverlaySpace() || maxAddr != null && maxAddr.compareTo((Object)block.getEnd()) >= 0) continue;
            maxAddr = block.getEnd();
        }
        return maxAddr;
    }

    protected String getProcessorDesignator() {
        String className = this.getClass().getSimpleName();
        if (!className.endsWith(EMULATOR_TEST_SUFFIX)) {
            throw new RuntimeException("Invalid emulator test classname, must end with 'EmulatorTest'");
        }
        return className.substring(0, className.length() - EMULATOR_TEST_SUFFIX.length());
    }

    protected String buildTestFileDesignator(int fileIndex, String filePath) {
        return null;
    }

    protected void initializeState(EmulatorTestRunner testRunner, Program program) throws Exception {
        Address addr = testRunner.getTestGroup().functionEntryPtr;
        addr = PseudoDisassembler.getNormalizedDisassemblyAddress((Program)program, (Address)addr);
        ProgramContext programContext = program.getProgramContext();
        for (Register reg : programContext.getRegisters()) {
            RegisterValue value;
            if (reg.isProcessorContext() || reg.isProgramCounter() || (value = programContext.getRegisterValue(reg, addr)) == null || !value.hasValue()) continue;
            this.log(testRunner.getTestGroup(), "Initialized register " + reg.getName() + "=0x" + value.getUnsignedValue().toString(16) + " using context at " + addr.toString(true));
            testRunner.setRegister(reg.getName(), value.getUnsignedValue());
        }
    }

    protected void postImport(Program program) throws Exception {
    }

    protected void preAnalyze(Program program) throws Exception {
    }

    protected void postAnalyze(Program program) throws Exception {
    }

    protected void analyze(Program program, PCodeTestControlBlock testControlBlock) throws Exception {
        this.setAnalysisOptions(program.getOptions("Analyzers"));
        GhidraProgramUtilities.setAnalyzedFlag(program, true);
        for (Function function : program.getFunctionManager().getFunctions(true)) {
            if (function.getBody().getNumAddresses() != 1L) continue;
            function.getSymbol().delete();
        }
        AutoAnalysisManager analysisMgr = AutoAnalysisManager.getAnalysisManager(program);
        analysisMgr.cancelQueuedTasks();
        analysisMgr.initializeOptions();
        AddressSet disassembleStarts = new AddressSet();
        this.addFunctionStartDisassemblyPoint(testControlBlock.getBreakOnDoneAddress(), "breakOnDone", disassembleStarts, program);
        this.addFunctionStartDisassemblyPoint(testControlBlock.getBreakOnPassAddress(), "breakOnPass", disassembleStarts, program);
        this.addFunctionStartDisassemblyPoint(testControlBlock.getBreakOnErrorAddress(), "breakOnError", disassembleStarts, program);
        this.addFunctionStartDisassemblyPoint(testControlBlock.getSprintf5Address(), "printf5", disassembleStarts, program);
        int functionCnt = testControlBlock.getNumberFunctions();
        for (int i = 0; i < functionCnt; ++i) {
            PCodeTestAbstractControlBlock.FunctionInfo functionInfo = testControlBlock.getFunctionInfo(i);
            this.addFunctionStartDisassemblyPoint(functionInfo.functionAddr, functionInfo.functionName, disassembleStarts, program);
        }
        for (PCodeTestGroup testGroup : testControlBlock.getTestGroups()) {
            functionCnt = testGroup.controlBlock.getNumberFunctions();
            for (int i = 0; i < functionCnt; ++i) {
                PCodeTestAbstractControlBlock.FunctionInfo functionInfo = testGroup.controlBlock.getFunctionInfo(i);
                this.addFunctionStartDisassemblyPoint(functionInfo.functionAddr, functionInfo.functionName, disassembleStarts, program);
            }
        }
        new DisassembleCommand((AddressSetView)disassembleStarts, null).applyTo((DomainObject)program);
        new CreateFunctionCmd((AddressSetView)disassembleStarts).applyTo((DomainObject)program);
        analysisMgr.reAnalyzeAll(null);
        analysisMgr.startAnalysis(TaskMonitor.DUMMY);
        ArrayList<DataTypeManager> dtMgrList = new ArrayList<DataTypeManager>();
        dtMgrList.add((DataTypeManager)this.archiveDtMgr);
        ApplyFunctionDataTypesCmd cmd = new ApplyFunctionDataTypesCmd(dtMgrList, null, SourceType.ANALYSIS, true, false);
        cmd.applyTo((DomainObject)program);
        PointerDataType testInfoStructPtrType = new PointerDataType((DataType)this.testInfoStruct);
        for (Function func : program.getFunctionManager().getFunctions(true)) {
            String name = func.getName();
            if (name.endsWith("_Main")) {
                func.setReturnType((DataType)VoidDataType.dataType, SourceType.ANALYSIS);
                continue;
            }
            if (!name.endsWith("_main")) continue;
            func.setReturnType((DataType)VoidDataType.dataType, SourceType.ANALYSIS);
            func.replaceParameters(Function.FunctionUpdateType.DYNAMIC_STORAGE_ALL_PARAMS, false, SourceType.ANALYSIS, new Variable[]{new ParameterImpl("ti", (DataType)testInfoStructPtrType, program)});
        }
    }

    protected void setAnalysisOptions(Options analysisOptions) {
        analysisOptions.setBoolean("Stack", false);
        analysisOptions.setBoolean("DWARF", false);
        analysisOptions.setBoolean("Create Address Tables", false);
    }

    private void addFunctionStartDisassemblyPoint(Address functionAddr, String functionName, AddressSet disassembleStarts, Program program) {
        String processor;
        Listing listing;
        CodeUnit cu;
        Symbol s = program.getSymbolTable().getPrimarySymbol(functionAddr);
        if (s == null || s.isDynamic() || s.getName().equals(SymbolUtilities.getDefaultFunctionName((Address)functionAddr))) {
            this.createSymbol(functionAddr, functionName, program);
        }
        if ((cu = (listing = program.getListing()).getCodeUnitAt(functionAddr)) instanceof Instruction) {
            return;
        }
        if (cu == null || ((Data)cu).isDefined()) {
            Msg.warn((Object)this, (Object)("Unexpected code unit or bad test-group function pointer: " + functionName + " at " + functionAddr));
        }
        if ("ARM".equals(processor = program.getLanguage().getProcessor().toString())) {
            Register tReg = program.getRegister("T");
            long offset = functionAddr.getOffset();
            if (tReg != null && (offset & 1L) == 1L) {
                RegisterValue thumbMode = new RegisterValue(tReg, BigInteger.ONE);
                try {
                    program.getProgramContext().setRegisterValue(functionAddr, functionAddr, thumbMode);
                }
                catch (ContextChangeException e) {
                    throw new AssertException((Throwable)e);
                }
            }
        } else if ("MIPS".equals(processor)) {
            Register isaModeReg = program.getRegister("ISA_MODE");
            long offset = functionAddr.getOffset();
            if (isaModeReg != null && (offset & 1L) == 1L) {
                RegisterValue thumbMode = new RegisterValue(isaModeReg, BigInteger.ONE);
                try {
                    program.getProgramContext().setRegisterValue(functionAddr, functionAddr, thumbMode);
                }
                catch (ContextChangeException e) {
                    throw new AssertException((Throwable)e);
                }
            }
        }
        functionAddr = ProcessorEmulatorTestAdapter.alignAddress(functionAddr, program.getLanguage().getInstructionAlignment());
        disassembleStarts.add(functionAddr);
    }

    private void createSymbol(Address functionAddr, String functionName, Program program) {
        SymbolTable symbolTable = program.getSymbolTable();
        try {
            symbolTable.createLabel(functionAddr, functionName, SourceType.ANALYSIS);
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
    }

    protected Class<? extends Loader> getLoaderClass() {
        return null;
    }

    private List<PCodeTestFile> findBinaryTestFiles(File testResourceDir) {
        ArrayList<PCodeTestFile> testFiles = new ArrayList<PCodeTestFile>();
        ArrayList<String> list = new ArrayList<String>();
        String escapedProcessorDesignator = this.processorDesignator.replace("+", "\\+");
        Pattern pattern = Pattern.compile(escapedProcessorDesignator + PCODE_TEST_FILE_BASE_REGEX, 2);
        File[] listFiles = testResourceDir.listFiles();
        if (listFiles == null) {
            return testFiles;
        }
        for (File f : testResourceDir.listFiles()) {
            String name = f.getName();
            Matcher matcher = pattern.matcher(name);
            if (!matcher.matches()) continue;
            if (f.isDirectory()) {
                this.getFiles(f, list, name + "/");
                continue;
            }
            list.add(name);
        }
        Collections.sort(list);
        for (int i = 0; i < list.size(); ++i) {
            String relativePath = (String)list.get(i);
            testFiles.add(new PCodeTestFile(new File(testResourceDir, relativePath), relativePath));
        }
        return testFiles;
    }

    private void getFiles(File dir, List<String> list, String pathPrefix) {
        for (File f : dir.listFiles()) {
            if (!f.isFile() || f.getName().startsWith(".")) continue;
            list.add(pathPrefix + f.getName());
        }
    }

    private Program getGzfProgram(String gzfProgName) throws IOException {
        return this.getGzfProgram(this.resourcesTestDataDir, gzfProgName);
    }

    private Program getGzfProgram(File dir, String gzfProgName) throws IOException {
        if (!gzfProgName.endsWith(GZF_FILE_EXT)) {
            throw new IllegalArgumentException();
        }
        String progName = gzfProgName.substring(0, gzfProgName.length() - GZF_FILE_EXT.length());
        try {
            ProgramDB program = this.env.getProgram(progName);
            if (program != null) {
                Msg.info(ProcessorEmulatorTestAdapter.class, (Object)("Loaded program from TestEnv cache: " + progName));
                program.addConsumer((Object)this);
                this.env.release((Program)program);
                return program;
            }
            if (dir != null) {
                Msg.info(ProcessorEmulatorTestAdapter.class, (Object)("Import program: " + gzfProgName));
                program = (ProgramDB)this.env.getGhidraProject().importProgram(new File(dir, gzfProgName));
                program.addConsumer((Object)this);
                this.env.getGhidraProject().close((Program)program);
                this.env.saveToCache(progName, program, true, TaskMonitor.DUMMY);
                return program;
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        throw new FileNotFoundException("Program file not found: " + gzfProgName);
    }

    public boolean failOnDisassemblyErrors() {
        return true;
    }

    public boolean failOnRelocationErrors() {
        return false;
    }

    private void checkForProgramIssues(Program program, String resourceFilePath, PCodeTestControlBlock testControlBlock, PCodeTestResults testResults) {
        BookmarkManager bookmarkManager = program.getBookmarkManager();
        Iterator iter = bookmarkManager.getBookmarksIterator("Error");
        boolean hasDisassemblyErrors = false;
        boolean hasRelocationErrors = false;
        while (iter.hasNext()) {
            Bookmark bookmark = (Bookmark)iter.next();
            if ("Bad Instruction".equals(bookmark.getCategory())) {
                hasDisassemblyErrors = true;
            }
            if (!"Relocation".equals(bookmark.getCategory())) continue;
            hasRelocationErrors = true;
        }
        if (hasDisassemblyErrors) {
            boolean fail = this.failOnDisassemblyErrors();
            this.log(null, (fail ? "ERROR" : "WARNING") + ": Program contains one or more Bad Instruction Error bookmarks - " + resourceFilePath);
            if (fail) {
                testResults.summaryHasDisassemblyErrors = true;
            }
        }
        if (hasRelocationErrors) {
            boolean fail = this.failOnRelocationErrors();
            this.log(null, (fail ? "ERROR" : "WARNING") + ": Program contains one or more Relocation Error bookmarks - " + resourceFilePath);
            if (fail) {
                testResults.summaryHasRelocationErrors = true;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void ingestTestBinaries() throws Exception {
        Program program;
        Object fileReferencePath;
        if (!resourcesCacheDir.exists() && !FileUtilities.mkdirs((File)resourcesCacheDir)) {
            throw new IOException("Failed to create GZF cache: " + resourcesCacheDir);
        }
        this.testControlBlocks = new ArrayList<PCodeTestControlBlock>();
        List<PCodeTestFile> testFiles = null;
        Msg.info((Object)this, (Object)("Locating " + this.processorDesignator + " P-Code test binaries in: " + this.resourcesTestDataDir));
        testFiles = this.findBinaryTestFiles(this.resourcesTestDataDir);
        if (testFiles.size() == 0) {
            throw new AssertException("No test binaries found");
        }
        Msg.info((Object)this, (Object)("Processing " + testFiles.size() + " P-Code test binaries"));
        int txId = -1;
        HashSet<String> duplicateTests = new HashSet<String>();
        HashMap<String, PCodeTestGroup> map = new HashMap<String, PCodeTestGroup>();
        Iterator<PCodeTestFile> iterator = testFiles.iterator();
        while (true) {
            block33: {
                boolean analyze;
                File absoluteGzfFilePath;
                boolean usingCachedGZF;
                PCodeTestFile testFile;
                block31: {
                    block32: {
                        if (!iterator.hasNext()) {
                            this.sortTestControlBlocks();
                            this.log(null, this.buildTestFileDigest(duplicateTests));
                            if (duplicateTests.isEmpty()) return;
                            this.log(null, "ERROR! One or more test groups have been duplicated");
                            throw new RuntimeException(this.processorDesignator + " Test files contain duplicate test groups");
                        }
                        testFile = iterator.next();
                        fileReferencePath = testFile.fileReferencePath;
                        program = null;
                        usingCachedGZF = false;
                        absoluteGzfFilePath = null;
                        analyze = false;
                        if (((String)fileReferencePath).endsWith(GZF_FILE_EXT)) {
                            absoluteGzfFilePath = new File(outputDir, (String)fileReferencePath);
                            program = this.getGzfProgram(this.resourcesTestDataDir, (String)fileReferencePath);
                            break block31;
                        }
                        if (testFile.fileReferencePath.endsWith(BINARY_FILE_EXT)) {
                            absoluteGzfFilePath = new File(resourcesCacheDir, (String)fileReferencePath + GZF_FILE_EXT);
                            String gzfCachePath = "cache/" + (String)fileReferencePath + GZF_FILE_EXT;
                            if (absoluteGzfFilePath.exists()) {
                                program = this.getGzfProgram(outputDir, gzfCachePath);
                                if (program != null && !MD5Utilities.getMD5Hash((File)testFile.file).equals(program.getExecutableMD5())) {
                                    this.env.release(program);
                                    program = null;
                                }
                                if (program == null) {
                                    absoluteGzfFilePath.delete();
                                    this.env.removeFromProgramCache(gzfCachePath);
                                } else {
                                    usingCachedGZF = true;
                                }
                            }
                            if (program == null) {
                                this.log(null, "Importing and Analyzing " + testFile.file);
                                this.log(null, "Using language/compiler spec: " + this.language.getLanguageID() + " / " + this.compilerSpec.getCompilerSpecID());
                                Class<? extends Loader> loaderClass = this.getLoaderClass();
                                program = loaderClass != null ? this.env.getGhidraProject().importProgram(testFile.file, loaderClass) : this.env.getGhidraProject().importProgram(testFile.file, this.language, this.compilerSpec);
                                program.addConsumer((Object)this);
                                this.env.getGhidraProject().close(program);
                                analyze = true;
                            }
                            fileReferencePath = gzfCachePath;
                            break block31;
                        }
                        Msg.warn((Object)this, (Object)("Ignoring P-Code test file - unsupported file extension: " + (String)fileReferencePath));
                        if (program == null) continue;
                        if (txId == -1) break block32;
                        program.endTransaction(txId, false);
                    }
                    this.env.release(program);
                    continue;
                }
                if (program == null) {
                    throw new IOException("Failed to open program: " + (String)fileReferencePath);
                }
                txId = program.startTransaction("Analyze");
                if (!program.getLanguageID().equals((Object)this.language.getLanguageID()) || !program.getCompilerSpec().getCompilerSpecID().equals((Object)this.compilerSpec.getCompilerSpecID())) {
                    String string;
                    if (usingCachedGZF) {
                        string = "Cached ";
                        throw new IOException(string + "Program has incorrect language/compiler spec (" + program.getLanguageID() + "/" + program.getCompilerSpec().getCompilerSpecID() + "): " + absoluteGzfFilePath);
                    }
                    string = "";
                    throw new IOException(string + "Program has incorrect language/compiler spec (" + program.getLanguageID() + "/" + program.getCompilerSpec().getCompilerSpecID() + "): " + absoluteGzfFilePath);
                }
                if (analyze) {
                    this.cleanupResidualSegmentData(program);
                    this.log(null, "Post-Import processing of " + (String)fileReferencePath);
                    this.postImport(program);
                }
                PCodeTestControlBlock testControlBlock = PCodeTestControlBlock.getMainControlBlock(program, testFile, this.getRestrictedSearchSet(program), (String)fileReferencePath, this.testInfoStruct, this.groupInfoStruct, analyze, this.logData.testResults);
                for (PCodeTestGroup testGroup : testControlBlock.getTestGroups()) {
                    if (map.containsKey(testGroup.testGroupName)) {
                        duplicateTests.add(testGroup.testGroupName);
                        continue;
                    }
                    map.put(testGroup.testGroupName, testGroup);
                }
                this.testControlBlocks.add(testControlBlock);
                if (analyze) {
                    this.log(null, "Analyzing " + (String)fileReferencePath);
                    this.preAnalyze(program);
                    this.analyze(program, testControlBlock);
                    this.postAnalyze(program);
                    program.endTransaction(txId, true);
                    txId = -1;
                    Msg.info(ProcessorEmulatorTestAdapter.class, (Object)("Storing analyzed program in persistent cache: " + absoluteGzfFilePath));
                    FileUtilities.mkdirs((File)absoluteGzfFilePath.getParentFile());
                    this.env.getGhidraProject().saveAsPackedFile(program, absoluteGzfFilePath, true);
                    if (!absoluteGzfFilePath.exists()) {
                        throw new IOException("Failed to cache gzf file: " + absoluteGzfFilePath);
                    }
                    this.env.saveToCache((String)fileReferencePath, (ProgramDB)program, true, TaskMonitor.DUMMY);
                }
                this.checkForProgramIssues(program, (String)fileReferencePath, testControlBlock, this.logData.testResults);
                if (program == null) continue;
                if (txId == -1) break block33;
                program.endTransaction(txId, false);
            }
            this.env.release(program);
        }
        catch (PCodeTestAbstractControlBlock.InvalidControlBlockException e) {
            try {
                throw new RuntimeException("Test control block error (TestInfo structure): " + (String)fileReferencePath, e);
                catch (LanguageNotFoundException e2) {
                    throw new RuntimeException("Unexpected Error", e2);
                }
                catch (CancelledException e3) {
                    throw new RuntimeException("Unexpected Error", e3);
                }
                catch (DuplicateNameException e4) {
                    throw new RuntimeException("Test file naming conflict: " + (String)fileReferencePath, e4);
                }
                catch (InvalidNameException e5) {
                    throw new RuntimeException("Unsupported test filename: " + (String)fileReferencePath, e5);
                }
                catch (VersionException e6) {
                    throw new RuntimeException("Unsupported Ghidra database version: " + (String)fileReferencePath, e6);
                }
                catch (IOException e7) {
                    throw new RuntimeException("IO Error during P-Code test processing: " + (String)fileReferencePath, e7);
                }
            }
            catch (Throwable throwable) {
                if (program == null) throw throwable;
                if (txId != -1) {
                    program.endTransaction(txId, false);
                }
                this.env.release(program);
                throw throwable;
            }
        }
    }

    private void cleanupResidualSegmentData(Program program) throws LockException {
        MemoryBlock[] blocks;
        Memory memory = program.getMemory();
        for (MemoryBlock block : blocks = memory.getBlocks()) {
            if (!block.getName().startsWith("segment_")) continue;
            this.log(null, "WARNING! Removing residual segment block to avoid possible duplication: " + block);
            memory.removeBlock(block, TaskMonitor.DUMMY);
        }
    }

    private void sortTestControlBlocks() {
        Collections.sort(this.testControlBlocks, (o1, o2) -> {
            String cf1 = o1.testFile.fileReferencePath;
            String cf2 = o2.testFile.fileReferencePath;
            return cf1.compareTo(cf2);
        });
    }

    public Symbol getUniqueGlobalSymbol(Program program, String name) {
        return SymbolUtilities.getLabelOrFunctionSymbol((Program)program, (String)name, err -> Msg.error((Object)this, (Object)err));
    }

    private String buildTestFileDigest(HashSet<String> duplicateTests) {
        StringBuilder testFileDigest = new StringBuilder();
        Object title = "*** " + this.getClass().getSimpleName() + " P-Code Test Suite (" + this.processorDesignator + ") ";
        title = StringUtilities.pad((String)title, (char)'*', (int)-80);
        testFileDigest.append((String)title);
        testFileDigest.append("\n");
        for (PCodeTestControlBlock controlBlock : this.testControlBlocks) {
            testFileDigest.append("* ");
            testFileDigest.append(controlBlock.testFile.fileReferencePath);
            testFileDigest.append(" (TestInfo @ ");
            testFileDigest.append(controlBlock.getInfoStructureAddress().toString(true));
            testFileDigest.append(")\n");
            int paddedLen = 0;
            for (PCodeTestGroup testGroup : controlBlock.getTestGroups()) {
                int len = testGroup.testGroupName.length() + testGroup.functionEntryPtr.toString(true).length() + 3;
                if (len <= paddedLen) continue;
                paddedLen = len;
            }
            for (PCodeTestGroup testGroup : controlBlock.getTestGroups()) {
                testFileDigest.append("*   - ");
                Object nameAndAddr = testGroup.testGroupName + " @ " + testGroup.functionEntryPtr.toString(true);
                nameAndAddr = StringUtilities.pad((String)nameAndAddr, (char)' ', (int)(-paddedLen));
                testFileDigest.append((String)nameAndAddr);
                testFileDigest.append(" (GroupInfo @ ");
                testFileDigest.append(testGroup.controlBlock.getInfoStructureAddress().toString(true));
                testFileDigest.append(")");
                if (duplicateTests.contains(testGroup.testGroupName)) {
                    testFileDigest.append(" *DUPLICATE*");
                }
                testFileDigest.append("\n");
            }
        }
        testFileDigest.append(StringUtilities.pad((String)"", (char)'*', (int)80));
        return testFileDigest.toString();
    }

    static long alignAddressOffset(long offset, int alignment) {
        return offset / (long)alignment * (long)alignment;
    }

    static Address alignAddress(Address addr, int alignment) {
        long alignedOffset;
        Address alignedAddr = addr;
        long offset = addr.getOffset();
        if (offset != (alignedOffset = ProcessorEmulatorTestAdapter.alignAddressOffset(offset, alignment))) {
            alignedAddr = addr.getNewAddress(alignedOffset);
        }
        return alignedAddr;
    }

    public final void test_asm() {
    }

    public final void test_BIOPS_DOUBLE() {
    }

    public final void test_BIOPS_FLOAT() {
    }

    public final void test_BIOPS_LONGLONG() {
    }

    public final void test_BIOPS() {
    }

    public final void test_BIOPS2() {
    }

    public final void test_BIOPS4() {
    }

    public final void test_BitManipulation() {
    }

    public final void test_DecisionMaking() {
    }

    public final void test_GlobalVariables() {
    }

    public final void test_IterativeProcessingDoWhile() {
    }

    public final void test_IterativeProcessingFor() {
    }

    public final void test_IterativeProcessingWhile() {
    }

    public final void test_misc() {
    }

    public final void test_ParameterPassing1() {
    }

    public final void test_ParameterPassing2() {
    }

    public final void test_ParameterPassing3() {
    }

    public final void test_PointerManipulation() {
    }

    public final void test_StructUnionManipulation() {
    }

    static {
        traceDisabled = false;
        if (System.getProperty(EMULATOR_TRACE_DISABLE_PROPERTY) != null) {
            traceDisabled = Boolean.getBoolean(EMULATOR_TRACE_DISABLE_PROPERTY);
        }
        File testDir = new File(TestProgramManager.getDbTestDir(), "PCodeTest");
        TestProgramManager.setDbTestDir(testDir);
        ProcessorEmulatorTestAdapter.cleanupTempData();
        initialized = false;
        testControlBlocksMap = new HashMap<String, List<PCodeTestControlBlock>>();
        deleteResultFilesOnStartup = false;
        testFailureMap = new HashMap();
    }

    private static class MyTestFailure
    extends TestSuite {
        private Throwable failure;

        MyTestFailure(Class<?> emulatorTestClass, Throwable failure) {
            this.failure = failure;
            this.addTest(TestSuite.createTest(emulatorTestClass, (String)ProcessorEmulatorTestAdapter.FAILURE_RESULT_NAME));
        }

        void throwFailure() throws Exception {
            if (this.failure instanceof Error) {
                throw (Error)this.failure;
            }
            if (this.failure instanceof Exception) {
                throw (Exception)this.failure;
            }
            AssertionFailedError error = new AssertionFailedError("Severe Failure");
            error.initCause(this.failure);
        }
    }

    private static class EmulationTestSuite
    extends TestSuite {
        private EmulationTestSuite() {
        }

        public void run(TestResult result) {
            super.run(result);
            resultsWriter.run();
        }
    }

    private static class LogData {
        File traceFile;
        PrintWriter traceLog;
        PCodeTestResults testResults;
        private TreeSet<String> unimplementedSet = new TreeSet();

        private LogData() {
        }
    }

    private static class FloatFormatter
    extends DumpFormatter {
        private final FloatFormat ff;
        private final int maxWidth;

        FloatFormatter(int elementSize, boolean bigEndian) {
            super(elementSize, bigEndian);
            this.ff = FloatFormatFactory.getFloatFormat((int)elementSize);
            this.maxWidth = this.ff.round(this.ff.maxValue).negate().toString().length();
        }

        @Override
        int getMaxWidth() {
            return this.maxWidth;
        }

        @Override
        String getString(byte[] bytes, int index) {
            BigInteger encoding = this.bigEndian ? BigEndianDataConverter.INSTANCE.getBigInteger(bytes, index, this.elementSize, false) : LittleEndianDataConverter.INSTANCE.getBigInteger(bytes, index, this.elementSize, false);
            BigDecimal val = this.ff.round(this.ff.getHostFloat(encoding));
            return val.toString();
        }
    }

    private static class DecimalFormatter
    extends DumpFormatter {
        DecimalFormatter(int elementSize, boolean bigEndian) {
            super(elementSize, bigEndian);
        }

        @Override
        int getMaxWidth() {
            byte[] sampleBytes = new byte[this.elementSize];
            sampleBytes[0] = -128;
            BigInteger sample = new BigInteger(-1, sampleBytes);
            return sample.toString().length();
        }

        @Override
        String getString(byte[] bytes, int index) {
            BigInteger val = this.bigEndian ? BigEndianDataConverter.INSTANCE.getBigInteger(bytes, index, this.elementSize, true) : LittleEndianDataConverter.INSTANCE.getBigInteger(bytes, index, this.elementSize, true);
            return val.toString();
        }
    }

    private static class HexFormatter
    extends DumpFormatter {
        HexFormatter(int elementSize, boolean bigEndian) {
            super(elementSize, bigEndian);
        }

        @Override
        int getMaxWidth() {
            return 2 * this.elementSize;
        }

        @Override
        String getString(byte[] bytes, int index) {
            BigInteger val = this.bigEndian ? BigEndianDataConverter.INSTANCE.getBigInteger(bytes, index, this.elementSize, false) : LittleEndianDataConverter.INSTANCE.getBigInteger(bytes, index, this.elementSize, false);
            String valStr = val.toString(16);
            return StringUtilities.pad((String)valStr, (char)'0', (int)(2 * this.elementSize));
        }
    }

    private static abstract class DumpFormatter {
        final int elementSize;
        final boolean bigEndian;

        DumpFormatter(int elementSize, boolean bigEndian) {
            this.elementSize = elementSize;
            this.bigEndian = bigEndian;
        }

        abstract int getMaxWidth();

        abstract String getString(byte[] var1, int var2);
    }
}

