/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugins.importer.batch;

import docking.widgets.table.AbstractSortedTableModel;
import ghidra.plugins.importer.batch.BatchGroup;
import ghidra.plugins.importer.batch.BatchGroupLoadSpec;
import ghidra.plugins.importer.batch.BatchInfo;
import ghidra.util.Msg;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

class BatchImportTableModel
extends AbstractSortedTableModel<BatchGroup> {
    private BatchInfo batchInfo;
    private List<BatchGroup> list;

    public BatchImportTableModel(BatchInfo ibi) {
        this.batchInfo = ibi;
        this.list = this.batchInfo.getGroups();
    }

    public String getName() {
        return "Batch Import";
    }

    public void refreshData() {
        this.list = this.batchInfo.getGroups();
        this.fireTableDataChanged();
    }

    protected Comparator<BatchGroup> createSortComparator(int columnIndex) {
        Comparator comp = super.createSortComparator(columnIndex);
        if (COLS.getCol(columnIndex) == COLS.SELECTED) {
            return comp.reversed().thenComparing((bg1, bg2) -> bg2.size() - bg1.size());
        }
        return comp;
    }

    public int getColumnCount() {
        return COLS.count;
    }

    public String getColumnName(int column) {
        return COLS.getColumnLabel(column);
    }

    public Class<?> getColumnClass(int columnIndex) {
        switch (COLS.getCol(columnIndex)) {
            case SELECTED: {
                return Boolean.class;
            }
            case FILETYPE: {
                return String.class;
            }
            case LOADER: {
                return String.class;
            }
            case LANG: {
                return BatchGroupLoadSpec.class;
            }
            case FILES: {
                return BatchGroup.class;
            }
        }
        return Object.class;
    }

    public boolean isSortable(int columnIndex) {
        return true;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return COLS.getCol((int)columnIndex).editable;
    }

    public List<BatchGroup> getModelData() {
        return this.list;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (rowIndex >= this.list.size()) {
            return;
        }
        BatchGroup row = this.list.get(rowIndex);
        switch (COLS.getCol(columnIndex)) {
            case SELECTED: {
                boolean newValue = (Boolean)aValue;
                if (newValue && row.getSelectedBatchGroupLoadSpec() == null) {
                    Msg.showWarn((Object)((Object)this), null, (String)"Missing language", (Object)"Select a language for this group before enabling");
                    return;
                }
                row.setEnabled(newValue);
                break;
            }
            case LANG: {
                row.setSelectedBatchGroupLoadSpec((BatchGroupLoadSpec)aValue);
                break;
            }
            case FILES: {
                break;
            }
            default: {
                throw new RuntimeException("bad column");
            }
        }
    }

    public Object getColumnValueForRow(BatchGroup row, int column) {
        switch (COLS.getCol(column)) {
            case SELECTED: {
                return row.isEnabled();
            }
            case FILETYPE: {
                return StringUtils.defaultString((String)row.getCriteria().getFileExt(), (String)"<no ext>");
            }
            case LOADER: {
                return row.getCriteria().getLoader();
            }
            case LANG: {
                return row.getSelectedBatchGroupLoadSpec();
            }
            case FILES: {
                return row;
            }
        }
        return "unknown col";
    }

    public static enum COLS {
        SELECTED("Selected", true),
        FILETYPE("File Type", false),
        LOADER("Loader", false),
        LANG("Language", true),
        FILES("Files", false);

        public final String columnLabel;
        public final boolean editable;
        private static final COLS[] staticvalues;
        public static final int count;
        public static final String UNKNOWN_COLUMN_LABEL = "<unknown>";

        public static String getColumnLabel(int i) {
            return i >= 0 && i < count ? COLS.staticvalues[i].columnLabel : UNKNOWN_COLUMN_LABEL;
        }

        public static COLS getCol(int i) {
            return i >= 0 && i < count ? staticvalues[i] : null;
        }

        private COLS(String colLabel, boolean editable) {
            this.columnLabel = colLabel;
            this.editable = editable;
        }

        static {
            staticvalues = COLS.values();
            count = staticvalues.length;
        }
    }
}

