/*
 * Decompiled with CFR 0.152.
 */
package ghidra.base.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import ghidra.util.HTMLUtilities;

public class HorizontalRuleAction
extends DockingAction {
    private static int idCount = 0;

    public HorizontalRuleAction(String owner, String topName, String bottomName) {
        super("HorizontalRuleAction: " + ++idCount, owner, false);
        this.setEnabled(false);
        this.markHelpUnnecessary();
        this.setMenuBarData(new MenuData(new String[]{"<HTML><CENTER><FONT SIZE=2 COLOR=SILVER>" + this.fixupFirstAmp(HTMLUtilities.escapeHTML((String)topName) + "<BR>" + HTMLUtilities.escapeHTML((String)bottomName)) + "</FONT></CENTER>"}));
        String padding = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
        this.setDescription("<HTML><CENTER><B>" + padding + HTMLUtilities.escapeHTML((String)topName) + padding + "<B><HR><B>" + padding + HTMLUtilities.escapeHTML((String)bottomName) + padding + "</B></CENTER>");
    }

    private String fixupFirstAmp(String text) {
        int index = text.indexOf(38);
        return index < 0 ? text : text.substring(0, index) + "&" + text.substring(index);
    }

    public void actionPerformed(ActionContext context) {
    }
}

