/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.html;

import ghidra.app.util.html.CompletelyDifferentHTMLDataTypeRepresentationWrapper;
import ghidra.app.util.html.EmptyVariableTextLine;
import ghidra.app.util.html.HTMLDataTypeRepresentation;
import ghidra.app.util.html.HTMLDataTypeRepresentationDiffInput;
import ghidra.app.util.html.PlaceHolderLine;
import ghidra.app.util.html.TextLine;
import ghidra.app.util.html.ValidatableLine;
import ghidra.app.util.html.VariableTextLine;
import ghidra.app.util.html.diff.DataTypeDiff;
import ghidra.app.util.html.diff.DataTypeDiffBuilder;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.GenericCallingConvention;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.util.HTMLUtilities;
import ghidra.util.StringUtilities;
import ghidra.util.exception.AssertException;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public class FunctionDataTypeHTMLRepresentation
extends HTMLDataTypeRepresentation {
    private static final int MAX_LINE_COUNT = 10;
    protected TextLine returnType;
    protected TextLine functionName;
    protected List<ValidatableLine> arguments;
    protected TextLine varArgs;
    protected TextLine voidArgs;
    private static String truncatedHtmlData;

    private FunctionDataTypeHTMLRepresentation(TextLine returnType, TextLine functionName, List<ValidatableLine> arguments, TextLine varArgs, TextLine voidArgs) {
        this.returnType = returnType;
        this.functionName = functionName;
        this.arguments = arguments;
        this.varArgs = varArgs;
        this.voidArgs = voidArgs;
        this.originalHTMLData = FunctionDataTypeHTMLRepresentation.buildHTMLText(returnType, functionName, arguments, varArgs, voidArgs, false);
        truncatedHtmlData = FunctionDataTypeHTMLRepresentation.buildHTMLText(returnType, functionName, arguments, varArgs, voidArgs, true);
    }

    public FunctionDataTypeHTMLRepresentation(FunctionDefinition functionDefinition) {
        this.returnType = this.buildReturnType(functionDefinition);
        this.functionName = this.buildName(functionDefinition);
        this.arguments = this.buildArguments(functionDefinition);
        this.varArgs = this.buildVarArgs(functionDefinition);
        this.voidArgs = this.buildVoidArgs(functionDefinition);
        this.originalHTMLData = FunctionDataTypeHTMLRepresentation.buildHTMLText(this.returnType, this.functionName, this.arguments, this.varArgs, this.voidArgs, false);
        truncatedHtmlData = FunctionDataTypeHTMLRepresentation.buildHTMLText(this.returnType, this.functionName, this.arguments, this.varArgs, this.voidArgs, true);
    }

    @Override
    public String getHTMLString() {
        return "<HTML>" + truncatedHtmlData + "</HTML>";
    }

    @Override
    public String getHTMLContentString() {
        return truncatedHtmlData;
    }

    @Override
    protected PlaceHolderLine createPlaceHolderLine(ValidatableLine oppositeLine) {
        if (!(oppositeLine instanceof VariableTextLine)) {
            throw new AssertException("I didn't know you could pass me other types of lines?!");
        }
        VariableTextLine variableTextLine = (VariableTextLine)oppositeLine;
        int stringLength = variableTextLine.getVariableType().length() + variableTextLine.getVariableName().length();
        return new EmptyVariableTextLine(stringLength);
    }

    private TextLine buildVarArgs(FunctionDefinition functionDefinition) {
        if (functionDefinition.hasVarArgs()) {
            return new TextLine("...");
        }
        return new TextLine("");
    }

    private TextLine buildVoidArgs(FunctionDefinition functionDefinition) {
        if (functionDefinition.getArguments().length == 0 && !functionDefinition.hasVarArgs()) {
            return new TextLine("void");
        }
        return new TextLine("");
    }

    private TextLine buildName(FunctionDefinition functionDefinition) {
        return new TextLine(HTMLUtilities.friendlyEncodeHTML((String)functionDefinition.getDisplayName()));
    }

    private TextLine buildReturnType(FunctionDefinition functionDefinition) {
        DataType returnDataType = functionDefinition.getReturnType();
        GenericCallingConvention genericCallingConvention = functionDefinition.getGenericCallingConvention();
        String modifier = genericCallingConvention != GenericCallingConvention.unknown ? " " + genericCallingConvention.getDeclarationName() : "";
        return new TextLine(HTMLUtilities.friendlyEncodeHTML((String)returnDataType.getDisplayName()) + modifier);
    }

    private List<ValidatableLine> buildArguments(FunctionDefinition functionDefinition) {
        ParameterDefinition[] vars = functionDefinition.getArguments();
        ArrayList<ValidatableLine> lines = new ArrayList<ValidatableLine>(vars.length);
        for (ParameterDefinition var : vars) {
            DataType dataType = var.getDataType();
            String displayName = dataType.getDisplayName();
            String name = var.getName();
            lines.add(new VariableTextLine(HTMLUtilities.friendlyEncodeHTML((String)displayName), HTMLUtilities.friendlyEncodeHTML((String)name), dataType));
        }
        return lines;
    }

    private static String buildHTMLText(TextLine returnType, TextLine functionName, List<ValidatableLine> arguments, TextLine varArgs, TextLine voidArgs, boolean trim) {
        StringBuilder fullHtml = new StringBuilder();
        StringBuilder truncatedHtml = new StringBuilder();
        int lineCount = 0;
        String returnTypeText = returnType.getText();
        if (trim) {
            returnTypeText = StringUtilities.trimMiddle((String)returnTypeText, (int)80);
        }
        returnTypeText = FunctionDataTypeHTMLRepresentation.wrapStringInColor(returnTypeText, returnType.getTextColor());
        String functionNameText = functionName.getText();
        if (trim) {
            functionNameText = StringUtilities.trimMiddle((String)functionNameText, (int)80);
        }
        functionNameText = FunctionDataTypeHTMLRepresentation.wrapStringInColor(functionNameText, functionName.getTextColor());
        FunctionDataTypeHTMLRepresentation.append(fullHtml, truncatedHtml, lineCount, returnTypeText, "&nbsp;", functionNameText, "(");
        String varArgsText = varArgs.getText();
        varArgsText = FunctionDataTypeHTMLRepresentation.wrapStringInColor(varArgsText, varArgs.getTextColor());
        boolean hasVarArgs = varArgsText.length() != 0;
        int size = arguments.size();
        int i = 0;
        while (i < size) {
            FunctionDataTypeHTMLRepresentation.append(fullHtml, truncatedHtml, lineCount, "<BR>");
            VariableTextLine variableLine = (VariableTextLine)arguments.get(i);
            String typeText = FunctionDataTypeHTMLRepresentation.generateTypeText(variableLine, trim);
            String variableNameText = variableLine.getVariableName();
            if (trim) {
                variableNameText = StringUtilities.trimMiddle((String)variableNameText, (int)80);
            }
            variableNameText = FunctionDataTypeHTMLRepresentation.wrapStringInColor(variableNameText, variableLine.getVariableNameColor());
            String separator = "";
            if (i < size - 1 || size > 0 && hasVarArgs) {
                separator = ",";
            }
            FunctionDataTypeHTMLRepresentation.append(fullHtml, truncatedHtml, lineCount, TAB, typeText, "&nbsp;", variableNameText, separator);
            ++i;
            ++lineCount;
        }
        if (hasVarArgs) {
            if (size > 0) {
                FunctionDataTypeHTMLRepresentation.append(fullHtml, truncatedHtml, lineCount, "<BR>", TAB);
                ++lineCount;
            }
            FunctionDataTypeHTMLRepresentation.append(fullHtml, truncatedHtml, lineCount, varArgsText);
        } else if (size == 0) {
            String voidArgsText = voidArgs.getText();
            if ((voidArgsText = FunctionDataTypeHTMLRepresentation.wrapStringInColor(voidArgsText, voidArgs.getTextColor())).length() != 0) {
                FunctionDataTypeHTMLRepresentation.append(fullHtml, truncatedHtml, lineCount, varArgsText);
            }
        }
        if (lineCount >= 10) {
            truncatedHtml.append("...");
        }
        fullHtml.append(")").append("<BR>");
        truncatedHtml.append(")").append("<BR>");
        if (trim) {
            return truncatedHtml.toString();
        }
        return fullHtml.toString();
    }

    private static void append(StringBuilder fullHtml, StringBuilder truncatedHtml, int lineCount, String ... content) {
        for (String string : content) {
            fullHtml.append(string);
            truncatedHtml.append(string);
        }
    }

    private static String generateTypeText(VariableTextLine line, boolean trim) {
        Color color = line.getVariableTypeColor();
        DataType dt = line.getDataType();
        if (dt != null) {
            return FunctionDataTypeHTMLRepresentation.generateTypeName(dt, color, trim);
        }
        String type = FunctionDataTypeHTMLRepresentation.truncateAsNecessary(line.getVariableType());
        type = HTMLUtilities.friendlyEncodeHTML((String)type);
        return FunctionDataTypeHTMLRepresentation.wrapStringInColor(type, color);
    }

    @Override
    public HTMLDataTypeRepresentation[] diff(HTMLDataTypeRepresentation otherRepresentation) {
        if (this == otherRepresentation) {
            return new HTMLDataTypeRepresentation[]{this, this};
        }
        if (!(otherRepresentation instanceof FunctionDataTypeHTMLRepresentation)) {
            return new HTMLDataTypeRepresentation[]{new CompletelyDifferentHTMLDataTypeRepresentationWrapper(this), new CompletelyDifferentHTMLDataTypeRepresentationWrapper(otherRepresentation)};
        }
        FunctionDataTypeHTMLRepresentation functionRepresentation = (FunctionDataTypeHTMLRepresentation)otherRepresentation;
        TextLine diffReturnType = new TextLine(this.returnType.getText());
        TextLine diffFunctionName = new TextLine(this.functionName.getText());
        List<ValidatableLine> argumentLines = this.copyLines(this.arguments);
        TextLine diffVarArgs = new TextLine(this.varArgs.getText());
        TextLine diffVoidArgs = new TextLine(this.voidArgs.getText());
        TextLine otherDiffReturnType = new TextLine(functionRepresentation.returnType.getText());
        TextLine otherDiffFunctionName = new TextLine(functionRepresentation.functionName.getText());
        List<ValidatableLine> otherArgumentLines = this.copyLines(functionRepresentation.arguments);
        TextLine otherDiffVarArgs = new TextLine(functionRepresentation.varArgs.getText());
        TextLine otherDiffVoidArgs = new TextLine(functionRepresentation.voidArgs.getText());
        this.diffTextLine(diffReturnType, otherDiffReturnType);
        this.diffTextLine(diffFunctionName, otherDiffFunctionName);
        HTMLDataTypeRepresentationDiffInput diffInput = new HTMLDataTypeRepresentationDiffInput(this, argumentLines);
        HTMLDataTypeRepresentationDiffInput otherDiffInput = new HTMLDataTypeRepresentationDiffInput(otherRepresentation, otherArgumentLines);
        DataTypeDiff argumentsDiff = DataTypeDiffBuilder.diffBody(diffInput, otherDiffInput);
        this.diffTextLine(diffVarArgs, otherDiffVarArgs);
        this.diffTextLine(diffVoidArgs, otherDiffVoidArgs);
        return new HTMLDataTypeRepresentation[]{new FunctionDataTypeHTMLRepresentation(diffReturnType, diffFunctionName, argumentsDiff.getLeftLines(), diffVarArgs, diffVoidArgs), new FunctionDataTypeHTMLRepresentation(otherDiffReturnType, otherDiffFunctionName, argumentsDiff.getRightLines(), otherDiffVarArgs, otherDiffVoidArgs)};
    }
}

