/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.ubi;

import ghidra.app.util.bin.BinaryReader;
import java.io.IOException;

public class FatArch {
    private int cputype;
    private int cpusubtype;
    private int offset;
    private int size;
    private int align;

    public FatArch(BinaryReader reader) throws IOException {
        this.cputype = reader.readNextInt();
        this.cpusubtype = reader.readNextInt();
        this.offset = reader.readNextInt();
        this.size = reader.readNextInt();
        this.align = reader.readNextInt();
    }

    public int getCpuType() {
        return this.cputype;
    }

    public int getCpuSubType() {
        return this.cpusubtype;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getSize() {
        return this.size;
    }

    public int getAlign() {
        return this.align;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("CPU Type: 0x" + Integer.toHexString(this.cputype));
        buffer.append('\n');
        buffer.append("CPU Sub Type: 0x" + Integer.toHexString(this.cpusubtype));
        buffer.append('\n');
        buffer.append("Offset: 0x" + Integer.toHexString(this.offset));
        buffer.append('\n');
        buffer.append("Size: 0x" + Integer.toHexString(this.size));
        buffer.append('\n');
        buffer.append("Align: 0x" + Integer.toHexString(this.align));
        buffer.append('\n');
        return buffer.toString();
    }
}

