/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.format.dwarf4.LEB128;
import ghidra.app.util.bin.format.macho.commands.LinkEditDataCommand;
import ghidra.program.model.address.Address;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class FunctionStartsCommand
extends LinkEditDataCommand {
    FunctionStartsCommand(BinaryReader loadCommandReader, BinaryReader dataReader) throws IOException {
        super(loadCommandReader, dataReader);
    }

    public List<Address> findFunctionStartAddrs(ByteProvider provider, Address textSegmentAddr) throws IOException {
        ArrayList<Address> addrs = new ArrayList<Address>();
        Address current = textSegmentAddr;
        for (long offset : this.findFunctionStartOffsets(provider)) {
            current = current.add(offset);
            addrs.add(current);
        }
        return addrs;
    }

    private List<Long> findFunctionStartOffsets(ByteProvider provider) throws IOException {
        long offset;
        BinaryReader reader = new BinaryReader(provider, true);
        reader.setPointerIndex(this.getDataOffset());
        ArrayList<Long> offsets = new ArrayList<Long>();
        while ((offset = LEB128.readAsLong(reader, false)) != 0L) {
            offsets.add(offset);
        }
        return offsets;
    }
}

