/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class GnuVerdef
implements StructConverter {
    private short vd_version;
    private short vd_flags;
    private short vd_ndx;
    private short vd_cnt;
    private int vd_hash;
    private int vd_aux;
    private int vd_next;

    GnuVerdef(BinaryReader reader) throws IOException {
        this.vd_version = reader.readNextShort();
        this.vd_flags = reader.readNextShort();
        this.vd_ndx = reader.readNextShort();
        this.vd_cnt = reader.readNextShort();
        this.vd_hash = reader.readNextInt();
        this.vd_aux = reader.readNextInt();
        this.vd_next = reader.readNextInt();
    }

    public short getVersion() {
        return this.vd_version;
    }

    public short getFlags() {
        return this.vd_flags;
    }

    public short getNdx() {
        return this.vd_ndx;
    }

    public short getCnt() {
        return this.vd_cnt;
    }

    public int getHash() {
        return this.vd_hash;
    }

    public int getAux() {
        return this.vd_aux;
    }

    public int getNext() {
        return this.vd_next;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("Elf_Verdef", 0);
        struct.add(WORD, "vd_version", "Version revision");
        struct.add(WORD, "vd_flags", "Version information");
        struct.add(WORD, "vd_ndx", "Version Index");
        struct.add(WORD, "vd_cnt", "Number of associated aux entries");
        struct.add(DWORD, "vd_hash", "Version name hash value");
        struct.add(DWORD, "vd_aux", "Offset in bytes to verdaux array");
        struct.add(DWORD, "vd_next", "Offset in bytes to next verdef entry");
        return struct;
    }
}

