/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bean;

import docking.DialogComponentProvider;
import docking.actions.KeyBindingUtils;
import docking.widgets.button.GRadioButton;
import docking.widgets.checkbox.GCheckBox;
import docking.widgets.filter.FilterListener;
import docking.widgets.label.GDLabel;
import docking.widgets.label.GLabel;
import docking.widgets.table.GTableCellRenderingData;
import ghidra.app.context.ListingActionContext;
import ghidra.app.services.DataTypeManagerService;
import ghidra.app.util.bean.SetEquateTableModel;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.database.symbol.EquateManager;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Enum;
import ghidra.program.model.listing.Program;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.Equate;
import ghidra.program.model.symbol.EquateTable;
import ghidra.program.util.ProgramSelection;
import ghidra.util.UniversalID;
import ghidra.util.layout.HorizontalLayout;
import ghidra.util.layout.VerticalLayout;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.GhidraTableCellRenderer;
import ghidra.util.table.GhidraTableFilterPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.apache.commons.lang3.StringUtils;
import utility.function.Callback;

public class SetEquateDialog
extends DialogComponentProvider {
    public static final int CANCELED = 0;
    public static final int OK = 1;
    private GhidraTable suggestedEquatesTable;
    private GhidraTableFilterPanel<EquateRowObject> filterPanel;
    private int result = 0;
    private SetEquateTableModel model;
    private DataTypeManager dataTypeManager;
    private EquateTable equateTable;
    private JLabel titleLabel;
    private JRadioButton applyToCurrent;
    private JRadioButton applyToSelection;
    private JRadioButton applyToAll;
    private JCheckBox overwriteExistingEquates;
    private PluginTool tool;
    private Program program;
    private Scalar scalar;
    private EquateFilterListener filterListener = new EquateFilterListener();
    private EquateEnterListener enterListener = new EquateEnterListener();

    public SetEquateDialog(PluginTool tool, Program program, Scalar value) {
        super("Set Equate", true, true, true, false);
        this.tool = tool;
        this.program = program;
        this.scalar = value;
        this.dataTypeManager = program.getDataTypeManager();
        this.equateTable = program.getEquateTable();
        this.addWorkPanel(this.buildMainPanel());
        this.addOKButton();
        this.addCancelButton();
        this.setRememberSize(false);
    }

    private void updateFilter() {
        this.suggestedEquatesTable.clearSelection();
        boolean isFiltered = this.filterPanel.isFiltered();
        int unfilteredSize = this.filterPanel.getUnfilteredRowCount();
        int filteredSize = this.filterPanel.getRowCount();
        if (isFiltered) {
            this.titleLabel.setText("Possible matches (showing " + filteredSize + " of " + unfilteredSize + ")");
        } else {
            this.titleLabel.setText("Possible matches");
        }
    }

    private GhidraTableCellRenderer getRenderer() {
        GhidraTableCellRenderer renderer = new GhidraTableCellRenderer(){

            public Component getTableCellRendererComponent(GTableCellRenderingData data) {
                Component c = super.getTableCellRendererComponent(data);
                Object rowObject = data.getRowObject();
                boolean isSelected = data.isSelected();
                EquateRowObject eqRowObject = (EquateRowObject)rowObject;
                int refCount = eqRowObject.getRefCount();
                if (refCount > 0) {
                    if (eqRowObject.getEntryName().contains("<BAD EQUATE>")) {
                        c.setForeground(isSelected ? Color.WHITE : Color.RED);
                    } else {
                        Equate e = eqRowObject.getEquate();
                        if (e != null && !e.isEnumBased()) {
                            c.setForeground(isSelected ? Color.WHITE : Color.BLUE.brighter());
                        }
                    }
                } else {
                    c.setForeground(isSelected ? Color.WHITE : Color.GRAY.darker());
                }
                return c;
            }
        };
        return renderer;
    }

    private List<EquateRowObject> getCurrentAndPotentialEquateNames() {
        HashSet<EquateRowObject> entries = new HashSet<EquateRowObject>();
        entries.addAll(this.createEntriesFromEquateTable());
        entries.addAll(this.createEntriesFromDataTypeManager());
        return new ArrayList<EquateRowObject>(entries);
    }

    private Set<EquateRowObject> createEntriesFromEquateTable() {
        List allEquates = this.equateTable.getEquates(this.scalar.getValue());
        return allEquates.stream().filter(equate -> equate.isValidUUID()).map(equate -> new EquateRowObject((Equate)equate)).collect(Collectors.toSet());
    }

    private Set<EquateRowObject> createEntriesFromDataTypeManager() {
        DataTypeManagerService service = (DataTypeManagerService)this.tool.getService(DataTypeManagerService.class);
        if (service == null) {
            return new HashSet<EquateRowObject>();
        }
        HashSet<EquateRowObject> entries = new HashSet<EquateRowObject>();
        service.getSortedDataTypeList().stream().filter(dt -> dt instanceof Enum).map(Enum.class::cast).flatMap(this::enumToRowObjects).forEach(entries::add);
        return entries;
    }

    private Stream<EquateRowObject> enumToRowObjects(Enum enoom) {
        String[] names = enoom.getNames(this.scalar.getValue());
        return Arrays.stream(names).map(name -> new EquateRowObject((String)name, enoom));
    }

    protected JPanel buildMainPanel() {
        this.titleLabel = new GDLabel("Possible Matches");
        this.titleLabel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        this.applyToCurrent = new GRadioButton("Current location", true);
        this.applyToCurrent.setName("applyToCurrent");
        this.applyToCurrent.setToolTipText("Apply to current scalar operand only");
        this.applyToSelection = new GRadioButton("Current selection", false);
        this.applyToSelection.setName("applyToSelection");
        this.applyToSelection.setToolTipText("Apply to all matching, defined scalar code units in current selection.");
        this.applyToAll = new GRadioButton("Entire program", false);
        this.applyToAll.setName("applyToAll");
        this.applyToAll.setToolTipText("Apply to all matching, defined scalar code units in entire program.");
        ButtonGroup group = new ButtonGroup();
        group.add(this.applyToCurrent);
        group.add(this.applyToSelection);
        group.add(this.applyToAll);
        this.overwriteExistingEquates = new GCheckBox("Overwrite existing equates", false);
        this.overwriteExistingEquates.setName("Overwrite");
        this.overwriteExistingEquates.setEnabled(false);
        this.overwriteExistingEquates.setToolTipText("If checked, apply equates to all unmarked scalars and overwrite any existing equates of the same value in the current selection or entire program depending on which option is selected. If not checked, only apply equates to unmarked scalars.");
        this.applyToCurrent.addActionListener(evt -> {
            this.overwriteExistingEquates.setEnabled(!this.applyToCurrent.isSelected());
            if (this.applyToCurrent.isSelected()) {
                this.overwriteExistingEquates.setSelected(false);
            }
        });
        this.applyToSelection.addActionListener(evt -> this.overwriteExistingEquates.setEnabled(this.applyToSelection.isSelected()));
        this.applyToAll.addActionListener(evt -> this.overwriteExistingEquates.setEnabled(this.applyToAll.isSelected()));
        List<EquateRowObject> equateNames = this.getCurrentAndPotentialEquateNames();
        this.model = new SetEquateTableModel((ServiceProvider)this.tool, equateNames, this.program);
        this.suggestedEquatesTable = new GhidraTable((TableModel)((Object)this.model));
        this.suggestedEquatesTable.setSelectionMode(0);
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SetEquateDialog.this.okCallback();
            }
        };
        KeyBindingUtils.registerAction((JComponent)((Object)this.suggestedEquatesTable), (KeyStroke)enter, (Action)action, (int)1);
        this.suggestedEquatesTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                int index = SetEquateDialog.this.suggestedEquatesTable.columnAtPoint(e.getPoint());
                if (index >= 0 && e.getClickCount() == 2) {
                    SetEquateDialog.this.okCallback();
                }
            }
        });
        JPanel tablePanel = new JPanel(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane((Component)((Object)this.suggestedEquatesTable));
        tablePanel.add(scrollPane);
        tablePanel.setBorder(BorderFactory.createEmptyBorder(2, 5, 5, 5));
        this.filterPanel = new GhidraTableFilterPanel((JTable)((Object)this.suggestedEquatesTable), this.model, " Equate String: ");
        this.model.addTableModelListener(evt -> this.updateFilter());
        GhidraTableCellRenderer renderer = this.getRenderer();
        TableColumnModel tcm = this.suggestedEquatesTable.getColumnModel();
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            tcm.getColumn(i).setCellRenderer((TableCellRenderer)((Object)renderer));
        }
        this.filterPanel.addFilterChagnedListener(this.filterListener);
        this.filterPanel.addEnterListener(this.enterListener);
        JPanel northPanel = new JPanel((LayoutManager)new VerticalLayout(2));
        String labelText = "Scalar Value:  " + this.scalar.toString(16, false, true, "0x", "") + " (" + this.scalar.toString(10, false, true, "", "") + ")";
        GLabel label = new GLabel(labelText);
        label.setName("EquateField");
        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        northPanel.add((Component)label);
        northPanel.add(this.titleLabel);
        northPanel.add((Component)((Object)this.filterPanel));
        northPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 0, 5));
        JPanel scopePanel = new JPanel((LayoutManager)new HorizontalLayout(2));
        scopePanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 0, 5));
        scopePanel.add((Component)new GLabel("Apply To: "));
        scopePanel.add(this.applyToCurrent);
        scopePanel.add(this.applyToSelection);
        scopePanel.add(this.applyToAll);
        JPanel optionsPanel = new JPanel((LayoutManager)new HorizontalLayout(2));
        optionsPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        optionsPanel.add((Component)new GLabel("Options: "));
        optionsPanel.add(this.overwriteExistingEquates);
        JPanel southPanel = new JPanel((LayoutManager)new VerticalLayout(0));
        southPanel.add(scopePanel);
        southPanel.add(optionsPanel);
        JPanel mainPanel = new JPanel(){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(700, 400);
            }
        };
        mainPanel.setLayout(new BorderLayout());
        mainPanel.setSize(mainPanel.getPreferredSize());
        mainPanel.add((Component)northPanel, "North");
        mainPanel.add((Component)tablePanel, "Center");
        mainPanel.add((Component)southPanel, "South");
        return mainPanel;
    }

    public int showSetDialog() {
        this.result = 0;
        this.overwriteExistingEquates.setVisible(true);
        this.setTitle("Set Equate");
        this.tool.showDialog((DialogComponentProvider)this);
        return this.result;
    }

    public int showRenameDialog() {
        this.result = 0;
        this.overwriteExistingEquates.setVisible(false);
        this.overwriteExistingEquates.setEnabled(false);
        this.setTitle("Rename Equate");
        this.tool.showDialog((DialogComponentProvider)this);
        return this.result;
    }

    public String getEquateName() {
        EquateRowObject equateEntry = this.getRowObject();
        if (equateEntry != null) {
            return equateEntry.getEntryName();
        }
        String equateFromFilter = this.filterPanel.getFilterText();
        if (StringUtils.isBlank((CharSequence)equateFromFilter)) {
            equateFromFilter = null;
        }
        return equateFromFilter;
    }

    public Enum getEnumDataType() {
        EquateRowObject equateEntry = this.getRowObject();
        return equateEntry != null ? equateEntry.getEnumDataType() : null;
    }

    private EquateRowObject getRowObject() {
        EquateRowObject equateEntry = (EquateRowObject)this.filterPanel.getSelectedItem();
        if (equateEntry != null) {
            return equateEntry;
        }
        String equateFromFilter = this.filterPanel.getFilterText();
        if (StringUtils.isBlank((CharSequence)equateFromFilter)) {
            return null;
        }
        EquateRowObject match = this.getMatchFromTable(equateFromFilter);
        if (match != null) {
            return match;
        }
        return null;
    }

    private EquateRowObject getMatchFromTable(String name) {
        Optional<EquateRowObject> getMatch = this.getCurrentAndPotentialEquateNames().stream().filter(entry -> entry.getEntryName().equals(name)).findFirst();
        if (getMatch.isPresent()) {
            EquateRowObject rowObject = getMatch.get();
            return rowObject;
        }
        return null;
    }

    public SelectionType getSelectionType() {
        if (this.applyToAll.isSelected()) {
            return SelectionType.ENTIRE_PROGRAM;
        }
        if (this.applyToSelection.isSelected()) {
            return SelectionType.SELECTION;
        }
        return SelectionType.CURRENT_ADDRESS;
    }

    public boolean getOverwriteExisting() {
        return this.overwriteExistingEquates.isSelected();
    }

    public void setHasSelection(ListingActionContext context) {
        ProgramSelection selection = context.getSelection();
        boolean hasSelection = selection != null && !selection.isEmpty();
        this.applyToSelection.setEnabled(hasSelection);
        this.applyToSelection.setSelected(hasSelection && selection.contains(context.getAddress()));
        this.overwriteExistingEquates.setEnabled(!this.applyToCurrent.isSelected());
    }

    public void disableHasSelection() {
        this.applyToAll.setEnabled(false);
        this.applyToSelection.setEnabled(false);
        this.applyToSelection.setSelected(false);
        this.overwriteExistingEquates.setEnabled(false);
    }

    void setStatus(String text) {
        this.setStatusText(text);
    }

    protected void okCallback() {
        if (this.isValid(this.getEquateName(), this.scalar)) {
            this.result = 1;
            this.close();
        } else {
            this.filterPanel.requestFocus();
        }
    }

    private boolean isValid(String equateStr, Scalar testScalar) {
        if (StringUtils.isBlank((CharSequence)equateStr)) {
            return true;
        }
        Equate newEquate = this.equateTable.getEquate(equateStr);
        if (newEquate != null && this.getEnumDataType() == null && newEquate.getValue() != testScalar.getValue()) {
            this.setStatus("Equate " + equateStr + " exists with value 0x" + Long.toHexString(newEquate.getValue()) + " (" + newEquate.getValue() + ")");
            return false;
        }
        return true;
    }

    private Enum getEnumWithUUID(UniversalID id) {
        return (Enum)this.dataTypeManager.findDataTypeForID(id);
    }

    protected void cancelCallback() {
        this.close();
    }

    public void dispose() {
        this.suggestedEquatesTable.dispose();
        this.filterPanel.dispose();
    }

    private class EquateFilterListener
    implements FilterListener {
        private EquateFilterListener() {
        }

        public void filterChanged(String text) {
            SetEquateDialog.this.suggestedEquatesTable.getSelectionManager().clearSavedSelection();
        }
    }

    private class EquateEnterListener
    implements Callback {
        private EquateEnterListener() {
        }

        public void call() {
            SetEquateDialog.this.okCallback();
        }
    }

    public class EquateRowObject {
        private String entryName;
        private String path;
        private int refCount;
        private UniversalID dataTypeUUID;
        private Equate equate;
        private Enum enoom;

        EquateRowObject(String name, Enum enoom) {
            long value = SetEquateDialog.this.scalar.getValue();
            if (enoom == null) {
                return;
            }
            this.enoom = enoom;
            this.entryName = name;
            this.dataTypeUUID = enoom.getUniversalID();
            this.path = this.getFullPath(enoom);
            String formattedEquateName = EquateManager.formatNameForEquate((UniversalID)this.dataTypeUUID, (long)value);
            this.equate = SetEquateDialog.this.equateTable.getEquate(formattedEquateName);
            if (this.equate != null) {
                this.refCount = this.equate.getReferenceCount();
            }
        }

        EquateRowObject(Equate equate) {
            UniversalID id = equate.getEnumUUID();
            this.equate = equate;
            this.entryName = equate.getDisplayName();
            this.refCount = equate.getReferenceCount();
            if (id != null && equate.isValidUUID()) {
                this.dataTypeUUID = id;
                this.enoom = SetEquateDialog.this.getEnumWithUUID(id);
                this.path = this.getFullPath(this.enoom);
            }
        }

        public Equate getEquate() {
            return this.equate;
        }

        public String getEntryName() {
            return this.entryName;
        }

        public String getPath() {
            return this.path;
        }

        private String getFullPath(Enum theEnum) {
            if (theEnum == null) {
                return null;
            }
            String rootCategory = theEnum.getDataTypeManager().getRootCategory().getName();
            String fullCategoryPath = rootCategory + theEnum.getCategoryPath().getPath();
            if (!fullCategoryPath.endsWith("defines")) {
                return rootCategory + theEnum.getDataTypePath().getPath();
            }
            return fullCategoryPath;
        }

        public int getRefCount() {
            return this.refCount;
        }

        public Enum getEnumDataType() {
            return this.enoom;
        }

        public String toString() {
            String dtName = this.enoom == null ? "<no data type>" : this.enoom.getName();
            return "{\n\tname: " + this.entryName + ",\n\tdata type: " + dtName + ",\n\trefs: " + this.refCount + "\n}";
        }

        public int hashCode() {
            int prime = 31;
            int hashResult = 1;
            hashResult = 31 * hashResult + ((Object)((Object)this.getOuterType())).hashCode();
            hashResult = 31 * hashResult + (this.entryName == null ? 0 : this.entryName.hashCode());
            return hashResult;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof EquateRowObject)) {
                return false;
            }
            EquateRowObject other = (EquateRowObject)obj;
            if (!((Object)((Object)this.getOuterType())).equals((Object)other.getOuterType())) {
                return false;
            }
            if (this.enoom == null || !this.enoom.isEquivalent((DataType)other.getEnumDataType())) {
                return false;
            }
            return Objects.equals(this.entryName, other.entryName);
        }

        private SetEquateDialog getOuterType() {
            return SetEquateDialog.this;
        }
    }

    public static enum SelectionType {
        CURRENT_ADDRESS,
        SELECTION,
        ENTIRE_PROGRAM;

    }
}

