/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symboltree.actions;

import docking.action.KeyBindingData;
import docking.action.KeyBindingType;
import docking.action.MenuData;
import ghidra.app.actions.AbstractFindReferencesDataTypeAction;
import ghidra.app.nav.Navigatable;
import ghidra.app.plugin.core.navigation.locationreferences.LocationReferencesService;
import ghidra.app.plugin.core.symboltree.SymbolTreeActionContext;
import ghidra.app.plugin.core.symboltree.actions.SymbolTreeContextAction;
import ghidra.app.plugin.core.symboltree.nodes.CodeSymbolNode;
import ghidra.app.plugin.core.symboltree.nodes.FunctionSymbolNode;
import ghidra.app.plugin.core.symboltree.nodes.LibrarySymbolNode;
import ghidra.app.plugin.core.symboltree.nodes.LocalVariableSymbolNode;
import ghidra.app.plugin.core.symboltree.nodes.ParameterSymbolNode;
import ghidra.app.plugin.core.symboltree.nodes.SymbolNode;
import ghidra.app.services.CodeViewerService;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.ServiceListener;
import ghidra.program.database.symbol.FunctionSymbol;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.util.FunctionSignatureFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.Msg;
import ghidra.util.Swing;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;

public class ShowSymbolReferencesAction
extends SymbolTreeContextAction {
    private PluginTool tool;
    private ServiceListener helpLocationServiceListener = new ServiceListener(){

        public void serviceRemoved(Class<?> interfaceClass, Object service) {
        }

        public void serviceAdded(Class<?> interfaceClass, Object service) {
            if (interfaceClass.equals(LocationReferencesService.class)) {
                ShowSymbolReferencesAction.this.setHelpLocation(((LocationReferencesService)service).getHelpLocation());
                Swing.runLater(() -> ShowSymbolReferencesAction.this.tool.removeServiceListener((ServiceListener)this));
            }
        }
    };

    public ShowSymbolReferencesAction(PluginTool tool, String owner) {
        super("Find References To", owner, KeyBindingType.SHARED);
        this.tool = tool;
        this.setPopupMenuData(new MenuData(new String[]{"Show References to"}, "0Middle"));
        this.installHelpLocation();
        KeyStroke defaultkeyStroke = AbstractFindReferencesDataTypeAction.DEFAULT_KEY_STROKE;
        this.initKeyStroke(defaultkeyStroke);
    }

    private void initKeyStroke(KeyStroke keyStroke) {
        if (keyStroke == null) {
            return;
        }
        this.setKeyBindingData(new KeyBindingData(keyStroke));
    }

    private void installHelpLocation() {
        LocationReferencesService locationReferencesService = (LocationReferencesService)this.tool.getService(LocationReferencesService.class);
        if (locationReferencesService == null) {
            this.tool.addServiceListener(this.helpLocationServiceListener);
            return;
        }
        this.setHelpLocation(locationReferencesService.getHelpLocation());
    }

    @Override
    protected boolean isEnabledForContext(SymbolTreeActionContext context) {
        LocationReferencesService locationReferencesService = (LocationReferencesService)this.tool.getService(LocationReferencesService.class);
        if (locationReferencesService == null) {
            return false;
        }
        TreePath[] selectionPaths = context.getSelectedSymbolTreePaths();
        if (selectionPaths.length != 1) {
            return false;
        }
        Object lastPathComponent = selectionPaths[0].getLastPathComponent();
        return lastPathComponent instanceof CodeSymbolNode || lastPathComponent instanceof FunctionSymbolNode || lastPathComponent instanceof LibrarySymbolNode || lastPathComponent instanceof LocalVariableSymbolNode || lastPathComponent instanceof ParameterSymbolNode;
    }

    @Override
    protected void actionPerformed(SymbolTreeActionContext context) {
        LocationReferencesService locationReferencesService = (LocationReferencesService)this.tool.getService(LocationReferencesService.class);
        CodeViewerService codeViewerService = (CodeViewerService)this.tool.getService(CodeViewerService.class);
        Navigatable navigatable = codeViewerService.getNavigatable();
        TreePath[] selectionPaths = context.getSelectedSymbolTreePaths();
        SymbolNode symbolNode = (SymbolNode)((Object)selectionPaths[0].getLastPathComponent());
        ProgramLocation location = this.getProgramLocation(symbolNode);
        if (location == null) {
            Msg.debug((Object)((Object)this), (Object)("Do not know how to show references to SymbolNode type: " + symbolNode));
            return;
        }
        locationReferencesService.showReferencesToLocation(location, navigatable);
    }

    private ProgramLocation getProgramLocation(SymbolNode symbolNode) {
        Symbol symbol = symbolNode.getSymbol();
        if (symbol instanceof FunctionSymbol) {
            return new FunctionSignatureFieldLocation(symbol.getProgram(), symbol.getAddress());
        }
        return symbol.getProgramLocation();
    }
}

