/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.navigation.locationreferences;

import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.GTableCellRenderingData;
import ghidra.app.plugin.core.navigation.locationreferences.LocationDescriptor;
import ghidra.app.plugin.core.navigation.locationreferences.LocationReference;
import ghidra.app.plugin.core.navigation.locationreferences.LocationReferenceContext;
import ghidra.app.plugin.core.navigation.locationreferences.LocationReferencesProvider;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.AddressBasedTableModel;
import ghidra.util.table.column.AbstractGhidraColumnRenderer;
import ghidra.util.table.column.GColumnRenderer;
import ghidra.util.table.field.AbstractProgramBasedDynamicTableColumn;
import ghidra.util.task.TaskMonitor;
import java.awt.Color;
import java.awt.Component;
import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;

class LocationReferencesTableModel
extends AddressBasedTableModel<LocationReference> {
    private LocationReferencesProvider provider;
    private boolean initialized = false;
    private boolean performFullReload = false;

    LocationReferencesTableModel(LocationReferencesProvider locationReferencesProvider) {
        super("References", (ServiceProvider)locationReferencesProvider.getTool(), locationReferencesProvider.getProgram(), null, true);
        this.provider = locationReferencesProvider;
        this.addTableColumn((DynamicTableColumn)new ContextTableColumn());
    }

    protected void doLoad(Accumulator<LocationReference> accumulator, TaskMonitor monitor) throws CancelledException {
        LocationDescriptor locationDescriptor = this.provider.getLocationDescriptor();
        locationDescriptor.setUseDynamicSearching(this.provider.useDynamicDataTypeSearching());
        locationDescriptor.getReferences(accumulator, monitor, this.performFullReload);
        this.initialized = true;
        this.performFullReload = false;
    }

    private Collection<Address> toAddresses(Iterable<LocationReference> references) {
        HashSet<Address> set = new HashSet<Address>();
        for (LocationReference locationReference : references) {
            set.add(locationReference.getLocationOfUse());
        }
        return set;
    }

    Collection<Address> getReferenceAddresses() {
        return this.toAddresses(this.getAllData());
    }

    boolean isInitialized() {
        return this.initialized;
    }

    public void reload() {
        this.initialized = false;
        super.reload();
    }

    void fullReload() {
        this.performFullReload = true;
        this.reload();
    }

    @Override
    public Address getAddress(int row) {
        return ((LocationReference)this.getRowObject(row)).getLocationOfUse();
    }

    @Override
    public ProgramLocation getProgramLocation(int row, int column) {
        LocationReference ref = (LocationReference)this.getRowObject(row);
        ProgramLocation location = ref.getProgramLocation();
        if (location != null) {
            return location;
        }
        return super.getProgramLocation(row, column);
    }

    private class ContextTableColumn
    extends AbstractProgramBasedDynamicTableColumn<LocationReference, LocationReference> {
        private ContextCellRenderer renderer;

        private ContextTableColumn() {
            this.renderer = new ContextCellRenderer();
        }

        public LocationReference getValue(LocationReference rowObject, Settings settings, Program p, ServiceProvider sp) throws IllegalArgumentException {
            return rowObject;
        }

        public String getColumnName() {
            return "Context";
        }

        public String getColumnDescription() {
            return "<html>Provides information about the references, such as<br>the reference type (for applied references) or the context<br>of use for discovered references";
        }

        public GColumnRenderer<LocationReference> getColumnRenderer() {
            return this.renderer;
        }
    }

    private class ContextCellRenderer
    extends AbstractGhidraColumnRenderer<LocationReference> {
        private static final String OFFCUT_STRING = "<< OFFCUT >>";

        private ContextCellRenderer() {
            this.setHTMLRenderingEnabled(true);
        }

        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            super.getTableCellRendererComponent(data);
            LocationReference rowObject = (LocationReference)data.getRowObject();
            String refTypeString = this.getRefTypeString(rowObject);
            if (refTypeString != null) {
                this.setText(refTypeString);
                return this;
            }
            LocationReferenceContext context = rowObject.getContext();
            String text = context.getBoldMatchingText();
            this.setText(text);
            return this;
        }

        private String getRefTypeString(LocationReference rowObject) {
            String refType = rowObject.getRefTypeString();
            if (!StringUtils.isBlank((CharSequence)refType)) {
                String trailingText = "";
                if (rowObject.isOffcutReference()) {
                    this.setForeground(Color.RED);
                    trailingText = OFFCUT_STRING;
                }
                return refType + trailingText;
            }
            return null;
        }

        public String getFilterString(LocationReference rowObject, Settings settings) {
            String refTypeString = this.getRefTypeString(rowObject);
            if (refTypeString != null) {
                return refTypeString;
            }
            LocationReferenceContext context = rowObject.getContext();
            return context.getPlainText();
        }
    }
}

