/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.interpreter;

import ghidra.app.plugin.core.interpreter.HistoryManager;
import java.util.ArrayList;

class HistoryManagerImpl
implements HistoryManager {
    private ArrayList<String> history = new ArrayList();
    private int position = 0;

    HistoryManagerImpl() {
    }

    @Override
    public void addHistory(String command) {
        if (command.matches("^\\s*$")) {
            return;
        }
        if (command.charAt(command.length() - 1) == '\n') {
            command = command.substring(0, command.length() - 1);
        }
        this.history.add(command);
        this.position = this.history.size();
    }

    @Override
    public String getHistoryUp() {
        if (this.position > 0) {
            --this.position;
            return this.history.get(this.position);
        }
        return null;
    }

    @Override
    public String getHistoryDown() {
        if (this.position < this.history.size() - 1) {
            ++this.position;
            String result = this.history.get(this.position);
            return result;
        }
        if (this.position == this.history.size() - 1) {
            this.position = this.history.size();
            return "";
        }
        return null;
    }

    @Override
    public void setRetention(int retention) {
    }

    @Override
    public int getRetention() {
        return Integer.MAX_VALUE;
    }
}

