/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.interpreter;

import ghidra.app.plugin.core.interpreter.AnsiParser;
import java.awt.Color;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class AnsiRenderer {
    public static final Color BLACK = new Color(0, 0, 0);
    public static final Color RED = new Color(194, 54, 33);
    public static final Color GREEN = new Color(37, 188, 36);
    public static final Color YELLOW = new Color(173, 173, 39);
    public static final Color BLUE = new Color(73, 46, 225);
    public static final Color MAGENTA = new Color(211, 56, 211);
    public static final Color CYAN = new Color(51, 187, 200);
    public static final Color WHITE = new Color(203, 204, 205);
    public static final Color HI_BLACK = new Color(129, 131, 131);
    public static final Color HI_RED = new Color(252, 57, 31);
    public static final Color HI_GREEN = new Color(49, 231, 34);
    public static final Color HI_YELLOW = new Color(234, 236, 35);
    public static final Color HI_BLUE = new Color(88, 51, 255);
    public static final Color HI_MAGENTA = new Color(249, 53, 248);
    public static final Color HI_CYAN = new Color(20, 240, 240);
    public static final Color HI_WHITE = new Color(233, 235, 235);
    private static final Color[] BASIC_COLORS = new Color[]{BLACK, RED, GREEN, YELLOW, BLUE, MAGENTA, CYAN, WHITE, HI_BLACK, HI_RED, HI_GREEN, HI_YELLOW, HI_BLUE, HI_MAGENTA, HI_CYAN, HI_WHITE};
    private static final int[] CUBE_STEPS = new int[]{0, 95, 135, 175, 215, 255};
    private final ParserHandler handler = new ParserHandler();
    private final AnsiParser parser = new AnsiParser(this.handler);
    private AttributeSet defaultAttributes = null;

    public void renderString(StyledDocument document, String text, MutableAttributeSet attributes) throws BadLocationException {
        this.handler.document = document;
        this.handler.attributes = attributes;
        if (this.defaultAttributes == null) {
            this.defaultAttributes = attributes.copyAttributes();
        }
        this.parser.processString(text);
    }

    private class ParserHandler
    implements AnsiParser.AnsiParserHandler {
        public StyledDocument document;
        public MutableAttributeSet attributes;

        private ParserHandler() {
        }

        @Override
        public void handleString(String text) throws BadLocationException {
            this.document.insertString(this.document.getLength(), text, this.attributes);
        }

        private Color get256Color(int v) {
            if (v < 16) {
                return BASIC_COLORS[v];
            }
            if (v < 232) {
                int b = (v -= 16) % 6;
                int g = v / 6 % 6;
                int r = v / 36 % 6;
                return new Color(CUBE_STEPS[r], CUBE_STEPS[g], CUBE_STEPS[b]);
            }
            if (v < 256) {
                int gray = (v -= 232) * 10 + 8;
                return new Color(gray, gray, gray);
            }
            return BASIC_COLORS[0];
        }

        private int handleSGRAttribute(String[] bits, int pos) throws NumberFormatException {
            int code = Integer.parseInt(bits[pos]);
            if (code >= 30 && code < 50) {
                Object attributeName = code < 40 ? StyleConstants.Foreground : StyleConstants.Background;
                int colorCode = code % 10;
                if (colorCode < 8) {
                    this.attributes.addAttribute(attributeName, BASIC_COLORS[colorCode]);
                    return 1;
                }
                if (colorCode == 8) {
                    if (pos + 1 >= bits.length) {
                        return 1;
                    }
                    int colorType = Integer.parseInt(bits[pos + 1]);
                    if (colorType == 5 && pos + 2 < bits.length) {
                        int color = Integer.parseInt(bits[pos + 2]);
                        this.attributes.addAttribute(attributeName, this.get256Color(color));
                        return 3;
                    }
                    if (colorType == 2 && pos + 4 < bits.length) {
                        int r = Integer.parseInt(bits[pos + 2]);
                        int g = Integer.parseInt(bits[pos + 3]);
                        int b = Integer.parseInt(bits[pos + 4]);
                        this.attributes.addAttribute(attributeName, new Color(r, g, b));
                        return 5;
                    }
                    return 1;
                }
                if (colorCode == 9) {
                    this.attributes.removeAttribute(attributeName);
                    return 1;
                }
            }
            switch (code) {
                case 0: {
                    this.attributes.removeAttributes(this.attributes);
                    this.attributes.addAttributes(AnsiRenderer.this.defaultAttributes);
                    break;
                }
                case 1: {
                    StyleConstants.setBold(this.attributes, true);
                    break;
                }
                case 2: {
                    StyleConstants.setBold(this.attributes, false);
                    break;
                }
                case 3: {
                    StyleConstants.setItalic(this.attributes, true);
                    break;
                }
                case 4: {
                    StyleConstants.setUnderline(this.attributes, true);
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    break;
                }
                case 7: {
                    break;
                }
                case 8: {
                    break;
                }
                case 9: {
                    StyleConstants.setStrikeThrough(this.attributes, true);
                    break;
                }
                case 20: {
                    break;
                }
                case 21: {
                    StyleConstants.setUnderline(this.attributes, true);
                    break;
                }
                case 22: {
                    StyleConstants.setBold(this.attributes, false);
                    break;
                }
                case 23: {
                    StyleConstants.setItalic(this.attributes, false);
                    break;
                }
                case 24: {
                    StyleConstants.setUnderline(this.attributes, false);
                    break;
                }
                case 25: {
                    break;
                }
                case 26: {
                    break;
                }
                case 27: {
                    break;
                }
                case 28: {
                    break;
                }
                case 29: {
                    StyleConstants.setStrikeThrough(this.attributes, false);
                }
            }
            return 1;
        }

        @Override
        public void handleCSI(String param, String inter, String finalChar) throws BadLocationException {
            if (finalChar.equals("m")) {
                if (param.isEmpty()) {
                    param = "0";
                }
                String[] bits = param.split("[:;]");
                int pos = 0;
                while (pos < bits.length) {
                    try {
                        int advance = this.handleSGRAttribute(bits, pos);
                        pos += advance;
                    }
                    catch (NumberFormatException e) {
                        ++pos;
                    }
                }
            }
        }

        @Override
        public void handleOSC(String param) throws BadLocationException {
        }
    }
}

