/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.tree;

import ghidra.app.plugin.core.datamgr.archive.DomainFileArchive;
import ghidra.app.plugin.core.datamgr.tree.ArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.ArrayPointerFilterState;
import ghidra.app.plugin.core.datamgr.tree.BackgroundIcon;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.listing.Program;
import ghidra.util.HTMLUtilities;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import resources.MultiIcon;
import resources.ResourceManager;
import resources.icons.TranslateIcon;

public class DomainFileArchiveNode
extends ArchiveNode {
    private static ImageIcon CHECKED_OUT_ICON = ResourceManager.loadImage((String)"images/check.png");
    private static ImageIcon CHECKED_OUT_EXCLUSIVE_ICON = ResourceManager.loadImage((String)"images/checkex.png");
    private static ImageIcon HIJACKED_ICON = ResourceManager.loadImage((String)"images/small_hijack.gif");
    private static ImageIcon READ_ONLY_ICON = ResourceManager.loadImage((String)"images/user-busy.png", (int)10, (int)10);
    private static ImageIcon NOT_LATEST_CHECKED_OUT_ICON = ResourceManager.loadImage((String)"images/checkNotLatest.gif");
    private boolean isChanged;
    private boolean isReadOnly;
    private boolean isHijacked;
    private boolean isCheckedOut;
    private boolean isCheckedOutExclusive;
    private boolean isVersioned;
    private int version;
    private int latestVersion;
    private String domainFileInfoString;

    public DomainFileArchiveNode(DomainFileArchive archive, ArrayPointerFilterState filterState) {
        super(archive, filterState);
        this.updateDomainFileInfo();
    }

    private void updateDomainFileInfo() {
        DomainObject domainObject = ((DomainFileArchive)this.archive).getDomainObject();
        DomainFile domainFile = ((DomainFileArchive)this.archive).getDomainFile();
        this.isChanged = domainObject.isChanged();
        this.isReadOnly = domainFile.isReadOnly();
        this.isHijacked = domainFile.isHijacked();
        this.isVersioned = domainFile.isVersioned();
        this.version = this.isVersioned || !domainFile.canSave() ? domainFile.getVersion() : -1;
        this.isCheckedOutExclusive = !this.isVersioned && domainObject.hasExclusiveAccess() && !this.isReadOnly || this.isVersioned && domainFile.isCheckedOutExclusive();
        this.isCheckedOut = this.isCheckedOutExclusive || domainFile.isCheckedOut();
        this.latestVersion = domainFile.getLatestVersion();
        this.domainFileInfoString = this.createDomainFileInfoString();
    }

    private String createDomainFileInfoString() {
        DomainObject domainObject = ((DomainFileArchive)this.archive).getDomainObject();
        Object name = "";
        if (this.isHijacked) {
            name = (String)name + " (hijacked)";
        } else if (this.isVersioned) {
            name = this.version == this.latestVersion && !this.isCheckedOut ? (String)name + " (" + this.version + ")" : (String)name + " (" + this.version + " of " + this.latestVersion + ")";
        } else if (this.version != -1) {
            name = (String)name + " @ " + this.version;
        }
        if (!(domainObject instanceof Program) && this.isChanged) {
            name = (String)name + " *";
        }
        return name;
    }

    @Override
    public String getToolTip() {
        DomainFile file = ((DomainFileArchive)this.archive).getDomainFile();
        if (file != null) {
            return "<html>" + HTMLUtilities.escapeHTML((String)file.getPathname());
        }
        return "[Unsaved New Domain File Archive]";
    }

    @Override
    public boolean canDelete() {
        return false;
    }

    @Override
    public Icon getIcon(boolean expanded) {
        ImageIcon baseIcon = this.archive.getIcon(expanded);
        BackgroundIcon bgIcon = new BackgroundIcon(24, 16, this.isVersioned);
        MultiIcon multiIcon = new MultiIcon((Icon)bgIcon);
        multiIcon.addIcon((Icon)baseIcon);
        if (this.isReadOnly) {
            multiIcon.addIcon((Icon)new TranslateIcon((Icon)READ_ONLY_ICON, 6, 6));
        } else if (this.isHijacked) {
            multiIcon.addIcon((Icon)new TranslateIcon((Icon)HIJACKED_ICON, 8, -4));
        } else if (this.isCheckedOut) {
            if (this.isCheckedOutExclusive) {
                multiIcon.addIcon((Icon)new TranslateIcon((Icon)CHECKED_OUT_EXCLUSIVE_ICON, 8, -4));
            } else if (this.version < this.latestVersion) {
                multiIcon.addIcon((Icon)new TranslateIcon((Icon)NOT_LATEST_CHECKED_OUT_ICON, 8, -4));
            } else {
                multiIcon.addIcon((Icon)new TranslateIcon((Icon)CHECKED_OUT_ICON, 8, -4));
            }
        }
        return multiIcon;
    }

    protected String getDomainObjectInfo() {
        return this.domainFileInfoString;
    }

    public DomainFile getDomainFile() {
        return ((DomainFileArchive)this.archive).getDomainFile();
    }

    @Override
    public void nodeChanged() {
        super.nodeChanged();
        this.updateDomainFileInfo();
    }
}

