/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import docking.ComponentProvider;
import ghidra.app.plugin.core.compositeeditor.AddBitFieldAction;
import ghidra.app.plugin.core.compositeeditor.ApplyAction;
import ghidra.app.plugin.core.compositeeditor.ArrayAction;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorProvider;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorTableAction;
import ghidra.app.plugin.core.compositeeditor.DeleteAction;
import ghidra.app.plugin.core.compositeeditor.DuplicateAction;
import ghidra.app.plugin.core.compositeeditor.DuplicateMultipleAction;
import ghidra.app.plugin.core.compositeeditor.EditBitFieldAction;
import ghidra.app.plugin.core.compositeeditor.EditComponentAction;
import ghidra.app.plugin.core.compositeeditor.EditFieldAction;
import ghidra.app.plugin.core.compositeeditor.HexNumbersAction;
import ghidra.app.plugin.core.compositeeditor.MoveDownAction;
import ghidra.app.plugin.core.compositeeditor.MoveUpAction;
import ghidra.app.plugin.core.compositeeditor.PointerAction;
import ghidra.app.plugin.core.compositeeditor.ShowComponentPathAction;
import ghidra.app.plugin.core.compositeeditor.ShowDataTypeInTreeAction;
import ghidra.app.plugin.core.compositeeditor.UnionEditorModel;
import ghidra.app.plugin.core.compositeeditor.UnionEditorPanel;
import ghidra.framework.plugintool.Plugin;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.Union;
import javax.swing.ImageIcon;
import resources.ResourceManager;

public class UnionEditorProvider
extends CompositeEditorProvider {
    protected static final ImageIcon UNION_EDITOR_ICON = ResourceManager.loadImage((String)"images/cUnion.png");

    public UnionEditorProvider(Plugin plugin, Union unionDataType, boolean showInHex) {
        super(plugin);
        this.setIcon(UNION_EDITOR_ICON);
        this.editorModel = new UnionEditorModel(this, showInHex);
        this.editorModel.load((Composite)unionDataType);
        this.initializeActions();
        this.editorPanel = new UnionEditorPanel((UnionEditorModel)this.editorModel, (CompositeEditorProvider)this);
        this.updateTitle();
        plugin.getTool().addComponentProvider((ComponentProvider)this, true);
        this.addActionsToTool();
        this.editorPanel.getTable().requestFocus();
        this.editorModel.selectionChanged();
    }

    @Override
    public String getName() {
        return "Union Editor";
    }

    @Override
    protected CompositeEditorTableAction[] createActions() {
        return new CompositeEditorTableAction[]{new ApplyAction(this), new MoveUpAction(this), new MoveDownAction(this), new DuplicateAction(this), new DuplicateMultipleAction(this), new DeleteAction(this), new PointerAction(this), new ArrayAction(this), new ShowComponentPathAction(this), new EditComponentAction(this), new EditFieldAction(this), new HexNumbersAction(this), new AddBitFieldAction(this), new EditBitFieldAction(this), new ShowDataTypeInTreeAction(this)};
    }

    @Override
    public String getHelpName() {
        return "Structure_Editor";
    }

    @Override
    public String getHelpTopic() {
        return "DataTypeEditors";
    }
}

