/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.database;

import db.DBHandle;
import db.util.ErrorHandler;
import ghidra.framework.model.AbortedTransactionListener;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.listing.ProgramUserData;
import ghidra.util.Msg;
import java.io.IOException;
import javax.help.UnsupportedOperationException;

public interface UndoableTransaction
extends AutoCloseable {
    public static UndoableTransaction start(DBHandle handle, ErrorHandler errHandler) {
        long tid = handle.startTransaction();
        return new DBHandleUndoableTransaction(handle, tid, errHandler);
    }

    public static UndoableTransaction start(UndoableDomainObject domainObject, String description) {
        int tid = domainObject.startTransaction(description);
        return new DomainObjectUndoableTransaction(domainObject, tid);
    }

    public static UndoableTransaction start(UndoableDomainObject domainObject, String description, AbortedTransactionListener listener) {
        int tid = domainObject.startTransaction(description, listener);
        return new DomainObjectUndoableTransaction(domainObject, tid);
    }

    public static UndoableTransaction start(DataTypeManager dataTypeManager, String description) {
        int tid = dataTypeManager.startTransaction(description);
        return new DataTypeManagerUndoableTransaction(dataTypeManager, tid);
    }

    public static UndoableTransaction start(ProgramUserData userData) {
        int tid = userData.startTransaction();
        return new ProgramUserDataUndoableTransaction(userData, tid);
    }

    public void commitOnClose();

    public void abortOnClose();

    public void commit();

    public void abort();

    @Override
    public void close();

    public static class DBHandleUndoableTransaction
    extends AbstractLongUndoableTransaction {
        private final DBHandle handle;
        private final ErrorHandler errHandler;

        public DBHandleUndoableTransaction(DBHandle handle, long transactionID, ErrorHandler errHandler) {
            super(transactionID);
            this.handle = handle;
            this.errHandler = errHandler;
        }

        @Override
        void endTransaction(boolean commit) {
            if (!commit) {
                Msg.debug((Object)this, (Object)"Aborting transaction");
            }
            try {
                this.handle.endTransaction(this.transactionID, commit);
            }
            catch (IOException e) {
                this.errHandler.dbError(e);
            }
        }
    }

    public static class DomainObjectUndoableTransaction
    extends AbstractIntUndoableTransaction {
        private final UndoableDomainObject domainObject;

        private DomainObjectUndoableTransaction(UndoableDomainObject domainObject, int tid) {
            super(tid);
            this.domainObject = domainObject;
        }

        @Override
        void endTransaction(boolean commit) {
            if (!commit) {
                Msg.debug((Object)this, (Object)"Aborting transaction");
            }
            this.domainObject.endTransaction(this.transactionID, commit);
        }
    }

    public static class DataTypeManagerUndoableTransaction
    extends AbstractIntUndoableTransaction {
        private final DataTypeManager dataTypeManager;

        private DataTypeManagerUndoableTransaction(DataTypeManager dataTypeManager, int tid) {
            super(tid);
            this.dataTypeManager = dataTypeManager;
        }

        @Override
        void endTransaction(boolean commit) {
            this.dataTypeManager.endTransaction(this.transactionID, commit);
        }
    }

    public static class ProgramUserDataUndoableTransaction
    extends AbstractIntUndoableTransaction {
        private final ProgramUserData userData;

        private ProgramUserDataUndoableTransaction(ProgramUserData userData, int tid) {
            super(tid);
            this.userData = userData;
        }

        @Override
        public void abortOnClose() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void abort() {
            throw new UnsupportedOperationException();
        }

        @Override
        void endTransaction(boolean commit) {
            this.userData.endTransaction(this.transactionID);
        }
    }

    public static abstract class AbstractIntUndoableTransaction
    extends AbstractUndoableTransaction {
        final int transactionID;

        public AbstractIntUndoableTransaction(int transactionID) {
            this.transactionID = transactionID;
        }
    }

    public static abstract class AbstractLongUndoableTransaction
    extends AbstractUndoableTransaction {
        final long transactionID;

        public AbstractLongUndoableTransaction(long transactionID) {
            this.transactionID = transactionID;
        }
    }

    public static abstract class AbstractUndoableTransaction
    implements UndoableTransaction {
        private boolean commit = true;
        private boolean open = true;

        protected AbstractUndoableTransaction() {
        }

        abstract void endTransaction(boolean var1);

        @Override
        public void abortOnClose() {
            this.commit = false;
        }

        @Override
        public void commitOnClose() {
            this.commit = true;
        }

        @Override
        public void abort() {
            if (this.open) {
                this.open = false;
                this.endTransaction(false);
            }
        }

        @Override
        public void commit() {
            if (this.open) {
                this.open = false;
                this.endTransaction(true);
            }
        }

        @Override
        public void close() {
            if (this.open) {
                this.open = false;
                this.endTransaction(this.commit);
            }
        }
    }
}

