/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.struct;

import ghidra.pcode.struct.Expr;
import ghidra.pcode.struct.LValInternal;
import ghidra.pcode.struct.RValInternal;
import ghidra.pcode.struct.StructuredSleigh;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.DataType;

class DerefExpr
extends Expr
implements LValInternal {
    private final AddressSpace space;
    private final RValInternal addr;

    private DerefExpr(StructuredSleigh ctx, AddressSpace space, RValInternal addr, DataType type) {
        super(ctx, type);
        this.space = space;
        this.addr = addr;
    }

    protected DerefExpr(StructuredSleigh ctx, AddressSpace space, RValInternal addr) {
        this(ctx, space, addr, ctx.computeDerefType(addr));
    }

    @Override
    public StructuredSleigh.LVal cast(DataType type) {
        return new DerefExpr(this.ctx, this.space, this.addr, type);
    }

    public String toString() {
        return "<Deref *" + this.addr + ">";
    }

    @Override
    public String generate() {
        String spacePiece = this.ctx.language.getDefaultSpace() == this.space ? "" : "[" + this.space.getName() + "]";
        String sizePiece = this.type.getLength() == 0 ? "" : ":" + this.type.getLength();
        return "(*" + spacePiece + sizePiece + " " + this.addr.generate() + ")";
    }
}

