/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec;

import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.plugin.processors.sleigh.template.OpTpl;
import ghidra.app.util.pcode.AbstractAppender;
import ghidra.app.util.pcode.AbstractPcodeFormatter;
import ghidra.app.util.pcode.Appender;
import ghidra.pcode.exec.PcodeExecutor;
import ghidra.pcode.exec.PcodeUseropLibrary;
import ghidra.pcodeCPort.slghsymbol.UserOpSymbol;
import ghidra.program.model.lang.Language;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.pcode.PcodeOp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PcodeProgram {
    protected final SleighLanguage language;
    protected final List<PcodeOp> code;
    protected final Map<Integer, String> useropNames = new HashMap<Integer, String>();

    public static PcodeProgram fromInstruction(Instruction instruction) {
        Language language = instruction.getPrototype().getLanguage();
        if (!(language instanceof SleighLanguage)) {
            throw new IllegalArgumentException("Instruction must be parsed using Sleigh");
        }
        PcodeOp[] pcode = instruction.getPcode(false);
        return new PcodeProgram((SleighLanguage)language, List.of(pcode), Map.of());
    }

    protected PcodeProgram(SleighLanguage language, List<PcodeOp> code, Map<Integer, UserOpSymbol> useropSymbols) {
        this.language = language;
        this.code = code;
        int langOpCount = language.getNumberOfUserDefinedOpNames();
        for (Map.Entry<Integer, UserOpSymbol> ent : useropSymbols.entrySet()) {
            int index = ent.getKey();
            if (index < langOpCount) {
                this.useropNames.put(index, language.getUserDefinedOpName(index));
                continue;
            }
            this.useropNames.put(index, ent.getValue().getName());
        }
    }

    public SleighLanguage getLanguage() {
        return this.language;
    }

    public List<PcodeOp> getCode() {
        return this.code;
    }

    public <T> void execute(PcodeExecutor<T> executor, PcodeUseropLibrary<T> library) {
        executor.execute(this, library);
    }

    protected String getHead() {
        return this.getClass().getSimpleName();
    }

    public String toString() {
        return (String)new MyFormatter(this).formatOps((Language)this.language, this.code);
    }

    protected static class MyFormatter
    extends AbstractPcodeFormatter<String, MyAppender> {
        protected final PcodeProgram program;

        public MyFormatter(PcodeProgram program) {
            this.program = program;
        }

        protected MyAppender createAppender(Language language, boolean indent) {
            return new MyAppender(this.program, language);
        }

        protected AbstractPcodeFormatter.FormatResult formatOpTemplate(MyAppender appender, OpTpl op) {
            AbstractPcodeFormatter.FormatResult result = super.formatOpTemplate((Appender)appender, op);
            appender.endLine();
            return result;
        }
    }

    protected static class MyAppender
    extends AbstractAppender<String> {
        protected final PcodeProgram program;
        protected final StringBuffer buf = new StringBuffer();

        public MyAppender(PcodeProgram program, Language language) {
            super(language, true);
            this.program = program;
            this.buf.append("<" + program.getHead() + ":\n");
        }

        protected void appendString(String string) {
            this.buf.append(string);
        }

        protected void endLine() {
            this.buf.append("\n");
        }

        protected String stringifyUseropUnchecked(Language language, int id) {
            String name = super.stringifyUseropUnchecked(language, id);
            if (name != null) {
                return name;
            }
            return this.program.useropNames.get(id);
        }

        public String finish() {
            this.buf.append(">");
            return this.buf.toString();
        }
    }
}

