/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.model.impl;

import agent.frida.frida.FridaClient;
import agent.frida.manager.FridaCause;
import agent.frida.manager.FridaProcess;
import agent.frida.manager.FridaReason;
import agent.frida.manager.FridaState;
import agent.frida.manager.FridaThread;
import agent.frida.manager.cmd.FridaAttachCommand;
import agent.frida.manager.cmd.FridaContinueCommand;
import agent.frida.manager.cmd.FridaDestroyCommand;
import agent.frida.manager.cmd.FridaDetachCommand;
import agent.frida.manager.cmd.FridaKillCommand;
import agent.frida.manager.cmd.FridaLaunchProcessCommand;
import agent.frida.model.iface1.FridaModelTargetFocusScope;
import agent.frida.model.iface2.FridaModelTargetMemoryContainer;
import agent.frida.model.iface2.FridaModelTargetProcess;
import agent.frida.model.iface2.FridaModelTargetProcessContainer;
import agent.frida.model.iface2.FridaModelTargetThreadContainer;
import agent.frida.model.impl.FridaModelTargetHeapMemoryContainerImpl;
import agent.frida.model.impl.FridaModelTargetMemoryContainerImpl;
import agent.frida.model.impl.FridaModelTargetObjectImpl;
import agent.frida.model.impl.FridaModelTargetThreadContainerImpl;
import ghidra.async.AsyncUtils;
import ghidra.dbg.DebuggerModelListener;
import ghidra.dbg.target.TargetAttachable;
import ghidra.dbg.target.TargetAttacher;
import ghidra.dbg.target.TargetEventScope;
import ghidra.dbg.target.TargetExecutionStateful;
import ghidra.dbg.target.TargetFocusScope;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.dbg.util.PathUtils;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@TargetObjectSchemaInfo(name="Process", attributeResync=TargetObjectSchema.ResyncMode.ALWAYS, elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(name="Memory", type=FridaModelTargetMemoryContainerImpl.class, required=true, fixed=true), @TargetAttributeType(name="Memory (Heap)", type=FridaModelTargetMemoryContainerImpl.class, required=false, fixed=true), @TargetAttributeType(name="Threads", type=FridaModelTargetThreadContainerImpl.class, required=true, fixed=true), @TargetAttributeType(name="_exit_code", type=String.class), @TargetAttributeType(type=Void.class)})
public class FridaModelTargetProcessImpl
extends FridaModelTargetObjectImpl
implements FridaModelTargetProcess {
    public static final String PID_ATTRIBUTE_NAME = "_pid";
    public static final String EXIT_CODE_ATTRIBUTE_NAME = "_exit_code";
    public static final TargetAttacher.TargetAttachKindSet SUPPORTED_KINDS = TargetAttacher.TargetAttachKindSet.of((TargetAttacher.TargetAttachKind[])new TargetAttacher.TargetAttachKind[]{TargetAttacher.TargetAttachKind.BY_OBJECT_REF, TargetAttacher.TargetAttachKind.BY_ID});
    protected final FridaModelTargetMemoryContainerImpl memory;
    protected final FridaModelTargetHeapMemoryContainerImpl heap;
    protected final FridaModelTargetThreadContainerImpl threads;
    private Integer base = 10;

    protected static String indexProcess(FridaProcess process) {
        return FridaClient.getId(process);
    }

    protected static String keyProcess(FridaProcess process) {
        return PathUtils.makeKey((String)FridaModelTargetProcessImpl.indexProcess(process));
    }

    public FridaModelTargetProcessImpl(FridaModelTargetProcessContainer processes, FridaProcess process) {
        super(processes.getModel(), (TargetObject)processes, FridaModelTargetProcessImpl.keyProcess(process), process, "Process");
        this.getModel().addModelObject(process, (TargetObject)this);
        this.memory = new FridaModelTargetMemoryContainerImpl(this);
        this.heap = new FridaModelTargetHeapMemoryContainerImpl(this);
        this.threads = new FridaModelTargetThreadContainerImpl(this);
        TargetExecutionStateful.TargetExecutionState state = FridaClient.convertState(this.getManager().getState());
        this.changeAttributes(List.of(), List.of(this.memory, this.heap, this.threads), Map.of("_display", this.getDisplay(), "_parameters", PARAMETERS, "_state", state, "_supported_attach_kinds", SUPPORTED_KINDS), "Initialized");
        this.setExecutionState(state, "Initialized");
        this.getManager().addEventsListener(this);
    }

    @Override
    public void setModelObject(Object modelObject) {
        super.setModelObject(modelObject);
        this.getModel().addModelObject(modelObject, (TargetObject)this);
    }

    @Override
    public String getDescription(int level) {
        FridaProcess process = (FridaProcess)this.getModelObject();
        return process.getDescription();
    }

    public String getDisplay() {
        Object pidstr = FridaClient.getId(this.getProcess());
        pidstr = this.base == 16 ? "0x" + (String)pidstr : Long.toString(Long.parseLong((String)pidstr, 16));
        return "[" + (String)pidstr + "]";
    }

    @Override
    public void processSelected(FridaProcess eventProcess, FridaCause cause) {
        if (eventProcess.getPID().equals(this.getProcess().getPID())) {
            ((FridaModelTargetFocusScope)this.searchForSuitable(TargetFocusScope.class)).setFocus(this);
        }
    }

    @Override
    public void threadStateChanged(FridaThread thread, FridaState state, FridaCause cause, FridaReason reason) {
        TargetExecutionStateful.TargetExecutionState targetState = FridaClient.convertState(state);
        this.setExecutionState(targetState, "ThreadStateChanged");
    }

    @Override
    public CompletableFuture<Void> launch(List<String> args) {
        this.model.gateFuture(this.getManager().execute(new FridaLaunchProcessCommand(this.getManager(), this.getProcess().getName(), args)));
        return AsyncUtils.NIL;
    }

    @Override
    public CompletableFuture<Void> resume() {
        return this.model.gateFuture(this.getManager().execute(new FridaContinueCommand(this.getManager(), this.getProcess())));
    }

    @Override
    public CompletableFuture<Void> kill() {
        return this.model.gateFuture(this.getManager().execute(new FridaKillCommand(this.getManager())));
    }

    @Override
    public CompletableFuture<Void> destroy() {
        return this.model.gateFuture(this.getManager().execute(new FridaDestroyCommand(this.getManager())));
    }

    @Override
    public CompletableFuture<Void> attach(TargetAttachable attachable) {
        this.getModel().assertMine(TargetObject.class, (TargetObject)attachable);
        FridaProcess proc = (FridaProcess)this.getModelObject();
        long pid = proc.getPID();
        return this.model.gateFuture((CompletableFuture)this.getManager().execute(new FridaAttachCommand(this.getManager(), Long.toString(pid))).thenApply(__ -> null));
    }

    @Override
    public CompletableFuture<Void> attach(long pid) {
        return this.model.gateFuture((CompletableFuture)this.getManager().execute(new FridaAttachCommand(this.getManager(), Long.toString(pid))).thenApply(__ -> null));
    }

    @Override
    public CompletableFuture<Void> detach() {
        return this.model.gateFuture(this.getManager().execute(new FridaDetachCommand(this.getManager(), this.getProcess().getSession())));
    }

    @Override
    public CompletableFuture<Void> delete() {
        return AsyncUtils.NIL;
    }

    @Override
    public void processStarted(FridaProcess proc) {
        if (proc != null) {
            this.changeAttributes(List.of(), List.of(), Map.of(PID_ATTRIBUTE_NAME, Long.valueOf(this.getProcess().getPID()), "_display", this.getDisplay(), "_state", TargetExecutionStateful.TargetExecutionState.STOPPED), "Started");
        }
        this.setExecutionState(TargetExecutionStateful.TargetExecutionState.STOPPED, "Started");
    }

    @Override
    public void processExited(FridaProcess proc, FridaCause cause) {
        if (proc.getPID().equals(this.getProcess().getPID())) {
            String exitDesc = "NONE";
            this.changeAttributes(List.of(), List.of(), Map.of("_state", TargetExecutionStateful.TargetExecutionState.TERMINATED, EXIT_CODE_ATTRIBUTE_NAME, exitDesc), "Exited");
            ((DebuggerModelListener)this.getListeners().fire).event((TargetObject)this.getProxy(), null, TargetEventScope.TargetEventType.PROCESS_EXITED, "Process " + FridaClient.getId(this.getProcess()) + " exited code=" + exitDesc, List.of(this.getProxy()));
        }
    }

    @Override
    public CompletableFuture<Void> setActive() {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public FridaModelTargetThreadContainer getThreads() {
        return this.threads;
    }

    @Override
    public FridaModelTargetMemoryContainer getMemory() {
        return this.memory;
    }

    @Override
    public FridaProcess getProcess() {
        return (FridaProcess)this.getModelObject();
    }

    public void setBase(Object value) {
        this.base = (Integer)value;
        this.changeAttributes(List.of(), List.of(), Map.of("_display", this.getDisplay()), "Started");
    }
}

